/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

public class OAuth2Client {
    public static final String SERIALIZED_NAME_ALLOWED_CORS_ORIGINS = "allowed_cors_origins";
    @SerializedName(value="allowed_cors_origins")
    private List<String> allowedCorsOrigins = null;
    public static final String SERIALIZED_NAME_AUDIENCE = "audience";
    @SerializedName(value="audience")
    private List<String> audience = null;
    public static final String SERIALIZED_NAME_BACKCHANNEL_LOGOUT_SESSION_REQUIRED = "backchannel_logout_session_required";
    @SerializedName(value="backchannel_logout_session_required")
    private Boolean backchannelLogoutSessionRequired;
    public static final String SERIALIZED_NAME_BACKCHANNEL_LOGOUT_URI = "backchannel_logout_uri";
    @SerializedName(value="backchannel_logout_uri")
    private String backchannelLogoutUri;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_CLIENT_NAME = "client_name";
    @SerializedName(value="client_name")
    private String clientName;
    public static final String SERIALIZED_NAME_CLIENT_SECRET = "client_secret";
    @SerializedName(value="client_secret")
    private String clientSecret;
    public static final String SERIALIZED_NAME_CLIENT_SECRET_EXPIRES_AT = "client_secret_expires_at";
    @SerializedName(value="client_secret_expires_at")
    private Long clientSecretExpiresAt;
    public static final String SERIALIZED_NAME_CLIENT_URI = "client_uri";
    @SerializedName(value="client_uri")
    private String clientUri;
    public static final String SERIALIZED_NAME_CONTACTS = "contacts";
    @SerializedName(value="contacts")
    private List<String> contacts = null;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private OffsetDateTime createdAt;
    public static final String SERIALIZED_NAME_FRONTCHANNEL_LOGOUT_SESSION_REQUIRED = "frontchannel_logout_session_required";
    @SerializedName(value="frontchannel_logout_session_required")
    private Boolean frontchannelLogoutSessionRequired;
    public static final String SERIALIZED_NAME_FRONTCHANNEL_LOGOUT_URI = "frontchannel_logout_uri";
    @SerializedName(value="frontchannel_logout_uri")
    private String frontchannelLogoutUri;
    public static final String SERIALIZED_NAME_GRANT_TYPES = "grant_types";
    @SerializedName(value="grant_types")
    private List<String> grantTypes = null;
    public static final String SERIALIZED_NAME_JWKS = "jwks";
    @SerializedName(value="jwks")
    private Object jwks;
    public static final String SERIALIZED_NAME_JWKS_URI = "jwks_uri";
    @SerializedName(value="jwks_uri")
    private String jwksUri;
    public static final String SERIALIZED_NAME_LOGO_URI = "logo_uri";
    @SerializedName(value="logo_uri")
    private String logoUri;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private Object metadata;
    public static final String SERIALIZED_NAME_OWNER = "owner";
    @SerializedName(value="owner")
    private String owner;
    public static final String SERIALIZED_NAME_POLICY_URI = "policy_uri";
    @SerializedName(value="policy_uri")
    private String policyUri;
    public static final String SERIALIZED_NAME_POST_LOGOUT_REDIRECT_URIS = "post_logout_redirect_uris";
    @SerializedName(value="post_logout_redirect_uris")
    private List<String> postLogoutRedirectUris = null;
    public static final String SERIALIZED_NAME_REDIRECT_URIS = "redirect_uris";
    @SerializedName(value="redirect_uris")
    private List<String> redirectUris = null;
    public static final String SERIALIZED_NAME_REQUEST_OBJECT_SIGNING_ALG = "request_object_signing_alg";
    @SerializedName(value="request_object_signing_alg")
    private String requestObjectSigningAlg;
    public static final String SERIALIZED_NAME_REQUEST_URIS = "request_uris";
    @SerializedName(value="request_uris")
    private List<String> requestUris = null;
    public static final String SERIALIZED_NAME_RESPONSE_TYPES = "response_types";
    @SerializedName(value="response_types")
    private List<String> responseTypes = null;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope;
    public static final String SERIALIZED_NAME_SECTOR_IDENTIFIER_URI = "sector_identifier_uri";
    @SerializedName(value="sector_identifier_uri")
    private String sectorIdentifierUri;
    public static final String SERIALIZED_NAME_SUBJECT_TYPE = "subject_type";
    @SerializedName(value="subject_type")
    private String subjectType;
    public static final String SERIALIZED_NAME_TOKEN_ENDPOINT_AUTH_METHOD = "token_endpoint_auth_method";
    @SerializedName(value="token_endpoint_auth_method")
    private String tokenEndpointAuthMethod;
    public static final String SERIALIZED_NAME_TOKEN_ENDPOINT_AUTH_SIGNING_ALG = "token_endpoint_auth_signing_alg";
    @SerializedName(value="token_endpoint_auth_signing_alg")
    private String tokenEndpointAuthSigningAlg;
    public static final String SERIALIZED_NAME_TOS_URI = "tos_uri";
    @SerializedName(value="tos_uri")
    private String tosUri;
    public static final String SERIALIZED_NAME_UPDATED_AT = "updated_at";
    @SerializedName(value="updated_at")
    private OffsetDateTime updatedAt;
    public static final String SERIALIZED_NAME_USERINFO_SIGNED_RESPONSE_ALG = "userinfo_signed_response_alg";
    @SerializedName(value="userinfo_signed_response_alg")
    private String userinfoSignedResponseAlg;

    public OAuth2Client allowedCorsOrigins(List<String> allowedCorsOrigins) {
        this.allowedCorsOrigins = allowedCorsOrigins;
        return this;
    }

    public OAuth2Client addAllowedCorsOriginsItem(String allowedCorsOriginsItem) {
        if (this.allowedCorsOrigins == null) {
            this.allowedCorsOrigins = new ArrayList<String>();
        }
        this.allowedCorsOrigins.add(allowedCorsOriginsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getAllowedCorsOrigins() {
        return this.allowedCorsOrigins;
    }

    public void setAllowedCorsOrigins(List<String> allowedCorsOrigins) {
        this.allowedCorsOrigins = allowedCorsOrigins;
    }

    public OAuth2Client audience(List<String> audience) {
        this.audience = audience;
        return this;
    }

    public OAuth2Client addAudienceItem(String audienceItem) {
        if (this.audience == null) {
            this.audience = new ArrayList<String>();
        }
        this.audience.add(audienceItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getAudience() {
        return this.audience;
    }

    public void setAudience(List<String> audience) {
        this.audience = audience;
    }

    public OAuth2Client backchannelLogoutSessionRequired(Boolean backchannelLogoutSessionRequired) {
        this.backchannelLogoutSessionRequired = backchannelLogoutSessionRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the RP requires that a sid (session ID) Claim be included in the Logout Token to identify the RP session with the OP when the backchannel_logout_uri is used. If omitted, the default value is false.")
    public Boolean getBackchannelLogoutSessionRequired() {
        return this.backchannelLogoutSessionRequired;
    }

    public void setBackchannelLogoutSessionRequired(Boolean backchannelLogoutSessionRequired) {
        this.backchannelLogoutSessionRequired = backchannelLogoutSessionRequired;
    }

    public OAuth2Client backchannelLogoutUri(String backchannelLogoutUri) {
        this.backchannelLogoutUri = backchannelLogoutUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RP URL that will cause the RP to log itself out when sent a Logout Token by the OP.")
    public String getBackchannelLogoutUri() {
        return this.backchannelLogoutUri;
    }

    public void setBackchannelLogoutUri(String backchannelLogoutUri) {
        this.backchannelLogoutUri = backchannelLogoutUri;
    }

    public OAuth2Client clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID  is the id for this client.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public OAuth2Client clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Name is the human-readable string name of the client to be presented to the end-user during authorization.")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public OAuth2Client clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Secret is the client's secret. The secret will be included in the create request as cleartext, and then never again. The secret is stored using BCrypt so it is impossible to recover it. Tell your users that they need to write the secret down as it will not be made available again.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public OAuth2Client clientSecretExpiresAt(Long clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SecretExpiresAt is an integer holding the time at which the client secret will expire or 0 if it will not expire. The time is represented as the number of seconds from 1970-01-01T00:00:00Z as measured in UTC until the date/time of expiration.  This feature is currently not supported and it's value will always be set to 0.")
    public Long getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt;
    }

    public void setClientSecretExpiresAt(Long clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt;
    }

    public OAuth2Client clientUri(String clientUri) {
        this.clientUri = clientUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ClientURI is an URL string of a web page providing information about the client. If present, the server SHOULD display this URL to the end-user in a clickable fashion.")
    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public OAuth2Client contacts(List<String> contacts) {
        this.contacts = contacts;
        return this;
    }

    public OAuth2Client addContactsItem(String contactsItem) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<String>();
        }
        this.contacts.add(contactsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> contacts) {
        this.contacts = contacts;
    }

    public OAuth2Client createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CreatedAt returns the timestamp of the client's creation.")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public OAuth2Client frontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {
        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Boolean value specifying whether the RP requires that iss (issuer) and sid (session ID) query parameters be included to identify the RP session with the OP when the frontchannel_logout_uri is used. If omitted, the default value is false.")
    public Boolean getFrontchannelLogoutSessionRequired() {
        return this.frontchannelLogoutSessionRequired;
    }

    public void setFrontchannelLogoutSessionRequired(Boolean frontchannelLogoutSessionRequired) {
        this.frontchannelLogoutSessionRequired = frontchannelLogoutSessionRequired;
    }

    public OAuth2Client frontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = frontchannelLogoutUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RP URL that will cause the RP to log itself out when rendered in an iframe by the OP. An iss (issuer) query parameter and a sid (session ID) query parameter MAY be included by the OP to enable the RP to validate the request and to determine which of the potentially multiple sessions is to be logged out; if either is included, both MUST be.")
    public String getFrontchannelLogoutUri() {
        return this.frontchannelLogoutUri;
    }

    public void setFrontchannelLogoutUri(String frontchannelLogoutUri) {
        this.frontchannelLogoutUri = frontchannelLogoutUri;
    }

    public OAuth2Client grantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public OAuth2Client addGrantTypesItem(String grantTypesItem) {
        if (this.grantTypes == null) {
            this.grantTypes = new ArrayList<String>();
        }
        this.grantTypes.add(grantTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public OAuth2Client jwks(Object jwks) {
        this.jwks = jwks;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getJwks() {
        return this.jwks;
    }

    public void setJwks(Object jwks) {
        this.jwks = jwks;
    }

    public OAuth2Client jwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL for the Client's JSON Web Key Set [JWK] document. If the Client signs requests to the Server, it contains the signing key(s) the Server uses to validate signatures from the Client. The JWK Set MAY also contain the Client's encryption keys(s), which are used by the Server to encrypt responses to the Client. When both signing and encryption keys are made available, a use (Key Use) parameter value is REQUIRED for all keys in the referenced JWK Set to indicate each key's intended usage. Although some algorithms allow the same key to be used for both signatures and encryption, doing so is NOT RECOMMENDED, as it is less secure. The JWK x5c parameter MAY be used to provide X.509 representations of keys provided. When used, the bare key values MUST still be present and MUST match those in the certificate.")
    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public OAuth2Client logoUri(String logoUri) {
        this.logoUri = logoUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="LogoURI is an URL string that references a logo for the client.")
    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public OAuth2Client metadata(Object metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Object metadata) {
        this.metadata = metadata;
    }

    public OAuth2Client owner(String owner) {
        this.owner = owner;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Owner is a string identifying the owner of the OAuth 2.0 Client.")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public OAuth2Client policyUri(String policyUri) {
        this.policyUri = policyUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PolicyURI is a URL string that points to a human-readable privacy policy document that describes how the deployment organization collects, uses, retains, and discloses personal data.")
    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public OAuth2Client postLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
        return this;
    }

    public OAuth2Client addPostLogoutRedirectUrisItem(String postLogoutRedirectUrisItem) {
        if (this.postLogoutRedirectUris == null) {
            this.postLogoutRedirectUris = new ArrayList<String>();
        }
        this.postLogoutRedirectUris.add(postLogoutRedirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(List<String> postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public OAuth2Client redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public OAuth2Client addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public OAuth2Client requestObjectSigningAlg(String requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JWS [JWS] alg algorithm [JWA] that MUST be used for signing Request Objects sent to the OP. All Request Objects from this Client MUST be rejected, if not signed with this algorithm.")
    public String getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(String requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public OAuth2Client requestUris(List<String> requestUris) {
        this.requestUris = requestUris;
        return this;
    }

    public OAuth2Client addRequestUrisItem(String requestUrisItem) {
        if (this.requestUris == null) {
            this.requestUris = new ArrayList<String>();
        }
        this.requestUris.add(requestUrisItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(List<String> requestUris) {
        this.requestUris = requestUris;
    }

    public OAuth2Client responseTypes(List<String> responseTypes) {
        this.responseTypes = responseTypes;
        return this;
    }

    public OAuth2Client addResponseTypesItem(String responseTypesItem) {
        if (this.responseTypes == null) {
            this.responseTypes = new ArrayList<String>();
        }
        this.responseTypes.add(responseTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(List<String> responseTypes) {
        this.responseTypes = responseTypes;
    }

    public OAuth2Client scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Scope is a string containing a space-separated list of scope values (as described in Section 3.3 of OAuth 2.0 [RFC6749]) that the client can use when requesting access tokens.")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public OAuth2Client sectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL using the https scheme to be used in calculating Pseudonymous Identifiers by the OP. The URL references a file with a single JSON array of redirect_uri values.")
    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public OAuth2Client subjectType(String subjectType) {
        this.subjectType = subjectType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SubjectType requested for responses to this Client. The subject_types_supported Discovery parameter contains a list of the supported subject_type values for this server. Valid types include `pairwise` and `public`.")
    public String getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public OAuth2Client tokenEndpointAuthMethod(String tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requested Client Authentication method for the Token Endpoint. The options are client_secret_post, client_secret_basic, private_key_jwt, and none.")
    public String getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(String tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public OAuth2Client tokenEndpointAuthSigningAlg(String tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Requested Client Authentication signing algorithm for the Token Endpoint.")
    public String getTokenEndpointAuthSigningAlg() {
        return this.tokenEndpointAuthSigningAlg;
    }

    public void setTokenEndpointAuthSigningAlg(String tokenEndpointAuthSigningAlg) {
        this.tokenEndpointAuthSigningAlg = tokenEndpointAuthSigningAlg;
    }

    public OAuth2Client tosUri(String tosUri) {
        this.tosUri = tosUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="TermsOfServiceURI is a URL string that points to a human-readable terms of service document for the client that describes a contractual relationship between the end-user and the client that the end-user accepts when authorizing the client.")
    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public OAuth2Client updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UpdatedAt returns the timestamp of the last update.")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public OAuth2Client userinfoSignedResponseAlg(String userinfoSignedResponseAlg) {
        this.userinfoSignedResponseAlg = userinfoSignedResponseAlg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="JWS alg algorithm [JWA] REQUIRED for signing UserInfo Responses. If this is specified, the response will be JWT [JWT] serialized, and signed using JWS. The default, if omitted, is for the UserInfo Response to return the Claims as a UTF-8 encoded JSON object using the application/json content-type.")
    public String getUserinfoSignedResponseAlg() {
        return this.userinfoSignedResponseAlg;
    }

    public void setUserinfoSignedResponseAlg(String userinfoSignedResponseAlg) {
        this.userinfoSignedResponseAlg = userinfoSignedResponseAlg;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2Client oAuth2Client = (OAuth2Client)o;
        return Objects.equals(this.allowedCorsOrigins, oAuth2Client.allowedCorsOrigins) && Objects.equals(this.audience, oAuth2Client.audience) && Objects.equals(this.backchannelLogoutSessionRequired, oAuth2Client.backchannelLogoutSessionRequired) && Objects.equals(this.backchannelLogoutUri, oAuth2Client.backchannelLogoutUri) && Objects.equals(this.clientId, oAuth2Client.clientId) && Objects.equals(this.clientName, oAuth2Client.clientName) && Objects.equals(this.clientSecret, oAuth2Client.clientSecret) && Objects.equals(this.clientSecretExpiresAt, oAuth2Client.clientSecretExpiresAt) && Objects.equals(this.clientUri, oAuth2Client.clientUri) && Objects.equals(this.contacts, oAuth2Client.contacts) && Objects.equals(this.createdAt, oAuth2Client.createdAt) && Objects.equals(this.frontchannelLogoutSessionRequired, oAuth2Client.frontchannelLogoutSessionRequired) && Objects.equals(this.frontchannelLogoutUri, oAuth2Client.frontchannelLogoutUri) && Objects.equals(this.grantTypes, oAuth2Client.grantTypes) && Objects.equals(this.jwks, oAuth2Client.jwks) && Objects.equals(this.jwksUri, oAuth2Client.jwksUri) && Objects.equals(this.logoUri, oAuth2Client.logoUri) && Objects.equals(this.metadata, oAuth2Client.metadata) && Objects.equals(this.owner, oAuth2Client.owner) && Objects.equals(this.policyUri, oAuth2Client.policyUri) && Objects.equals(this.postLogoutRedirectUris, oAuth2Client.postLogoutRedirectUris) && Objects.equals(this.redirectUris, oAuth2Client.redirectUris) && Objects.equals(this.requestObjectSigningAlg, oAuth2Client.requestObjectSigningAlg) && Objects.equals(this.requestUris, oAuth2Client.requestUris) && Objects.equals(this.responseTypes, oAuth2Client.responseTypes) && Objects.equals(this.scope, oAuth2Client.scope) && Objects.equals(this.sectorIdentifierUri, oAuth2Client.sectorIdentifierUri) && Objects.equals(this.subjectType, oAuth2Client.subjectType) && Objects.equals(this.tokenEndpointAuthMethod, oAuth2Client.tokenEndpointAuthMethod) && Objects.equals(this.tokenEndpointAuthSigningAlg, oAuth2Client.tokenEndpointAuthSigningAlg) && Objects.equals(this.tosUri, oAuth2Client.tosUri) && Objects.equals(this.updatedAt, oAuth2Client.updatedAt) && Objects.equals(this.userinfoSignedResponseAlg, oAuth2Client.userinfoSignedResponseAlg);
    }

    public int hashCode() {
        return Objects.hash(this.allowedCorsOrigins, this.audience, this.backchannelLogoutSessionRequired, this.backchannelLogoutUri, this.clientId, this.clientName, this.clientSecret, this.clientSecretExpiresAt, this.clientUri, this.contacts, this.createdAt, this.frontchannelLogoutSessionRequired, this.frontchannelLogoutUri, this.grantTypes, this.jwks, this.jwksUri, this.logoUri, this.metadata, this.owner, this.policyUri, this.postLogoutRedirectUris, this.redirectUris, this.requestObjectSigningAlg, this.requestUris, this.responseTypes, this.scope, this.sectorIdentifierUri, this.subjectType, this.tokenEndpointAuthMethod, this.tokenEndpointAuthSigningAlg, this.tosUri, this.updatedAt, this.userinfoSignedResponseAlg);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuth2Client {\n");
        sb.append("    allowedCorsOrigins: ").append(this.toIndentedString(this.allowedCorsOrigins)).append("\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("    backchannelLogoutSessionRequired: ").append(this.toIndentedString(this.backchannelLogoutSessionRequired)).append("\n");
        sb.append("    backchannelLogoutUri: ").append(this.toIndentedString(this.backchannelLogoutUri)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    clientSecretExpiresAt: ").append(this.toIndentedString(this.clientSecretExpiresAt)).append("\n");
        sb.append("    clientUri: ").append(this.toIndentedString(this.clientUri)).append("\n");
        sb.append("    contacts: ").append(this.toIndentedString(this.contacts)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    frontchannelLogoutSessionRequired: ").append(this.toIndentedString(this.frontchannelLogoutSessionRequired)).append("\n");
        sb.append("    frontchannelLogoutUri: ").append(this.toIndentedString(this.frontchannelLogoutUri)).append("\n");
        sb.append("    grantTypes: ").append(this.toIndentedString(this.grantTypes)).append("\n");
        sb.append("    jwks: ").append(this.toIndentedString(this.jwks)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    logoUri: ").append(this.toIndentedString(this.logoUri)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    policyUri: ").append(this.toIndentedString(this.policyUri)).append("\n");
        sb.append("    postLogoutRedirectUris: ").append(this.toIndentedString(this.postLogoutRedirectUris)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    requestObjectSigningAlg: ").append(this.toIndentedString(this.requestObjectSigningAlg)).append("\n");
        sb.append("    requestUris: ").append(this.toIndentedString(this.requestUris)).append("\n");
        sb.append("    responseTypes: ").append(this.toIndentedString(this.responseTypes)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    sectorIdentifierUri: ").append(this.toIndentedString(this.sectorIdentifierUri)).append("\n");
        sb.append("    subjectType: ").append(this.toIndentedString(this.subjectType)).append("\n");
        sb.append("    tokenEndpointAuthMethod: ").append(this.toIndentedString(this.tokenEndpointAuthMethod)).append("\n");
        sb.append("    tokenEndpointAuthSigningAlg: ").append(this.toIndentedString(this.tokenEndpointAuthSigningAlg)).append("\n");
        sb.append("    tosUri: ").append(this.toIndentedString(this.tosUri)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    userinfoSignedResponseAlg: ").append(this.toIndentedString(this.userinfoSignedResponseAlg)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

