/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import sh.ory.hydra.model.OAuth2Client;
import sh.ory.hydra.model.OpenIDConnectContext;

public class LoginRequest {
    public static final String SERIALIZED_NAME_CHALLENGE = "challenge";
    @SerializedName(value="challenge")
    private String challenge;
    public static final String SERIALIZED_NAME_CLIENT = "client";
    @SerializedName(value="client")
    private OAuth2Client client;
    public static final String SERIALIZED_NAME_OIDC_CONTEXT = "oidc_context";
    @SerializedName(value="oidc_context")
    private OpenIDConnectContext oidcContext;
    public static final String SERIALIZED_NAME_REQUEST_URL = "request_url";
    @SerializedName(value="request_url")
    private String requestUrl;
    public static final String SERIALIZED_NAME_REQUESTED_ACCESS_TOKEN_AUDIENCE = "requested_access_token_audience";
    @SerializedName(value="requested_access_token_audience")
    private List<String> requestedAccessTokenAudience = new ArrayList<String>();
    public static final String SERIALIZED_NAME_REQUESTED_SCOPE = "requested_scope";
    @SerializedName(value="requested_scope")
    private List<String> requestedScope = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SESSION_ID = "session_id";
    @SerializedName(value="session_id")
    private String sessionId;
    public static final String SERIALIZED_NAME_SKIP = "skip";
    @SerializedName(value="skip")
    private Boolean skip;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;

    public LoginRequest challenge(String challenge) {
        this.challenge = challenge;
        return this;
    }

    @ApiModelProperty(required=true, value="ID is the identifier (\"login challenge\") of the login request. It is used to identify the session.")
    public String getChallenge() {
        return this.challenge;
    }

    public void setChallenge(String challenge) {
        this.challenge = challenge;
    }

    public LoginRequest client(OAuth2Client client) {
        this.client = client;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public OAuth2Client getClient() {
        return this.client;
    }

    public void setClient(OAuth2Client client) {
        this.client = client;
    }

    public LoginRequest oidcContext(OpenIDConnectContext oidcContext) {
        this.oidcContext = oidcContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OpenIDConnectContext getOidcContext() {
        return this.oidcContext;
    }

    public void setOidcContext(OpenIDConnectContext oidcContext) {
        this.oidcContext = oidcContext;
    }

    public LoginRequest requestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="RequestURL is the original OAuth 2.0 Authorization URL requested by the OAuth 2.0 client. It is the URL which initiates the OAuth 2.0 Authorization Code or OAuth 2.0 Implicit flow. This URL is typically not needed, but might come in handy if you want to deal with additional request parameters.")
    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public LoginRequest requestedAccessTokenAudience(List<String> requestedAccessTokenAudience) {
        this.requestedAccessTokenAudience = requestedAccessTokenAudience;
        return this;
    }

    public LoginRequest addRequestedAccessTokenAudienceItem(String requestedAccessTokenAudienceItem) {
        this.requestedAccessTokenAudience.add(requestedAccessTokenAudienceItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getRequestedAccessTokenAudience() {
        return this.requestedAccessTokenAudience;
    }

    public void setRequestedAccessTokenAudience(List<String> requestedAccessTokenAudience) {
        this.requestedAccessTokenAudience = requestedAccessTokenAudience;
    }

    public LoginRequest requestedScope(List<String> requestedScope) {
        this.requestedScope = requestedScope;
        return this;
    }

    public LoginRequest addRequestedScopeItem(String requestedScopeItem) {
        this.requestedScope.add(requestedScopeItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<String> getRequestedScope() {
        return this.requestedScope;
    }

    public void setRequestedScope(List<String> requestedScope) {
        this.requestedScope = requestedScope;
    }

    public LoginRequest sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SessionID is the login session ID. If the user-agent reuses a login session (via cookie / remember flag) this ID will remain the same. If the user-agent did not have an existing authentication session (e.g. remember is false) this will be a new random value. This value is used as the \"sid\" parameter in the ID Token and in OIDC Front-/Back- channel logout. It's value can generally be used to associate consecutive login requests by a certain user.")
    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public LoginRequest skip(Boolean skip) {
        this.skip = skip;
        return this;
    }

    @ApiModelProperty(required=true, value="Skip, if true, implies that the client has requested the same scopes from the same user previously. If true, you can skip asking the user to grant the requested scopes, and simply forward the user to the redirect URL.  This feature allows you to update / set session information.")
    public Boolean getSkip() {
        return this.skip;
    }

    public void setSkip(Boolean skip) {
        this.skip = skip;
    }

    public LoginRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(required=true, value="Subject is the user ID of the end-user that authenticated. Now, that end user needs to grant or deny the scope requested by the OAuth 2.0 client. If this value is set and `skip` is true, you MUST include this subject type when accepting the login request, or the request will fail.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginRequest loginRequest = (LoginRequest)o;
        return Objects.equals(this.challenge, loginRequest.challenge) && Objects.equals(this.client, loginRequest.client) && Objects.equals(this.oidcContext, loginRequest.oidcContext) && Objects.equals(this.requestUrl, loginRequest.requestUrl) && Objects.equals(this.requestedAccessTokenAudience, loginRequest.requestedAccessTokenAudience) && Objects.equals(this.requestedScope, loginRequest.requestedScope) && Objects.equals(this.sessionId, loginRequest.sessionId) && Objects.equals(this.skip, loginRequest.skip) && Objects.equals(this.subject, loginRequest.subject);
    }

    public int hashCode() {
        return Objects.hash(this.challenge, this.client, this.oidcContext, this.requestUrl, this.requestedAccessTokenAudience, this.requestedScope, this.sessionId, this.skip, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginRequest {\n");
        sb.append("    challenge: ").append(this.toIndentedString(this.challenge)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    oidcContext: ").append(this.toIndentedString(this.oidcContext)).append("\n");
        sb.append("    requestUrl: ").append(this.toIndentedString(this.requestUrl)).append("\n");
        sb.append("    requestedAccessTokenAudience: ").append(this.toIndentedString(this.requestedAccessTokenAudience)).append("\n");
        sb.append("    requestedScope: ").append(this.toIndentedString(this.requestedScope)).append("\n");
        sb.append("    sessionId: ").append(this.toIndentedString(this.sessionId)).append("\n");
        sb.append("    skip: ").append(this.toIndentedString(this.skip)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

