/*
 * Decompiled with CFR 0.152.
 */
package sh.ory.hydra.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

public class AcceptLoginRequest {
    public static final String SERIALIZED_NAME_ACR = "acr";
    @SerializedName(value="acr")
    private String acr;
    public static final String SERIALIZED_NAME_CONTEXT = "context";
    @SerializedName(value="context")
    private Object context;
    public static final String SERIALIZED_NAME_FORCE_SUBJECT_IDENTIFIER = "force_subject_identifier";
    @SerializedName(value="force_subject_identifier")
    private String forceSubjectIdentifier;
    public static final String SERIALIZED_NAME_REMEMBER = "remember";
    @SerializedName(value="remember")
    private Boolean remember;
    public static final String SERIALIZED_NAME_REMEMBER_FOR = "remember_for";
    @SerializedName(value="remember_for")
    private Long rememberFor;
    public static final String SERIALIZED_NAME_SUBJECT = "subject";
    @SerializedName(value="subject")
    private String subject;

    public AcceptLoginRequest acr(String acr) {
        this.acr = acr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ACR sets the Authentication AuthorizationContext Class Reference value for this authentication session. You can use it to express that, for example, a user authenticated using two factor authentication.")
    public String getAcr() {
        return this.acr;
    }

    public void setAcr(String acr) {
        this.acr = acr;
    }

    public AcceptLoginRequest context(Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Object getContext() {
        return this.context;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public AcceptLoginRequest forceSubjectIdentifier(String forceSubjectIdentifier) {
        this.forceSubjectIdentifier = forceSubjectIdentifier;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ForceSubjectIdentifier forces the \"pairwise\" user ID of the end-user that authenticated. The \"pairwise\" user ID refers to the (Pairwise Identifier Algorithm)[http://openid.net/specs/openid-connect-core-1_0.html#PairwiseAlg] of the OpenID Connect specification. It allows you to set an obfuscated subject (\"user\") identifier that is unique to the client.  Please note that this changes the user ID on endpoint /userinfo and sub claim of the ID Token. It does not change the sub claim in the OAuth 2.0 Introspection.  Per default, ORY Hydra handles this value with its own algorithm. In case you want to set this yourself you can use this field. Please note that setting this field has no effect if `pairwise` is not configured in ORY Hydra or the OAuth 2.0 Client does not expect a pairwise identifier (set via `subject_type` key in the client's configuration).  Please also be aware that ORY Hydra is unable to properly compute this value during authentication. This implies that you have to compute this value on every authentication process (probably depending on the client ID or some other unique value).  If you fail to compute the proper value, then authentication processes which have id_token_hint set might fail.")
    public String getForceSubjectIdentifier() {
        return this.forceSubjectIdentifier;
    }

    public void setForceSubjectIdentifier(String forceSubjectIdentifier) {
        this.forceSubjectIdentifier = forceSubjectIdentifier;
    }

    public AcceptLoginRequest remember(Boolean remember) {
        this.remember = remember;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Remember, if set to true, tells ORY Hydra to remember this user by telling the user agent (browser) to store a cookie with authentication data. If the same user performs another OAuth 2.0 Authorization Request, he/she will not be asked to log in again.")
    public Boolean getRemember() {
        return this.remember;
    }

    public void setRemember(Boolean remember) {
        this.remember = remember;
    }

    public AcceptLoginRequest rememberFor(Long rememberFor) {
        this.rememberFor = rememberFor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RememberFor sets how long the authentication should be remembered for in seconds. If set to `0`, the authorization will be remembered for the duration of the browser session (using a session cookie).")
    public Long getRememberFor() {
        return this.rememberFor;
    }

    public void setRememberFor(Long rememberFor) {
        this.rememberFor = rememberFor;
    }

    public AcceptLoginRequest subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(required=true, value="Subject is the user ID of the end-user that authenticated.")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AcceptLoginRequest acceptLoginRequest = (AcceptLoginRequest)o;
        return Objects.equals(this.acr, acceptLoginRequest.acr) && Objects.equals(this.context, acceptLoginRequest.context) && Objects.equals(this.forceSubjectIdentifier, acceptLoginRequest.forceSubjectIdentifier) && Objects.equals(this.remember, acceptLoginRequest.remember) && Objects.equals(this.rememberFor, acceptLoginRequest.rememberFor) && Objects.equals(this.subject, acceptLoginRequest.subject);
    }

    public int hashCode() {
        return Objects.hash(this.acr, this.context, this.forceSubjectIdentifier, this.remember, this.rememberFor, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AcceptLoginRequest {\n");
        sb.append("    acr: ").append(this.toIndentedString(this.acr)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    forceSubjectIdentifier: ").append(this.toIndentedString(this.forceSubjectIdentifier)).append("\n");
        sb.append("    remember: ").append(this.toIndentedString(this.remember)).append("\n");
        sb.append("    rememberFor: ").append(this.toIndentedString(this.rememberFor)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

