/**
 * Copyright 2010 Västra Götalandsregionen
 *
 *   This library is free software; you can redistribute it and/or modify
 *   it under the terms of version 2.1 of the GNU Lesser General Public
 *   License as published by the Free Software Foundation.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 *   Boston, MA 02111-1307  USA
 */

package se.vgregion.activation.rest;

import se.vgregion.activation.api.ActivationAccountDTO;
import se.vgregion.activation.domain.ActivationAccount;

import javax.ws.rs.core.UriInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public final class DTOAssembler {

    //Only static methods. No public constructor.
    private DTOAssembler() {

    }

    static ActivationAccountDTO toDTO(final ActivationAccount account, UriInfo ui) throws MalformedURLException {
        return toDTO(account, ui, "");
    }

    static ActivationAccountDTO toDTO(final ActivationAccount account, UriInfo ui, String pathSuffix)
            throws MalformedURLException {
        ActivationAccountDTO dto = null;
        if (account != null) {
            String base = getBaseUrl(ui);

            URL link = new URL(base + ui.getPath() + pathSuffix);
            URL customUrl = new URL(account.getCustomUrl());

            dto = new ActivationAccountDTO(account.getVgrId(), account.getActivationCode().getValue(), link, customUrl,
                    account.getCustomMessage(), account.currentStatus().name(), account.getSystem());
        }
        return dto;
    }

    static String getBaseUrl(UriInfo ui) {
        String base = ui.getBaseUri().toString();
        if (!base.endsWith("/")) {
            base += "/";
        }
        return base;
    }

    static Collection<ActivationAccountDTO> toDTOCollection(final Collection<ActivationAccount> allAccounts,
            UriInfo ui) throws MalformedURLException {
        Collection<ActivationAccountDTO> dtoCollection = Collections.emptySet();
        if (allAccounts != null) {
            dtoCollection = new HashSet<ActivationAccountDTO>(allAccounts.size());
            for (ActivationAccount account : allAccounts) {
                dtoCollection.add(toDTO(account, ui, account.getId().getValue()));
            }
        }
        return dtoCollection;
    }
}
