/*
 * Decompiled with CFR 0.152.
 */
package se.sawano.java.text;

import java.nio.CharBuffer;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;

public class AlphanumericComparator
implements Comparator<String> {
    private final Collator collator;

    public AlphanumericComparator() {
        this.collator = null;
    }

    public AlphanumericComparator(Locale locale) {
        this(Collator.getInstance(Objects.requireNonNull(locale)));
    }

    public AlphanumericComparator(Collator collator) {
        this.collator = Objects.requireNonNull(collator);
    }

    @Override
    public int compare(String s1, String s2) {
        CharBuffer b1 = CharBuffer.wrap(s1);
        CharBuffer b2 = CharBuffer.wrap(s2);
        while (b1.remaining() > 0 && b2.remaining() > 0) {
            int result = this.compare(this.nextToken(b1), this.nextToken(b2));
            if (result == 0) continue;
            return result;
        }
        return s1.length() - s2.length();
    }

    @Override
    private int compare(CharBuffer s1, CharBuffer s2) {
        int numericalResult;
        if (this.isNumeric(s1) && this.isNumeric(s2) && (numericalResult = this.compareNumerically(s1, s2)) != 0) {
            return numericalResult;
        }
        return this.compareStrings(s1.toString(), s2.toString());
    }

    private int compareStrings(String s1, String s2) {
        if (this.collator == null) {
            return s1.compareTo(s2);
        }
        return this.collator.compare(s1, s2);
    }

    private CharBuffer nextToken(CharBuffer s) {
        int endOfToken = this.positionOfNextDigitBoundary(s);
        CharBuffer token = s.subSequence(0, endOfToken - s.position());
        s.position(endOfToken);
        return token;
    }

    private int positionOfNextDigitBoundary(CharBuffer s) {
        int endPos;
        boolean firstWasDigit = this.isDigit(s.get(s.position()));
        for (endPos = s.position(); endPos < s.limit() && firstWasDigit == this.isDigit(s.get(endPos)); ++endPos) {
        }
        return endPos;
    }

    private boolean isNumeric(CharBuffer string) {
        return this.isDigit(string.get(string.position()));
    }

    private boolean isDigit(char c) {
        if (this.collator == null) {
            char cInt = c;
            return cInt >= '0' && cInt <= '9';
        }
        return Character.isDigit(c);
    }

    private int compareNumerically(CharBuffer s1, CharBuffer s2) {
        this.trimLeadingZeros(s1);
        this.trimLeadingZeros(s2);
        if (s1.remaining() != s2.remaining()) {
            return s1.remaining() - s2.remaining();
        }
        while (s1.hasRemaining()) {
            int result = Character.compare(s1.get(), s2.get());
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private void trimLeadingZeros(CharBuffer numericalString) {
        while (numericalString.remaining() > 0 && numericalString.get(numericalString.position()) == '0') {
            numericalString.position(numericalString.position() + 1);
        }
    }
}

