
// line 1 "Scanner.java.rl"
/**
 * Copyright (c) 2009-2014, Christer Sandberg
 */
package se.fishtank.css.selectors.scanner;

import java.util.LinkedList;
import java.util.List;

import se.fishtank.css.selectors.Selector;
import se.fishtank.css.selectors.Specifier;
import se.fishtank.css.selectors.specifier.AttributeSpecifier;
import se.fishtank.css.selectors.specifier.NegationSpecifier;
import se.fishtank.css.selectors.specifier.PseudoContainsSpecifier;
import se.fishtank.css.selectors.specifier.PseudoClassSpecifier;
import se.fishtank.css.selectors.specifier.PseudoNthSpecifier;
import se.fishtank.css.util.Assert;

/**
 * A selectors scanner as defined by
 * <a href="http://www.w3.org/TR/css3-selectors/#w3cselgrammar">Selectors Level 3 specification</a>.
 * <p/>
 * This implementation uses the <a href="http://www.complang.org/ragel/">Ragel State Machine Compiler</a>.
 * <p/>
 * Use the following command to generate the Java code for the scanner:
 * <br/>
 * <pre>
 * ragel -J Scanner.java.rl -o ../java/se/fishtank/css/selectors/scanner/Scanner.java
 * </pre>
 *
 * @author Christer Sandberg
 */
public class Scanner {

    /** The input to scan. */
    private final String input;

    /**
     * Create a new scanner instance with the specified {@code input}.
     */
    public Scanner(CharSequence input) {
        Assert.notNull(input, "input is null!");
        this.input = input.toString();
    }


// line 49 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
private static byte[] init__Scanner_actions_0()
{
	return new byte [] {
	    0,    1,    0,    1,    1,    1,    2,    1,    3,    1,    4,    1,
	    5,    1,    6,    1,    7,    1,    8,    1,    9,    1,   12,    1,
	   13,    1,   14,    1,   15,    1,   16,    1,   17,    2,    1,    0,
	    2,    1,    9,    2,    2,    9,    2,    3,    0,    2,    4,   16,
	    2,    4,   17,    2,    6,    9,    2,    8,   16,    2,    8,   17,
	    2,   10,   18,    2,   11,   19,    2,   12,   16,    2,   12,   17,
	    2,   16,    5,    2,   16,    7,    2,   16,   17,    2,   17,    4,
	    2,   17,    8,    2,   17,   12,    2,   17,   16,    3,    4,   16,
	    5,    3,    4,   16,    7,    3,    4,   16,   17,    3,    8,   16,
	    5,    3,    8,   16,    7,    3,    8,   16,   17,    3,   12,   16,
	    5,    3,   12,   16,    7,    3,   12,   16,   17,    3,   16,   11,
	   19,    3,   16,   17,    5,    3,   16,   17,    7,    3,   17,    4,
	   16,    3,   17,    8,   16,    3,   17,   12,   16,    3,   17,   16,
	    5,    3,   17,   16,    7,    4,    4,   16,   11,   19,    4,    4,
	   16,   17,    5,    4,    4,   16,   17,    7,    4,    8,   16,   11,
	   19,    4,    8,   16,   17,    5,    4,    8,   16,   17,    7,    4,
	   12,   16,   11,   19,    4,   12,   16,   17,    5,    4,   12,   16,
	   17,    7,    4,   17,    4,   16,    5,    4,   17,    4,   16,    7,
	    4,   17,    8,   16,    5,    4,   17,    8,   16,    7,    4,   17,
	   12,   16,    5,    4,   17,   12,   16,    7,    4,   17,   16,   11,
	   19
	};
}

private static final byte _Scanner_actions[] = init__Scanner_actions_0();


private static short[] init__Scanner_key_offsets_0()
{
	return new short [] {
	    0,    0,   17,   28,   39,   56,   65,   73,   85,   93,  103,  106,
	  113,  117,  129,  137,  158,  168,  169,  183,  197,  204,  208,  212,
	  234,  242,  262,  282,  302,  322,  342,  350,  357,  379,  387,  407,
	  427,  447,  467,  487,  495,  503,  518,  529,  548,  567,  586,  605,
	  624,  639,  650,  675,  700,  725,  750,  775,  796,  802,  807,  812,
	  818,  819,  820,  821,  825,  826,  827,  838,  849,  858,  866,  877,
	  888,  900,  907,  911,  933,  941,  961,  981, 1001, 1021, 1041, 1049,
	 1056, 1078, 1086, 1106, 1126, 1146, 1166, 1186, 1194, 1205, 1216, 1224,
	 1235, 1246, 1255, 1263, 1275, 1283, 1293, 1296, 1303, 1307, 1319, 1327,
	 1348, 1358, 1359, 1373, 1387, 1394, 1398, 1402, 1424, 1432, 1452, 1472,
	 1492, 1512, 1532, 1540, 1547, 1569, 1577, 1597, 1617, 1637, 1657, 1677,
	 1685, 1693, 1708, 1719, 1738, 1757, 1776, 1795, 1814, 1829, 1840, 1865,
	 1890, 1915, 1940, 1965, 1986, 1992, 1997, 2002, 2008, 2009, 2010, 2011,
	 2015, 2016, 2017, 2028, 2039, 2048, 2056, 2067, 2078, 2090, 2097, 2101,
	 2123, 2131, 2151, 2171, 2191, 2211, 2231, 2239, 2246, 2268, 2276, 2296,
	 2316, 2336, 2356, 2376, 2384, 2395, 2406, 2417, 2428, 2436, 2447, 2464,
	 2475, 2494, 2498, 2507, 2515, 2534, 2544, 2552, 2572, 2582, 2585, 2592,
	 2596, 2604, 2616, 2624, 2645, 2655, 2656, 2670, 2684, 2691, 2695, 2699,
	 2721, 2729, 2749, 2769, 2789, 2809, 2829, 2837, 2844, 2866, 2874, 2894,
	 2914, 2934, 2954, 2974, 2982, 2990, 3005, 3016, 3035, 3054, 3073, 3092,
	 3111, 3126, 3137, 3162, 3187, 3212, 3237, 3262, 3283, 3289, 3294, 3299,
	 3305, 3306, 3307, 3308, 3312, 3313, 3314, 3325, 3349, 3373, 3397, 3421,
	 3445, 3465, 3486, 3507, 3526, 3537, 3560, 3583, 3606, 3629, 3652, 3671,
	 3682, 3705, 3728, 3751, 3774, 3797, 3816, 3824, 3832, 3851, 3862, 3885,
	 3908, 3931, 3954, 3977, 3996, 4018, 4039, 4061, 4072, 4094, 4117, 4128,
	 4155, 4179, 4202, 4225, 4252, 4276, 4303, 4330, 4357, 4384, 4407, 4434,
	 4461, 4488, 4515, 4538, 4560, 4586, 4609, 4631, 4653, 4679, 4702, 4728,
	 4754, 4780, 4806, 4828, 4854, 4880, 4906, 4932, 4954, 4978, 5002, 5026,
	 5050, 5074, 5098, 5122, 5145, 5169, 5193, 5216, 5242, 5265, 5287, 5309,
	 5335, 5358, 5384, 5410, 5436, 5462, 5484, 5510, 5536, 5562, 5588, 5610,
	 5636, 5659, 5681, 5703, 5729, 5752, 5778, 5804, 5830, 5856, 5878, 5904,
	 5930, 5956, 5982, 6004, 6026, 6049, 6060, 6087, 6111, 6134, 6157, 6184,
	 6208, 6235, 6262, 6289, 6316, 6339, 6366, 6393, 6420, 6447, 6470, 6492,
	 6518, 6541, 6563, 6585, 6611, 6634, 6660, 6686, 6712, 6738, 6760, 6786,
	 6812, 6838, 6864, 6886, 6910, 6934, 6958, 6982, 7006, 7030, 7054, 7077,
	 7101, 7125, 7148, 7174, 7197, 7219, 7241, 7267, 7290, 7316, 7342, 7368,
	 7394, 7416, 7442, 7468, 7494, 7520, 7542, 7568, 7591, 7613, 7635, 7661,
	 7684, 7710, 7736, 7762, 7788, 7810, 7836, 7862, 7888, 7914, 7936, 7947,
	 7969, 7995, 8018, 8044, 8070, 8096, 8122, 8144
	};
}

private static final short _Scanner_key_offsets[] = init__Scanner_key_offsets_0();


private static char[] init__Scanner_trans_keys_0()
{
	return new char [] {
	   32,   35,   42,   45,   46,   58,   91,   92,   95,    9,   13,   65,
	   90,   97,  122,  128,  255,   45,   92,   95,   48,   57,   65,   90,
	   97,  122,  128,  255,   45,   92,   95,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   42,   45,   46,   58,   91,   92,   95,
	    9,   13,   65,   90,   97,  122,  128,  255,   45,   92,   95,   65,
	   90,   97,  122,  128,  255,   92,   95,   65,   90,   97,  122,  128,
	  255,   45,   58,   92,   95,   99,  110,   65,   90,   97,  122,  128,
	  255,   92,   95,   65,   90,   97,  122,  128,  255,   32,   43,   45,
	  101,  110,  111,    9,   13,   48,   57,  110,   48,   57,   32,   41,
	  110,    9,   13,   48,   57,   32,   41,    9,   13,   32,   45,   92,
	   95,    9,   13,   65,   90,   97,  122,  128,  255,   92,   95,   65,
	   90,   97,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,
	   94,   95,  124,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   36,   42,   61,   93,   94,  124,  126,    9,   13,
	   61,   32,   34,   39,   45,   92,   95,    9,   13,   65,   90,   97,
	  122,  128,  255,   32,   34,   39,   45,   92,   95,    9,   13,   65,
	   90,   97,  122,  128,  255,    9,   34,   92,   32,  126,  128,  255,
	   32,   93,    9,   13,   32,   93,    9,   13,   12,   13,   34,   92,
	    9,   10,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,
	   97,  102,  103,  126,  128,  255,   34,   92,    9,   10,   32,  126,
	  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,
	    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,
	   97,  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,   47,
	   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,
	  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,
	    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,
	   97,  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,  126,
	  128,  255,    9,   39,   92,   32,  126,  128,  255,   12,   13,   39,
	   92,    9,   10,   32,   47,   48,   57,   58,   64,   65,   70,   71,
	   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,   10,   32,
	  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,
	   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,
	   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,
	   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,
	   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,
	  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,
	   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,
	   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,
	   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,
	  126,  128,  255,   92,   95,   65,   90,   97,  122,  128,  255,   32,
	   45,   92,   93,   95,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,
	  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   45,   92,   93,
	   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   45,
	   92,   93,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   45,   92,   93,   95,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,
	  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,   95,  124,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,   95,
	  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,
	   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,
	   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,
	   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,
	   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   41,   43,   45,    9,   13,   32,   43,
	   45,    9,   13,   32,    9,   13,   48,   57,   32,   41,    9,   13,
	   48,   57,  118,  101,  110,   32,   41,    9,   13,  100,  100,   32,
	   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,   45,
	  126,   48,   57,   65,   70,   97,  102,  128,  255,   45,   92,   95,
	   65,   90,   97,  122,  128,  255,   92,   95,   65,   90,   97,  122,
	  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,
	  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,
	   32,   34,   39,   43,   45,  101,  110,  111,    9,   13,   48,   57,
	    9,   34,   92,   32,  126,  128,  255,   32,   41,    9,   13,   12,
	   13,   34,   92,    9,   10,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,
	   10,   32,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,
	   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,
	  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,
	   13,   32,  126,  128,  255,    9,   39,   92,   32,  126,  128,  255,
	   12,   13,   39,   92,    9,   10,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,
	    9,   10,   32,  126,  128,  255,   39,   92,    9,   13,   32,   47,
	   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,
	  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,
	    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,
	   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,
	   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,
	  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,
	    9,   13,   32,  126,  128,  255,   32,   45,  126,   48,   57,   65,
	   70,   97,  102,  128,  255,   32,   45,  126,   48,   57,   65,   70,
	   97,  102,  128,  255,   92,   95,   65,   90,   97,  122,  128,  255,
	   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,
	   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   45,   92,
	   95,   65,   90,   97,  122,  128,  255,   92,   95,   65,   90,   97,
	  122,  128,  255,   45,   58,   92,   95,   99,  110,   65,   90,   97,
	  122,  128,  255,   92,   95,   65,   90,   97,  122,  128,  255,   32,
	   43,   45,  101,  110,  111,    9,   13,   48,   57,  110,   48,   57,
	   32,   41,  110,    9,   13,   48,   57,   32,   41,    9,   13,   32,
	   45,   92,   95,    9,   13,   65,   90,   97,  122,  128,  255,   92,
	   95,   65,   90,   97,  122,  128,  255,   32,   36,   42,   45,   61,
	   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   36,   42,   61,   93,   94,  124,  126,
	    9,   13,   61,   32,   34,   39,   45,   92,   95,    9,   13,   65,
	   90,   97,  122,  128,  255,   32,   34,   39,   45,   92,   95,    9,
	   13,   65,   90,   97,  122,  128,  255,    9,   34,   92,   32,  126,
	  128,  255,   32,   93,    9,   13,   32,   93,    9,   13,   12,   13,
	   34,   92,    9,   10,   32,   47,   48,   57,   58,   64,   65,   70,
	   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,   10,
	   32,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,
	   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,   13,
	   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,
	  103,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,
	   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,   13,
	   32,  126,  128,  255,    9,   39,   92,   32,  126,  128,  255,   12,
	   13,   39,   92,    9,   10,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,
	   10,   32,  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,
	   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,
	  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,
	   13,   32,  126,  128,  255,   92,   95,   65,   90,   97,  122,  128,
	  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,
	  102,  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   45,
	   92,   93,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   45,   92,   93,   95,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   45,   92,   93,   95,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   45,  126,   48,   57,   65,   70,
	   97,  102,  128,  255,   32,   36,   42,   45,   61,   92,   93,   94,
	   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,   93,
	   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,
	   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,
	   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,
	   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,
	   45,   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   41,   43,   45,    9,   13,
	   32,   43,   45,    9,   13,   32,    9,   13,   48,   57,   32,   41,
	    9,   13,   48,   57,  118,  101,  110,   32,   41,    9,   13,  100,
	  100,   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,
	   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   45,
	   92,   95,   65,   90,   97,  122,  128,  255,   92,   95,   65,   90,
	   97,  122,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,
	  102,  128,  255,   32,   45,  126,   48,   57,   65,   70,   97,  102,
	  128,  255,   32,   34,   39,   43,   45,  101,  110,  111,    9,   13,
	   48,   57,    9,   34,   92,   32,  126,  128,  255,   32,   41,    9,
	   13,   12,   13,   34,   92,    9,   10,   32,   47,   48,   57,   58,
	   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,
	   92,    9,   10,   32,  126,  128,  255,   34,   92,    9,   13,   32,
	   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,
	  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,
	   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,
	   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,
	   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,
	   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,
	  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,
	   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,
	   92,    9,   13,   32,  126,  128,  255,    9,   39,   92,   32,  126,
	  128,  255,   12,   13,   39,   92,    9,   10,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   39,   92,    9,   10,   32,  126,  128,  255,   39,   92,    9,   13,
	   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,
	  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,
	   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,
	   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,
	  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,
	   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,
	   39,   92,    9,   13,   32,  126,  128,  255,   32,   45,  126,   48,
	   57,   65,   70,   97,  102,  128,  255,   32,   45,  126,   48,   57,
	   65,   70,   97,  102,  128,  255,   32,   45,  126,   48,   57,   65,
	   70,   97,  102,  128,  255,   32,   45,  126,   48,   57,   65,   70,
	   97,  102,  128,  255,   92,   95,   65,   90,   97,  122,  128,  255,
	   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,
	   35,   42,   45,   46,   58,   91,   92,   95,    9,   13,   65,   90,
	   97,  122,  128,  255,   45,   92,   95,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   41,
	    9,   13,   45,   92,   95,   65,   90,   97,  122,  128,  255,   92,
	   95,   65,   90,   97,  122,  128,  255,   32,   35,   41,   45,   46,
	   58,   91,   92,   95,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   45,   92,   95,  110,   65,   90,   97,  122,  128,  255,
	   92,   95,   65,   90,   97,  122,  128,  255,   32,   35,   40,   41,
	   45,   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   43,   45,  101,  110,  111,    9,   13,
	   48,   57,  110,   48,   57,   32,   41,  110,    9,   13,   48,   57,
	   32,   41,    9,   13,   32,   35,   41,   46,   58,   91,    9,   13,
	   32,   45,   92,   95,    9,   13,   65,   90,   97,  122,  128,  255,
	   92,   95,   65,   90,   97,  122,  128,  255,   32,   36,   42,   45,
	   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   36,   42,   61,   93,   94,  124,
	  126,    9,   13,   61,   32,   34,   39,   45,   92,   95,    9,   13,
	   65,   90,   97,  122,  128,  255,   32,   34,   39,   45,   92,   95,
	    9,   13,   65,   90,   97,  122,  128,  255,    9,   34,   92,   32,
	  126,  128,  255,   32,   93,    9,   13,   32,   93,    9,   13,   12,
	   13,   34,   92,    9,   10,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,
	   10,   32,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,
	   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,   97,
	  102,  103,  126,  128,  255,   34,   92,    9,   13,   32,   47,   48,
	   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,  128,
	  255,   34,   92,    9,   13,   32,   47,   48,   57,   58,   64,   65,
	   70,   71,   96,   97,  102,  103,  126,  128,  255,   34,   92,    9,
	   13,   32,  126,  128,  255,    9,   39,   92,   32,  126,  128,  255,
	   12,   13,   39,   92,    9,   10,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,
	    9,   10,   32,  126,  128,  255,   39,   92,    9,   13,   32,   47,
	   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,
	  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,
	    9,   13,   32,   47,   48,   57,   58,   64,   65,   70,   71,   96,
	   97,  102,  103,  126,  128,  255,   39,   92,    9,   13,   32,   47,
	   48,   57,   58,   64,   65,   70,   71,   96,   97,  102,  103,  126,
	  128,  255,   39,   92,    9,   13,   32,   47,   48,   57,   58,   64,
	   65,   70,   71,   96,   97,  102,  103,  126,  128,  255,   39,   92,
	    9,   13,   32,  126,  128,  255,   92,   95,   65,   90,   97,  122,
	  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   45,  126,   48,   57,   65,   70,
	   97,  102,  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   45,   92,   93,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   45,   92,   93,   95,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   45,   92,   93,
	   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   45,   92,   93,   95,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   45,  126,   48,   57,   65,
	   70,   97,  102,  128,  255,   32,   36,   42,   45,   61,   92,   93,
	   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,   92,
	   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,   61,
	   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,   45,
	   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   36,   42,
	   45,   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   36,
	   42,   45,   61,   92,   93,   94,   95,  124,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   41,   43,   45,    9,
	   13,   32,   43,   45,    9,   13,   32,    9,   13,   48,   57,   32,
	   41,    9,   13,   48,   57,  118,  101,  110,   32,   41,    9,   13,
	  100,  100,   32,   45,  126,   48,   57,   65,   70,   97,  102,  128,
	  255,   32,   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   41,   45,   46,   58,   91,   92,   95,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   41,   45,   46,   58,   91,   92,   95,  111,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   40,   41,   45,   46,
	   58,   91,   92,   95,  116,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,   95,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   45,
	  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,   35,   41,
	   45,   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,
	   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,
	   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,
	   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,
	   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,
	   95,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,   35,
	   41,   45,   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,
	   45,   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,
	   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,
	   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,
	   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,
	   92,   95,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   41,   46,   58,   91,    9,   13,   92,   95,   65,   90,
	   97,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,   92,
	   95,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   45,  126,   48,   57,   65,   70,   97,  102,  128,  255,   32,   35,
	   41,   45,   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,
	   45,   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,
	   46,   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,
	   58,   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,
	   91,   92,   95,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   41,   45,   46,   58,   91,
	   92,   95,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   42,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   46,   58,   62,
	   91,  126,    9,   13,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   43,   44,   46,   58,   62,   91,  126,    9,   13,
	   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   40,   42,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   40,   42,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   40,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   40,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   42,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   42,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  111,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  110,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  116,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,   97,  126,
	    9,   13,   48,   57,   65,   90,   98,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  105,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  110,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  115,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  111,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  116,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   42,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   42,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   43,   44,   46,   58,   62,   91,  126,    9,   13,
	   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   40,   42,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   40,   42,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   40,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,
	  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   40,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   40,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   42,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,
	   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,
	   35,   42,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  111,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  110,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  116,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,   97,  126,
	    9,   13,   48,   57,   65,   90,   98,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  105,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  110,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  115,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   40,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  111,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  116,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   40,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   42,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,
	   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,
	   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   42,   43,
	   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,
	   57,   65,   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,
	   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,
	   90,   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,
	   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,
	  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,
	  102,  103,  122,  128,  255,   32,   35,   42,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   90,   97,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,
	   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,
	    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,
	   97,  122,  128,  255,   32,   35,   43,   44,   46,   58,   62,   91,
	  126,    9,   13,   32,   35,   43,   44,   45,   46,   58,   62,   91,
	   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,  128,
	  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,   95,
	  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,  103,
	  122,  128,  255,   32,   35,   42,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   90,   97,  122,
	  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,   91,   92,
	   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,   97,  102,
	  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,   58,   62,
	   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,   71,   90,
	   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,   45,   46,
	   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,   65,   70,
	   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,   43,   44,
	   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,   48,   57,
	   65,   70,   71,   90,   97,  102,  103,  122,  128,  255,   32,   35,
	   43,   44,   45,   46,   58,   62,   91,   92,   95,  126,    9,   13,
	   48,   57,   65,   90,   97,  122,  128,  255,    0
	};
}

private static final char _Scanner_trans_keys[] = init__Scanner_trans_keys_0();


private static byte[] init__Scanner_single_lengths_0()
{
	return new byte [] {
	    0,    9,    3,    3,    9,    3,    2,    6,    2,    6,    1,    3,
	    2,    4,    2,   11,    8,    1,    6,    6,    3,    2,    2,    4,
	    2,    2,    2,    2,    2,    2,    2,    3,    4,    2,    2,    2,
	    2,    2,    2,    2,    2,    5,    3,    5,    5,    5,    5,    5,
	    5,    3,   11,   11,   11,   11,   11,   11,    4,    3,    1,    2,
	    1,    1,    1,    2,    1,    1,    3,    3,    3,    2,    3,    3,
	    8,    3,    2,    4,    2,    2,    2,    2,    2,    2,    2,    3,
	    4,    2,    2,    2,    2,    2,    2,    2,    3,    3,    2,    3,
	    3,    3,    2,    6,    2,    6,    1,    3,    2,    4,    2,   11,
	    8,    1,    6,    6,    3,    2,    2,    4,    2,    2,    2,    2,
	    2,    2,    2,    3,    4,    2,    2,    2,    2,    2,    2,    2,
	    2,    5,    3,    5,    5,    5,    5,    5,    5,    3,   11,   11,
	   11,   11,   11,   11,    4,    3,    1,    2,    1,    1,    1,    2,
	    1,    1,    3,    3,    3,    2,    3,    3,    8,    3,    2,    4,
	    2,    2,    2,    2,    2,    2,    2,    3,    4,    2,    2,    2,
	    2,    2,    2,    2,    3,    3,    3,    3,    2,    3,    9,    3,
	    9,    2,    3,    2,    9,    4,    2,   10,    6,    1,    3,    2,
	    6,    4,    2,   11,    8,    1,    6,    6,    3,    2,    2,    4,
	    2,    2,    2,    2,    2,    2,    2,    3,    4,    2,    2,    2,
	    2,    2,    2,    2,    2,    5,    3,    5,    5,    5,    5,    5,
	    5,    3,   11,   11,   11,   11,   11,   11,    4,    3,    1,    2,
	    1,    1,    1,    2,    1,    1,    3,   10,   10,   10,   10,   10,
	   10,   11,   11,    9,    3,    9,    9,    9,    9,    9,    9,    3,
	    9,    9,    9,    9,    9,    9,    6,    2,    9,    3,    9,    9,
	    9,    9,    9,    9,   12,   13,   12,    9,   12,   13,    9,   13,
	   14,   13,   13,   13,   14,   13,   13,   13,   13,   13,   13,   13,
	   13,   13,   13,   12,   12,   13,   12,   12,   12,   13,   12,   12,
	   12,   12,   12,   12,   12,   12,   12,   12,   14,   14,   14,   14,
	   14,   14,   14,   13,   14,   14,   13,   12,   13,   12,   12,   12,
	   13,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,
	   13,   12,   12,   12,   13,   12,   12,   12,   12,   12,   12,   12,
	   12,   12,   12,   12,   13,    9,   13,   14,   13,   13,   13,   14,
	   13,   13,   13,   13,   13,   13,   13,   13,   13,   13,   12,   12,
	   13,   12,   12,   12,   13,   12,   12,   12,   12,   12,   12,   12,
	   12,   12,   12,   14,   14,   14,   14,   14,   14,   14,   13,   14,
	   14,   13,   12,   13,   12,   12,   12,   13,   12,   12,   12,   12,
	   12,   12,   12,   12,   12,   12,   12,   13,   12,   12,   12,   13,
	   12,   12,   12,   12,   12,   12,   12,   12,   12,   12,    9,   12,
	   12,   13,   12,   12,   12,   12,   12,    0
	};
}

private static final byte _Scanner_single_lengths[] = init__Scanner_single_lengths_0();


private static byte[] init__Scanner_range_lengths_0()
{
	return new byte [] {
	    0,    4,    4,    4,    4,    3,    3,    3,    3,    2,    1,    2,
	    1,    4,    3,    5,    1,    0,    4,    4,    2,    1,    1,    9,
	    3,    9,    9,    9,    9,    9,    3,    2,    9,    3,    9,    9,
	    9,    9,    9,    3,    3,    5,    4,    7,    7,    7,    7,    7,
	    5,    4,    7,    7,    7,    7,    7,    5,    1,    1,    2,    2,
	    0,    0,    0,    1,    0,    0,    4,    4,    3,    3,    4,    4,
	    2,    2,    1,    9,    3,    9,    9,    9,    9,    9,    3,    2,
	    9,    3,    9,    9,    9,    9,    9,    3,    4,    4,    3,    4,
	    4,    3,    3,    3,    3,    2,    1,    2,    1,    4,    3,    5,
	    1,    0,    4,    4,    2,    1,    1,    9,    3,    9,    9,    9,
	    9,    9,    3,    2,    9,    3,    9,    9,    9,    9,    9,    3,
	    3,    5,    4,    7,    7,    7,    7,    7,    5,    4,    7,    7,
	    7,    7,    7,    5,    1,    1,    2,    2,    0,    0,    0,    1,
	    0,    0,    4,    4,    3,    3,    4,    4,    2,    2,    1,    9,
	    3,    9,    9,    9,    9,    9,    3,    2,    9,    3,    9,    9,
	    9,    9,    9,    3,    4,    4,    4,    4,    3,    4,    4,    4,
	    5,    1,    3,    3,    5,    3,    3,    5,    2,    1,    2,    1,
	    1,    4,    3,    5,    1,    0,    4,    4,    2,    1,    1,    9,
	    3,    9,    9,    9,    9,    9,    3,    2,    9,    3,    9,    9,
	    9,    9,    9,    3,    3,    5,    4,    7,    7,    7,    7,    7,
	    5,    4,    7,    7,    7,    7,    7,    5,    1,    1,    2,    2,
	    0,    0,    0,    1,    0,    0,    4,    7,    7,    7,    7,    7,
	    5,    5,    5,    5,    4,    7,    7,    7,    7,    7,    5,    4,
	    7,    7,    7,    7,    7,    5,    1,    3,    5,    4,    7,    7,
	    7,    7,    7,    5,    5,    4,    5,    1,    5,    5,    1,    7,
	    5,    5,    5,    7,    5,    7,    7,    7,    7,    5,    7,    7,
	    7,    7,    5,    5,    7,    5,    5,    5,    7,    5,    7,    7,
	    7,    7,    5,    7,    7,    7,    7,    5,    5,    5,    5,    5,
	    5,    5,    5,    5,    5,    5,    5,    7,    5,    5,    5,    7,
	    5,    7,    7,    7,    7,    5,    7,    7,    7,    7,    5,    7,
	    5,    5,    5,    7,    5,    7,    7,    7,    7,    5,    7,    7,
	    7,    7,    5,    5,    5,    1,    7,    5,    5,    5,    7,    5,
	    7,    7,    7,    7,    5,    7,    7,    7,    7,    5,    5,    7,
	    5,    5,    5,    7,    5,    7,    7,    7,    7,    5,    7,    7,
	    7,    7,    5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
	    5,    5,    7,    5,    5,    5,    7,    5,    7,    7,    7,    7,
	    5,    7,    7,    7,    7,    5,    7,    5,    5,    5,    7,    5,
	    7,    7,    7,    7,    5,    7,    7,    7,    7,    5,    1,    5,
	    7,    5,    7,    7,    7,    7,    5,    0
	};
}

private static final byte _Scanner_range_lengths[] = init__Scanner_range_lengths_0();


private static short[] init__Scanner_index_offsets_0()
{
	return new short [] {
	    0,    0,   14,   22,   30,   44,   51,   57,   67,   73,   82,   85,
	   91,   95,  104,  110,  127,  137,  139,  150,  161,  167,  171,  175,
	  189,  195,  207,  219,  231,  243,  255,  261,  267,  281,  287,  299,
	  311,  323,  335,  347,  353,  359,  370,  378,  391,  404,  417,  430,
	  443,  454,  462,  481,  500,  519,  538,  557,  574,  580,  585,  589,
	  594,  596,  598,  600,  604,  606,  608,  616,  624,  631,  637,  645,
	  653,  664,  670,  674,  688,  694,  706,  718,  730,  742,  754,  760,
	  766,  780,  786,  798,  810,  822,  834,  846,  852,  860,  868,  874,
	  882,  890,  897,  903,  913,  919,  928,  931,  937,  941,  950,  956,
	  973,  983,  985,  996, 1007, 1013, 1017, 1021, 1035, 1041, 1053, 1065,
	 1077, 1089, 1101, 1107, 1113, 1127, 1133, 1145, 1157, 1169, 1181, 1193,
	 1199, 1205, 1216, 1224, 1237, 1250, 1263, 1276, 1289, 1300, 1308, 1327,
	 1346, 1365, 1384, 1403, 1420, 1426, 1431, 1435, 1440, 1442, 1444, 1446,
	 1450, 1452, 1454, 1462, 1470, 1477, 1483, 1491, 1499, 1510, 1516, 1520,
	 1534, 1540, 1552, 1564, 1576, 1588, 1600, 1606, 1612, 1626, 1632, 1644,
	 1656, 1668, 1680, 1692, 1698, 1706, 1714, 1722, 1730, 1736, 1744, 1758,
	 1766, 1781, 1785, 1792, 1798, 1813, 1821, 1827, 1843, 1852, 1855, 1861,
	 1865, 1873, 1882, 1888, 1905, 1915, 1917, 1928, 1939, 1945, 1949, 1953,
	 1967, 1973, 1985, 1997, 2009, 2021, 2033, 2039, 2045, 2059, 2065, 2077,
	 2089, 2101, 2113, 2125, 2131, 2137, 2148, 2156, 2169, 2182, 2195, 2208,
	 2221, 2232, 2240, 2259, 2278, 2297, 2316, 2335, 2352, 2358, 2363, 2367,
	 2372, 2374, 2376, 2378, 2382, 2384, 2386, 2394, 2412, 2430, 2448, 2466,
	 2484, 2500, 2517, 2534, 2549, 2557, 2574, 2591, 2608, 2625, 2642, 2657,
	 2665, 2682, 2699, 2716, 2733, 2750, 2765, 2773, 2779, 2794, 2802, 2819,
	 2836, 2853, 2870, 2887, 2902, 2920, 2938, 2956, 2967, 2985, 3004, 3015,
	 3036, 3056, 3075, 3094, 3115, 3135, 3156, 3177, 3198, 3219, 3238, 3259,
	 3280, 3301, 3322, 3341, 3359, 3379, 3398, 3416, 3434, 3454, 3473, 3493,
	 3513, 3533, 3553, 3571, 3591, 3611, 3631, 3651, 3669, 3689, 3709, 3729,
	 3749, 3769, 3789, 3809, 3828, 3848, 3868, 3887, 3907, 3926, 3944, 3962,
	 3982, 4001, 4021, 4041, 4061, 4081, 4099, 4119, 4139, 4159, 4179, 4197,
	 4217, 4236, 4254, 4272, 4292, 4311, 4331, 4351, 4371, 4391, 4409, 4429,
	 4449, 4469, 4489, 4507, 4525, 4544, 4555, 4576, 4596, 4615, 4634, 4655,
	 4675, 4696, 4717, 4738, 4759, 4778, 4799, 4820, 4841, 4862, 4881, 4899,
	 4919, 4938, 4956, 4974, 4994, 5013, 5033, 5053, 5073, 5093, 5111, 5131,
	 5151, 5171, 5191, 5209, 5229, 5249, 5269, 5289, 5309, 5329, 5349, 5368,
	 5388, 5408, 5427, 5447, 5466, 5484, 5502, 5522, 5541, 5561, 5581, 5601,
	 5621, 5639, 5659, 5679, 5699, 5719, 5737, 5757, 5776, 5794, 5812, 5832,
	 5851, 5871, 5891, 5911, 5931, 5949, 5969, 5989, 6009, 6029, 6047, 6058,
	 6076, 6096, 6115, 6135, 6155, 6175, 6195, 6213
	};
}

private static final short _Scanner_index_offsets[] = init__Scanner_index_offsets_0();


private static short[] init__Scanner_indicies_0()
{
	return new short [] {
	    0,    2,    3,    4,    5,    6,    8,    9,    7,    0,    7,    7,
	    7,    1,   10,   11,   10,   10,   10,   10,   10,    1,   12,   13,
	   12,   12,   12,   12,   12,    1,   14,   15,   16,   17,   18,   19,
	   21,   22,   20,   14,   20,   20,   20,    1,   23,   25,   24,   24,
	   24,   24,    1,   27,   26,   26,   26,   26,    1,   28,   29,   31,
	   30,   32,   33,   30,   30,   30,    1,   35,   34,   34,   34,   34,
	    1,   36,   37,   37,   39,   40,   41,   36,   38,    1,   43,   42,
	    1,   44,   45,   43,   44,   42,    1,   46,   47,   46,    1,   21,
	   48,   50,   49,   21,   49,   49,   49,    1,   52,   51,   51,   51,
	   51,    1,   53,   54,   54,   51,   55,   52,   56,   54,   51,   54,
	   54,   53,   51,   51,   51,   51,    1,   57,   58,   58,   59,   60,
	   58,   58,   58,   57,    1,   61,    1,   62,   63,   64,   65,   67,
	   66,   62,   66,   66,   66,    1,   68,   69,   70,   71,   73,   72,
	   68,   72,   72,   72,    1,   74,   75,   76,   74,   74,    1,   77,
	   78,   77,    1,   79,   60,   79,    1,   74,   80,   75,   76,   74,
	   74,   81,   74,   81,   74,   81,   74,   74,    1,   75,   76,   74,
	   74,   74,    1,   75,   76,   74,   74,   82,   74,   82,   74,   82,
	   74,   74,    1,   75,   76,   74,   74,   83,   74,   83,   74,   83,
	   74,   74,    1,   75,   76,   74,   74,   84,   74,   84,   74,   84,
	   74,   74,    1,   75,   76,   74,   74,   85,   74,   85,   74,   85,
	   74,   74,    1,   75,   76,   74,   74,   86,   74,   86,   74,   86,
	   74,   74,    1,   75,   76,   74,   74,   74,    1,   87,   75,   88,
	   87,   87,    1,   87,   89,   75,   88,   87,   87,   90,   87,   90,
	   87,   90,   87,   87,    1,   75,   88,   87,   87,   87,    1,   75,
	   88,   87,   87,   91,   87,   91,   87,   91,   87,   87,    1,   75,
	   88,   87,   87,   92,   87,   92,   87,   92,   87,   87,    1,   75,
	   88,   87,   87,   93,   87,   93,   87,   93,   87,   87,    1,   75,
	   88,   87,   87,   94,   87,   94,   87,   94,   87,   87,    1,   75,
	   88,   87,   87,   95,   87,   95,   87,   95,   87,   87,    1,   75,
	   88,   87,   87,   87,    1,   97,   96,   96,   96,   96,    1,   77,
	   96,   97,   78,   96,   77,   96,   96,   96,   96,    1,   96,   96,
	   96,   98,   98,   98,   96,    1,   99,   96,   97,   78,   96,   99,
	  100,  100,   96,  100,   96,   96,    1,   99,   96,   97,   78,   96,
	   99,  101,  101,   96,  101,   96,   96,    1,   99,   96,   97,   78,
	   96,   99,  102,  102,   96,  102,   96,   96,    1,   99,   96,   97,
	   78,   96,   99,  103,  103,   96,  103,   96,   96,    1,   99,   96,
	   97,   78,   96,   99,  104,  104,   96,  104,   96,   96,    1,   99,
	   96,   97,   78,   96,   99,   96,   96,   96,   96,    1,   51,   51,
	   51,  105,  105,  105,   51,    1,  106,   54,   54,   51,   55,   52,
	   56,   54,   51,   54,   54,  106,  107,  107,   51,  107,   51,   51,
	    1,  106,   54,   54,   51,   55,   52,   56,   54,   51,   54,   54,
	  106,  108,  108,   51,  108,   51,   51,    1,  106,   54,   54,   51,
	   55,   52,   56,   54,   51,   54,   54,  106,  109,  109,   51,  109,
	   51,   51,    1,  106,   54,   54,   51,   55,   52,   56,   54,   51,
	   54,   54,  106,  110,  110,   51,  110,   51,   51,    1,  106,   54,
	   54,   51,   55,   52,   56,   54,   51,   54,   54,  106,  111,  111,
	   51,  111,   51,   51,    1,  106,   54,   54,   51,   55,   52,   56,
	   54,   51,   54,   54,  106,   51,   51,   51,   51,    1,  112,   45,
	  113,  113,  112,    1,  112,  113,  113,  112,    1,  113,  113,  114,
	    1,   44,   45,   44,  114,    1,  115,    1,  116,    1,  117,    1,
	   44,   45,   44,    1,  118,    1,  117,    1,   34,   34,   34,  119,
	  119,  119,   34,    1,  120,  120,  120,  121,  121,  121,  120,    1,
	  122,  124,  123,  123,  123,  123,    1,  124,  123,  123,  123,  123,
	    1,  123,  123,  123,  125,  125,  125,  123,    1,  126,  126,  126,
	  127,  127,  127,  126,    1,  128,  129,  130,   37,   37,   39,   40,
	   41,  128,   38,    1,  131,  132,  133,  131,  131,    1,  134,  135,
	  134,    1,  131,  136,  132,  133,  131,  131,  137,  131,  137,  131,
	  137,  131,  131,    1,  132,  133,  131,  131,  131,    1,  132,  133,
	  131,  131,  138,  131,  138,  131,  138,  131,  131,    1,  132,  133,
	  131,  131,  139,  131,  139,  131,  139,  131,  131,    1,  132,  133,
	  131,  131,  140,  131,  140,  131,  140,  131,  131,    1,  132,  133,
	  131,  131,  141,  131,  141,  131,  141,  131,  131,    1,  132,  133,
	  131,  131,  142,  131,  142,  131,  142,  131,  131,    1,  132,  133,
	  131,  131,  131,    1,  143,  132,  144,  143,  143,    1,  143,  145,
	  132,  144,  143,  143,  146,  143,  146,  143,  146,  143,  143,    1,
	  132,  144,  143,  143,  143,    1,  132,  144,  143,  143,  147,  143,
	  147,  143,  147,  143,  143,    1,  132,  144,  143,  143,  148,  143,
	  148,  143,  148,  143,  143,    1,  132,  144,  143,  143,  149,  143,
	  149,  143,  149,  143,  143,    1,  132,  144,  143,  143,  150,  143,
	  150,  143,  150,  143,  143,    1,  132,  144,  143,  143,  151,  143,
	  151,  143,  151,  143,  143,    1,  132,  144,  143,  143,  143,    1,
	   26,   26,   26,  152,  152,  152,   26,    1,  153,  153,  153,  154,
	  154,  154,  153,    1,  155,  126,  126,  126,  126,    1,  156,  156,
	  156,  157,  157,  157,  156,    1,  158,  158,  158,  159,  159,  159,
	  158,    1,  160,  162,  161,  161,  161,  161,    1,  164,  163,  163,
	  163,  163,    1,  165,  166,  168,  167,  169,  170,  167,  167,  167,
	    1,  172,  171,  171,  171,  171,    1,  173,  174,  174,  176,  177,
	  178,  173,  175,    1,  180,  179,    1,  181,  182,  180,  181,  179,
	    1,  183,  184,  183,    1,  185,  186,  188,  187,  185,  187,  187,
	  187,    1,  190,  189,  189,  189,  189,    1,  191,  192,  192,  189,
	  193,  190,  194,  192,  189,  192,  192,  191,  189,  189,  189,  189,
	    1,  195,  196,  196,  197,  198,  196,  196,  196,  195,    1,  199,
	    1,  200,  201,  202,  203,  205,  204,  200,  204,  204,  204,    1,
	  206,  207,  208,  209,  211,  210,  206,  210,  210,  210,    1,  212,
	  213,  214,  212,  212,    1,  215,  216,  215,    1,  217,  198,  217,
	    1,  212,  218,  213,  214,  212,  212,  219,  212,  219,  212,  219,
	  212,  212,    1,  213,  214,  212,  212,  212,    1,  213,  214,  212,
	  212,  220,  212,  220,  212,  220,  212,  212,    1,  213,  214,  212,
	  212,  221,  212,  221,  212,  221,  212,  212,    1,  213,  214,  212,
	  212,  222,  212,  222,  212,  222,  212,  212,    1,  213,  214,  212,
	  212,  223,  212,  223,  212,  223,  212,  212,    1,  213,  214,  212,
	  212,  224,  212,  224,  212,  224,  212,  212,    1,  213,  214,  212,
	  212,  212,    1,  225,  213,  226,  225,  225,    1,  225,  227,  213,
	  226,  225,  225,  228,  225,  228,  225,  228,  225,  225,    1,  213,
	  226,  225,  225,  225,    1,  213,  226,  225,  225,  229,  225,  229,
	  225,  229,  225,  225,    1,  213,  226,  225,  225,  230,  225,  230,
	  225,  230,  225,  225,    1,  213,  226,  225,  225,  231,  225,  231,
	  225,  231,  225,  225,    1,  213,  226,  225,  225,  232,  225,  232,
	  225,  232,  225,  225,    1,  213,  226,  225,  225,  233,  225,  233,
	  225,  233,  225,  225,    1,  213,  226,  225,  225,  225,    1,  235,
	  234,  234,  234,  234,    1,  215,  234,  235,  216,  234,  215,  234,
	  234,  234,  234,    1,  234,  234,  234,  236,  236,  236,  234,    1,
	  237,  234,  235,  216,  234,  237,  238,  238,  234,  238,  234,  234,
	    1,  237,  234,  235,  216,  234,  237,  239,  239,  234,  239,  234,
	  234,    1,  237,  234,  235,  216,  234,  237,  240,  240,  234,  240,
	  234,  234,    1,  237,  234,  235,  216,  234,  237,  241,  241,  234,
	  241,  234,  234,    1,  237,  234,  235,  216,  234,  237,  242,  242,
	  234,  242,  234,  234,    1,  237,  234,  235,  216,  234,  237,  234,
	  234,  234,  234,    1,  189,  189,  189,  243,  243,  243,  189,    1,
	  244,  192,  192,  189,  193,  190,  194,  192,  189,  192,  192,  244,
	  245,  245,  189,  245,  189,  189,    1,  244,  192,  192,  189,  193,
	  190,  194,  192,  189,  192,  192,  244,  246,  246,  189,  246,  189,
	  189,    1,  244,  192,  192,  189,  193,  190,  194,  192,  189,  192,
	  192,  244,  247,  247,  189,  247,  189,  189,    1,  244,  192,  192,
	  189,  193,  190,  194,  192,  189,  192,  192,  244,  248,  248,  189,
	  248,  189,  189,    1,  244,  192,  192,  189,  193,  190,  194,  192,
	  189,  192,  192,  244,  249,  249,  189,  249,  189,  189,    1,  244,
	  192,  192,  189,  193,  190,  194,  192,  189,  192,  192,  244,  189,
	  189,  189,  189,    1,  250,  182,  251,  251,  250,    1,  250,  251,
	  251,  250,    1,  251,  251,  252,    1,  181,  182,  181,  252,    1,
	  253,    1,  254,    1,  255,    1,  181,  182,  181,    1,  256,    1,
	  255,    1,  171,  171,  171,  257,  257,  257,  171,    1,  258,  258,
	  258,  259,  259,  259,  258,    1,  260,  262,  261,  261,  261,  261,
	    1,  262,  261,  261,  261,  261,    1,  261,  261,  261,  263,  263,
	  263,  261,    1,  264,  264,  264,  265,  265,  265,  264,    1,  266,
	  267,  268,  174,  174,  176,  177,  178,  266,  175,    1,  269,  270,
	  271,  269,  269,    1,  272,  273,  272,    1,  269,  274,  270,  271,
	  269,  269,  275,  269,  275,  269,  275,  269,  269,    1,  270,  271,
	  269,  269,  269,    1,  270,  271,  269,  269,  276,  269,  276,  269,
	  276,  269,  269,    1,  270,  271,  269,  269,  277,  269,  277,  269,
	  277,  269,  269,    1,  270,  271,  269,  269,  278,  269,  278,  269,
	  278,  269,  269,    1,  270,  271,  269,  269,  279,  269,  279,  269,
	  279,  269,  269,    1,  270,  271,  269,  269,  280,  269,  280,  269,
	  280,  269,  269,    1,  270,  271,  269,  269,  269,    1,  281,  270,
	  282,  281,  281,    1,  281,  283,  270,  282,  281,  281,  284,  281,
	  284,  281,  284,  281,  281,    1,  270,  282,  281,  281,  281,    1,
	  270,  282,  281,  281,  285,  281,  285,  281,  285,  281,  281,    1,
	  270,  282,  281,  281,  286,  281,  286,  281,  286,  281,  281,    1,
	  270,  282,  281,  281,  287,  281,  287,  281,  287,  281,  281,    1,
	  270,  282,  281,  281,  288,  281,  288,  281,  288,  281,  281,    1,
	  270,  282,  281,  281,  289,  281,  289,  281,  289,  281,  281,    1,
	  270,  282,  281,  281,  281,    1,  163,  163,  163,  290,  290,  290,
	  163,    1,  291,  291,  291,  292,  292,  292,  291,    1,  293,  293,
	  293,  294,  294,  294,  293,    1,  295,  295,  295,  296,  296,  296,
	  295,    1,  298,  297,  297,  297,  297,    1,  297,  297,  297,  299,
	  299,  299,  297,    1,  300,  301,  302,  303,  304,  305,  307,  308,
	  306,  300,  306,  306,  306,    1,  309,  310,  309,  309,  309,  309,
	  309,    1,  311,  312,  313,  314,  315,  316,  317,  318,  314,  311,
	  314,  314,  314,  314,    1,  319,  320,  319,    1,  321,  323,  322,
	  322,  322,  322,    1,  325,  324,  324,  324,  324,    1,  326,  327,
	  328,  324,  329,  330,  331,  325,  324,  326,  324,  324,  324,  324,
	    1,  332,  334,  333,  335,  333,  333,  333,    1,  337,  336,  336,
	  336,  336,    1,  338,  339,  340,  341,  336,  342,  343,  344,  337,
	  336,  338,  336,  336,  336,  336,    1,  345,  346,  346,  348,  349,
	  350,  345,  347,    1,  352,  351,    1,  353,  354,  352,  353,  351,
	    1,  355,  356,  355,    1,  357,  301,  358,  304,  305,  307,  357,
	    1,  307,  359,  361,  360,  307,  360,  360,  360,    1,  363,  362,
	  362,  362,  362,    1,  364,  365,  365,  362,  366,  363,  367,  365,
	  362,  365,  365,  364,  362,  362,  362,  362,    1,  368,  369,  369,
	  370,  371,  369,  369,  369,  368,    1,  372,    1,  373,  374,  375,
	  376,  378,  377,  373,  377,  377,  377,    1,  379,  380,  381,  382,
	  384,  383,  379,  383,  383,  383,    1,  385,  386,  387,  385,  385,
	    1,  388,  389,  388,    1,  390,  371,  390,    1,  385,  391,  386,
	  387,  385,  385,  392,  385,  392,  385,  392,  385,  385,    1,  386,
	  387,  385,  385,  385,    1,  386,  387,  385,  385,  393,  385,  393,
	  385,  393,  385,  385,    1,  386,  387,  385,  385,  394,  385,  394,
	  385,  394,  385,  385,    1,  386,  387,  385,  385,  395,  385,  395,
	  385,  395,  385,  385,    1,  386,  387,  385,  385,  396,  385,  396,
	  385,  396,  385,  385,    1,  386,  387,  385,  385,  397,  385,  397,
	  385,  397,  385,  385,    1,  386,  387,  385,  385,  385,    1,  398,
	  386,  399,  398,  398,    1,  398,  400,  386,  399,  398,  398,  401,
	  398,  401,  398,  401,  398,  398,    1,  386,  399,  398,  398,  398,
	    1,  386,  399,  398,  398,  402,  398,  402,  398,  402,  398,  398,
	    1,  386,  399,  398,  398,  403,  398,  403,  398,  403,  398,  398,
	    1,  386,  399,  398,  398,  404,  398,  404,  398,  404,  398,  398,
	    1,  386,  399,  398,  398,  405,  398,  405,  398,  405,  398,  398,
	    1,  386,  399,  398,  398,  406,  398,  406,  398,  406,  398,  398,
	    1,  386,  399,  398,  398,  398,    1,  408,  407,  407,  407,  407,
	    1,  388,  407,  408,  389,  407,  388,  407,  407,  407,  407,    1,
	  407,  407,  407,  409,  409,  409,  407,    1,  410,  407,  408,  389,
	  407,  410,  411,  411,  407,  411,  407,  407,    1,  410,  407,  408,
	  389,  407,  410,  412,  412,  407,  412,  407,  407,    1,  410,  407,
	  408,  389,  407,  410,  413,  413,  407,  413,  407,  407,    1,  410,
	  407,  408,  389,  407,  410,  414,  414,  407,  414,  407,  407,    1,
	  410,  407,  408,  389,  407,  410,  415,  415,  407,  415,  407,  407,
	    1,  410,  407,  408,  389,  407,  410,  407,  407,  407,  407,    1,
	  362,  362,  362,  416,  416,  416,  362,    1,  417,  365,  365,  362,
	  366,  363,  367,  365,  362,  365,  365,  417,  418,  418,  362,  418,
	  362,  362,    1,  417,  365,  365,  362,  366,  363,  367,  365,  362,
	  365,  365,  417,  419,  419,  362,  419,  362,  362,    1,  417,  365,
	  365,  362,  366,  363,  367,  365,  362,  365,  365,  417,  420,  420,
	  362,  420,  362,  362,    1,  417,  365,  365,  362,  366,  363,  367,
	  365,  362,  365,  365,  417,  421,  421,  362,  421,  362,  362,    1,
	  417,  365,  365,  362,  366,  363,  367,  365,  362,  365,  365,  417,
	  422,  422,  362,  422,  362,  362,    1,  417,  365,  365,  362,  366,
	  363,  367,  365,  362,  365,  365,  417,  362,  362,  362,  362,    1,
	  423,  354,  424,  424,  423,    1,  423,  424,  424,  423,    1,  424,
	  424,  425,    1,  353,  354,  353,  425,    1,  426,    1,  427,    1,
	  428,    1,  353,  354,  353,    1,  429,    1,  428,    1,  336,  336,
	  336,  430,  430,  430,  336,    1,  431,  339,  340,  341,  336,  342,
	  343,  344,  337,  336,  431,  432,  432,  336,  432,  336,  336,    1,
	  431,  339,  340,  341,  336,  342,  343,  344,  337,  336,  431,  433,
	  433,  336,  433,  336,  336,    1,  431,  339,  340,  341,  336,  342,
	  343,  344,  337,  336,  431,  434,  434,  336,  434,  336,  336,    1,
	  431,  339,  340,  341,  336,  342,  343,  344,  337,  336,  431,  435,
	  435,  336,  435,  336,  336,    1,  431,  339,  340,  341,  336,  342,
	  343,  344,  337,  336,  431,  436,  436,  336,  436,  336,  336,    1,
	  431,  339,  340,  341,  336,  342,  343,  344,  337,  336,  431,  336,
	  336,  336,  336,    1,  338,  339,  340,  341,  336,  342,  343,  344,
	  337,  336,  437,  338,  336,  336,  336,  336,    1,  338,  339,  340,
	  341,  336,  342,  343,  344,  337,  336,  438,  338,  336,  336,  336,
	  336,    1,  338,  339,  341,  336,  342,  343,  344,  337,  336,  338,
	  336,  336,  336,  336,    1,  324,  324,  324,  439,  439,  439,  324,
	    1,  440,  327,  328,  324,  329,  330,  331,  325,  324,  440,  441,
	  441,  324,  441,  324,  324,    1,  440,  327,  328,  324,  329,  330,
	  331,  325,  324,  440,  442,  442,  324,  442,  324,  324,    1,  440,
	  327,  328,  324,  329,  330,  331,  325,  324,  440,  443,  443,  324,
	  443,  324,  324,    1,  440,  327,  328,  324,  329,  330,  331,  325,
	  324,  440,  444,  444,  324,  444,  324,  324,    1,  440,  327,  328,
	  324,  329,  330,  331,  325,  324,  440,  445,  445,  324,  445,  324,
	  324,    1,  440,  327,  328,  324,  329,  330,  331,  325,  324,  440,
	  324,  324,  324,  324,    1,  314,  314,  314,  446,  446,  446,  314,
	    1,  447,  312,  313,  314,  315,  316,  317,  318,  314,  447,  448,
	  448,  314,  448,  314,  314,    1,  447,  312,  313,  314,  315,  316,
	  317,  318,  314,  447,  449,  449,  314,  449,  314,  314,    1,  447,
	  312,  313,  314,  315,  316,  317,  318,  314,  447,  450,  450,  314,
	  450,  314,  314,    1,  447,  312,  313,  314,  315,  316,  317,  318,
	  314,  447,  451,  451,  314,  451,  314,  314,    1,  447,  312,  313,
	  314,  315,  316,  317,  318,  314,  447,  452,  452,  314,  452,  314,
	  314,    1,  447,  312,  313,  314,  315,  316,  317,  318,  314,  447,
	  314,  314,  314,  314,    1,  453,  454,  455,  456,  457,  458,  453,
	    1,  460,  459,  459,  459,  459,    1,  453,  454,  455,  459,  456,
	  457,  458,  460,  459,  453,  459,  459,  459,  459,    1,  459,  459,
	  459,  461,  461,  461,  459,    1,  462,  454,  455,  459,  456,  457,
	  458,  460,  459,  462,  463,  463,  459,  463,  459,  459,    1,  462,
	  454,  455,  459,  456,  457,  458,  460,  459,  462,  464,  464,  459,
	  464,  459,  459,    1,  462,  454,  455,  459,  456,  457,  458,  460,
	  459,  462,  465,  465,  459,  465,  459,  459,    1,  462,  454,  455,
	  459,  456,  457,  458,  460,  459,  462,  466,  466,  459,  466,  459,
	  459,    1,  462,  454,  455,  459,  456,  457,  458,  460,  459,  462,
	  467,  467,  459,  467,  459,  459,    1,  462,  454,  455,  459,  456,
	  457,  458,  460,  459,  462,  459,  459,  459,  459,    1,  468,  469,
	  470,  471,  293,  472,  473,  470,  474,  475,  293,  470,  468,  293,
	  293,  293,  293,    1,  476,   15,   16,  477,  478,   17,   18,   19,
	  477,   21,   22,   20,  477,  476,   20,   20,   20,    1,  468,  479,
	  470,  471,  156,  480,  481,  470,  482,  483,  156,  470,  468,  156,
	  156,  156,  156,    1,  484,  485,  486,  487,  488,  489,  486,  490,
	  486,  484,    1,  491,  492,  493,  494,   26,  495,  496,  493,  497,
	   27,   26,  493,  491,   26,   26,   26,   26,    1,  498,  499,  500,
	  501,  502,   34,  503,  504,  501,  505,   35,   34,  501,  498,   34,
	   34,   34,   34,    1,  506,   15,  507,  508,   18,   19,  507,   21,
	  507,  506,    1,  509,  499,  500,  501,  502,   34,  503,  504,  501,
	  505,   35,   34,  501,  509,  510,  510,   34,  510,   34,   34,    1,
	  498,  499,  500,   16,  501,  502,  511,  503,  504,  501,  505,  513,
	  512,  501,  498,   34,  512,  512,  512,    1,  498,  499,  500,  501,
	  502,   34,  503,  504,  501,  505,  514,  120,  501,  498,   34,  120,
	  120,  120,    1,  515,  516,  500,  517,  518,  120,  519,  520,  517,
	  521,  514,  120,  517,  515,  120,  120,  120,  120,    1,  522,  516,
	  500,  517,  518,  120,  519,  520,  517,  521,  514,  120,  517,  522,
	  523,  523,  120,  523,  120,  120,    1,  515,  516,  500,   16,  517,
	  518,  512,  519,  520,  517,  521,  513,  512,  517,  515,  120,  512,
	  512,  512,    1,  522,  516,  500,  517,  518,  120,  519,  520,  517,
	  521,  514,  120,  517,  522,  524,  524,  120,  524,  120,  120,    1,
	  522,  516,  500,  517,  518,  120,  519,  520,  517,  521,  514,  120,
	  517,  522,  525,  525,  120,  525,  120,  120,    1,  522,  516,  500,
	  517,  518,  120,  519,  520,  517,  521,  514,  120,  517,  522,  526,
	  526,  120,  526,  120,  120,    1,  522,  516,  500,  517,  518,  120,
	  519,  520,  517,  521,  514,  120,  517,  522,  527,  527,  120,  527,
	  120,  120,    1,  522,  516,  500,  517,  518,  120,  519,  520,  517,
	  521,  514,  120,  517,  522,  120,  120,  120,  120,    1,  509,  499,
	  500,  501,  502,   34,  503,  504,  501,  505,   35,   34,  501,  509,
	  528,  528,   34,  528,   34,   34,    1,  509,  499,  500,  501,  502,
	   34,  503,  504,  501,  505,   35,   34,  501,  509,  529,  529,   34,
	  529,   34,   34,    1,  509,  499,  500,  501,  502,   34,  503,  504,
	  501,  505,   35,   34,  501,  509,  530,  530,   34,  530,   34,   34,
	    1,  509,  499,  500,  501,  502,   34,  503,  504,  501,  505,   35,
	   34,  501,  509,  531,  531,   34,  531,   34,   34,    1,  509,  499,
	  500,  501,  502,   34,  503,  504,  501,  505,   35,   34,  501,  509,
	   34,   34,   34,   34,    1,  506,   15,  507,  508,  123,   18,   19,
	  507,   21,  124,  123,  507,  506,  123,  123,  123,  123,    1,  532,
	   15,  507,  508,  123,   18,   19,  507,   21,  124,  123,  507,  532,
	  533,  533,  123,  533,  123,  123,    1,  506,   15,   16,  507,  508,
	  534,   18,   19,  507,   21,   22,   20,  507,  506,  123,   20,   20,
	   20,    1,  506,   15,  507,  508,  123,   18,   19,  507,   21,  155,
	  126,  507,  506,  123,  126,  126,  126,    1,  484,  485,  486,  487,
	  126,  488,  489,  486,  490,  155,  126,  486,  484,  126,  126,  126,
	  126,    1,  535,  485,  486,  487,  126,  488,  489,  486,  490,  155,
	  126,  486,  535,  536,  536,  126,  536,  126,  126,    1,  484,  485,
	   16,  486,  487,   20,  488,  489,  486,  490,   22,   20,  486,  484,
	  126,   20,   20,   20,    1,  535,  485,  486,  487,  126,  488,  489,
	  486,  490,  155,  126,  486,  535,  537,  537,  126,  537,  126,  126,
	    1,  535,  485,  486,  487,  126,  488,  489,  486,  490,  155,  126,
	  486,  535,  538,  538,  126,  538,  126,  126,    1,  535,  485,  486,
	  487,  126,  488,  489,  486,  490,  155,  126,  486,  535,  539,  539,
	  126,  539,  126,  126,    1,  535,  485,  486,  487,  126,  488,  489,
	  486,  490,  155,  126,  486,  535,  540,  540,  126,  540,  126,  126,
	    1,  535,  485,  486,  487,  126,  488,  489,  486,  490,  155,  126,
	  486,  535,  126,  126,  126,  126,    1,  532,   15,  507,  508,  123,
	   18,   19,  507,   21,  124,  123,  507,  532,  541,  541,  123,  541,
	  123,  123,    1,  532,   15,  507,  508,  123,   18,   19,  507,   21,
	  124,  123,  507,  532,  542,  542,  123,  542,  123,  123,    1,  532,
	   15,  507,  508,  123,   18,   19,  507,   21,  124,  123,  507,  532,
	  543,  543,  123,  543,  123,  123,    1,  532,   15,  507,  508,  123,
	   18,   19,  507,   21,  124,  123,  507,  532,  544,  544,  123,  544,
	  123,  123,    1,  532,   15,  507,  508,  123,   18,   19,  507,   21,
	  124,  123,  507,  532,  123,  123,  123,  123,    1,  498,  499,  500,
	  501,  502,   34,  503,  504,  501,  505,   35,   34,  545,  501,  498,
	   34,   34,   34,   34,    1,  498,  499,  500,  501,  502,   34,  503,
	  504,  501,  505,   35,   34,  546,  501,  498,   34,   34,   34,   34,
	    1,  498,  499,  500,  501,  502,   34,  503,  504,  501,  505,   35,
	   34,  547,  501,  498,   34,   34,   34,   34,    1,  498,  499,  500,
	  501,  502,   34,  503,  504,  501,  505,   35,   34,  548,  501,  498,
	   34,   34,   34,   34,    1,  498,  499,  500,  501,  502,   34,  503,
	  504,  501,  505,   35,   34,  549,  501,  498,   34,   34,   34,   34,
	    1,  498,  499,  500,  501,  502,   34,  503,  504,  501,  505,   35,
	   34,  550,  501,  498,   34,   34,   34,   34,    1,  498,  499,  500,
	  501,  502,   34,  503,  504,  501,  505,   35,   34,  551,  501,  498,
	   34,   34,   34,   34,    1,  498,  499,  552,  501,  502,   34,  503,
	  504,  501,  505,   35,   34,  501,  498,   34,   34,   34,   34,    1,
	  498,  499,  500,  501,  502,   34,  503,  504,  501,  505,   35,   34,
	  553,  501,  498,   34,   34,   34,   34,    1,  498,  499,  500,  501,
	  502,   34,  503,  504,  501,  505,   35,   34,  554,  501,  498,   34,
	   34,   34,   34,    1,  498,  499,  555,  501,  502,   34,  503,  504,
	  501,  505,   35,   34,  501,  498,   34,   34,   34,   34,    1,  556,
	  492,  493,  494,   26,  495,  496,  493,  497,   27,   26,  493,  556,
	  557,  557,   26,  557,   26,   26,    1,  491,  492,   16,  493,  494,
	  558,  495,  496,  493,  497,  560,  559,  493,  491,   26,  559,  559,
	  559,    1,  491,  492,  493,  494,   26,  495,  496,  493,  497,  561,
	  153,  493,  491,   26,  153,  153,  153,    1,  562,  563,  564,  565,
	  153,  566,  567,  564,  568,  561,  153,  564,  562,  153,  153,  153,
	  153,    1,  569,  563,  564,  565,  153,  566,  567,  564,  568,  561,
	  153,  564,  569,  570,  570,  153,  570,  153,  153,    1,  562,  563,
	   16,  564,  565,  559,  566,  567,  564,  568,  560,  559,  564,  562,
	  153,  559,  559,  559,    1,  569,  563,  564,  565,  153,  566,  567,
	  564,  568,  561,  153,  564,  569,  571,  571,  153,  571,  153,  153,
	    1,  569,  563,  564,  565,  153,  566,  567,  564,  568,  561,  153,
	  564,  569,  572,  572,  153,  572,  153,  153,    1,  569,  563,  564,
	  565,  153,  566,  567,  564,  568,  561,  153,  564,  569,  573,  573,
	  153,  573,  153,  153,    1,  569,  563,  564,  565,  153,  566,  567,
	  564,  568,  561,  153,  564,  569,  574,  574,  153,  574,  153,  153,
	    1,  569,  563,  564,  565,  153,  566,  567,  564,  568,  561,  153,
	  564,  569,  153,  153,  153,  153,    1,  556,  492,  493,  494,   26,
	  495,  496,  493,  497,   27,   26,  493,  556,  575,  575,   26,  575,
	   26,   26,    1,  556,  492,  493,  494,   26,  495,  496,  493,  497,
	   27,   26,  493,  556,  576,  576,   26,  576,   26,   26,    1,  556,
	  492,  493,  494,   26,  495,  496,  493,  497,   27,   26,  493,  556,
	  577,  577,   26,  577,   26,   26,    1,  556,  492,  493,  494,   26,
	  495,  496,  493,  497,   27,   26,  493,  556,  578,  578,   26,  578,
	   26,   26,    1,  556,  492,  493,  494,   26,  495,  496,  493,  497,
	   27,   26,  493,  556,   26,   26,   26,   26,    1,  579,  479,  470,
	  471,  156,  480,  481,  470,  482,  483,  156,  470,  579,  580,  580,
	  156,  580,  156,  156,    1,  468,  479,   16,  470,  471,  581,  480,
	  481,  470,  482,  583,  582,  470,  468,  156,  582,  582,  582,    1,
	  468,  479,  470,  471,  156,  480,  481,  470,  482,  584,  158,  470,
	  468,  156,  158,  158,  158,    1,  585,  586,  587,  588,  158,  589,
	  590,  587,  591,  584,  158,  587,  585,  158,  158,  158,  158,    1,
	  592,  586,  587,  588,  158,  589,  590,  587,  591,  584,  158,  587,
	  592,  593,  593,  158,  593,  158,  158,    1,  585,  586,   16,  587,
	  588,  582,  589,  590,  587,  591,  583,  582,  587,  585,  158,  582,
	  582,  582,    1,  592,  586,  587,  588,  158,  589,  590,  587,  591,
	  584,  158,  587,  592,  594,  594,  158,  594,  158,  158,    1,  592,
	  586,  587,  588,  158,  589,  590,  587,  591,  584,  158,  587,  592,
	  595,  595,  158,  595,  158,  158,    1,  592,  586,  587,  588,  158,
	  589,  590,  587,  591,  584,  158,  587,  592,  596,  596,  158,  596,
	  158,  158,    1,  592,  586,  587,  588,  158,  589,  590,  587,  591,
	  584,  158,  587,  592,  597,  597,  158,  597,  158,  158,    1,  592,
	  586,  587,  588,  158,  589,  590,  587,  591,  584,  158,  587,  592,
	  158,  158,  158,  158,    1,  579,  479,  470,  471,  156,  480,  481,
	  470,  482,  483,  156,  470,  579,  598,  598,  156,  598,  156,  156,
	    1,  579,  479,  470,  471,  156,  480,  481,  470,  482,  483,  156,
	  470,  579,  599,  599,  156,  599,  156,  156,    1,  579,  479,  470,
	  471,  156,  480,  481,  470,  482,  483,  156,  470,  579,  600,  600,
	  156,  600,  156,  156,    1,  579,  479,  470,  471,  156,  480,  481,
	  470,  482,  483,  156,  470,  579,  601,  601,  156,  601,  156,  156,
	    1,  579,  479,  470,  471,  156,  480,  481,  470,  482,  483,  156,
	  470,  579,  156,  156,  156,  156,    1,  491,  602,  493,  494,  163,
	  603,  604,  493,  605,  164,  163,  493,  491,  163,  163,  163,  163,
	    1,  498,  606,  607,  501,  502,  171,  608,  609,  501,  610,  172,
	  171,  501,  498,  171,  171,  171,  171,    1,  506,  611,  507,  508,
	  612,  613,  507,  185,  507,  506,    1,  614,  606,  607,  501,  502,
	  171,  608,  609,  501,  610,  172,  171,  501,  614,  615,  615,  171,
	  615,  171,  171,    1,  498,  606,  607,   16,  501,  502,  616,  608,
	  609,  501,  610,  618,  617,  501,  498,  171,  617,  617,  617,    1,
	  498,  606,  607,  501,  502,  171,  608,  609,  501,  610,  619,  258,
	  501,  498,  171,  258,  258,  258,    1,  620,  621,  607,  622,  623,
	  258,  624,  625,  622,  626,  619,  258,  622,  620,  258,  258,  258,
	  258,    1,  627,  621,  607,  622,  623,  258,  624,  625,  622,  626,
	  619,  258,  622,  627,  628,  628,  258,  628,  258,  258,    1,  620,
	  621,  607,   16,  622,  623,  617,  624,  625,  622,  626,  618,  617,
	  622,  620,  258,  617,  617,  617,    1,  627,  621,  607,  622,  623,
	  258,  624,  625,  622,  626,  619,  258,  622,  627,  629,  629,  258,
	  629,  258,  258,    1,  627,  621,  607,  622,  623,  258,  624,  625,
	  622,  626,  619,  258,  622,  627,  630,  630,  258,  630,  258,  258,
	    1,  627,  621,  607,  622,  623,  258,  624,  625,  622,  626,  619,
	  258,  622,  627,  631,  631,  258,  631,  258,  258,    1,  627,  621,
	  607,  622,  623,  258,  624,  625,  622,  626,  619,  258,  622,  627,
	  632,  632,  258,  632,  258,  258,    1,  627,  621,  607,  622,  623,
	  258,  624,  625,  622,  626,  619,  258,  622,  627,  258,  258,  258,
	  258,    1,  614,  606,  607,  501,  502,  171,  608,  609,  501,  610,
	  172,  171,  501,  614,  633,  633,  171,  633,  171,  171,    1,  614,
	  606,  607,  501,  502,  171,  608,  609,  501,  610,  172,  171,  501,
	  614,  634,  634,  171,  634,  171,  171,    1,  614,  606,  607,  501,
	  502,  171,  608,  609,  501,  610,  172,  171,  501,  614,  635,  635,
	  171,  635,  171,  171,    1,  614,  606,  607,  501,  502,  171,  608,
	  609,  501,  610,  172,  171,  501,  614,  636,  636,  171,  636,  171,
	  171,    1,  614,  606,  607,  501,  502,  171,  608,  609,  501,  610,
	  172,  171,  501,  614,  171,  171,  171,  171,    1,  506,  611,  507,
	  508,  261,  612,  613,  507,  185,  262,  261,  507,  506,  261,  261,
	  261,  261,    1,  637,  611,  507,  508,  261,  612,  613,  507,  185,
	  262,  261,  507,  637,  638,  638,  261,  638,  261,  261,    1,  506,
	  611,   16,  507,  508,  639,  612,  613,  507,  185,  641,  640,  507,
	  506,  261,  640,  640,  640,    1,  506,  611,  507,  508,  261,  612,
	  613,  507,  185,  642,  264,  507,  506,  261,  264,  264,  264,    1,
	  643,  644,  645,  646,  264,  647,  648,  645,  649,  642,  264,  645,
	  643,  264,  264,  264,  264,    1,  650,  644,  645,  646,  264,  647,
	  648,  645,  649,  642,  264,  645,  650,  651,  651,  264,  651,  264,
	  264,    1,  643,  644,   16,  645,  646,  640,  647,  648,  645,  649,
	  641,  640,  645,  643,  264,  640,  640,  640,    1,  650,  644,  645,
	  646,  264,  647,  648,  645,  649,  642,  264,  645,  650,  652,  652,
	  264,  652,  264,  264,    1,  650,  644,  645,  646,  264,  647,  648,
	  645,  649,  642,  264,  645,  650,  653,  653,  264,  653,  264,  264,
	    1,  650,  644,  645,  646,  264,  647,  648,  645,  649,  642,  264,
	  645,  650,  654,  654,  264,  654,  264,  264,    1,  650,  644,  645,
	  646,  264,  647,  648,  645,  649,  642,  264,  645,  650,  655,  655,
	  264,  655,  264,  264,    1,  650,  644,  645,  646,  264,  647,  648,
	  645,  649,  642,  264,  645,  650,  264,  264,  264,  264,    1,  637,
	  611,  507,  508,  261,  612,  613,  507,  185,  262,  261,  507,  637,
	  656,  656,  261,  656,  261,  261,    1,  637,  611,  507,  508,  261,
	  612,  613,  507,  185,  262,  261,  507,  637,  657,  657,  261,  657,
	  261,  261,    1,  637,  611,  507,  508,  261,  612,  613,  507,  185,
	  262,  261,  507,  637,  658,  658,  261,  658,  261,  261,    1,  637,
	  611,  507,  508,  261,  612,  613,  507,  185,  262,  261,  507,  637,
	  659,  659,  261,  659,  261,  261,    1,  637,  611,  507,  508,  261,
	  612,  613,  507,  185,  262,  261,  507,  637,  261,  261,  261,  261,
	    1,  498,  606,  607,  501,  502,  171,  608,  609,  501,  610,  172,
	  171,  660,  501,  498,  171,  171,  171,  171,    1,  498,  606,  607,
	  501,  502,  171,  608,  609,  501,  610,  172,  171,  661,  501,  498,
	  171,  171,  171,  171,    1,  498,  606,  607,  501,  502,  171,  608,
	  609,  501,  610,  172,  171,  662,  501,  498,  171,  171,  171,  171,
	    1,  498,  606,  607,  501,  502,  171,  608,  609,  501,  610,  172,
	  171,  663,  501,  498,  171,  171,  171,  171,    1,  498,  606,  607,
	  501,  502,  171,  608,  609,  501,  610,  172,  171,  664,  501,  498,
	  171,  171,  171,  171,    1,  498,  606,  607,  501,  502,  171,  608,
	  609,  501,  610,  172,  171,  665,  501,  498,  171,  171,  171,  171,
	    1,  498,  606,  607,  501,  502,  171,  608,  609,  501,  610,  172,
	  171,  666,  501,  498,  171,  171,  171,  171,    1,  498,  606,  667,
	  501,  502,  171,  608,  609,  501,  610,  172,  171,  501,  498,  171,
	  171,  171,  171,    1,  498,  606,  607,  501,  502,  171,  608,  609,
	  501,  610,  172,  171,  668,  501,  498,  171,  171,  171,  171,    1,
	  498,  606,  607,  501,  502,  171,  608,  609,  501,  610,  172,  171,
	  669,  501,  498,  171,  171,  171,  171,    1,  498,  606,  670,  501,
	  502,  171,  608,  609,  501,  610,  172,  171,  501,  498,  171,  171,
	  171,  171,    1,  671,  602,  493,  494,  163,  603,  604,  493,  605,
	  164,  163,  493,  671,  672,  672,  163,  672,  163,  163,    1,  491,
	  602,   16,  493,  494,  673,  603,  604,  493,  605,  675,  674,  493,
	  491,  163,  674,  674,  674,    1,  491,  602,  493,  494,  163,  603,
	  604,  493,  605,  676,  291,  493,  491,  163,  291,  291,  291,    1,
	  677,  678,  679,  680,  291,  681,  682,  679,  683,  676,  291,  679,
	  677,  291,  291,  291,  291,    1,  684,  678,  679,  680,  291,  681,
	  682,  679,  683,  676,  291,  679,  684,  685,  685,  291,  685,  291,
	  291,    1,  677,  678,   16,  679,  680,  674,  681,  682,  679,  683,
	  675,  674,  679,  677,  291,  674,  674,  674,    1,  684,  678,  679,
	  680,  291,  681,  682,  679,  683,  676,  291,  679,  684,  686,  686,
	  291,  686,  291,  291,    1,  684,  678,  679,  680,  291,  681,  682,
	  679,  683,  676,  291,  679,  684,  687,  687,  291,  687,  291,  291,
	    1,  684,  678,  679,  680,  291,  681,  682,  679,  683,  676,  291,
	  679,  684,  688,  688,  291,  688,  291,  291,    1,  684,  678,  679,
	  680,  291,  681,  682,  679,  683,  676,  291,  679,  684,  689,  689,
	  291,  689,  291,  291,    1,  684,  678,  679,  680,  291,  681,  682,
	  679,  683,  676,  291,  679,  684,  291,  291,  291,  291,    1,  671,
	  602,  493,  494,  163,  603,  604,  493,  605,  164,  163,  493,  671,
	  690,  690,  163,  690,  163,  163,    1,  671,  602,  493,  494,  163,
	  603,  604,  493,  605,  164,  163,  493,  671,  691,  691,  163,  691,
	  163,  163,    1,  671,  602,  493,  494,  163,  603,  604,  493,  605,
	  164,  163,  493,  671,  692,  692,  163,  692,  163,  163,    1,  671,
	  602,  493,  494,  163,  603,  604,  493,  605,  164,  163,  493,  671,
	  693,  693,  163,  693,  163,  163,    1,  671,  602,  493,  494,  163,
	  603,  604,  493,  605,  164,  163,  493,  671,  163,  163,  163,  163,
	    1,  694,  469,  470,  471,  293,  472,  473,  470,  474,  475,  293,
	  470,  694,  695,  695,  293,  695,  293,  293,    1,  468,  469,   16,
	  470,  471,  696,  472,  473,  470,  474,  698,  697,  470,  468,  293,
	  697,  697,  697,    1,  468,  469,  470,  471,  293,  472,  473,  470,
	  474,  699,  295,  470,  468,  293,  295,  295,  295,    1,  700,  701,
	  702,  703,  295,  704,  705,  702,  706,  699,  295,  702,  700,  295,
	  295,  295,  295,    1,  707,  701,  702,  703,  295,  704,  705,  702,
	  706,  699,  295,  702,  707,  708,  708,  295,  708,  295,  295,    1,
	  700,  701,   16,  702,  703,  697,  704,  705,  702,  706,  698,  697,
	  702,  700,  295,  697,  697,  697,    1,  707,  701,  702,  703,  295,
	  704,  705,  702,  706,  699,  295,  702,  707,  709,  709,  295,  709,
	  295,  295,    1,  707,  701,  702,  703,  295,  704,  705,  702,  706,
	  699,  295,  702,  707,  710,  710,  295,  710,  295,  295,    1,  707,
	  701,  702,  703,  295,  704,  705,  702,  706,  699,  295,  702,  707,
	  711,  711,  295,  711,  295,  295,    1,  707,  701,  702,  703,  295,
	  704,  705,  702,  706,  699,  295,  702,  707,  712,  712,  295,  712,
	  295,  295,    1,  707,  701,  702,  703,  295,  704,  705,  702,  706,
	  699,  295,  702,  707,  295,  295,  295,  295,    1,  694,  469,  470,
	  471,  293,  472,  473,  470,  474,  475,  293,  470,  694,  713,  713,
	  293,  713,  293,  293,    1,  694,  469,  470,  471,  293,  472,  473,
	  470,  474,  475,  293,  470,  694,  714,  714,  293,  714,  293,  293,
	    1,  694,  469,  470,  471,  293,  472,  473,  470,  474,  475,  293,
	  470,  694,  715,  715,  293,  715,  293,  293,    1,  694,  469,  470,
	  471,  293,  472,  473,  470,  474,  475,  293,  470,  694,  716,  716,
	  293,  716,  293,  293,    1,  694,  469,  470,  471,  293,  472,  473,
	  470,  474,  475,  293,  470,  694,  293,  293,  293,  293,    1,  484,
	  644,  486,  487,  647,  648,  486,  649,  486,  484,    1,  484,  644,
	  486,  487,  297,  647,  648,  486,  649,  298,  297,  486,  484,  297,
	  297,  297,  297,    1,  717,  644,  486,  487,  297,  647,  648,  486,
	  649,  298,  297,  486,  717,  718,  718,  297,  718,  297,  297,    1,
	  484,  644,   16,  486,  487,  719,  647,  648,  486,  649,  720,  719,
	  486,  484,  297,  719,  719,  719,    1,  717,  644,  486,  487,  297,
	  647,  648,  486,  649,  298,  297,  486,  717,  721,  721,  297,  721,
	  297,  297,    1,  717,  644,  486,  487,  297,  647,  648,  486,  649,
	  298,  297,  486,  717,  722,  722,  297,  722,  297,  297,    1,  717,
	  644,  486,  487,  297,  647,  648,  486,  649,  298,  297,  486,  717,
	  723,  723,  297,  723,  297,  297,    1,  717,  644,  486,  487,  297,
	  647,  648,  486,  649,  298,  297,  486,  717,  724,  724,  297,  724,
	  297,  297,    1,  717,  644,  486,  487,  297,  647,  648,  486,  649,
	  298,  297,  486,  717,  297,  297,  297,  297,    1,    1,    0
	};
}

private static final short _Scanner_indicies[] = init__Scanner_indicies_0();


private static short[] init__Scanner_trans_targs_0()
{
	return new short [] {
	    1,    0,    2,  454,  188,   97,   99,  455,  105,  189,  292,  186,
	  294,   95,    4,    3,  295,   94,    5,    7,  319,   13,   71,    6,
	  296,   92,  296,   92,    8,   68,  297,   66,  332,  340,  297,   66,
	    9,   10,   11,   60,   56,   64,   11,   56,   12,  298,   12,  298,
	   14,   15,   49,   15,   49,   16,   17,   18,  298,   16,   17,   18,
	  298,   18,   19,   20,   31,   40,   41,   42,   19,   20,   31,   40,
	   41,   42,   20,   21,   23,   22,  298,   22,   24,   25,   26,   27,
	   28,   29,   30,   31,   32,   33,   34,   35,   36,   37,   38,   39,
	   41,   42,   43,   41,   44,   45,   46,   47,   48,   50,   15,   51,
	   52,   53,   54,   55,   57,   58,   59,   61,   62,   63,   65,  299,
	  302,  303,   69,  315,   70,  316,  319,  320,   72,   73,   83,   73,
	   74,   75,   12,  298,   76,   77,   78,   79,   80,   81,   82,   83,
	   84,   85,   86,   87,   88,   89,   90,   91,  343,  346,  347,   71,
	  294,  359,  362,  363,   98,  375,  184,  375,  184,  100,  160,  376,
	  158,  411,  419,  376,  158,  101,  102,  103,  152,  148,  156,  103,
	  148,  104,  377,  104,  377,  105,  106,  107,  141,  107,  141,  108,
	  109,  110,  377,  108,  109,  110,  377,  110,  111,  112,  123,  132,
	  133,  134,  111,  112,  123,  132,  133,  134,  112,  113,  115,  114,
	  377,  114,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,
	  126,  127,  128,  129,  130,  131,  133,  134,  135,  133,  136,  137,
	  138,  139,  140,  142,  107,  143,  144,  145,  146,  147,  149,  150,
	  151,  153,  154,  155,  157,  378,  381,  382,  161,  394,  162,  395,
	  398,  399,  164,  165,  175,  165,  166,  167,  104,  377,  168,  169,
	  170,  171,  172,  173,  174,  175,  176,  177,  178,  179,  180,  181,
	  182,  183,  422,  425,  426,  292,  438,  441,  442,  455,  189,  456,
	  190,  191,  282,  283,  194,  197,  284,  205,  285,  192,  275,  193,
	  191,  463,  192,  194,  197,  205,  275,  193,  463,  195,  196,  268,
	  196,  268,  193,  191,  463,  194,  197,  205,  198,  199,  258,  265,
	  199,  258,  193,  191,  200,  463,  194,  197,  205,  200,  201,  202,
	  252,  248,  256,  202,  248,  203,  204,  203,  204,  193,  463,  206,
	  207,  241,  207,  241,  208,  209,  210,  204,  208,  209,  210,  204,
	  210,  211,  212,  223,  232,  233,  234,  211,  212,  223,  232,  233,
	  234,  212,  213,  215,  214,  204,  214,  216,  217,  218,  219,  220,
	  221,  222,  223,  224,  225,  226,  227,  228,  229,  230,  231,  233,
	  234,  235,  233,  236,  237,  238,  239,  240,  242,  207,  243,  244,
	  245,  246,  247,  249,  250,  251,  253,  254,  255,  257,  259,  199,
	  260,  261,  262,  263,  264,  266,  267,  269,  196,  270,  271,  272,
	  273,  274,  276,  192,  277,  278,  279,  280,  281,  193,  191,  463,
	  194,  197,  205,  284,  285,  286,  284,  287,  288,  289,  290,  291,
	  293,    2,    4,    1,   97,   99,  105,  186,  293,    4,    1,    3,
	    5,    7,   13,   95,  293,    3,    4,    1,    5,    7,   13,  293,
	    3,    4,    1,    5,    7,   13,  293,    3,    9,    4,    1,    5,
	    7,   13,  293,    4,    1,  300,  310,  301,  302,   67,   67,  293,
	    3,    4,    1,    5,    7,   13,  304,  305,  306,  307,  308,  309,
	  311,  312,  313,  314,  317,  327,  318,  321,  322,  323,  324,  325,
	  326,  328,  329,  330,  331,  333,  334,  335,  336,  337,  338,  339,
	   72,  341,  342,  298,  344,  354,  345,  346,   93,   93,  293,    3,
	    4,    1,    5,    7,   13,  348,  349,  350,  351,  352,  353,  355,
	  356,  357,  358,  360,  370,  361,  362,   96,   96,  293,    3,    4,
	    1,    5,    7,   13,  364,  365,  366,  367,  368,  369,  371,  372,
	  373,  374,    2,   97,   99,  105,    2,  101,   97,   99,  105,    2,
	   97,   99,  379,  389,  380,  381,  159,  159,  293,    2,    4,    1,
	   97,   99,  105,  383,  384,  385,  386,  387,  388,  390,  391,  392,
	  393,  396,  406,  397,  398,  163,  163,  293,    2,    4,    1,   97,
	   99,  105,  400,  401,  402,  403,  404,  405,  407,  408,  409,  410,
	  412,  413,  414,  415,  416,  417,  418,  164,  420,  421,  377,  423,
	  433,  424,  425,  185,  185,  293,    2,    4,    1,   97,   99,  105,
	  427,  428,  429,  430,  431,  432,  434,  435,  436,  437,  439,  449,
	  440,  441,  187,  187,  293,    2,    4,    1,   97,   99,  105,  443,
	  444,  445,  446,  447,  448,  450,  451,  452,  453,  457,  458,  455,
	  189,  459,  460,  461,  462
	};
}

private static final short _Scanner_trans_targs[] = init__Scanner_trans_targs_0();


private static short[] init__Scanner_trans_actions_0()
{
	return new short [] {
	    0,    0,   13,   51,   51,   13,   13,   51,   13,   51,   19,   19,
	   19,   19,    0,    0,   19,   19,    0,    0,   19,    0,   19,   19,
	   19,   19,    0,    0,   19,    0,   19,   19,   19,   19,    0,    0,
	    0,   19,   19,   19,   19,   19,    0,    0,   23,   23,    0,    0,
	   19,   19,   19,    0,    0,    3,   36,   36,   33,    0,   19,   19,
	    1,    0,    5,   39,   39,   39,   39,   39,    0,   19,   19,   19,
	   19,   19,    0,    0,    0,    7,   42,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    7,    0,    0,    0,    0,    0,    0,    3,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,   19,   19,    0,
	    0,    0,   25,   25,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,   19,   19,   19,    0,    0,   19,    0,   19,
	   19,   19,   19,    0,    0,    0,   19,   19,   19,   19,   19,    0,
	    0,   23,   23,    0,    0,    0,   19,   19,   19,    0,    0,    3,
	   36,   36,   33,    0,   19,   19,    1,    0,    5,   39,   39,   39,
	   39,   39,    0,   19,   19,   19,   19,   19,    0,    0,    0,    7,
	   42,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    7,    0,    0,
	    0,    0,    0,    0,    3,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,   19,   19,    0,    0,    0,   25,   25,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,   19,   19,    0,    0,   19,    0,   19,   19,   19,   54,
	   17,  176,    0,   17,   17,   17,    0,    0,   63,   19,   19,   19,
	    0,    0,   45,    9,  161,    9,    9,    9,   19,   19,   19,   19,
	    0,    0,   66,   21,   27,  191,   21,   21,   21,    0,   19,   19,
	   19,   19,   19,    0,    0,   23,   23,    0,    0,   29,  129,   19,
	   19,   19,    0,    0,    3,   36,   36,   33,    0,   19,   19,    1,
	    0,    5,   39,   39,   39,   39,   39,    0,   19,   19,   19,   19,
	   19,    0,    0,    0,    7,   42,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    7,    0,    0,    0,    0,    0,    0,    3,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,   66,
	    0,    0,    0,    0,    0,    0,    0,    0,   45,    0,    0,    0,
	    0,    0,    0,   54,    0,    0,    0,    0,    0,   90,   31,  236,
	   31,   31,   31,    0,    0,    0,   90,    0,    0,    0,    0,    0,
	   54,   17,  105,  109,   17,   17,   17,    0,    0,   11,   15,   17,
	   17,   17,   17,    0,   90,   31,  153,  157,   31,   31,   31,   45,
	    9,   93,   97,    9,    9,    9,   66,   21,   27,  117,  121,   21,
	   21,   21,   29,   72,   75,   66,    0,   19,   19,   19,    0,  149,
	   87,  226,  231,   87,   87,   87,  149,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,   29,    0,   19,   90,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	   27,    0,    0,   60,   45,    0,   19,   19,   19,    0,  141,   81,
	  206,  211,   81,   81,   81,  141,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,   54,    0,   19,   19,   19,    0,  145,   84,  216,
	  221,   84,   84,   84,  145,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    9,    9,    9,    9,   21,   27,   21,   21,   21,    0,
	    0,    0,   66,    0,   19,   19,   19,    0,  125,   69,  196,  201,
	   69,   69,   69,  125,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,   29,    0,   19,   19,   19,    0,   78,   31,  133,  137,   31,
	   31,   31,   78,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,   27,    0,    0,   60,   45,
	    0,   19,   19,   19,    0,  101,   48,  166,  171,   48,   48,   48,
	  101,    0,    0,    0,    0,    0,    0,    0,    0,    0,   54,    0,
	   19,   19,   19,    0,  113,   57,  181,  186,   57,   57,   57,  113,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,   90,    0,   19,
	   19,    0,    0,    0,    0
	};
}

private static final short _Scanner_trans_actions[] = init__Scanner_trans_actions_0();


private static short[] init__Scanner_eof_actions_0()
{
	return new short [] {
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
	    0,    0,    0,    0,  109,   15,  109,  157,   97,  121,   75,  121,
	  121,  121,  231,  231,  231,  231,  231,  231,  231,  231,  121,  121,
	  121,  121,  121,   75,   75,   75,   75,  157,  157,  157,  157,  157,
	  157,  157,  157,   75,   75,   75,   75,   75,  121,  121,  121,  121,
	  121,  121,  121,  121,  121,  121,  121,   97,   97,   97,  211,  211,
	  211,  211,  211,  211,  211,  211,   97,   97,   97,   97,   97,  109,
	  109,  109,  221,  221,  221,  221,  221,  221,  221,  221,  109,  109,
	  109,  109,  109,   97,  121,   75,  121,  121,  121,  201,  201,  201,
	  201,  201,  201,  201,  201,  121,  121,  121,  121,  121,   75,   75,
	   75,   75,  137,  137,  137,  137,  137,  137,  137,  137,   75,   75,
	   75,   75,   75,  121,  121,  121,  121,  121,  121,  121,  121,  121,
	  121,  121,   97,   97,   97,  171,  171,  171,  171,  171,  171,  171,
	  171,   97,   97,   97,   97,   97,  109,  109,  109,  186,  186,  186,
	  186,  186,  186,  186,  186,  109,  109,  109,  109,  109,  157,  157,
	  157,  157,  157,  157,  157,  157,  157,    0
	};
}

private static final short _Scanner_eof_actions[] = init__Scanner_eof_actions_0();


static final int Scanner_start = 1;
static final int Scanner_first_final = 292;
static final int Scanner_error = 0;

static final int Scanner_en_neg = 190;
static final int Scanner_en_main = 1;


// line 191 "Scanner.java.rl"


    /**
     * Scan the {@link #input}.
     *
     * @return A list of selector groups that contain a list of {@link Selector}s scanned.
     * @throws ScannerException If the input is invalid.
     */
    public List<List<Selector>> scan() throws ScannerException {
        char[] data = input.toCharArray();
        int cs;
        int top;
        int[] stack = new int[32];
        int eof = data.length;
        int p = 0;
        int pe = eof;

        int mark = 0;

        LinkedList<List<Selector>> selectors = new LinkedList<List<Selector>>();
            List<Selector> parts = null;

        String tagName = Selector.UNIVERSAL_TAG;
        String negationTagName = Selector.UNIVERSAL_TAG;
        Selector.Combinator combinator = null;
        List<Specifier> specifiers = new LinkedList<Specifier>();

        String attributeName = null;
        String attributeValue = null;
        AttributeSpecifier.Match attributeMatch = null;

        String pseudoNthClass = null;

        boolean isNegation = false;
        Selector negationSelector = null;

        
// line 1721 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
	{
	cs = Scanner_start;
	top = 0;
	}

// line 228 "Scanner.java.rl"
        
// line 1729 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
	{
	int _klen;
	int _trans = 0;
	int _acts;
	int _nacts;
	int _keys;
	int _goto_targ = 0;

	_goto: while (true) {
	switch ( _goto_targ ) {
	case 0:
	if ( p == pe ) {
		_goto_targ = 4;
		continue _goto;
	}
	if ( cs == 0 ) {
		_goto_targ = 5;
		continue _goto;
	}
case 1:
	_match: do {
	_keys = _Scanner_key_offsets[cs];
	_trans = _Scanner_index_offsets[cs];
	_klen = _Scanner_single_lengths[cs];
	if ( _klen > 0 ) {
		int _lower = _keys;
		int _mid;
		int _upper = _keys + _klen - 1;
		while (true) {
			if ( _upper < _lower )
				break;

			_mid = _lower + ((_upper-_lower) >> 1);
			if ( data[p] < _Scanner_trans_keys[_mid] )
				_upper = _mid - 1;
			else if ( data[p] > _Scanner_trans_keys[_mid] )
				_lower = _mid + 1;
			else {
				_trans += (_mid - _keys);
				break _match;
			}
		}
		_keys += _klen;
		_trans += _klen;
	}

	_klen = _Scanner_range_lengths[cs];
	if ( _klen > 0 ) {
		int _lower = _keys;
		int _mid;
		int _upper = _keys + (_klen<<1) - 2;
		while (true) {
			if ( _upper < _lower )
				break;

			_mid = _lower + (((_upper-_lower) >> 1) & ~1);
			if ( data[p] < _Scanner_trans_keys[_mid] )
				_upper = _mid - 2;
			else if ( data[p] > _Scanner_trans_keys[_mid+1] )
				_lower = _mid + 2;
			else {
				_trans += ((_mid - _keys)>>1);
				break _match;
			}
		}
		_trans += _klen;
	}
	} while (false);

	_trans = _Scanner_indicies[_trans];
	cs = _Scanner_trans_targs[_trans];

	if ( _Scanner_trans_actions[_trans] != 0 ) {
		_acts = _Scanner_trans_actions[_trans];
		_nacts = (int) _Scanner_actions[_acts++];
		while ( _nacts-- > 0 )
	{
			switch ( _Scanner_actions[_acts++] )
			{
	case 0:
// line 48 "Scanner.java.rl"
	{
        AttributeSpecifier specifier;
        if (attributeValue != null) {
            specifier = new AttributeSpecifier(attributeName, attributeValue, attributeMatch);
        } else {
            specifier = new AttributeSpecifier(attributeName);
        }

        specifiers.add(specifier);
    }
	break;
	case 1:
// line 59 "Scanner.java.rl"
	{
        attributeName = getSlice(mark, p);
    }
	break;
	case 2:
// line 63 "Scanner.java.rl"
	{
        String m = getSlice(mark, p);
        if ("=".equals(m)) {
            attributeMatch = AttributeSpecifier.Match.EXACT;
        } else if ("~=".equals(m)) {
            attributeMatch = AttributeSpecifier.Match.LIST;
        } else if ("|=".equals(m)) {
            attributeMatch = AttributeSpecifier.Match.HYPHEN;
        } else if ("^=".equals(m)) {
            attributeMatch = AttributeSpecifier.Match.PREFIX;
        } else if ("$=".equals(m)) {
            attributeMatch = AttributeSpecifier.Match.SUFFIX;
        } else if ("*=".equals(m)) {
            attributeMatch = AttributeSpecifier.Match.CONTAINS;
        }
    }
	break;
	case 3:
// line 80 "Scanner.java.rl"
	{
        String value = getSlice(mark, p);
        if (value.charAt(0) == '"' || value.charAt(0) == '\'') {
            value = value.substring(1, value.length() - 1);
        }

        attributeValue = value;
    }
	break;
	case 4:
// line 89 "Scanner.java.rl"
	{
        specifiers.add(new AttributeSpecifier("class",
            getSlice(mark, p), AttributeSpecifier.Match.LIST));
    }
	break;
	case 5:
// line 94 "Scanner.java.rl"
	{
        switch (data[p]) {
        case ' ':
            combinator = Selector.Combinator.DESCENDANT;
            break;
        case '>':
            combinator = Selector.Combinator.CHILD;
            break;
        case '+':
            combinator = Selector.Combinator.ADJACENT_SIBLING;
            break;
        case '~':
            combinator = Selector.Combinator.GENERAL_SIBLING;
            break;
        }
    }
	break;
	case 6:
// line 111 "Scanner.java.rl"
	{
        parts = new LinkedList<Selector>();
    }
	break;
	case 7:
// line 115 "Scanner.java.rl"
	{
        selectors.add(parts);
    }
	break;
	case 8:
// line 119 "Scanner.java.rl"
	{
        specifiers.add(new AttributeSpecifier("id",
            getSlice(mark, p), AttributeSpecifier.Match.EXACT));
    }
	break;
	case 9:
// line 124 "Scanner.java.rl"
	{
        mark = p;
    }
	break;
	case 10:
// line 128 "Scanner.java.rl"
	{
        isNegation = true;
    }
	break;
	case 11:
// line 132 "Scanner.java.rl"
	{
        specifiers.add(new NegationSpecifier(negationSelector));
        isNegation = false;
    }
	break;
	case 12:
// line 137 "Scanner.java.rl"
	{
        specifiers.add(new PseudoClassSpecifier(getSlice(mark, p)));
    }
	break;
	case 13:
// line 141 "Scanner.java.rl"
	{
        specifiers.add(new PseudoNthSpecifier(pseudoNthClass, getSlice(mark, p)));
    }
	break;
	case 14:
// line 145 "Scanner.java.rl"
	{
        specifiers.add(new PseudoContainsSpecifier(getSlice(mark, p)));
    }
	break;
	case 15:
// line 149 "Scanner.java.rl"
	{
        pseudoNthClass = getSlice(mark, p);
    }
	break;
	case 16:
// line 153 "Scanner.java.rl"
	{
        Selector selector;
        List<Specifier> list = specifiers.isEmpty() ? null : specifiers;
        if (isNegation) {
            negationSelector = new Selector(negationTagName, list);
        } else {
            if (combinator == null) {
                selector = new Selector(tagName, list);
            } else {
                selector = new Selector(tagName, combinator, list);
            }

            parts.add(selector);
            tagName = Selector.UNIVERSAL_TAG;
            combinator = null;
        }

        negationTagName = Selector.UNIVERSAL_TAG;
        attributeName = null;
        attributeValue = null;
        attributeMatch = null;
        pseudoNthClass = null;
        specifiers = new LinkedList<Specifier>();
    }
	break;
	case 17:
// line 178 "Scanner.java.rl"
	{
        if (isNegation) {
            negationTagName = getSlice(mark, p);
        } else {
            tagName = getSlice(mark, p);
        }
    }
	break;
	case 18:
// line 30 "ScannerCommon.rl"
	{ {stack[top++] = cs; cs = 190; _goto_targ = 2; if (true) continue _goto;} }
	break;
	case 19:
// line 44 "ScannerCommon.rl"
	{ {cs = stack[--top];_goto_targ = 2; if (true) continue _goto;} }
	break;
// line 1991 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
			}
		}
	}

case 2:
	if ( cs == 0 ) {
		_goto_targ = 5;
		continue _goto;
	}
	if ( ++p != pe ) {
		_goto_targ = 1;
		continue _goto;
	}
case 4:
	if ( p == eof )
	{
	int __acts = _Scanner_eof_actions[cs];
	int __nacts = (int) _Scanner_actions[__acts++];
	while ( __nacts-- > 0 ) {
		switch ( _Scanner_actions[__acts++] ) {
	case 4:
// line 89 "Scanner.java.rl"
	{
        specifiers.add(new AttributeSpecifier("class",
            getSlice(mark, p), AttributeSpecifier.Match.LIST));
    }
	break;
	case 7:
// line 115 "Scanner.java.rl"
	{
        selectors.add(parts);
    }
	break;
	case 8:
// line 119 "Scanner.java.rl"
	{
        specifiers.add(new AttributeSpecifier("id",
            getSlice(mark, p), AttributeSpecifier.Match.EXACT));
    }
	break;
	case 12:
// line 137 "Scanner.java.rl"
	{
        specifiers.add(new PseudoClassSpecifier(getSlice(mark, p)));
    }
	break;
	case 16:
// line 153 "Scanner.java.rl"
	{
        Selector selector;
        List<Specifier> list = specifiers.isEmpty() ? null : specifiers;
        if (isNegation) {
            negationSelector = new Selector(negationTagName, list);
        } else {
            if (combinator == null) {
                selector = new Selector(tagName, list);
            } else {
                selector = new Selector(tagName, combinator, list);
            }

            parts.add(selector);
            tagName = Selector.UNIVERSAL_TAG;
            combinator = null;
        }

        negationTagName = Selector.UNIVERSAL_TAG;
        attributeName = null;
        attributeValue = null;
        attributeMatch = null;
        pseudoNthClass = null;
        specifiers = new LinkedList<Specifier>();
    }
	break;
	case 17:
// line 178 "Scanner.java.rl"
	{
        if (isNegation) {
            negationTagName = getSlice(mark, p);
        } else {
            tagName = getSlice(mark, p);
        }
    }
	break;
// line 2075 "../java/se/fishtank/css/selectors/scanner/Scanner.java"
		}
	}
	}

case 5:
	}
	break; }
	}

// line 229 "Scanner.java.rl"

        if (cs < Scanner_first_final && p != pe) {
            // TODO: Better error reporting ;)
            throw new ScannerException("Bad input!");
        }

        return selectors;
    }

    /**
     * Get a slice from the {@linkplain #input scanner input}.
     *
     * @param start The start offset.
     * @param end The end offset.
     * @return A substring starting at {@code start} and ending in {@code end}.
     */
    private String getSlice(int start, int end) {
        return input.substring(start, end);
    }

}
