/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import java.io.IOException;
import java.io.InputStream;
import ru.yandex.clickhouse.response.ByteFragment;
import ru.yandex.clickhouse.util.guava.StreamUtils;

public class StreamSplitter {
    private static final int buflen = 65536;
    private final InputStream delegate;
    private final byte sep;
    private byte[] buf;
    private int posRead;
    private int posNext;
    private int markedRead;
    private int markedNext;
    private boolean readOnce;
    private boolean closed;

    public StreamSplitter(ByteFragment bf, byte sep) {
        this.delegate = bf.asStream();
        this.sep = sep;
        this.buf = new byte[bf.getLen()];
        this.readOnce = true;
    }

    public StreamSplitter(InputStream delegate, byte sep, int buflen) {
        this.delegate = delegate;
        this.sep = sep;
        this.buf = new byte[buflen];
    }

    public StreamSplitter(InputStream delegate, byte sep) {
        this(delegate, sep, 65536);
    }

    public ByteFragment next() throws IOException {
        int positionSep;
        int readBytes;
        if (this.posNext >= this.posRead && (readBytes = this.readFromStream()) <= 0) {
            return null;
        }
        while ((positionSep = StreamSplitter.indexOf(this.buf, this.sep, this.posNext, this.posRead)) < this.posNext) {
            int readBytes2 = this.readFromStream();
            if (readBytes2 > 0) continue;
            positionSep = this.posRead;
            break;
        }
        int fragmentStart = this.posNext;
        this.posNext = positionSep + 1;
        return new ByteFragment(this.buf, fragmentStart, positionSep - fragmentStart);
    }

    protected int readFromStream() throws IOException {
        int read;
        if (this.readOnce) {
            if (this.posRead >= this.buf.length) {
                return -1;
            }
            int read2 = this.delegate.read(this.buf, this.posRead, this.buf.length - this.posRead);
            if (read2 > 0) {
                this.posRead += read2;
            }
            return read2;
        }
        if (this.posRead >= this.buf.length) {
            this.shiftOrResize();
        }
        if ((read = this.delegate.read(this.buf, this.posRead, this.buf.length - this.posRead)) > 0) {
            this.posRead += read;
        }
        return read;
    }

    private void shiftOrResize() {
        if (this.posNext > 0) {
            byte[] oldBuf = this.buf;
            this.buf = new byte[this.buf.length];
            System.arraycopy(oldBuf, this.posNext, this.buf, 0, oldBuf.length - this.posNext);
            this.posRead -= this.posNext;
            this.posNext = 0;
        } else {
            byte[] oldBuf = this.buf;
            this.buf = new byte[this.buf.length * 2];
            System.arraycopy(oldBuf, 0, this.buf, 0, oldBuf.length);
        }
    }

    private static int indexOf(byte[] array, byte target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array[i] != target) continue;
            return i;
        }
        return -1;
    }

    public void close() throws IOException {
        this.closed = true;
        this.delegate.close();
    }

    public boolean isClosed() throws IOException {
        return this.closed;
    }

    public String toString() {
        String bufStr = new String(this.buf, StreamUtils.UTF_8).trim();
        return "StreamSplitter{delegate=" + this.delegate + ", sep=" + this.sep + ", buf=" + bufStr + ", posRead=" + this.posRead + ", posNext=" + this.posNext + ", readOnce=" + this.readOnce + '}';
    }

    public void mark() {
        this.markedRead = this.posRead;
        this.markedNext = this.posNext;
    }

    public void reset() {
        this.posRead = this.markedRead;
        this.posNext = this.markedNext;
    }
}

