/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.response;

import ru.yandex.clickhouse.response.ByteFragment;

public final class ByteFragmentUtils {
    private ByteFragmentUtils() {
    }

    public static int parseInt(ByteFragment s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (s.isNull()) {
            return 0;
        }
        int result = 0;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            int limit;
            if (s.charAt(0) == 45) {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / 10;
            if (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                if ((result *= 10) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
        }
        return -result;
    }

    public static long parseLong(ByteFragment s) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        if (s.isNull()) {
            return 0L;
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = s.length();
        if (max > 0) {
            int digit;
            long limit;
            if (s.charAt(0) == 45) {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / 10L;
            if (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = s.charAt(i++) - 48) < 0 || digit > 9) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                if ((result *= 10L) < limit + (long)digit) {
                    throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + s.asString() + '\"');
        }
        return -result;
    }
}

