/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.typescript;

import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.script.RhinoScriptBuilder;
import ro.isdc.wro.util.StopWatch;
import ro.isdc.wro.util.WroUtil;

public class TypeScriptCompiler {
    private static final String PARAM_ERRORS = "errors";
    private static final String PARAM_SOURCE = "source";
    private static final Logger LOG = LoggerFactory.getLogger(TypeScriptCompiler.class);
    private static final String TYPESCRIPT_JS = "typescript-0.8.js";
    private static final String TYPESCRIPT_COMPILE_JS = "typescript.compile-0.3.js";
    private final String ecmaScriptVersion = "TypeScript.CodeGenTarget.ES5";
    private ScriptableObject scope;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compile(String typeScript) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start("initContext");
        RhinoScriptBuilder builder = this.initScriptBuilder();
        stopWatch.stop();
        stopWatch.start("compile");
        try {
            String execute = this.getCompilationCommand(typeScript);
            NativeObject compilationResult = (NativeObject)builder.evaluate(execute, "compile");
            NativeArray errors = (NativeArray)compilationResult.get((Object)PARAM_ERRORS);
            if (errors.size() > 0) {
                this.throwCompilationError(errors);
            }
            String string = compilationResult.get((Object)PARAM_SOURCE).toString();
            return string;
        }
        finally {
            stopWatch.stop();
            LOG.debug(stopWatch.prettyPrint());
        }
    }

    private void throwCompilationError(NativeArray errors) {
        StringBuilder sb = new StringBuilder();
        for (Object error : errors) {
            sb.append(error.toString()).append("\n");
        }
        LOG.debug("Compilation errors: {}", (Object)sb);
        throw new WroRuntimeException(sb.toString());
    }

    private String getCompilationCommand(String input) {
        return String.format("compilerWrapper.compile(%s, %s)", WroUtil.toJSMultiLineString((String)input), "TypeScript.CodeGenTarget.ES5");
    }

    private InputStream getCompilerAsStream() throws IOException {
        return new SequenceInputStream(this.getCompilerStream(), this.getCompilerWrapperStream());
    }

    protected InputStream getCompilerWrapperStream() {
        return TypeScriptCompiler.class.getResourceAsStream(TYPESCRIPT_COMPILE_JS);
    }

    protected InputStream getCompilerStream() {
        return TypeScriptCompiler.class.getResourceAsStream(TYPESCRIPT_JS);
    }

    private RhinoScriptBuilder initScriptBuilder() {
        try {
            RhinoScriptBuilder builder;
            if (this.scope == null) {
                builder = RhinoScriptBuilder.newClientSideAwareChain().evaluateChain(this.getCompilerAsStream(), "templateCompiler.js");
                this.scope = builder.getScope();
            } else {
                builder = RhinoScriptBuilder.newChain(this.scope);
            }
            return builder;
        }
        catch (IOException ex) {
            throw new WroRuntimeException("Failed reading init script", (Throwable)ex);
        }
    }
}

