/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.jsonhpack.JsonHPack;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public class JsonHPackProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(JsonHPackProcessor.class);
    public static final String ALIAS_PACK = "jsonh-pack";
    public static final String ALIAS_UNPACK = "jsonh-unpack";
    private ObjectPoolHelper<JsonHPack> enginePool;
    private boolean pack;

    public JsonHPackProcessor(boolean pack) {
        this.pack = pack;
        this.enginePool = new ObjectPoolHelper<JsonHPack>(new ObjectFactory<JsonHPack>(){

            public JsonHPack create() {
                return JsonHPackProcessor.this.newEngine();
            }
        });
    }

    public static JsonHPackProcessor packProcessor() {
        return new JsonHPackProcessor(true);
    }

    public static JsonHPackProcessor unpackProcessor() {
        return new JsonHPackProcessor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        try {
            writer.write(this.doProcess(content));
        }
        catch (WroRuntimeException e) {
            this.onException(e);
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while applying hpack processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doProcess(String content) {
        JsonHPack engine = this.enginePool.getObject();
        try {
            if (this.pack) {
                String string = engine.pack(content);
                return string;
            }
            String string = engine.unpack(content);
            return string;
        }
        finally {
            this.enginePool.returnObject(engine);
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    protected JsonHPack newEngine() {
        return new JsonHPack();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }
}

