/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.coffeescript.CoffeeScript;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@SupportedResourceType(value=ResourceType.JS)
public class CoffeeScriptProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(CoffeeScriptProcessor.class);
    public static final String ALIAS = "coffeeScript";
    private ObjectPoolHelper<CoffeeScript> enginePool = new ObjectPoolHelper<CoffeeScript>(new ObjectFactory<CoffeeScript>(){

        public CoffeeScript create() {
            return CoffeeScriptProcessor.this.newCoffeeScript();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        CoffeeScript coffeeScript = this.enginePool.getObject();
        try {
            writer.write(coffeeScript.compile(content));
        }
        catch (WroRuntimeException e) {
            this.onException(e);
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.error("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            reader.close();
            writer.close();
            this.enginePool.returnObject(coffeeScript);
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    protected CoffeeScript newCoffeeScript() {
        return new CoffeeScript();
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }
}

