/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.support.ObjectPoolHelper;
import ro.isdc.wro.extensions.processor.support.linter.AbstractLinter;
import ro.isdc.wro.extensions.processor.support.linter.LinterException;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ObjectFactory;

@SupportedResourceType(value=ResourceType.JS)
public abstract class AbstractLinterProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLinterProcessor.class);
    private ObjectPoolHelper<AbstractLinter> enginePool = new ObjectPoolHelper<AbstractLinter>(new ObjectFactory<AbstractLinter>(){

        public AbstractLinter create() {
            return AbstractLinterProcessor.this.newLinter();
        }
    });
    private String[] options;

    public AbstractLinterProcessor setOptions(String ... options) {
        this.options = options;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        String content = IOUtils.toString((Reader)reader);
        AbstractLinter linter = this.enginePool.getObject();
        try {
            linter.setOptions(this.options).validate(content);
        }
        catch (LinterException e) {
            this.onLinterException(e, resource);
        }
        catch (WroRuntimeException e) {
            this.onException(e);
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.warn("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
        }
        finally {
            writer.write(content);
            reader.close();
            writer.close();
            this.enginePool.returnObject(linter);
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    protected abstract AbstractLinter newLinter();

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    protected void onLinterException(LinterException e, Resource resource) {
        LOG.error("The following resource: " + resource + " has " + e.getErrors().size() + " errors.", (Throwable)e);
    }
}

