/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.AccessControlLogEntry;
import redis.clients.jedis.AccessControlUser;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.ClusterReset;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.JedisSocketFactory;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.Module;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.StreamPendingSummary;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.args.ClientType;
import redis.clients.jedis.args.ClusterFailoverOption;
import redis.clients.jedis.args.ClusterResetType;
import redis.clients.jedis.args.ListDirection;
import redis.clients.jedis.args.UnblockType;
import redis.clients.jedis.commands.AdvancedJedisCommands;
import redis.clients.jedis.commands.BasicCommands;
import redis.clients.jedis.commands.ClusterCommands;
import redis.clients.jedis.commands.JedisCommands;
import redis.clients.jedis.commands.ModuleCommands;
import redis.clients.jedis.commands.MultiKeyCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.ScriptingCommands;
import redis.clients.jedis.commands.SentinelCommands;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoRadiusStoreParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.MigrateParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.StrAlgoLCSParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XReadGroupParams;
import redis.clients.jedis.params.XReadParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.KeyedZSetElement;
import redis.clients.jedis.resps.LCSMatchResult;
import redis.clients.jedis.util.SafeEncoder;
import redis.clients.jedis.util.Slowlog;

public class Jedis
extends BinaryJedis
implements JedisCommands,
MultiKeyCommands,
AdvancedJedisCommands,
ScriptingCommands,
BasicCommands,
ClusterCommands,
SentinelCommands,
ModuleCommands {
    @Deprecated
    protected JedisPoolAbstract dataSource = null;

    public Jedis() {
    }

    @Deprecated
    public Jedis(String uri) {
        super(uri);
    }

    public Jedis(HostAndPort hp) {
        super(hp);
    }

    public Jedis(HostAndPort hp, JedisClientConfig config) {
        super(hp, config);
    }

    public Jedis(String host, int port) {
        super(host, port);
    }

    public Jedis(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    public Jedis(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(String host, int port, int timeout) {
        super(host, port, timeout);
    }

    public Jedis(String host, int port, int timeout, boolean ssl) {
        super(host, port, timeout, ssl);
    }

    public Jedis(String host, int port, int timeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, timeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout) {
        super(host, port, connectionTimeout, soTimeout);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout) {
        super(host, port, connectionTimeout, soTimeout, infiniteSoTimeout);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl) {
        super(host, port, connectionTimeout, soTimeout, ssl);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, connectionTimeout, soTimeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, connectionTimeout, soTimeout, infiniteSoTimeout, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(JedisShardInfo shardInfo) {
        super(shardInfo);
    }

    public Jedis(URI uri) {
        super(uri);
    }

    public Jedis(URI uri, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri, int timeout) {
        super(uri, timeout);
    }

    public Jedis(URI uri, int timeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, timeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri, int connectionTimeout, int soTimeout) {
        super(uri, connectionTimeout, soTimeout);
    }

    public Jedis(URI uri, int connectionTimeout, int soTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, connectionTimeout, soTimeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri, int connectionTimeout, int soTimeout, int infiniteSoTimeout, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(uri, connectionTimeout, soTimeout, infiniteSoTimeout, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    public Jedis(URI uri, JedisClientConfig config) {
        super(uri, config);
    }

    @Deprecated
    public Jedis(JedisSocketFactory jedisSocketFactory) {
        super(jedisSocketFactory);
    }

    public Jedis(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        super(jedisSocketFactory, clientConfig);
    }

    @Override
    public Boolean copy(String srcKey, String dstKey, int db, boolean replace) {
        this.checkIsInMultiOrPipeline();
        this.client.copy(srcKey, dstKey, db, replace);
        return BuilderFactory.BOOLEAN.build(this.client.getOne());
    }

    @Override
    public Boolean copy(String srcKey, String dstKey, boolean replace) {
        this.checkIsInMultiOrPipeline();
        this.client.copy(srcKey, dstKey, replace);
        return BuilderFactory.BOOLEAN.build(this.client.getOne());
    }

    public String ping(String message) {
        this.checkIsInMultiOrPipeline();
        this.client.ping(message);
        return this.client.getBulkReply();
    }

    @Override
    public String set(String key, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String set(String key, String value, SetParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.set(key, value, params);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String get(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.get(key);
        return this.client.getBulkReply();
    }

    @Override
    public String getDel(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.getDel(key);
        return this.client.getBulkReply();
    }

    @Override
    public String getEx(String key, GetExParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.getEx(key, params);
        return this.client.getBulkReply();
    }

    @Override
    public Long exists(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean exists(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.exists(key);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long del(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.del(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long del(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.del(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long unlink(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.unlink(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long unlink(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.unlink(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String type(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.type(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Set<String> keys(String pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.keys(pattern);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public String randomKey() {
        this.checkIsInMultiOrPipeline();
        this.client.randomKey();
        return this.client.getBulkReply();
    }

    @Override
    public String rename(String oldkey, String newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rename(oldkey, newkey);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long renamenx(String oldkey, String newkey) {
        this.checkIsInMultiOrPipeline();
        this.client.renamenx(oldkey, newkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expire(String key, long seconds) {
        this.checkIsInMultiOrPipeline();
        this.client.expire(key, seconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        this.checkIsInMultiOrPipeline();
        this.client.expireAt(key, unixTime);
        return this.client.getIntegerReply();
    }

    @Override
    public Long ttl(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.ttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long touch(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.touch(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Long touch(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.touch(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long move(String key, int dbIndex) {
        this.checkIsInMultiOrPipeline();
        this.client.move(key, dbIndex);
        return this.client.getIntegerReply();
    }

    @Override
    public String getSet(String key, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.getSet(key, value);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> mget(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.mget(keys);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long setnx(String key, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.setnx(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String setex(String key, long seconds, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.setex(key, seconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String mset(String ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.mset(keysvalues);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long msetnx(String ... keysvalues) {
        this.checkIsInMultiOrPipeline();
        this.client.msetnx(keysvalues);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decrBy(String key, long decrement) {
        this.checkIsInMultiOrPipeline();
        this.client.decrBy(key, decrement);
        return this.client.getIntegerReply();
    }

    @Override
    public Long decr(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.decr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long incrBy(String key, long increment) {
        this.checkIsInMultiOrPipeline();
        this.client.incrBy(key, increment);
        return this.client.getIntegerReply();
    }

    @Override
    public Double incrByFloat(String key, double increment) {
        this.checkIsInMultiOrPipeline();
        this.client.incrByFloat(key, increment);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Long incr(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.incr(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long append(String key, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.append(key, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String substr(String key, int start, int end) {
        this.checkIsInMultiOrPipeline();
        this.client.substr(key, start, end);
        return this.client.getBulkReply();
    }

    @Override
    public Long hset(String key, String field, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hset(String key, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hset(key, hash);
        return this.client.getIntegerReply();
    }

    @Override
    public String hget(String key, String field) {
        this.checkIsInMultiOrPipeline();
        this.client.hget(key, field);
        return this.client.getBulkReply();
    }

    @Override
    public Long hsetnx(String key, String field, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.hsetnx(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String hmset(String key, Map<String, String> hash) {
        this.checkIsInMultiOrPipeline();
        this.client.hmset(key, hash);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> hmget(String key, String ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hmget(key, fields);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrBy(key, field, value);
        return this.client.getIntegerReply();
    }

    @Override
    public Double hincrByFloat(String key, String field, double value) {
        this.checkIsInMultiOrPipeline();
        this.client.hincrByFloat(key, field, value);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Boolean hexists(String key, String field) {
        this.checkIsInMultiOrPipeline();
        this.client.hexists(key, field);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long hdel(String key, String ... fields) {
        this.checkIsInMultiOrPipeline();
        this.client.hdel(key, fields);
        return this.client.getIntegerReply();
    }

    @Override
    public Long hlen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> hkeys(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hkeys(key);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<String> hvals(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hvals(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hgetAll(key);
        return BuilderFactory.STRING_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public String hrandfield(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.hrandfield(key);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> hrandfield(String key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.hrandfield(key, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Map<String, String> hrandfieldWithValues(String key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.hrandfieldWithValues(key, count);
        return BuilderFactory.STRING_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long rpush(String key, String ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.rpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpush(String key, String ... strings) {
        this.checkIsInMultiOrPipeline();
        this.client.lpush(key, strings);
        return this.client.getIntegerReply();
    }

    @Override
    public Long llen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.llen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> lrange(String key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.lrange(key, start, stop);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String ltrim(String key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.ltrim(key, start, stop);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String lindex(String key, long index) {
        this.checkIsInMultiOrPipeline();
        this.client.lindex(key, index);
        return this.client.getBulkReply();
    }

    @Override
    public String lset(String key, long index, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.lset(key, index, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long lrem(String key, long count, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.lrem(key, count, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String lpop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.lpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> lpop(String key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.lpop(key, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long lpos(String key, String element) {
        this.checkIsInMultiOrPipeline();
        this.client.lpos(key, element);
        return this.client.getIntegerReply();
    }

    @Override
    public Long lpos(String key, String element, LPosParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.lpos(key, element, params);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Long> lpos(String key, String element, LPosParams params, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.lpos(key, element, params, count);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public String rpop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.rpop(key);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> rpop(String key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.rpop(key, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String rpoplpush(String srckey, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.rpoplpush(srckey, dstkey);
        return this.client.getBulkReply();
    }

    @Override
    public Long sadd(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.sadd(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> smembers(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.smembers(key);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long srem(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.srem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public String spop(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key);
        return this.client.getBulkReply();
    }

    @Override
    public Set<String> spop(String key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.spop(key, count);
        List<String> members = this.client.getMultiBulkReply();
        if (members == null) {
            return null;
        }
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long smove(String srckey, String dstkey, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.smove(srckey, dstkey, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long scard(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.scard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Boolean sismember(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.sismember(key, member);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public List<Boolean> smismember(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.smismember(key, members);
        return BuilderFactory.BOOLEAN_LIST.build(this.client.getIntegerMultiBulkReply());
    }

    @Override
    public Set<String> sinter(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinter(keys);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long sinterstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sinterstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sunion(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunion(keys);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long sunionstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sunionstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> sdiff(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiff(keys);
        return BuilderFactory.STRING_SET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Long sdiffstore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.sdiffstore(dstkey, keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String srandmember(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key);
        return this.client.getBulkReply();
    }

    @Override
    public List<String> srandmember(String key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.srandmember(key, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long zadd(String key, double score, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, double score, String member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, score, member, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zadd(key, scoreMembers, params);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zaddIncr(String key, double score, String member, ZAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zaddIncr(key, score, member, params);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Set<String> zdiff(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zdiff(keys);
        return BinaryJedis.SetFromList.of(this.client.getMultiBulkReply());
    }

    @Override
    public Set<Tuple> zdiffWithScores(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zdiffWithScores(keys);
        return this.getTupledSet();
    }

    @Override
    public Long zdiffStore(String dstkey, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zdiffStore(dstkey, keys);
        return BuilderFactory.LONG.build(this.client.getOne());
    }

    @Override
    public Set<String> zrange(String key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrange(key, start, stop);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long zrem(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.zrem(key, members);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zincrby(String key, double increment, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, increment, member);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Double zincrby(String key, double increment, String member, ZIncrByParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zincrby(key, increment, member, params);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Long zrank(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zrevrank(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrank(key, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrevrange(String key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrange(key, start, stop);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrangeWithScores(String key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeWithScores(key, start, stop);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(String key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeWithScores(key, start, stop);
        return this.getTupledSet();
    }

    @Override
    public String zrandmember(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.zrandmember(key);
        return this.client.getBulkReply();
    }

    @Override
    public Set<String> zrandmember(String key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrandmember(key, count);
        List<String> members = this.client.getMultiBulkReply();
        return members == null ? null : BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrandmemberWithScores(String key, long count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrandmemberWithScores(key, count);
        return this.getTupledSet();
    }

    @Override
    public Long zcard(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.zcard(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Double zscore(String key, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.zscore(key, member);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public List<Double> zmscore(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.zmscore(key, members);
        return BuilderFactory.DOUBLE_LIST.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Tuple zpopmax(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.zpopmax(key);
        return BuilderFactory.TUPLE.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zpopmax(String key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zpopmax(key, count);
        return this.getTupledSet();
    }

    @Override
    public Tuple zpopmin(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.zpopmin(key);
        return BuilderFactory.TUPLE.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zpopmin(String key, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zpopmin(key, (long)count);
        return this.getTupledSet();
    }

    @Override
    public String watch(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.watch(keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> sort(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<String> sort(String key, SortingParams sortingParameters) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters);
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, sortingParameters, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public Long sort(String key, String dstkey) {
        this.checkIsInMultiOrPipeline();
        this.client.sort(key, dstkey);
        return this.client.getIntegerReply();
    }

    @Override
    public String lmove(String srcKey, String dstKey, ListDirection from, ListDirection to) {
        this.checkIsInMultiOrPipeline();
        this.client.lmove(srcKey, dstKey, from, to);
        return this.client.getBulkReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String blmove(String srcKey, String dstKey, ListDirection from, ListDirection to, double timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.blmove(srcKey, dstKey, from, to, timeout);
        this.client.setTimeoutInfinite();
        try {
            String string = this.client.getBulkReply();
            return string;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<String> blpop(int timeout, String ... keys) {
        return this.blpop(this.getKeysAndTimeout(timeout, keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyedListElement blpop(double timeout, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.blpop(timeout, keys);
        this.client.setTimeoutInfinite();
        try {
            KeyedListElement keyedListElement = BuilderFactory.KEYED_LIST_ELEMENT.build(this.client.getBinaryMultiBulkReply());
            return keyedListElement;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<String> brpop(int timeout, String ... keys) {
        return this.brpop(this.getKeysAndTimeout(timeout, keys));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyedListElement brpop(double timeout, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.brpop(timeout, keys);
        this.client.setTimeoutInfinite();
        try {
            KeyedListElement keyedListElement = BuilderFactory.KEYED_LIST_ELEMENT.build(this.client.getBinaryMultiBulkReply());
            return keyedListElement;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    private String[] getKeysAndTimeout(int timeout, String[] keys) {
        int keyCount = keys.length;
        String[] args = new String[keyCount + 1];
        System.arraycopy(keys, 0, args, 0, keyCount);
        args[keyCount] = String.valueOf(timeout);
        return args;
    }

    @Override
    public List<String> blpop(String ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.blpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<String> list = this.client.getMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<String> brpop(String ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.brpop(args);
        this.client.setTimeoutInfinite();
        try {
            List<String> list = this.client.getMultiBulkReply();
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyedZSetElement bzpopmax(double timeout, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.bzpopmax(timeout, keys);
        this.client.setTimeoutInfinite();
        try {
            KeyedZSetElement keyedZSetElement = BuilderFactory.KEYED_ZSET_ELEMENT.build(this.client.getBinaryMultiBulkReply());
            return keyedZSetElement;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyedZSetElement bzpopmin(double timeout, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.bzpopmin(timeout, keys);
        this.client.setTimeoutInfinite();
        try {
            KeyedZSetElement keyedZSetElement = BuilderFactory.KEYED_ZSET_ELEMENT.build(this.client.getBinaryMultiBulkReply());
            return keyedZSetElement;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public List<String> blpop(int timeout, String key) {
        return this.blpop(key, String.valueOf(timeout));
    }

    @Override
    public KeyedListElement blpop(double timeout, String key) {
        return this.blpop(timeout, new String[]{key});
    }

    @Override
    public List<String> brpop(int timeout, String key) {
        return this.brpop(key, String.valueOf(timeout));
    }

    @Override
    public KeyedListElement brpop(double timeout, String key) {
        return this.brpop(timeout, new String[]{key});
    }

    @Override
    public Long zcount(String key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zcount(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScore(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByScoreWithScores(key, min, max, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min, offset, count);
        return this.getTupledSet();
    }

    @Override
    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScore(key, max, min, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByScoreWithScores(key, max, min);
        return this.getTupledSet();
    }

    @Override
    public Long zremrangeByRank(String key, long start, long stop) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByRank(key, start, stop);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, double min, double max) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zremrangeByScore(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByScore(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zunion(ZParams params, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zunion(params, keys);
        return BuilderFactory.STRING_ZSET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zunionWithScores(ZParams params, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionWithScores(params, keys);
        return this.getTupledSet();
    }

    @Override
    public Long zunionstore(String dstkey, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zunionstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zinter(ZParams params, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zinter(params, keys);
        return BuilderFactory.STRING_ZSET.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public Set<Tuple> zinterWithScores(ZParams params, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterWithScores(params, keys);
        return this.getTupledSet();
    }

    @Override
    public Long zinterstore(String dstkey, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        this.checkIsInMultiOrPipeline();
        this.client.zinterstore(dstkey, params, sets);
        return this.client.getIntegerReply();
    }

    @Override
    public Long zlexcount(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zlexcount(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Set<String> zrangeByLex(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min, max);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrangeByLex(key, min, max, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max, String min) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max, min);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.zrevrangeByLex(key, max, min, offset, count);
        List<String> members = this.client.getMultiBulkReply();
        return BinaryJedis.SetFromList.of(members);
    }

    @Override
    public Long zremrangeByLex(String key, String min, String max) {
        this.checkIsInMultiOrPipeline();
        this.client.zremrangeByLex(key, min, max);
        return this.client.getIntegerReply();
    }

    @Override
    public Long strlen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.strlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public LCSMatchResult strAlgoLCSKeys(String keyA, String keyB, StrAlgoLCSParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.strAlgoLCSKeys(keyA, keyB, params);
        return BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER.build(this.client.getOne());
    }

    @Override
    public LCSMatchResult strAlgoLCSStrings(String strA, String strB, StrAlgoLCSParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.strAlgoLCSStrings(strA, strB, params);
        return BuilderFactory.STR_ALGO_LCS_RESULT_BUILDER.build(this.client.getOne());
    }

    @Override
    public Long lpushx(String key, String ... string) {
        this.checkIsInMultiOrPipeline();
        this.client.lpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public Long persist(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.persist(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long rpushx(String key, String ... string) {
        this.checkIsInMultiOrPipeline();
        this.client.rpushx(key, string);
        return this.client.getIntegerReply();
    }

    @Override
    public String echo(String string) {
        this.checkIsInMultiOrPipeline();
        this.client.echo(string);
        return this.client.getBulkReply();
    }

    @Override
    public Long linsert(String key, ListPosition where, String pivot, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.linsert(key, where, pivot, value);
        return this.client.getIntegerReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String brpoplpush(String source, String destination, int timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.brpoplpush(source, destination, timeout);
        this.client.setTimeoutInfinite();
        try {
            String string = this.client.getBulkReply();
            return string;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Boolean setbit(String key, long offset, boolean value) {
        this.checkIsInMultiOrPipeline();
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    @Deprecated
    public Boolean setbit(String key, long offset, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.setbit(key, offset, value);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Boolean getbit(String key, long offset) {
        this.checkIsInMultiOrPipeline();
        this.client.getbit(key, offset);
        return this.client.getIntegerReply() == 1L;
    }

    @Override
    public Long setrange(String key, long offset, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.setrange(key, offset, value);
        return this.client.getIntegerReply();
    }

    @Override
    public String getrange(String key, long startOffset, long endOffset) {
        this.checkIsInMultiOrPipeline();
        this.client.getrange(key, startOffset, endOffset);
        return this.client.getBulkReply();
    }

    @Override
    public Long bitpos(String key, boolean value) {
        return this.bitpos(key, value, new BitPosParams());
    }

    @Override
    public Long bitpos(String key, boolean value, BitPosParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.bitpos(key, value, params);
        return this.client.getIntegerReply();
    }

    @Override
    public List<Object> role() {
        this.checkIsInMultiOrPipeline();
        this.client.role();
        return BuilderFactory.ENCODED_OBJECT_LIST.build(this.client.getOne());
    }

    @Override
    public List<String> configGet(String pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.configGet(pattern);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String configSet(String parameter, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.configSet(parameter, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceed(this.client, channels);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Long publish(String channel, String message) {
        this.checkIsInMultiOrPipeline();
        this.client.publish(channel, message);
        return this.client.getIntegerReply();
    }

    @Override
    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.checkIsInMultiOrPipeline();
        this.client.setTimeoutInfinite();
        try {
            jedisPubSub.proceedWithPatterns(this.client, patterns);
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    protected static String[] getParams(List<String> keys, List<String> args) {
        int i;
        int keyCount = keys.size();
        int argCount = args.size();
        String[] params = new String[keyCount + args.size()];
        for (i = 0; i < keyCount; ++i) {
            params[i] = keys.get(i);
        }
        for (i = 0; i < argCount; ++i) {
            params[keyCount + i] = args.get(i);
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String script, int keyCount, String ... params) {
        this.checkIsInMultiOrPipeline();
        this.client.eval(script, keyCount, params);
        this.client.setTimeoutInfinite();
        try {
            Object object = SafeEncoder.encodeObject(this.client.getOne());
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public Object eval(String script, List<String> keys, List<String> args) {
        return this.eval(script, keys.size(), Jedis.getParams(keys, args));
    }

    @Override
    public Object eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    @Override
    public Object evalsha(String sha1) {
        return this.evalsha(sha1, 0, new String[0]);
    }

    @Override
    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        return this.evalsha(sha1, keys.size(), Jedis.getParams(keys, args));
    }

    @Override
    public Object evalsha(String sha1, int keyCount, String ... params) {
        this.checkIsInMultiOrPipeline();
        this.client.evalsha(sha1, keyCount, params);
        return SafeEncoder.encodeObject(this.client.getOne());
    }

    @Override
    public Boolean scriptExists(String sha1) {
        String[] a = new String[]{sha1};
        return this.scriptExists(a).get(0);
    }

    @Override
    public List<Boolean> scriptExists(String ... sha1) {
        this.client.scriptExists(sha1);
        List<Long> result = this.client.getIntegerMultiBulkReply();
        ArrayList<Boolean> exists = new ArrayList<Boolean>();
        for (Long value : result) {
            exists.add(value == 1L);
        }
        return exists;
    }

    @Override
    public String scriptLoad(String script) {
        this.client.scriptLoad(script);
        return this.client.getBulkReply();
    }

    @Override
    public List<Slowlog> slowlogGet() {
        this.client.slowlogGet();
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<Slowlog> slowlogGet(long entries) {
        this.client.slowlogGet(entries);
        return Slowlog.from(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Long objectRefcount(String key) {
        this.client.objectRefcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String objectEncoding(String key) {
        this.client.objectEncoding(key);
        return this.client.getBulkReply();
    }

    @Override
    public Long objectIdletime(String key) {
        this.client.objectIdletime(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<String> objectHelp() {
        this.client.objectHelp();
        return this.client.getMultiBulkReply();
    }

    @Override
    public Long objectFreq(String key) {
        this.client.objectFreq(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.bitcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitcount(String key, long start, long end) {
        this.checkIsInMultiOrPipeline();
        this.client.bitcount(key, start, end);
        return this.client.getIntegerReply();
    }

    @Override
    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        this.checkIsInMultiOrPipeline();
        this.client.bitop(op, destKey, srcKeys);
        return this.client.getIntegerReply();
    }

    @Override
    public String sentinelMyId() {
        this.client.sentinel(Protocol.SentinelKeyword.MYID);
        return BuilderFactory.STRING.build(this.client.getBinaryBulkReply());
    }

    @Override
    public List<Map<String, String>> sentinelMasters() {
        this.client.sentinel("masters");
        List<Object> reply = this.client.getObjectMultiBulkReply();
        ArrayList<Map<String, String>> masters = new ArrayList<Map<String, String>>();
        for (Object obj : reply) {
            masters.add(BuilderFactory.STRING_MAP.build(obj));
        }
        return masters;
    }

    @Override
    public Map<String, String> sentinelMaster(String masterName) {
        this.client.sentinel(Protocol.SentinelKeyword.MASTER, masterName);
        return BuilderFactory.STRING_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public List<Map<String, String>> sentinelSentinels(String masterName) {
        this.client.sentinel(Protocol.SentinelKeyword.SENTINELS, masterName);
        return this.client.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public List<String> sentinelGetMasterAddrByName(String masterName) {
        this.client.sentinel("get-master-addr-by-name", masterName);
        List<Object> reply = this.client.getObjectMultiBulkReply();
        return BuilderFactory.STRING_LIST.build(reply);
    }

    @Override
    public Long sentinelReset(String pattern) {
        this.client.sentinel("reset", pattern);
        return this.client.getIntegerReply();
    }

    @Override
    @Deprecated
    public List<Map<String, String>> sentinelSlaves(String masterName) {
        this.client.sentinel("slaves", masterName);
        List<Object> reply = this.client.getObjectMultiBulkReply();
        ArrayList<Map<String, String>> slaves = new ArrayList<Map<String, String>>();
        for (Object obj : reply) {
            slaves.add(BuilderFactory.STRING_MAP.build(obj));
        }
        return slaves;
    }

    @Override
    public List<Map<String, String>> sentinelReplicas(String masterName) {
        this.client.sentinel(Protocol.SentinelKeyword.REPLICAS, masterName);
        return this.client.getObjectMultiBulkReply().stream().map(BuilderFactory.STRING_MAP::build).collect(Collectors.toList());
    }

    @Override
    public String sentinelFailover(String masterName) {
        this.client.sentinel("failover", masterName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        this.client.sentinel("monitor", masterName, ip, String.valueOf(port), String.valueOf(quorum));
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelRemove(String masterName) {
        this.client.sentinel("remove", masterName);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        int index = 0;
        int paramsLength = parameterMap.size() * 2 + 2;
        String[] params = new String[paramsLength];
        params[index++] = "set";
        params[index++] = masterName;
        for (Map.Entry<String, String> entry : parameterMap.entrySet()) {
            params[index++] = entry.getKey();
            params[index++] = entry.getValue();
        }
        this.client.sentinel(params);
        return this.client.getStatusCodeReply();
    }

    @Override
    public byte[] dump(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.dump(key);
        return this.client.getBinaryBulkReply();
    }

    @Override
    public String restore(String key, long ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restore(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String restoreReplace(String key, long ttl, byte[] serializedValue) {
        this.checkIsInMultiOrPipeline();
        this.client.restoreReplace(key, ttl, serializedValue);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String restore(String key, long ttl, byte[] serializedValue, RestoreParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.restore(key, ttl, serializedValue, params);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long pexpire(String key, long milliseconds) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpire(key, milliseconds);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pexpireAt(String key, long millisecondsTimestamp) {
        this.checkIsInMultiOrPipeline();
        this.client.pexpireAt(key, millisecondsTimestamp);
        return this.client.getIntegerReply();
    }

    @Override
    public Long pttl(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.pttl(key);
        return this.client.getIntegerReply();
    }

    @Override
    public String psetex(String key, long milliseconds, String value) {
        this.checkIsInMultiOrPipeline();
        this.client.psetex(key, milliseconds, value);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clientKill(String ipPort) {
        this.checkIsInMultiOrPipeline();
        this.client.clientKill(ipPort);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clientGetname() {
        this.checkIsInMultiOrPipeline();
        this.client.clientGetname();
        return this.client.getBulkReply();
    }

    @Override
    public String clientList() {
        this.checkIsInMultiOrPipeline();
        this.client.clientList();
        return this.client.getBulkReply();
    }

    @Override
    public String clientList(ClientType type) {
        this.checkIsInMultiOrPipeline();
        this.client.clientList(type);
        return this.client.getBulkReply();
    }

    @Override
    public String clientList(long ... clientIds) {
        this.checkIsInMultiOrPipeline();
        this.client.clientList(clientIds);
        return this.client.getBulkReply();
    }

    @Override
    public String clientInfo() {
        this.checkIsInMultiOrPipeline();
        this.client.clientInfo();
        return this.client.getBulkReply();
    }

    @Override
    public String clientSetname(String name) {
        this.checkIsInMultiOrPipeline();
        this.client.clientSetname(name);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long clientId() {
        this.checkIsInMultiOrPipeline();
        this.client.clientId();
        return this.client.getIntegerReply();
    }

    @Override
    public Long clientUnblock(long clientId, UnblockType unblockType) {
        this.checkIsInMultiOrPipeline();
        this.client.clientUnblock(clientId, unblockType);
        return this.client.getIntegerReply();
    }

    @Override
    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, key, destinationDb, timeout);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String migrate(String host, int port, int destinationDB, int timeout, MigrateParams params, String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.migrate(host, port, destinationDB, timeout, params, keys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public ScanResult<String> scan(String cursor) {
        return this.scan(cursor, new ScanParams());
    }

    @Override
    public ScanResult<String> scan(String cursor, ScanParams params) {
        return this.scan(cursor, params, null);
    }

    @Override
    public ScanResult<String> scan(String cursor, ScanParams params, String type) {
        this.checkIsInMultiOrPipeline();
        this.client.scan(cursor, params, type);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.hscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.hscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<AbstractMap.SimpleEntry<String, String>> results = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new AbstractMap.SimpleEntry<String, String>(SafeEncoder.encode((byte[])iterator.next()), SafeEncoder.encode((byte[])iterator.next())));
        }
        return new ScanResult<Map.Entry<String, String>>(newcursor, results);
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor) {
        return this.sscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.sscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<String> results = new ArrayList<String>();
        List rawResults = (List)result.get(1);
        for (byte[] bs : rawResults) {
            results.add(SafeEncoder.encode(bs));
        }
        return new ScanResult<String>(newcursor, results);
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.zscan(key, cursor, new ScanParams());
    }

    @Override
    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.zscan(key, cursor, params);
        List<Object> result = this.client.getObjectMultiBulkReply();
        String newcursor = new String((byte[])result.get(0));
        ArrayList<Tuple> results = new ArrayList<Tuple>();
        List rawResults = (List)result.get(1);
        Iterator iterator = rawResults.iterator();
        while (iterator.hasNext()) {
            results.add(new Tuple((byte[])iterator.next(), BuilderFactory.DOUBLE.build(iterator.next())));
        }
        return new ScanResult<Tuple>(newcursor, results);
    }

    @Override
    public String readonly() {
        this.checkIsInMultiOrPipeline();
        this.client.readonly();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String readwrite() {
        this.checkIsInMultiOrPipeline();
        this.client.readwrite();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterNodes() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterNodes();
        return this.client.getBulkReply();
    }

    @Override
    public String clusterReplicas(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterReplicas(nodeId);
        return this.client.getBulkReply();
    }

    @Override
    public String clusterMeet(String ip, int port) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterMeet(ip, port);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReset(ClusterReset resetType) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterReset(resetType);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReset(ClusterResetType resetType) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterReset(resetType);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterAddSlots(int ... slots) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterAddSlots(slots);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterDelSlots(int ... slots) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterDelSlots(slots);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterInfo() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterInfo();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> clusterGetKeysInSlot(int slot, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterGetKeysInSlot(slot, count);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<byte[]> clusterGetKeysInSlotBinary(int slot, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterGetKeysInSlot(slot, count);
        return this.client.getBinaryMultiBulkReply();
    }

    @Override
    public String clusterSetSlotNode(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotNode(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotMigrating(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotMigrating(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotImporting(int slot, String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotImporting(slot, nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterSetSlotStable(int slot) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSetSlotStable(slot);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterForget(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterForget(nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterFlushSlots() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterFlushSlots();
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long clusterKeySlot(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterKeySlot(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long clusterCountKeysInSlot(int slot) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterCountKeysInSlot(slot);
        return this.client.getIntegerReply();
    }

    @Override
    public String clusterSaveConfig() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSaveConfig();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String clusterReplicate(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterReplicate(nodeId);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> clusterSlaves(String nodeId) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSlaves(nodeId);
        return this.client.getMultiBulkReply();
    }

    @Override
    public String clusterFailover(ClusterFailoverOption failoverOption) {
        this.checkIsInMultiOrPipeline();
        this.client.clusterFailover(failoverOption);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Object> clusterSlots() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterSlots();
        return this.client.getObjectMultiBulkReply();
    }

    @Override
    public String clusterMyId() {
        this.checkIsInMultiOrPipeline();
        this.client.clusterMyId();
        return this.client.getBulkReply();
    }

    public String asking() {
        this.checkIsInMultiOrPipeline();
        this.client.asking();
        return this.client.getStatusCodeReply();
    }

    public List<String> pubsubChannels() {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubChannels();
        return this.client.getMultiBulkReply();
    }

    public List<String> pubsubChannels(String pattern) {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubChannels(pattern);
        return this.client.getMultiBulkReply();
    }

    public Long pubsubNumPat() {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubNumPat();
        return this.client.getIntegerReply();
    }

    public Map<String, String> pubsubNumSub(String ... channels) {
        this.checkIsInMultiOrPipeline();
        this.client.pubsubNumSub(channels);
        return BuilderFactory.PUBSUB_NUMSUB_MAP.build(this.client.getBinaryMultiBulkReply());
    }

    @Override
    public void close() {
        if (this.dataSource != null) {
            JedisPoolAbstract pool = this.dataSource;
            this.dataSource = null;
            if (this.isBroken()) {
                pool.returnBrokenResource(this);
            } else {
                pool.returnResource(this);
            }
        } else {
            super.close();
        }
    }

    public void setDataSource(JedisPoolAbstract jedisPool) {
        this.dataSource = jedisPool;
    }

    @Override
    public Long pfadd(String key, String ... elements) {
        this.checkIsInMultiOrPipeline();
        this.client.pfadd(key, elements);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(key);
        return this.client.getIntegerReply();
    }

    @Override
    public long pfcount(String ... keys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfcount(keys);
        return this.client.getIntegerReply();
    }

    @Override
    public String pfmerge(String destkey, String ... sourcekeys) {
        this.checkIsInMultiOrPipeline();
        this.client.pfmerge(destkey, sourcekeys);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long geoadd(String key, double longitude, double latitude, String member) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, longitude, latitude, member);
        return this.client.getIntegerReply();
    }

    @Override
    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, memberCoordinateMap);
        return this.client.getIntegerReply();
    }

    @Override
    public Long geoadd(String key, GeoAddParams params, Map<String, GeoCoordinate> memberCoordinateMap) {
        this.checkIsInMultiOrPipeline();
        this.client.geoadd(key, params, memberCoordinateMap);
        return this.client.getIntegerReply();
    }

    @Override
    public Double geodist(String key, String member1, String member2) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.geodist(key, member1, member2, unit);
        return BuilderFactory.DOUBLE.build(this.client.getOne());
    }

    @Override
    public List<String> geohash(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.geohash(key, members);
        return this.client.getMultiBulkReply();
    }

    @Override
    public List<GeoCoordinate> geopos(String key, String ... members) {
        this.checkIsInMultiOrPipeline();
        this.client.geopos(key, members);
        return BuilderFactory.GEO_COORDINATE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusReadonly(key, longitude, latitude, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadius(key, longitude, latitude, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Long georadiusStore(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusStore(key, longitude, latitude, radius, unit, param, storeParam);
        return this.client.getIntegerReply();
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusReadonly(key, longitude, latitude, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberReadonly(key, member, radius, unit);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMember(key, member, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Long georadiusByMemberStore(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberStore(key, member, radius, unit, param, storeParam);
        return this.client.getIntegerReply();
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        this.checkIsInMultiOrPipeline();
        this.client.georadiusByMemberReadonly(key, member, radius, unit, param);
        return BuilderFactory.GEORADIUS_WITH_PARAMS_RESULT.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public String moduleLoad(String path) {
        this.checkIsInMultiOrPipeline();
        this.client.moduleLoad(path);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String moduleUnload(String name) {
        this.checkIsInMultiOrPipeline();
        this.client.moduleUnload(name);
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Module> moduleList() {
        this.checkIsInMultiOrPipeline();
        this.client.moduleList();
        return BuilderFactory.MODULE_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public String aclSetUser(String name) {
        this.client.aclSetUser(name);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String aclSetUser(String name, String ... params) {
        this.client.aclSetUser(name, params);
        return this.client.getStatusCodeReply();
    }

    @Override
    public Long aclDelUser(String name) {
        this.client.aclDelUser(name);
        return this.client.getIntegerReply();
    }

    @Override
    public AccessControlUser aclGetUser(String name) {
        this.client.aclGetUser(name);
        return BuilderFactory.ACCESS_CONTROL_USER.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<String> aclUsers() {
        this.client.aclUsers();
        return BuilderFactory.STRING_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<String> aclList() {
        this.client.aclList();
        return this.client.getMultiBulkReply();
    }

    @Override
    public String aclWhoAmI() {
        this.client.aclWhoAmI();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<String> aclCat() {
        this.client.aclCat();
        return BuilderFactory.STRING_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<String> aclCat(String category) {
        this.client.aclCat(category);
        return BuilderFactory.STRING_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<AccessControlLogEntry> aclLog() {
        this.client.aclLog();
        return BuilderFactory.ACCESS_CONTROL_LOG_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<AccessControlLogEntry> aclLog(int limit) {
        this.client.aclLog(limit);
        return BuilderFactory.ACCESS_CONTROL_LOG_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public String aclLog(String options) {
        this.client.aclLog(options);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String aclGenPass() {
        this.client.aclGenPass();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String aclLoad() {
        this.checkIsInMultiOrPipeline();
        this.client.aclLoad();
        return this.client.getStatusCodeReply();
    }

    @Override
    public String aclSave() {
        this.checkIsInMultiOrPipeline();
        this.client.aclSave();
        return this.client.getStatusCodeReply();
    }

    @Override
    public List<Long> bitfield(String key, String ... arguments) {
        this.checkIsInMultiOrPipeline();
        this.client.bitfield(key, arguments);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public List<Long> bitfieldReadonly(String key, String ... arguments) {
        this.checkIsInMultiOrPipeline();
        this.client.bitfieldReadonly(key, arguments);
        return this.client.getIntegerMultiBulkReply();
    }

    @Override
    public Long hstrlen(String key, String field) {
        this.checkIsInMultiOrPipeline();
        this.client.hstrlen(key, field);
        return this.client.getIntegerReply();
    }

    @Override
    public String memoryDoctor() {
        this.checkIsInMultiOrPipeline();
        this.client.memoryDoctor();
        return this.client.getBulkReply();
    }

    @Override
    public Long memoryUsage(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.memoryUsage(key);
        return this.client.getIntegerReply();
    }

    @Override
    public Long memoryUsage(String key, int samples) {
        this.checkIsInMultiOrPipeline();
        this.client.memoryUsage(key, samples);
        return this.client.getIntegerReply();
    }

    @Override
    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash) {
        return this.xadd(key, id, hash, Long.MAX_VALUE, false);
    }

    @Override
    public StreamEntryID xadd(String key, StreamEntryID id, Map<String, String> hash, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        this.client.xadd(key, id, hash, maxLen, approximateLength);
        String result = this.client.getBulkReply();
        return new StreamEntryID(result);
    }

    @Override
    public StreamEntryID xadd(String key, Map<String, String> hash, XAddParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xadd(key, hash, params);
        return BuilderFactory.STREAM_ENTRY_ID.build(this.client.getBinaryBulkReply());
    }

    @Override
    public Long xlen(String key) {
        this.checkIsInMultiOrPipeline();
        this.client.xlen(key);
        return this.client.getIntegerReply();
    }

    @Override
    public List<StreamEntry> xrange(String key, StreamEntryID start, StreamEntryID end) {
        this.checkIsInMultiOrPipeline();
        this.client.xrange(key, start, end);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamEntry> xrange(String key, StreamEntryID start, StreamEntryID end, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.xrange(key, start, end, count);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamEntry> xrevrange(String key, StreamEntryID end, StreamEntryID start) {
        this.checkIsInMultiOrPipeline();
        this.client.xrevrange(key, end, start);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamEntry> xrevrange(String key, StreamEntryID end, StreamEntryID start, int count) {
        this.checkIsInMultiOrPipeline();
        this.client.xrevrange(key, end, start, count);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xread(int count, long block, Map.Entry<String, StreamEntryID> ... streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xread(count, block, streams);
        this.client.setTimeoutInfinite();
        try {
            List<Object> streamsEntries = this.client.getObjectMultiBulkReply();
            if (streamsEntries == null) {
                ArrayList<Map.Entry<String, List<StreamEntry>>> arrayList = new ArrayList<Map.Entry<String, List<StreamEntry>>>();
                return arrayList;
            }
            List<Map.Entry<String, List<StreamEntry>>> list = BuilderFactory.STREAM_READ_RESPONSE.build(streamsEntries);
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xread(XReadParams xReadParams, Map<String, StreamEntryID> streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xread(xReadParams, streams);
        if (!xReadParams.hasBlock()) {
            return BuilderFactory.STREAM_READ_RESPONSE.build(this.client.getObjectMultiBulkReply());
        }
        this.client.setTimeoutInfinite();
        try {
            List<Map.Entry<String, List<StreamEntry>>> list = BuilderFactory.STREAM_READ_RESPONSE.build(this.client.getObjectMultiBulkReply());
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public long xack(String key, String group, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xack(key, group, ids);
        return this.client.getIntegerReply();
    }

    @Override
    public String xgroupCreate(String key, String groupname, StreamEntryID id, boolean makeStream) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupCreate(key, groupname, id, makeStream);
        return this.client.getStatusCodeReply();
    }

    @Override
    public String xgroupSetID(String key, String groupname, StreamEntryID id) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupSetID(key, groupname, id);
        return this.client.getStatusCodeReply();
    }

    @Override
    public long xgroupDestroy(String key, String groupname) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupDestroy(key, groupname);
        return this.client.getIntegerReply();
    }

    @Override
    public Long xgroupDelConsumer(String key, String groupname, String consumerName) {
        this.checkIsInMultiOrPipeline();
        this.client.xgroupDelConsumer(key, groupname, consumerName);
        return this.client.getIntegerReply();
    }

    @Override
    public long xdel(String key, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xdel(key, ids);
        return this.client.getIntegerReply();
    }

    @Override
    public long xtrim(String key, long maxLen, boolean approximateLength) {
        this.checkIsInMultiOrPipeline();
        this.client.xtrim(key, maxLen, approximateLength);
        return this.client.getIntegerReply();
    }

    @Override
    public long xtrim(String key, XTrimParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xtrim(key, params);
        return this.client.getIntegerReply();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xreadGroup(String groupname, String consumer, int count, long block, boolean noAck, Map.Entry<String, StreamEntryID> ... streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xreadGroup(groupname, consumer, count, block, noAck, streams);
        this.client.setTimeoutInfinite();
        try {
            List<Map.Entry<String, List<StreamEntry>>> list = BuilderFactory.STREAM_READ_RESPONSE.build(this.client.getObjectMultiBulkReply());
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<String, List<StreamEntry>>> xreadGroup(String groupname, String consumer, XReadGroupParams xReadGroupParams, Map<String, StreamEntryID> streams) {
        this.checkIsInMultiOrPipeline();
        this.client.xreadGroup(groupname, consumer, xReadGroupParams, streams);
        if (!xReadGroupParams.hasBlock()) {
            return BuilderFactory.STREAM_READ_RESPONSE.build(this.client.getObjectMultiBulkReply());
        }
        this.client.setTimeoutInfinite();
        try {
            List<Map.Entry<String, List<StreamEntry>>> list = BuilderFactory.STREAM_READ_RESPONSE.build(this.client.getObjectMultiBulkReply());
            return list;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }

    @Override
    public StreamPendingSummary xpending(String key, String groupname) {
        this.checkIsInMultiOrPipeline();
        this.client.xpending(key, groupname);
        return BuilderFactory.STREAM_PENDING_SUMMARY.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamPendingEntry> xpending(String key, String groupname, StreamEntryID start, StreamEntryID end, int count, String consumername) {
        this.checkIsInMultiOrPipeline();
        this.client.xpending(key, groupname, start, end, count, consumername);
        return BuilderFactory.STREAM_PENDING_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamPendingEntry> xpending(String key, String groupname, XPendingParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xpending(key, groupname, params);
        return BuilderFactory.STREAM_PENDING_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamEntry> xclaim(String key, String group, String consumername, long minIdleTime, long newIdleTime, int retries, boolean force, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xclaim(key, group, consumername, minIdleTime, newIdleTime, retries, force, ids);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamEntry> xclaim(String key, String group, String consumername, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xclaim(key, group, consumername, minIdleTime, params, ids);
        return BuilderFactory.STREAM_ENTRY_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamEntryID> xclaimJustId(String key, String group, String consumername, long minIdleTime, XClaimParams params, StreamEntryID ... ids) {
        this.checkIsInMultiOrPipeline();
        this.client.xclaimJustId(key, group, consumername, minIdleTime, params, ids);
        return BuilderFactory.STREAM_ENTRY_ID_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String key, String group, String consumerName, long minIdleTime, StreamEntryID start, XAutoClaimParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xautoclaim(key, group, consumerName, minIdleTime, start, params);
        return BuilderFactory.STREAM_AUTO_CLAIM_RESPONSE.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String key, String group, String consumerName, long minIdleTime, StreamEntryID start, XAutoClaimParams params) {
        this.checkIsInMultiOrPipeline();
        this.client.xautoclaimJustId(key, group, consumerName, minIdleTime, start, params);
        return BuilderFactory.STREAM_AUTO_CLAIM_ID_RESPONSE.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public StreamInfo xinfoStream(String key) {
        this.client.xinfoStream(key);
        return BuilderFactory.STREAM_INFO.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamGroupInfo> xinfoGroup(String key) {
        this.client.xinfoGroup(key);
        return BuilderFactory.STREAM_GROUP_INFO_LIST.build(this.client.getObjectMultiBulkReply());
    }

    @Override
    public List<StreamConsumersInfo> xinfoConsumers(String key, String group) {
        this.client.xinfoConsumers(key, group);
        return BuilderFactory.STREAM_CONSUMERS_INFO_LIST.build(this.client.getObjectMultiBulkReply());
    }

    public Object sendCommand(ProtocolCommand cmd, String ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.sendCommand(cmd, args);
        return this.client.getOne();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sendBlockingCommand(ProtocolCommand cmd, String ... args) {
        this.checkIsInMultiOrPipeline();
        this.client.sendCommand(cmd, args);
        this.client.setTimeoutInfinite();
        try {
            Object object = this.client.getOne();
            return object;
        }
        finally {
            this.client.rollbackTimeout();
        }
    }
}

