/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisFactory;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;

public class JedisSentinelPool
extends JedisPoolAbstract {
    @Deprecated
    protected static Logger log = LoggerFactory.getLogger(JedisSentinelPool.class);
    @Deprecated
    protected final GenericObjectPoolConfig<Jedis> poolConfig;
    private final JedisFactory factory;
    @Deprecated
    protected int connectionTimeout;
    @Deprecated
    protected int soTimeout;
    @Deprecated
    protected int infiniteSoTimeout;
    @Deprecated
    protected String user;
    @Deprecated
    protected String password;
    @Deprecated
    protected int database;
    @Deprecated
    protected String clientName;
    @Deprecated
    protected int sentinelConnectionTimeout;
    @Deprecated
    protected int sentinelSoTimeout;
    @Deprecated
    protected String sentinelUser;
    @Deprecated
    protected String sentinelPassword;
    @Deprecated
    protected String sentinelClientName;
    private final JedisClientConfig sentinelClientConfig;
    protected final Set<MasterListener> masterListeners = new HashSet<MasterListener>();
    private volatile HostAndPort currentHostMaster;
    private final Object initPoolLock = new Object();

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig) {
        this(masterName, sentinels, poolConfig, 2000, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels) {
        this(masterName, sentinels, (GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), 2000, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, String password) {
        this(masterName, sentinels, (GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), 2000, password);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, String password, String sentinelPassword) {
        this(masterName, sentinels, (GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), 2000, 2000, password, 0, null, 2000, 2000, sentinelPassword, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int timeout, String password) {
        this(masterName, sentinels, poolConfig, timeout, password, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int timeout) {
        this(masterName, sentinels, poolConfig, timeout, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, String password) {
        this(masterName, sentinels, poolConfig, 2000, password);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int timeout, String password, int database) {
        this(masterName, sentinels, poolConfig, timeout, timeout, null, password, database);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int timeout, String user, String password, int database) {
        this(masterName, sentinels, poolConfig, timeout, timeout, user, password, database);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int timeout, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, timeout, timeout, password, database, clientName);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int timeout, String user, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, timeout, timeout, user, password, database, clientName);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, int database) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, null, password, database, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, int database) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, user, password, database, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, null, password, database, clientName);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, user, password, database, clientName, 2000, 2000, null, null, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName, 2000, 2000, null, null, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName, int sentinelConnectionTimeout, int sentinelSoTimeout, String sentinelPassword, String sentinelClientName) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, null, password, database, clientName, sentinelConnectionTimeout, sentinelSoTimeout, null, sentinelPassword, sentinelClientName);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, int sentinelConnectionTimeout, int sentinelSoTimeout, String sentinelUser, String sentinelPassword, String sentinelClientName) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, 0, user, password, database, clientName, sentinelConnectionTimeout, sentinelSoTimeout, sentinelUser, sentinelPassword, sentinelClientName);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName, int sentinelConnectionTimeout, int sentinelSoTimeout, String sentinelUser, String sentinelPassword, String sentinelClientName) {
        this(masterName, sentinels, poolConfig, new JedisFactory(connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName));
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
        this.infiniteSoTimeout = infiniteSoTimeout;
        this.user = user;
        this.password = password;
        this.database = database;
        this.clientName = clientName;
        this.sentinelConnectionTimeout = sentinelConnectionTimeout;
        this.sentinelSoTimeout = sentinelSoTimeout;
        this.sentinelUser = sentinelUser;
        this.sentinelPassword = sentinelPassword;
        this.sentinelClientName = sentinelClientName;
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, JedisFactory factory) {
        this(masterName, JedisSentinelPool.parseHostAndPorts(sentinels), poolConfig, factory, (JedisClientConfig)DefaultJedisClientConfig.builder().build());
    }

    public JedisSentinelPool(String masterName, Set<HostAndPort> sentinels, JedisClientConfig masteClientConfig, JedisClientConfig sentinelClientConfig) {
        this(masterName, sentinels, (GenericObjectPoolConfig<Jedis>)new GenericObjectPoolConfig(), masteClientConfig, sentinelClientConfig);
    }

    public JedisSentinelPool(String masterName, Set<HostAndPort> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, JedisClientConfig masteClientConfig, JedisClientConfig sentinelClientConfig) {
        this(masterName, sentinels, poolConfig, new JedisFactory(masteClientConfig), sentinelClientConfig);
    }

    public JedisSentinelPool(String masterName, Set<HostAndPort> sentinels, GenericObjectPoolConfig<Jedis> poolConfig, JedisFactory factory, JedisClientConfig sentinelClientConfig) {
        super(poolConfig, factory);
        this.poolConfig = poolConfig;
        this.factory = factory;
        this.sentinelClientConfig = sentinelClientConfig;
        HostAndPort master = this.initSentinels(sentinels, masterName);
        this.initMaster(master);
    }

    private static Set<HostAndPort> parseHostAndPorts(Set<String> strings) {
        return strings.stream().map(HostAndPort::parseString).collect(Collectors.toSet());
    }

    @Override
    public void destroy() {
        for (MasterListener m : this.masterListeners) {
            m.shutdown();
        }
        super.destroy();
    }

    public HostAndPort getCurrentHostMaster() {
        return this.currentHostMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMaster(HostAndPort master) {
        Object object = this.initPoolLock;
        synchronized (object) {
            if (!master.equals(this.currentHostMaster)) {
                this.currentHostMaster = master;
                this.factory.setHostAndPort(this.currentHostMaster);
                this.clearInternalPool();
                log.info("Created JedisSentinelPool to master at {}", (Object)master);
            }
        }
    }

    private HostAndPort initSentinels(Set<HostAndPort> sentinels, String masterName) {
        HostAndPort master = null;
        boolean sentinelAvailable = false;
        log.info("Trying to find master from available Sentinels...");
        for (HostAndPort sentinel : sentinels) {
            log.debug("Connecting to Sentinel {}", (Object)sentinel);
            try {
                Jedis jedis = new Jedis(sentinel, this.sentinelClientConfig);
                Throwable throwable = null;
                try {
                    List<String> masterAddr = jedis.sentinelGetMasterAddrByName(masterName);
                    sentinelAvailable = true;
                    if (masterAddr == null || masterAddr.size() != 2) {
                        log.warn("Can not get master addr, master name: {}. Sentinel: {}", (Object)masterName, (Object)sentinel);
                        continue;
                    }
                    master = this.toHostAndPort(masterAddr);
                    log.debug("Found Redis master at {}", (Object)master);
                    break;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jedis == null) continue;
                    if (throwable != null) {
                        try {
                            jedis.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jedis.close();
                }
            }
            catch (JedisException e) {
                log.warn("Cannot get master address from sentinel running @ {}. Reason: {}. Trying next one.", (Object)sentinel, (Object)e);
            }
        }
        if (master == null) {
            if (sentinelAvailable) {
                throw new JedisException("Can connect to sentinel, but " + masterName + " seems to be not monitored...");
            }
            throw new JedisConnectionException("All sentinels down, cannot determine where is " + masterName + " master is running...");
        }
        log.info("Redis master running at {}, starting Sentinel listeners...", master);
        for (HostAndPort sentinel : sentinels) {
            MasterListener masterListener = new MasterListener(masterName, sentinel.getHost(), sentinel.getPort());
            masterListener.setDaemon(true);
            this.masterListeners.add(masterListener);
            masterListener.start();
        }
        return master;
    }

    private HostAndPort toHostAndPort(List<String> getMasterAddrByNameResult) {
        String host = getMasterAddrByNameResult.get(0);
        int port = Integer.parseInt(getMasterAddrByNameResult.get(1));
        return new HostAndPort(host, port);
    }

    @Override
    public Jedis getResource() {
        while (true) {
            Jedis jedis = (Jedis)super.getResource();
            jedis.setDataSource(this);
            HostAndPort master = this.currentHostMaster;
            HostAndPort connection = new HostAndPort(jedis.getClient().getHost(), jedis.getClient().getPort());
            if (master.equals(connection)) {
                return jedis;
            }
            this.returnBrokenResource(jedis);
        }
    }

    @Override
    public void returnResource(Jedis resource) {
        if (resource != null) {
            try {
                resource.resetState();
                this.returnResourceObject(resource);
            }
            catch (Exception e) {
                this.returnBrokenResource(resource);
                log.debug("Resource is returned to the pool as broken", (Throwable)e);
            }
        }
    }

    protected class MasterListener
    extends Thread {
        protected String masterName;
        protected String host;
        protected int port;
        protected long subscribeRetryWaitTimeMillis;
        protected volatile Jedis j;
        protected AtomicBoolean running;

        protected MasterListener() {
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
        }

        public MasterListener(String masterName, String host, int port) {
            super(String.format("MasterListener-%s-[%s:%d]", masterName, host, port));
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
            this.masterName = masterName;
            this.host = host;
            this.port = port;
        }

        public MasterListener(String masterName, String host, int port, long subscribeRetryWaitTimeMillis) {
            this(masterName, host, port);
            this.subscribeRetryWaitTimeMillis = subscribeRetryWaitTimeMillis;
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                try {
                    if (!this.running.get()) break;
                    final HostAndPort hostPort = new HostAndPort(this.host, this.port);
                    this.j = new Jedis(hostPort, JedisSentinelPool.this.sentinelClientConfig);
                    List<String> masterAddr = this.j.sentinelGetMasterAddrByName(this.masterName);
                    if (masterAddr == null || masterAddr.size() != 2) {
                        log.warn("Can not get master addr, master name: {}. Sentinel: {}.", (Object)this.masterName, (Object)hostPort);
                    } else {
                        JedisSentinelPool.this.initMaster(JedisSentinelPool.this.toHostAndPort(masterAddr));
                    }
                    this.j.subscribe(new JedisPubSub(){

                        @Override
                        public void onMessage(String channel, String message) {
                            log.debug("Sentinel {} published: {}.", (Object)hostPort, (Object)message);
                            String[] switchMasterMsg = message.split(" ");
                            if (switchMasterMsg.length > 3) {
                                if (MasterListener.this.masterName.equals(switchMasterMsg[0])) {
                                    JedisSentinelPool.this.initMaster(JedisSentinelPool.this.toHostAndPort(Arrays.asList(switchMasterMsg[3], switchMasterMsg[4])));
                                } else {
                                    log.debug("Ignoring message on +switch-master for master name {}, our master name is {}", (Object)switchMasterMsg[0], (Object)MasterListener.this.masterName);
                                }
                            } else {
                                log.error("Invalid message received on Sentinel {} on channel +switch-master: {}", (Object)hostPort, (Object)message);
                            }
                        }
                    }, "+switch-master");
                }
                catch (JedisException e) {
                    if (this.running.get()) {
                        log.error("Lost connection to Sentinel at {}:{}. Sleeping 5000ms and retrying.", new Object[]{this.host, this.port, e});
                        try {
                            Thread.sleep(this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException e1) {
                            log.error("Sleep interrupted: ", (Throwable)e1);
                        }
                        continue;
                    }
                    log.debug("Unsubscribing from Sentinel at {}:{}", (Object)this.host, (Object)this.port);
                }
                finally {
                    if (this.j == null) continue;
                    this.j.close();
                }
            }
        }

        public void shutdown() {
            try {
                log.debug("Shutting down listener on {}:{}", (Object)this.host, (Object)this.port);
                this.running.set(false);
                if (this.j != null) {
                    this.j.close();
                }
            }
            catch (Exception e) {
                log.error("Caught exception while shutting down: ", (Throwable)e);
            }
        }
    }
}

