/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisAccessControlException;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisBusyException;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.exceptions.JedisNoScriptException;
import redis.clients.jedis.util.RedisInputStream;
import redis.clients.jedis.util.RedisOutputStream;
import redis.clients.jedis.util.SafeEncoder;

public final class Protocol {
    private static final String ASK_PREFIX = "ASK ";
    private static final String MOVED_PREFIX = "MOVED ";
    private static final String CLUSTERDOWN_PREFIX = "CLUSTERDOWN ";
    private static final String BUSY_PREFIX = "BUSY ";
    private static final String NOSCRIPT_PREFIX = "NOSCRIPT ";
    private static final String WRONGPASS_PREFIX = "WRONGPASS";
    private static final String NOPERM_PREFIX = "NOPERM";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_DATABASE = 0;
    public static final String CHARSET = "UTF-8";
    public static final byte DOLLAR_BYTE = 36;
    public static final byte ASTERISK_BYTE = 42;
    public static final byte PLUS_BYTE = 43;
    public static final byte MINUS_BYTE = 45;
    public static final byte COLON_BYTE = 58;
    public static final String SENTINEL_MASTERS = "masters";
    public static final String SENTINEL_GET_MASTER_ADDR_BY_NAME = "get-master-addr-by-name";
    public static final String SENTINEL_RESET = "reset";
    public static final String SENTINEL_SLAVES = "slaves";
    public static final String SENTINEL_FAILOVER = "failover";
    public static final String SENTINEL_MONITOR = "monitor";
    public static final String SENTINEL_REMOVE = "remove";
    public static final String SENTINEL_SET = "set";
    public static final String CLUSTER_NODES = "nodes";
    public static final String CLUSTER_MEET = "meet";
    public static final String CLUSTER_RESET = "reset";
    public static final String CLUSTER_ADDSLOTS = "addslots";
    public static final String CLUSTER_DELSLOTS = "delslots";
    public static final String CLUSTER_INFO = "info";
    public static final String CLUSTER_GETKEYSINSLOT = "getkeysinslot";
    public static final String CLUSTER_SETSLOT = "setslot";
    public static final String CLUSTER_SETSLOT_NODE = "node";
    public static final String CLUSTER_SETSLOT_MIGRATING = "migrating";
    public static final String CLUSTER_SETSLOT_IMPORTING = "importing";
    public static final String CLUSTER_SETSLOT_STABLE = "stable";
    public static final String CLUSTER_FORGET = "forget";
    public static final String CLUSTER_FLUSHSLOT = "flushslots";
    public static final String CLUSTER_KEYSLOT = "keyslot";
    public static final String CLUSTER_COUNTKEYINSLOT = "countkeysinslot";
    public static final String CLUSTER_SAVECONFIG = "saveconfig";
    public static final String CLUSTER_REPLICATE = "replicate";
    public static final String CLUSTER_SLAVES = "slaves";
    public static final String CLUSTER_FAILOVER = "failover";
    public static final String CLUSTER_SLOTS = "slots";
    public static final String PUBSUB_CHANNELS = "channels";
    public static final String PUBSUB_NUMSUB = "numsub";
    public static final String PUBSUB_NUM_PAT = "numpat";
    public static final byte[] BYTES_TRUE = Protocol.toByteArray(1);
    public static final byte[] BYTES_FALSE = Protocol.toByteArray(0);
    public static final byte[] BYTES_TILDE = SafeEncoder.encode("~");
    public static final byte[] POSITIVE_INFINITY_BYTES = "+inf".getBytes();
    public static final byte[] NEGATIVE_INFINITY_BYTES = "-inf".getBytes();

    private Protocol() {
    }

    public static void sendCommand(RedisOutputStream os, ProtocolCommand command, byte[] ... args) {
        Protocol.sendCommand(os, command.getRaw(), args);
    }

    private static void sendCommand(RedisOutputStream os, byte[] command, byte[] ... args) {
        try {
            os.write((byte)42);
            os.writeIntCrLf(args.length + 1);
            os.write((byte)36);
            os.writeIntCrLf(command.length);
            os.write(command);
            os.writeCrLf();
            for (byte[] arg : args) {
                os.write((byte)36);
                os.writeIntCrLf(arg.length);
                os.write(arg);
                os.writeCrLf();
            }
        }
        catch (IOException e) {
            throw new JedisConnectionException(e);
        }
    }

    private static void processError(RedisInputStream is) {
        String message = is.readLine();
        if (message.startsWith(MOVED_PREFIX)) {
            String[] movedInfo = Protocol.parseTargetHostAndSlot(message);
            throw new JedisMovedDataException(message, new HostAndPort(movedInfo[1], Integer.parseInt(movedInfo[2])), Integer.parseInt(movedInfo[0]));
        }
        if (message.startsWith(ASK_PREFIX)) {
            String[] askInfo = Protocol.parseTargetHostAndSlot(message);
            throw new JedisAskDataException(message, new HostAndPort(askInfo[1], Integer.parseInt(askInfo[2])), Integer.parseInt(askInfo[0]));
        }
        if (message.startsWith(CLUSTERDOWN_PREFIX)) {
            throw new JedisClusterException(message);
        }
        if (message.startsWith(BUSY_PREFIX)) {
            throw new JedisBusyException(message);
        }
        if (message.startsWith(NOSCRIPT_PREFIX)) {
            throw new JedisNoScriptException(message);
        }
        if (message.startsWith(WRONGPASS_PREFIX)) {
            throw new JedisAccessControlException(message);
        }
        if (message.startsWith(NOPERM_PREFIX)) {
            throw new JedisAccessControlException(message);
        }
        throw new JedisDataException(message);
    }

    public static String readErrorLineIfPossible(RedisInputStream is) {
        byte b = is.readByte();
        if (b != 45) {
            return null;
        }
        return is.readLine();
    }

    private static String[] parseTargetHostAndSlot(String clusterRedirectResponse) {
        String[] response = new String[3];
        String[] messageInfo = clusterRedirectResponse.split(" ");
        String[] targetHostAndPort = HostAndPort.extractParts(messageInfo[2]);
        response[0] = messageInfo[1];
        response[1] = targetHostAndPort[0];
        response[2] = targetHostAndPort[1];
        return response;
    }

    private static Object process(RedisInputStream is) {
        byte b = is.readByte();
        switch (b) {
            case 43: {
                return Protocol.processStatusCodeReply(is);
            }
            case 36: {
                return Protocol.processBulkReply(is);
            }
            case 42: {
                return Protocol.processMultiBulkReply(is);
            }
            case 58: {
                return Protocol.processInteger(is);
            }
            case 45: {
                Protocol.processError(is);
                return null;
            }
        }
        throw new JedisConnectionException("Unknown reply: " + (char)b);
    }

    private static byte[] processStatusCodeReply(RedisInputStream is) {
        return is.readLineBytes();
    }

    private static byte[] processBulkReply(RedisInputStream is) {
        int size;
        int len = is.readIntCrLf();
        if (len == -1) {
            return null;
        }
        byte[] read = new byte[len];
        for (int offset = 0; offset < len; offset += size) {
            size = is.read(read, offset, len - offset);
            if (size != -1) continue;
            throw new JedisConnectionException("It seems like server has closed the connection.");
        }
        is.readByte();
        is.readByte();
        return read;
    }

    private static Long processInteger(RedisInputStream is) {
        return is.readLongCrLf();
    }

    private static List<Object> processMultiBulkReply(RedisInputStream is) {
        int num = is.readIntCrLf();
        if (num == -1) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            try {
                ret.add(Protocol.process(is));
                continue;
            }
            catch (JedisDataException e) {
                ret.add(e);
            }
        }
        return ret;
    }

    public static Object read(RedisInputStream is) {
        return Protocol.process(is);
    }

    public static final byte[] toByteArray(boolean value) {
        return value ? BYTES_TRUE : BYTES_FALSE;
    }

    public static final byte[] toByteArray(int value) {
        return SafeEncoder.encode(String.valueOf(value));
    }

    public static final byte[] toByteArray(long value) {
        return SafeEncoder.encode(String.valueOf(value));
    }

    public static final byte[] toByteArray(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY_BYTES;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_BYTES;
        }
        return SafeEncoder.encode(String.valueOf(value));
    }

    public static enum Keyword {
        AGGREGATE,
        ALPHA,
        ASC,
        BY,
        DESC,
        GET,
        LIMIT,
        MESSAGE,
        NO,
        NOSORT,
        PMESSAGE,
        PSUBSCRIBE,
        PUNSUBSCRIBE,
        OK,
        ONE,
        QUEUED,
        SET,
        STORE,
        SUBSCRIBE,
        UNSUBSCRIBE,
        WEIGHTS,
        WITHSCORES,
        RESETSTAT,
        REWRITE,
        RESET,
        FLUSH,
        EXISTS,
        LOAD,
        KILL,
        LEN,
        REFCOUNT,
        ENCODING,
        IDLETIME,
        GETNAME,
        SETNAME,
        LIST,
        MATCH,
        COUNT,
        PING,
        PONG,
        UNLOAD,
        REPLACE,
        KEYS,
        PAUSE,
        DOCTOR,
        BLOCK,
        NOACK,
        STREAMS,
        KEY,
        CREATE,
        MKSTREAM,
        SETID,
        DESTROY,
        DELCONSUMER,
        MAXLEN,
        GROUP,
        ID,
        IDLE,
        TIME,
        RETRYCOUNT,
        FORCE,
        USAGE,
        SAMPLES,
        STREAM,
        GROUPS,
        CONSUMERS,
        HELP,
        FREQ,
        SETUSER,
        GETUSER,
        DELUSER,
        WHOAMI,
        CAT,
        GENPASS,
        USERS,
        LOG,
        INCR,
        SAVE;

        @Deprecated
        public final byte[] raw = SafeEncoder.encode(this.name().toLowerCase(Locale.ENGLISH));

        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum Command implements ProtocolCommand
    {
        PING,
        SET,
        GET,
        GETDEL,
        GETEX,
        QUIT,
        EXISTS,
        DEL,
        UNLINK,
        TYPE,
        FLUSHDB,
        KEYS,
        RANDOMKEY,
        RENAME,
        RENAMENX,
        RENAMEX,
        DBSIZE,
        EXPIRE,
        EXPIREAT,
        TTL,
        SELECT,
        MOVE,
        FLUSHALL,
        GETSET,
        MGET,
        SETNX,
        SETEX,
        MSET,
        MSETNX,
        DECRBY,
        DECR,
        INCRBY,
        INCR,
        APPEND,
        SUBSTR,
        HSET,
        HGET,
        HSETNX,
        HMSET,
        HMGET,
        HINCRBY,
        HEXISTS,
        HDEL,
        HLEN,
        HKEYS,
        HVALS,
        HGETALL,
        RPUSH,
        LPUSH,
        LLEN,
        LRANGE,
        LTRIM,
        LINDEX,
        LSET,
        LREM,
        LPOP,
        RPOP,
        RPOPLPUSH,
        SADD,
        SMEMBERS,
        SREM,
        SPOP,
        SMOVE,
        SCARD,
        SISMEMBER,
        SINTER,
        SINTERSTORE,
        SUNION,
        SUNIONSTORE,
        SDIFF,
        SDIFFSTORE,
        SRANDMEMBER,
        ZADD,
        ZRANGE,
        ZREM,
        ZINCRBY,
        ZRANK,
        ZREVRANK,
        ZREVRANGE,
        ZCARD,
        ZSCORE,
        ZPOPMAX,
        ZPOPMIN,
        MULTI,
        DISCARD,
        EXEC,
        WATCH,
        UNWATCH,
        SORT,
        BLPOP,
        BRPOP,
        AUTH,
        SUBSCRIBE,
        PUBLISH,
        UNSUBSCRIBE,
        PSUBSCRIBE,
        PUNSUBSCRIBE,
        PUBSUB,
        ZCOUNT,
        ZRANGEBYSCORE,
        ZREVRANGEBYSCORE,
        ZREMRANGEBYRANK,
        ZREMRANGEBYSCORE,
        ZUNIONSTORE,
        ZINTERSTORE,
        ZLEXCOUNT,
        ZRANGEBYLEX,
        ZREVRANGEBYLEX,
        ZREMRANGEBYLEX,
        SAVE,
        BGSAVE,
        BGREWRITEAOF,
        LASTSAVE,
        SHUTDOWN,
        INFO,
        MONITOR,
        SLAVEOF,
        CONFIG,
        STRLEN,
        SYNC,
        LPUSHX,
        PERSIST,
        RPUSHX,
        ECHO,
        LINSERT,
        DEBUG,
        BRPOPLPUSH,
        SETBIT,
        GETBIT,
        BITPOS,
        SETRANGE,
        GETRANGE,
        EVAL,
        EVALSHA,
        SCRIPT,
        SLOWLOG,
        OBJECT,
        BITCOUNT,
        BITOP,
        SENTINEL,
        DUMP,
        RESTORE,
        PEXPIRE,
        PEXPIREAT,
        PTTL,
        INCRBYFLOAT,
        PSETEX,
        CLIENT,
        TIME,
        MIGRATE,
        HINCRBYFLOAT,
        SCAN,
        HSCAN,
        SSCAN,
        ZSCAN,
        WAIT,
        CLUSTER,
        ASKING,
        PFADD,
        PFCOUNT,
        PFMERGE,
        READONLY,
        GEOADD,
        GEODIST,
        GEOHASH,
        GEOPOS,
        GEORADIUS,
        GEORADIUS_RO,
        GEORADIUSBYMEMBER,
        GEORADIUSBYMEMBER_RO,
        MODULE,
        BITFIELD,
        HSTRLEN,
        TOUCH,
        SWAPDB,
        MEMORY,
        XADD,
        XLEN,
        XDEL,
        XTRIM,
        XRANGE,
        XREVRANGE,
        XREAD,
        XACK,
        XGROUP,
        XREADGROUP,
        XPENDING,
        XCLAIM,
        ACL,
        XINFO,
        BITFIELD_RO,
        LPOS,
        SMISMEMBER,
        ZMSCORE,
        BZPOPMIN,
        BZPOPMAX;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }
}

