/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.KeyedTuple;
import redis.clients.jedis.Module;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.commands.BasicRedisPipeline;
import redis.clients.jedis.commands.BinaryScriptingCommandsPipeline;
import redis.clients.jedis.commands.ClusterPipeline;
import redis.clients.jedis.commands.MultiKeyBinaryRedisPipeline;
import redis.clients.jedis.commands.MultiKeyCommandsPipeline;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.commands.ScriptingCommandsPipeline;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GeoRadiusStoreParam;
import redis.clients.jedis.params.MigrateParams;

public abstract class MultiKeyPipelineBase
extends PipelineBase
implements MultiKeyBinaryRedisPipeline,
MultiKeyCommandsPipeline,
ClusterPipeline,
BinaryScriptingCommandsPipeline,
ScriptingCommandsPipeline,
BasicRedisPipeline {
    protected Client client = null;

    @Override
    public Response<List<String>> brpop(String ... args) {
        this.client.brpop(args);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> brpop(int timeout, String ... keys) {
        this.client.brpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<String>> blpop(String ... args) {
        this.client.blpop(args);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<List<String>> blpop(int timeout, String ... keys) {
        this.client.blpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Map<String, String>> blpopMap(int timeout, String ... keys) {
        this.client.blpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    @Override
    public Response<List<byte[]>> brpop(byte[] ... args) {
        this.client.brpop(args);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    public Response<List<String>> brpop(int timeout, byte[] ... keys) {
        this.client.brpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    public Response<Map<String, String>> brpopMap(int timeout, String ... keys) {
        this.client.blpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_MAP);
    }

    @Override
    public Response<List<byte[]>> blpop(byte[] ... args) {
        this.client.blpop(args);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    public Response<List<String>> blpop(int timeout, byte[] ... keys) {
        this.client.blpop(timeout, keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<KeyedTuple> bzpopmax(int timeout, String ... keys) {
        this.client.bzpopmax(timeout, keys);
        return this.getResponse(BuilderFactory.KEYED_TUPLE);
    }

    @Override
    public Response<KeyedTuple> bzpopmin(int timeout, String ... keys) {
        this.client.bzpopmin(timeout, keys);
        return this.getResponse(BuilderFactory.KEYED_TUPLE);
    }

    @Override
    public Response<KeyedTuple> bzpopmax(int timeout, byte[] ... keys) {
        this.client.bzpopmax(timeout, keys);
        return this.getResponse(BuilderFactory.KEYED_TUPLE);
    }

    @Override
    public Response<KeyedTuple> bzpopmin(int timeout, byte[] ... keys) {
        this.client.bzpopmin(timeout, keys);
        return this.getResponse(BuilderFactory.KEYED_TUPLE);
    }

    @Override
    public Response<Long> del(String ... keys) {
        this.client.del(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> del(byte[] ... keys) {
        this.client.del(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> unlink(String ... keys) {
        this.client.unlink(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> unlink(byte[] ... keys) {
        this.client.unlink(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> exists(String ... keys) {
        this.client.exists(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> exists(byte[] ... keys) {
        this.client.exists(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> keys(String pattern) {
        this.getClient(pattern).keys(pattern);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> keys(byte[] pattern) {
        this.getClient(pattern).keys(pattern);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<List<String>> mget(String ... keys) {
        this.client.mget(keys);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<List<byte[]>> mget(byte[] ... keys) {
        this.client.mget(keys);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
    }

    @Override
    public Response<String> mset(String ... keysvalues) {
        this.client.mset(keysvalues);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> mset(byte[] ... keysvalues) {
        this.client.mset(keysvalues);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> msetnx(String ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> msetnx(byte[] ... keysvalues) {
        this.client.msetnx(keysvalues);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> rename(String oldkey, String newkey) {
        this.client.rename(oldkey, newkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> rename(byte[] oldkey, byte[] newkey) {
        this.client.rename(oldkey, newkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> renamenx(String oldkey, String newkey) {
        this.client.renamenx(oldkey, newkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> renamenx(byte[] oldkey, byte[] newkey) {
        this.client.renamenx(oldkey, newkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> rpoplpush(String srckey, String dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> rpoplpush(byte[] srckey, byte[] dstkey) {
        this.client.rpoplpush(srckey, dstkey);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<Set<String>> sdiff(String ... keys) {
        this.client.sdiff(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> sdiff(byte[] ... keys) {
        this.client.sdiff(keys);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Long> sdiffstore(String dstkey, String ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sdiffstore(byte[] dstkey, byte[] ... keys) {
        this.client.sdiffstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> sinter(String ... keys) {
        this.client.sinter(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> sinter(byte[] ... keys) {
        this.client.sinter(keys);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Long> sinterstore(String dstkey, String ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sinterstore(byte[] dstkey, byte[] ... keys) {
        this.client.sinterstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> smove(String srckey, String dstkey, String member) {
        this.client.smove(srckey, dstkey, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        this.client.smove(srckey, dstkey, member);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sort(String key, SortingParams sortingParameters, String dstkey) {
        this.client.sort(key, sortingParameters, dstkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        this.client.sort(key, sortingParameters, dstkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sort(String key, String dstkey) {
        this.client.sort(key, dstkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sort(byte[] key, byte[] dstkey) {
        this.client.sort(key, dstkey);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Set<String>> sunion(String ... keys) {
        this.client.sunion(keys);
        return this.getResponse(BuilderFactory.STRING_SET);
    }

    @Override
    public Response<Set<byte[]>> sunion(byte[] ... keys) {
        this.client.sunion(keys);
        return this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
    }

    @Override
    public Response<Long> sunionstore(String dstkey, String ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> sunionstore(byte[] dstkey, byte[] ... keys) {
        this.client.sunionstore(dstkey, keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> watch(String ... keys) {
        this.client.watch(keys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> watch(byte[] ... keys) {
        this.client.watch(keys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> unwatch() {
        this.client.unwatch();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> zinterstore(String dstkey, String ... sets) {
        this.client.zinterstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zinterstore(byte[] dstkey, byte[] ... sets) {
        this.client.zinterstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zinterstore(String dstkey, ZParams params, String ... sets) {
        this.client.zinterstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.client.zinterstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zunionstore(String dstkey, String ... sets) {
        this.client.zunionstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zunionstore(byte[] dstkey, byte[] ... sets) {
        this.client.zunionstore(dstkey, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zunionstore(String dstkey, ZParams params, String ... sets) {
        this.client.zunionstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        this.client.zunionstore(dstkey, params, sets);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> bgrewriteaof() {
        this.client.bgrewriteaof();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> bgsave() {
        this.client.bgsave();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<String>> configGet(String pattern) {
        this.client.configGet(pattern);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<String> configSet(String parameter, String value) {
        this.client.configSet(parameter, value);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> brpoplpush(String source, String destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> brpoplpush(byte[] source, byte[] destination, int timeout) {
        this.client.brpoplpush(source, destination, timeout);
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<String> configResetStat() {
        this.client.configResetStat();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> save() {
        this.client.save();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> lastsave() {
        this.client.lastsave();
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> publish(String channel, String message) {
        this.client.publish(channel, message);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> publish(byte[] channel, byte[] message) {
        this.client.publish(channel, message);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> randomKey() {
        this.client.randomKey();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<byte[]> randomKeyBinary() {
        this.client.randomKey();
        return this.getResponse(BuilderFactory.BYTE_ARRAY);
    }

    @Override
    public Response<String> flushDB() {
        this.client.flushDB();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> flushAll() {
        this.client.flushAll();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> info() {
        this.client.info();
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<String> info(String section) {
        this.client.info(section);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> dbSize() {
        this.client.dbSize();
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> shutdown() {
        this.client.shutdown();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> ping() {
        this.client.ping();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> select(int index) {
        this.client.select(index);
        Response<String> response = this.getResponse(BuilderFactory.STRING);
        this.client.setDb(index);
        return response;
    }

    @Override
    public Response<String> swapDB(int index1, int index2) {
        this.client.swapDB(index1, index2);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Long> bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        this.client.bitop(op, destKey, srcKeys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> bitop(BitOP op, String destKey, String ... srcKeys) {
        this.client.bitop(op, destKey, srcKeys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> clusterNodes() {
        this.client.clusterNodes();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterMeet(String ip, int port) {
        this.client.clusterMeet(ip, port);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterAddSlots(int ... slots) {
        this.client.clusterAddSlots(slots);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterDelSlots(int ... slots) {
        this.client.clusterDelSlots(slots);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterInfo() {
        this.client.clusterInfo();
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<String>> clusterGetKeysInSlot(int slot, int count) {
        this.client.clusterGetKeysInSlot(slot, count);
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<String> clusterSetSlotNode(int slot, String nodeId) {
        this.client.clusterSetSlotNode(slot, nodeId);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterSetSlotMigrating(int slot, String nodeId) {
        this.client.clusterSetSlotMigrating(slot, nodeId);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> clusterSetSlotImporting(int slot, String nodeId) {
        this.client.clusterSetSlotImporting(slot, nodeId);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<Object> eval(String script) {
        return this.eval(script, 0, new String[0]);
    }

    @Override
    public Response<Object> eval(String script, List<String> keys, List<String> args) {
        String[] argv = Jedis.getParams(keys, args);
        return this.eval(script, keys.size(), argv);
    }

    @Override
    public Response<Object> eval(String script, int keyCount, String ... params) {
        this.getClient(script).eval(script, keyCount, params);
        return this.getResponse(BuilderFactory.EVAL_RESULT);
    }

    @Override
    public Response<Object> evalsha(String sha1) {
        return this.evalsha(sha1, 0, new String[0]);
    }

    @Override
    public Response<Object> evalsha(String sha1, List<String> keys, List<String> args) {
        String[] argv = Jedis.getParams(keys, args);
        return this.evalsha(sha1, keys.size(), argv);
    }

    @Override
    public Response<Object> evalsha(String sha1, int keyCount, String ... params) {
        this.getClient(sha1).evalsha(sha1, keyCount, params);
        return this.getResponse(BuilderFactory.EVAL_RESULT);
    }

    @Override
    public Response<Object> eval(byte[] script) {
        return this.eval(script, 0, (byte[][])new byte[0][]);
    }

    @Override
    public Response<Object> eval(byte[] script, byte[] keyCount, byte[] ... params) {
        this.getClient(script).eval(script, keyCount, params);
        return this.getResponse(BuilderFactory.EVAL_BINARY_RESULT);
    }

    @Override
    public Response<Object> eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        byte[][] argv = BinaryJedis.getParamsWithBinary(keys, args);
        return this.eval(script, keys.size(), argv);
    }

    @Override
    public Response<Object> eval(byte[] script, int keyCount, byte[] ... params) {
        this.getClient(script).eval(script, keyCount, params);
        return this.getResponse(BuilderFactory.EVAL_BINARY_RESULT);
    }

    @Override
    public Response<Object> evalsha(byte[] sha1) {
        return this.evalsha(sha1, 0, new byte[0][]);
    }

    @Override
    public Response<Object> evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        byte[][] argv = BinaryJedis.getParamsWithBinary(keys, args);
        return this.evalsha(sha1, keys.size(), argv);
    }

    @Override
    public Response<Object> evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        this.getClient(sha1).evalsha(sha1, keyCount, params);
        return this.getResponse(BuilderFactory.EVAL_BINARY_RESULT);
    }

    @Override
    public Response<Long> pfcount(String ... keys) {
        this.client.pfcount(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> pfcount(byte[] ... keys) {
        this.client.pfcount(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        this.client.pfmerge(destkey, sourcekeys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> pfmerge(String destkey, String ... sourcekeys) {
        this.client.pfmerge(destkey, sourcekeys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<String>> time() {
        this.client.time();
        return this.getResponse(BuilderFactory.STRING_LIST);
    }

    @Override
    public Response<Long> touch(String ... keys) {
        this.client.touch(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> touch(byte[] ... keys) {
        this.client.touch(keys);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<String> moduleUnload(String name) {
        this.client.moduleUnload(name);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<List<Module>> moduleList() {
        this.client.moduleList();
        return this.getResponse(BuilderFactory.MODULE_LIST);
    }

    @Override
    public Response<String> moduleLoad(String path) {
        this.client.moduleLoad(path);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> migrate(String host, int port, int destinationDB, int timeout, MigrateParams params, String ... keys) {
        this.client.migrate(host, port, destinationDB, timeout, params, keys);
        return this.getResponse(BuilderFactory.STRING);
    }

    @Override
    public Response<String> migrate(String host, int port, int destinationDB, int timeout, MigrateParams params, byte[] ... keys) {
        this.client.migrate(host, port, destinationDB, timeout, params, keys);
        return this.getResponse(BuilderFactory.STRING);
    }

    public Response<Object> sendCommand(ProtocolCommand cmd, String ... args) {
        this.client.sendCommand(cmd, args);
        return this.getResponse(BuilderFactory.OBJECT);
    }

    public Response<Object> sendCommand(ProtocolCommand cmd, byte[] ... args) {
        this.client.sendCommand(cmd, args);
        return this.getResponse(BuilderFactory.OBJECT);
    }

    @Override
    public Response<Long> georadiusStore(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.client.georadiusStore(key, longitude, latitude, radius, unit, param, storeParam);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> georadiusStore(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.client.georadiusStore(key, longitude, latitude, radius, unit, param, storeParam);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> georadiusByMemberStore(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.client.georadiusByMemberStore(key, member, radius, unit, param, storeParam);
        return this.getResponse(BuilderFactory.LONG);
    }

    @Override
    public Response<Long> georadiusByMemberStore(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param, GeoRadiusStoreParam storeParam) {
        this.client.georadiusByMemberStore(key, member, radius, unit, param, storeParam);
        return this.getResponse(BuilderFactory.LONG);
    }
}

