/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.util.SafeEncoder;

public class KeyedTuple
extends Tuple {
    private byte[] key;

    public KeyedTuple(byte[] key, byte[] element, Double score) {
        super(element, score);
        this.key = key;
    }

    public KeyedTuple(String key, String element, Double score) {
        super(element, score);
        this.key = SafeEncoder.encode(key);
    }

    public String getKey() {
        if (null != this.key) {
            return SafeEncoder.encode(this.key);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyedTuple)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KeyedTuple that = (KeyedTuple)o;
        return Arrays.equals(this.key, that.key);
    }

    @Override
    public int hashCode() {
        return 31 * (this.key != null ? Arrays.hashCode(this.key) : 0) + super.hashCode();
    }

    @Override
    public String toString() {
        return "KeyedTuple{key=" + SafeEncoder.encode(this.key) + ", element='" + this.getElement() + "', score=" + this.getScore() + "} ";
    }
}

