/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.util.JedisURIHelper;

class JedisFactory
implements PooledObjectFactory<Jedis> {
    private static final Logger logger = LoggerFactory.getLogger(JedisFactory.class);
    private final AtomicReference<HostAndPort> hostAndPort = new AtomicReference();
    private final JedisClientConfig config;

    JedisFactory(String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this(host, port, connectionTimeout, soTimeout, password, database, clientName, false, null, null, null);
    }

    JedisFactory(String host, int port, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName) {
        this(host, port, connectionTimeout, soTimeout, 0, user, password, database, clientName);
    }

    JedisFactory(String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName) {
        this(host, port, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, database, clientName, false, null, null, null);
    }

    JedisFactory(String host, int port, int connectionTimeout, int soTimeout, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, connectionTimeout, soTimeout, null, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    JedisFactory(String host, int port, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(host, port, connectionTimeout, soTimeout, 0, user, password, database, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    JedisFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this.hostAndPort.set(hostAndPort);
        this.config = DefaultJedisClientConfig.copyConfig(clientConfig);
    }

    JedisFactory(String host, int port, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.hostAndPort.set(new HostAndPort(host, port));
        this.config = DefaultJedisClientConfig.builder().withConnectionTimeoutMillis(connectionTimeout).withSoTimeoutMillis(soTimeout).withInfiniteSoTimeoutMillis(infiniteSoTimeout).withUser(user).withPassword(password).withDatabse(database).withClientName(clientName).withSsl(ssl).withSslSocketFactory(sslSocketFactory).withSslParameters(sslParameters).withHostnameVerifier(hostnameVerifier).build();
    }

    JedisFactory(URI uri, int connectionTimeout, int soTimeout, String clientName) {
        this(uri, connectionTimeout, soTimeout, clientName, null, null, null);
    }

    JedisFactory(URI uri, int connectionTimeout, int soTimeout, String clientName, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this(uri, connectionTimeout, soTimeout, 0, clientName, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    JedisFactory(URI uri, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String clientName, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        if (!JedisURIHelper.isValid(uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI. %s", uri.toString()));
        }
        this.hostAndPort.set(new HostAndPort(uri.getHost(), uri.getPort()));
        this.config = DefaultJedisClientConfig.builder().withConnectionTimeoutMillis(connectionTimeout).withSoTimeoutMillis(soTimeout).withInfiniteSoTimeoutMillis(infiniteSoTimeout).withUser(JedisURIHelper.getUser(uri)).withPassword(JedisURIHelper.getPassword(uri)).withDatabse(JedisURIHelper.getDBIndex(uri)).withClientName(clientName).withSsl(JedisURIHelper.isRedisSSLScheme(uri)).withSslSocketFactory(sslSocketFactory).withSslParameters(sslParameters).withHostnameVerifier(hostnameVerifier).build();
    }

    public void setHostAndPort(HostAndPort hostAndPort) {
        this.hostAndPort.set(hostAndPort);
    }

    public void activateObject(PooledObject<Jedis> pooledJedis) throws Exception {
        BinaryJedis jedis = (BinaryJedis)pooledJedis.getObject();
        if (jedis.getDB() != this.config.getDatabase()) {
            jedis.select(this.config.getDatabase());
        }
    }

    public void destroyObject(PooledObject<Jedis> pooledJedis) throws Exception {
        BinaryJedis jedis = (BinaryJedis)pooledJedis.getObject();
        if (jedis.isConnected()) {
            try {
                if (!jedis.isBroken()) {
                    jedis.quit();
                }
            }
            catch (Exception e) {
                logger.warn("Error while QUIT", (Throwable)e);
            }
            try {
                jedis.close();
            }
            catch (Exception e) {
                logger.warn("Error while close", (Throwable)e);
            }
        }
    }

    public PooledObject<Jedis> makeObject() throws Exception {
        HostAndPort hostPort = this.hostAndPort.get();
        Jedis jedis = null;
        try {
            jedis = new Jedis(hostPort, this.config);
            jedis.connect();
            return new DefaultPooledObject((Object)jedis);
        }
        catch (JedisException je) {
            if (jedis != null) {
                try {
                    jedis.quit();
                }
                catch (Exception e) {
                    logger.warn("Error while QUIT", (Throwable)e);
                }
                try {
                    jedis.close();
                }
                catch (Exception e) {
                    logger.warn("Error while close", (Throwable)e);
                }
            }
            throw je;
        }
    }

    public void passivateObject(PooledObject<Jedis> pooledJedis) throws Exception {
    }

    public boolean validateObject(PooledObject<Jedis> pooledJedis) {
        BinaryJedis jedis = (BinaryJedis)pooledJedis.getObject();
        try {
            HostAndPort hostAndPort = this.hostAndPort.get();
            String connectionHost = jedis.getClient().getHost();
            int connectionPort = jedis.getClient().getPort();
            return hostAndPort.getHost().equals(connectionHost) && hostAndPort.getPort() == connectionPort && jedis.isConnected() && jedis.ping().equals("PONG");
        }
        catch (Exception e) {
            return false;
        }
    }
}

