/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.Closeable;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisClusterHostAndPortMap;
import redis.clients.jedis.JedisClusterInfoCache;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

public abstract class JedisClusterConnectionHandler
implements Closeable {
    protected final JedisClusterInfoCache cache;

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, password, null);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, null, password, clientName);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, 0, user, password, clientName);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, infiniteSoTimeout, user, password, clientName, false, null, null, null, null);
    }

    @Deprecated
    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, null, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, portMap);
    }

    @Deprecated
    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, 0, user, password, clientName, ssl, sslSocketFactory, sslParameters, hostnameVerifier, portMap);
    }

    @Deprecated
    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, int connectionTimeout, int soTimeout, int infiniteSoTimeout, String user, String password, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, JedisClusterHostAndPortMap portMap) {
        this(nodes, DefaultJedisClientConfig.builder().withConnectionTimeoutMillis(connectionTimeout).withSoTimeoutMillis(soTimeout).withInfiniteSoTimeoutMillis(infiniteSoTimeout).withUser(user).withPassword(password).withClientName(clientName).withSsl(ssl).withSslSocketFactory(sslSocketFactory).withSslParameters(sslParameters).withHostnameVerifier(hostnameVerifier).build(), poolConfig, DefaultJedisClientConfig.builder().withConnectionTimeoutMillis(connectionTimeout).withSoTimeoutMillis(soTimeout).withInfiniteSoTimeoutMillis(infiniteSoTimeout).withUser(user).withPassword(password).withClientName(clientName).withSsl(ssl).withSslSocketFactory(sslSocketFactory).withSslParameters(sslParameters).withHostnameVerifier(hostnameVerifier).withHostAndPortMapper(portMap).build());
    }

    @Deprecated
    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, JedisClientConfig seedNodesClientConfig, GenericObjectPoolConfig<Jedis> poolConfig, JedisClientConfig clusterNodesClientConfig) {
        this.cache = new JedisClusterInfoCache(poolConfig, clusterNodesClientConfig);
        this.initializeSlotsCache(nodes, seedNodesClientConfig);
    }

    public JedisClusterConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig<Jedis> poolConfig, JedisClientConfig clientConfig) {
        this.cache = new JedisClusterInfoCache(poolConfig, clientConfig);
        this.initializeSlotsCache(nodes, clientConfig);
    }

    protected abstract Jedis getConnection();

    protected abstract Jedis getConnectionFromSlot(int var1);

    public Jedis getConnectionFromNode(HostAndPort node) {
        return this.cache.setupNodeIfNotExist(node).getResource();
    }

    public Map<String, JedisPool> getNodes() {
        return this.cache.getNodes();
    }

    private void initializeSlotsCache(Set<HostAndPort> startNodes, JedisClientConfig clientConfig) {
        for (HostAndPort hostAndPort : startNodes) {
            try (Jedis jedis = new Jedis(hostAndPort, clientConfig);){
                this.cache.discoverClusterNodesAndSlots(jedis);
                return;
            }
            catch (JedisConnectionException jedisConnectionException) {
            }
        }
    }

    public void renewSlotCache() {
        this.cache.renewClusterSlots(null);
    }

    public void renewSlotCache(Jedis jedis) {
        this.cache.renewClusterSlots(jedis);
    }

    @Override
    public void close() {
        this.cache.reset();
    }
}

