/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.HostAndPortMapper;
import redis.clients.jedis.JedisClientConfig;

public final class DefaultJedisClientConfig
implements JedisClientConfig {
    private final int connectionTimeoutMillis;
    private final int soTimeoutMillis;
    private final int infiniteSoTimeoutMillis;
    private final String user;
    private final String password;
    private final int database;
    private final String clientName;
    private final boolean ssl;
    private final SSLSocketFactory sslSocketFactory;
    private final SSLParameters sslParameters;
    private final HostnameVerifier hostnameVerifier;
    private final HostAndPortMapper hostAndPortMapper;

    private DefaultJedisClientConfig(int connectionTimeoutMillis, int soTimeoutMillis, int infiniteSoTimeoutMillis, String user, String password, int database, String clientName, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier, HostAndPortMapper hostAndPortMapper) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        this.soTimeoutMillis = soTimeoutMillis;
        this.infiniteSoTimeoutMillis = infiniteSoTimeoutMillis;
        this.user = user;
        this.password = password;
        this.database = database;
        this.clientName = clientName;
        this.ssl = ssl;
        this.sslSocketFactory = sslSocketFactory;
        this.sslParameters = sslParameters;
        this.hostnameVerifier = hostnameVerifier;
        this.hostAndPortMapper = hostAndPortMapper;
    }

    @Override
    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Override
    public int getSoTimeoutMillis() {
        return this.soTimeoutMillis;
    }

    @Override
    public int getInfiniteSoTimeoutMillis() {
        return this.infiniteSoTimeoutMillis;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getDatabase() {
        return this.database;
    }

    @Override
    public String getClientName() {
        return this.clientName;
    }

    @Override
    public boolean isSsl() {
        return this.ssl;
    }

    @Override
    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public SSLParameters getSslParameters() {
        return this.sslParameters;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    @Override
    public HostAndPortMapper getHostAndPortMapper() {
        return this.hostAndPortMapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static DefaultJedisClientConfig copyConfig(JedisClientConfig copy) {
        return new DefaultJedisClientConfig(copy.getConnectionTimeoutMillis(), copy.getSoTimeoutMillis(), copy.getInfiniteSoTimeoutMillis(), copy.getUser(), copy.getPassword(), copy.getDatabase(), copy.getClientName(), copy.isSsl(), copy.getSslSocketFactory(), copy.getSslParameters(), copy.getHostnameVerifier(), copy.getHostAndPortMapper());
    }

    public static class Builder {
        private int connectionTimeoutMillis = 2000;
        private int soTimeoutMillis = 2000;
        private int infiniteSoTimeoutMillis = 0;
        private String user = null;
        private String password = null;
        private int databse = 0;
        private String clientName = null;
        private boolean ssl = false;
        private SSLSocketFactory sslSocketFactory = null;
        private SSLParameters sslParameters = null;
        private HostnameVerifier hostnameVerifier = null;
        private HostAndPortMapper hostAndPortMapper = null;

        private Builder() {
        }

        public DefaultJedisClientConfig build() {
            return new DefaultJedisClientConfig(this.connectionTimeoutMillis, this.soTimeoutMillis, this.infiniteSoTimeoutMillis, this.user, this.password, this.databse, this.clientName, this.ssl, this.sslSocketFactory, this.sslParameters, this.hostnameVerifier, this.hostAndPortMapper);
        }

        public Builder withConnectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder withSoTimeoutMillis(int soTimeoutMillis) {
            this.soTimeoutMillis = soTimeoutMillis;
            return this;
        }

        public Builder withInfiniteSoTimeoutMillis(int infiniteSoTimeoutMillis) {
            this.infiniteSoTimeoutMillis = infiniteSoTimeoutMillis;
            return this;
        }

        public Builder withUser(String user) {
            this.user = user;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withDatabse(int databse) {
            this.databse = databse;
            return this;
        }

        public Builder withClientName(String clientName) {
            this.clientName = clientName;
            return this;
        }

        public Builder withSsl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder withSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder withSslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
            return this;
        }

        public Builder withHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder withHostAndPortMapper(HostAndPortMapper hostAndPortMapper) {
            this.hostAndPortMapper = hostAndPortMapper;
            return this;
        }
    }
}

