/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.ShardedJedisPipeline;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.commands.BinaryJedisCommands;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.util.Hashing;
import redis.clients.jedis.util.Sharded;

public class BinaryShardedJedis
extends Sharded<Jedis, JedisShardInfo>
implements BinaryJedisCommands {
    private static final Logger logger = LoggerFactory.getLogger(BinaryShardedJedis.class);
    private final byte[][] dummyArray = new byte[0][];

    public BinaryShardedJedis(List<JedisShardInfo> shards) {
        super(shards);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Hashing algo) {
        super(shards, algo);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Pattern keyTagPattern) {
        super(shards, keyTagPattern);
    }

    public BinaryShardedJedis(List<JedisShardInfo> shards, Hashing algo, Pattern keyTagPattern) {
        super(shards, algo, keyTagPattern);
    }

    public void disconnect() {
        for (Jedis jedis : this.getAllShards()) {
            if (!jedis.isConnected()) continue;
            try {
                if (!jedis.isBroken()) {
                    jedis.quit();
                }
            }
            catch (JedisConnectionException e) {
                logger.warn("Error while QUIT", (Throwable)e);
            }
            try {
                jedis.disconnect();
            }
            catch (JedisConnectionException e) {
                logger.warn("Error while disconnect", (Throwable)e);
            }
        }
    }

    protected Jedis create(JedisShardInfo shard) {
        return new Jedis(shard);
    }

    @Override
    public String set(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value);
    }

    @Override
    public String set(byte[] key, byte[] value, SetParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.set(key, value, params);
    }

    @Override
    public byte[] get(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.get(key);
    }

    @Override
    public byte[] getDel(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getDel(key);
    }

    @Override
    public byte[] getEx(byte[] key, GetExParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getEx(key, params);
    }

    @Override
    public Boolean exists(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.exists(key);
    }

    @Override
    public String type(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.type(key);
    }

    @Override
    public byte[] dump(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.dump(key);
    }

    @Override
    public String restore(byte[] key, long ttl, byte[] serializedValue) {
        Jedis j = (Jedis)this.getShard(key);
        return j.restore(key, ttl, serializedValue);
    }

    @Override
    public String restoreReplace(byte[] key, long ttl, byte[] serializedValue) {
        Jedis j = (Jedis)this.getShard(key);
        return j.restoreReplace(key, ttl, serializedValue);
    }

    @Override
    public Long expire(byte[] key, long seconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expire(key, seconds);
    }

    @Override
    public Long pexpire(byte[] key, long milliseconds) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpire(key, milliseconds);
    }

    @Override
    public Long expireAt(byte[] key, long unixTime) {
        Jedis j = (Jedis)this.getShard(key);
        return j.expireAt(key, unixTime);
    }

    @Override
    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pexpireAt(key, millisecondsTimestamp);
    }

    @Override
    public Long ttl(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ttl(key);
    }

    @Override
    public Long pttl(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pttl(key);
    }

    @Override
    public Long touch(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.touch(key);
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getSet(key, value);
    }

    @Override
    public Long setnx(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setnx(key, value);
    }

    @Override
    public String setex(byte[] key, long seconds, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setex(key, seconds, value);
    }

    @Override
    public String psetex(byte[] key, long milliseconds, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.psetex(key, milliseconds, value);
    }

    @Override
    public Long decrBy(byte[] key, long decrement) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decrBy(key, decrement);
    }

    @Override
    public Long decr(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.decr(key);
    }

    @Override
    public Long del(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.del(key);
    }

    @Override
    public Long unlink(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.unlink(key);
    }

    @Override
    public Long incrBy(byte[] key, long increment) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrBy(key, increment);
    }

    @Override
    public Double incrByFloat(byte[] key, double increment) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incrByFloat(key, increment);
    }

    @Override
    public Long incr(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.incr(key);
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.append(key, value);
    }

    @Override
    public byte[] substr(byte[] key, int start, int end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.substr(key, start, end);
    }

    @Override
    public Long hset(byte[] key, byte[] field, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, field, value);
    }

    @Override
    public Long hset(byte[] key, Map<byte[], byte[]> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hset(key, hash);
    }

    @Override
    public byte[] hget(byte[] key, byte[] field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hget(key, field);
    }

    @Override
    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hsetnx(key, field, value);
    }

    @Override
    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmset(key, hash);
    }

    @Override
    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hmget(key, fields);
    }

    @Override
    public Long hincrBy(byte[] key, byte[] field, long value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrBy(key, field, value);
    }

    @Override
    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hincrByFloat(key, field, value);
    }

    @Override
    public Boolean hexists(byte[] key, byte[] field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hexists(key, field);
    }

    @Override
    public Long hdel(byte[] key, byte[] ... fields) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hdel(key, fields);
    }

    @Override
    public Long hlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hlen(key);
    }

    @Override
    public Set<byte[]> hkeys(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hkeys(key);
    }

    @Override
    public List<byte[]> hvals(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hvals(key);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hgetAll(key);
    }

    @Override
    public Long rpush(byte[] key, byte[] ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpush(key, strings);
    }

    @Override
    public Long lpush(byte[] key, byte[] ... strings) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpush(key, strings);
    }

    @Override
    public Long strlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.strlen(key);
    }

    @Override
    public Long lpushx(byte[] key, byte[] ... string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpushx(key, string);
    }

    @Override
    public Long persist(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.persist(key);
    }

    @Override
    public Long rpushx(byte[] key, byte[] ... string) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpushx(key, string);
    }

    @Override
    public Long llen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.llen(key);
    }

    @Override
    public List<byte[]> lrange(byte[] key, long start, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrange(key, start, stop);
    }

    @Override
    public String ltrim(byte[] key, long start, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.ltrim(key, start, stop);
    }

    @Override
    public byte[] lindex(byte[] key, long index) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lindex(key, index);
    }

    @Override
    public String lset(byte[] key, long index, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lset(key, index, value);
    }

    @Override
    public Long lrem(byte[] key, long count, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lrem(key, count, value);
    }

    @Override
    public byte[] lpop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpop(key);
    }

    @Override
    public List<byte[]> lpop(byte[] key, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpop(key, count);
    }

    @Override
    public Long lpos(byte[] key, byte[] element) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpos(key, element);
    }

    @Override
    public Long lpos(byte[] key, byte[] element, LPosParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpos(key, element, params);
    }

    @Override
    public List<Long> lpos(byte[] key, byte[] element, LPosParams params, long count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.lpos(key, element, params, count);
    }

    @Override
    public byte[] rpop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpop(key);
    }

    @Override
    public List<byte[]> rpop(byte[] key, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.rpop(key, count);
    }

    @Override
    public Long sadd(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sadd(key, members);
    }

    @Override
    public Set<byte[]> smembers(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.smembers(key);
    }

    @Override
    public Long srem(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srem(key, members);
    }

    @Override
    public byte[] spop(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key);
    }

    @Override
    public Set<byte[]> spop(byte[] key, long count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.spop(key, count);
    }

    @Override
    public Long scard(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.scard(key);
    }

    @Override
    public Boolean sismember(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sismember(key, member);
    }

    @Override
    public List<Boolean> smismember(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.smismember(key, members);
    }

    @Override
    public byte[] srandmember(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key);
    }

    @Override
    public List<byte[]> srandmember(byte[] key, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.srandmember(key, count);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member);
    }

    @Override
    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, score, member, params);
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers);
    }

    @Override
    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zadd(key, scoreMembers, params);
    }

    @Override
    public Double zaddIncr(byte[] key, double score, byte[] member, ZAddParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zaddIncr(key, score, member, params);
    }

    @Override
    public Set<byte[]> zrange(byte[] key, long start, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrange(key, start, stop);
    }

    @Override
    public Long zrem(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrem(key, members);
    }

    @Override
    public Double zincrby(byte[] key, double increment, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, increment, member);
    }

    @Override
    public Double zincrby(byte[] key, double increment, byte[] member, ZIncrByParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zincrby(key, increment, member, params);
    }

    @Override
    public Long zrank(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrank(key, member);
    }

    @Override
    public Long zrevrank(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrank(key, member);
    }

    @Override
    public Set<byte[]> zrevrange(byte[] key, long start, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrange(key, start, stop);
    }

    @Override
    public Set<Tuple> zrangeWithScores(byte[] key, long start, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeWithScores(key, start, stop);
    }

    @Override
    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeWithScores(key, start, stop);
    }

    @Override
    public Long zcard(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcard(key);
    }

    @Override
    public Double zscore(byte[] key, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscore(key, member);
    }

    @Override
    public List<Double> zmscore(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zmscore(key, members);
    }

    @Override
    public Tuple zpopmax(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zpopmax(key);
    }

    @Override
    public Set<Tuple> zpopmax(byte[] key, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zpopmax(key, count);
    }

    @Override
    public Tuple zpopmin(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zpopmin(key);
    }

    @Override
    public Set<Tuple> zpopmin(byte[] key, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zpopmin(key, count);
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key);
    }

    @Override
    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sort(key, sortingParameters);
    }

    @Override
    public Long zcount(byte[] key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min, max);
    }

    @Override
    public Long zcount(byte[] key, byte[] min, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zcount(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max);
    }

    @Override
    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByScore(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min);
    }

    @Override
    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScore(key, max, min, offset, count);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min);
    }

    @Override
    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    @Override
    public Long zremrangeByRank(byte[] key, long start, long stop) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByRank(key, start, stop);
    }

    @Override
    public Long zremrangeByScore(byte[] key, double min, double max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, min, max);
    }

    @Override
    public Long zremrangeByScore(byte[] key, byte[] min, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByScore(key, min, max);
    }

    @Override
    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zlexcount(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByLex(key, min, max);
    }

    @Override
    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrangeByLex(key, min, max, offset, count);
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByLex(key, max, min);
    }

    @Override
    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zrevrangeByLex(key, max, min, offset, count);
    }

    @Override
    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zremrangeByLex(key, min, max);
    }

    @Override
    public Long linsert(byte[] key, ListPosition where, byte[] pivot, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.linsert(key, where, pivot, value);
    }

    public ShardedJedisPipeline pipelined() {
        ShardedJedisPipeline pipeline = new ShardedJedisPipeline();
        pipeline.setShardedJedis(this);
        return pipeline;
    }

    public Long objectRefcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectRefcount(key);
    }

    public byte[] objectEncoding(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectEncoding(key);
    }

    public Long objectIdletime(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectIdletime(key);
    }

    public List<String> objectHelp() {
        Jedis j = (Jedis)this.getShard("null");
        return j.objectHelp();
    }

    public Long objectFreq(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.objectIdletime(key);
    }

    @Override
    public Boolean setbit(byte[] key, long offset, boolean value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value);
    }

    @Override
    public Boolean setbit(byte[] key, long offset, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setbit(key, offset, value);
    }

    @Override
    public Boolean getbit(byte[] key, long offset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getbit(key, offset);
    }

    @Override
    public Long setrange(byte[] key, long offset, byte[] value) {
        Jedis j = (Jedis)this.getShard(key);
        return j.setrange(key, offset, value);
    }

    @Override
    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        Jedis j = (Jedis)this.getShard(key);
        return j.getrange(key, startOffset, endOffset);
    }

    @Override
    public Long move(byte[] key, int dbIndex) {
        Jedis j = (Jedis)this.getShard(key);
        return j.move(key, dbIndex);
    }

    @Override
    public byte[] echo(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.echo(arg);
    }

    public List<byte[]> brpop(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.brpop(new byte[][]{arg});
    }

    public List<byte[]> blpop(byte[] arg) {
        Jedis j = (Jedis)this.getShard(arg);
        return j.blpop(new byte[][]{arg});
    }

    @Override
    public Long bitcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key);
    }

    @Override
    public Long bitcount(byte[] key, long start, long end) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitcount(key, start, end);
    }

    @Override
    public Long pfadd(byte[] key, byte[] ... elements) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfadd(key, elements);
    }

    @Override
    public long pfcount(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.pfcount(key);
    }

    @Override
    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, longitude, latitude, member);
    }

    @Override
    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, memberCoordinateMap);
    }

    @Override
    public Long geoadd(byte[] key, GeoAddParams params, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geoadd(key, params, memberCoordinateMap);
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2);
    }

    @Override
    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geodist(key, member1, member2, unit);
    }

    @Override
    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geohash(key, members);
    }

    @Override
    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        Jedis j = (Jedis)this.getShard(key);
        return j.geopos(key, members);
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusReadonly(key, longitude, latitude, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadius(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> georadiusReadonly(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusReadonly(key, longitude, latitude, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMemberReadonly(key, member, radius, unit);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMember(key, member, radius, unit, param);
    }

    @Override
    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        Jedis j = (Jedis)this.getShard(key);
        return j.georadiusByMemberReadonly(key, member, radius, unit, param);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, cursor);
    }

    @Override
    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hscan(key, cursor, params);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, cursor);
    }

    @Override
    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.sscan(key, cursor, params);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, cursor);
    }

    @Override
    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        Jedis j = (Jedis)this.getShard(key);
        return j.zscan(key, cursor, params);
    }

    @Override
    public List<Long> bitfield(byte[] key, byte[] ... arguments) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitfield(key, arguments);
    }

    @Override
    public List<Long> bitfieldReadonly(byte[] key, byte[] ... arguments) {
        Jedis j = (Jedis)this.getShard(key);
        return j.bitfieldReadonly(key, arguments);
    }

    @Override
    public Long hstrlen(byte[] key, byte[] field) {
        Jedis j = (Jedis)this.getShard(key);
        return j.hstrlen(key, field);
    }

    @Override
    public byte[] xadd(byte[] key, byte[] id, Map<byte[], byte[]> hash, long maxLen, boolean approximateLength) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xadd(key, id, hash, maxLen, approximateLength);
    }

    @Override
    public Long xlen(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xlen(key);
    }

    @Override
    public List<byte[]> xrange(byte[] key, byte[] start, byte[] end, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xrange(key, start, end, count);
    }

    @Override
    public List<byte[]> xrevrange(byte[] key, byte[] end, byte[] start, int count) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xrevrange(key, end, start, count);
    }

    @Override
    public Long xack(byte[] key, byte[] group, byte[] ... ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xack(key, group, ids);
    }

    @Override
    public String xgroupCreate(byte[] key, byte[] consumer, byte[] id, boolean makeStream) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupCreate(key, consumer, id, makeStream);
    }

    @Override
    public String xgroupSetID(byte[] key, byte[] consumer, byte[] id) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupSetID(key, consumer, id);
    }

    @Override
    public Long xgroupDestroy(byte[] key, byte[] consumer) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupDestroy(key, consumer);
    }

    @Override
    public Long xgroupDelConsumer(byte[] key, byte[] consumer, byte[] consumerName) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xgroupDelConsumer(key, consumer, consumerName);
    }

    @Override
    public Long xdel(byte[] key, byte[] ... ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xdel(key, ids);
    }

    @Override
    public Long xtrim(byte[] key, long maxLen, boolean approximateLength) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xtrim(key, maxLen, approximateLength);
    }

    @Override
    public List<Object> xpending(byte[] key, byte[] groupname, byte[] start, byte[] end, int count, byte[] consumername) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xpending(key, groupname, start, end, count, consumername);
    }

    @Override
    public Object xpendingSummary(byte[] key, byte[] groupname) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xpendingSummary(key, groupname);
    }

    @Override
    public List<byte[]> xclaim(byte[] key, byte[] groupname, byte[] consumername, long minIdleTime, long newIdleTime, int retries, boolean force, byte[] ... ids) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xclaim(key, groupname, consumername, minIdleTime, newIdleTime, retries, force, ids);
    }

    @Override
    public StreamInfo xinfoStream(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xinfoStream(key);
    }

    @Override
    public Object xinfoStreamBinary(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xinfoStreamBinary(key);
    }

    @Override
    public List<StreamGroupInfo> xinfoGroup(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xinfoGroup(key);
    }

    @Override
    public List<Object> xinfoGroupBinary(byte[] key) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xinfoGroupBinary(key);
    }

    @Override
    public List<StreamConsumersInfo> xinfoConsumers(byte[] key, byte[] group) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xinfoConsumers(key, group);
    }

    @Override
    public List<Object> xinfoConsumersBinary(byte[] key, byte[] group) {
        Jedis j = (Jedis)this.getShard(key);
        return j.xinfoConsumersBinary(key, group);
    }

    public Object sendCommand(ProtocolCommand cmd, byte[] ... args) {
        byte[] sampleKey = args.length > 0 ? args[0] : cmd.getRaw();
        Jedis j = (Jedis)this.getShard(sampleKey);
        return j.sendCommand(cmd, args);
    }

    public Object sendBlockingCommand(ProtocolCommand cmd, byte[] ... args) {
        byte[] sampleKey = args.length > 0 ? args[0] : cmd.getRaw();
        Jedis j = (Jedis)this.getShard(sampleKey);
        return j.sendBlockingCommand(cmd, args);
    }

    public Object sendCommand(ProtocolCommand cmd) {
        return this.sendCommand(cmd, this.dummyArray);
    }
}

