/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClusterConnectionHandler;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisClusterMaxAttemptsException;
import redis.clients.jedis.exceptions.JedisClusterOperationException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.exceptions.JedisNoReachableClusterNodeException;
import redis.clients.jedis.exceptions.JedisRedirectionException;
import redis.clients.jedis.util.JedisClusterCRC16;

public abstract class JedisClusterCommand<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JedisClusterCommand.class);
    private final JedisClusterConnectionHandler connectionHandler;
    private final int maxAttempts;

    public JedisClusterCommand(JedisClusterConnectionHandler connectionHandler, int maxAttempts) {
        this.connectionHandler = connectionHandler;
        this.maxAttempts = maxAttempts;
    }

    public abstract T execute(Jedis var1);

    public T run(String key) {
        return this.runWithRetries(JedisClusterCRC16.getSlot(key));
    }

    public T run(int keyCount, String ... keys) {
        if (keys == null || keys.length == 0) {
            throw new JedisClusterOperationException("No way to dispatch this command to Redis Cluster.");
        }
        int slot = JedisClusterCRC16.getSlot(keys[0]);
        if (keys.length > 1) {
            for (int i = 1; i < keyCount; ++i) {
                int nextSlot = JedisClusterCRC16.getSlot(keys[i]);
                if (slot == nextSlot) continue;
                throw new JedisClusterOperationException("No way to dispatch this command to Redis Cluster because keys have different slots.");
            }
        }
        return this.runWithRetries(slot);
    }

    public T runBinary(byte[] key) {
        return this.runWithRetries(JedisClusterCRC16.getSlot(key));
    }

    public T runBinary(int keyCount, byte[] ... keys) {
        if (keys == null || keys.length == 0) {
            throw new JedisClusterOperationException("No way to dispatch this command to Redis Cluster.");
        }
        int slot = JedisClusterCRC16.getSlot(keys[0]);
        if (keys.length > 1) {
            for (int i = 1; i < keyCount; ++i) {
                int nextSlot = JedisClusterCRC16.getSlot(keys[i]);
                if (slot == nextSlot) continue;
                throw new JedisClusterOperationException("No way to dispatch this command to Redis Cluster because keys have different slots.");
            }
        }
        return this.runWithRetries(slot);
    }

    public T runWithAnyNode() {
        Jedis connection = null;
        try {
            connection = this.connectionHandler.getConnection();
            T t = this.execute(connection);
            return t;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T runWithRetries(int slot) {
        JedisRedirectionException redirect = null;
        JedisException lastException = null;
        int attemptsLeft = this.maxAttempts;
        while (true) {
            T t;
            if (attemptsLeft <= 0) {
                JedisClusterMaxAttemptsException maxAttemptsException = new JedisClusterMaxAttemptsException("No more cluster attempts left.");
                maxAttemptsException.addSuppressed(lastException);
                throw maxAttemptsException;
            }
            Jedis connection = null;
            try {
                if (redirect != null) {
                    connection = this.connectionHandler.getConnectionFromNode(redirect.getTargetNode());
                    if (redirect instanceof JedisAskDataException) {
                        connection.asking();
                    }
                } else {
                    connection = this.connectionHandler.getConnectionFromSlot(slot);
                }
                t = this.execute(connection);
            }
            catch (JedisNoReachableClusterNodeException jnrcne) {
                throw jnrcne;
                catch (JedisConnectionException jce) {
                    lastException = jce;
                    LOG.debug("Failed connecting to Redis: {}", (Object)connection, (Object)jce);
                    this.handleConnectionProblem(attemptsLeft - 1);
                    this.releaseConnection(connection);
                }
                catch (JedisRedirectionException jre) {
                    try {
                        if (lastException == null || lastException instanceof JedisRedirectionException) {
                            lastException = jre;
                        }
                        LOG.debug("Redirected by server to {}", (Object)jre.getTargetNode());
                        redirect = jre;
                        if (jre instanceof JedisMovedDataException) {
                            this.connectionHandler.renewSlotCache(connection);
                        }
                        this.releaseConnection(connection);
                    }
                    catch (Throwable throwable) {
                        this.releaseConnection(connection);
                        throw throwable;
                    }
                }
            }
            this.releaseConnection(connection);
            return t;
            --attemptsLeft;
        }
    }

    private void handleConnectionProblem(int attemptsLeft) {
        if (attemptsLeft <= 1) {
            this.connectionHandler.renewSlotCache();
        }
    }

    private void releaseConnection(Jedis connection) {
        if (connection != null) {
            connection.close();
        }
    }
}

