/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisFactory;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;

public class JedisSentinelPool
extends JedisPoolAbstract {
    protected GenericObjectPoolConfig poolConfig;
    protected int connectionTimeout;
    protected int soTimeout;
    protected String password;
    protected String user;
    protected int database;
    protected String clientName;
    protected int sentinelConnectionTimeout;
    protected int sentinelSoTimeout;
    protected String sentinelPassword;
    protected String sentinelClientName;
    protected final Set<MasterListener> masterListeners = new HashSet<MasterListener>();
    protected final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private volatile JedisFactory factory;
    private volatile HostAndPort currentHostMaster;
    private final Object initPoolLock = new Object();

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig) {
        this(masterName, sentinels, poolConfig, 2000, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels) {
        this(masterName, sentinels, new GenericObjectPoolConfig(), 2000, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, String password) {
        this(masterName, sentinels, new GenericObjectPoolConfig(), 2000, password);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password) {
        this(masterName, sentinels, poolConfig, timeout, password, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout) {
        this(masterName, sentinels, poolConfig, timeout, null, 0);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, String password) {
        this(masterName, sentinels, poolConfig, 2000, password);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database) {
        this(masterName, sentinels, poolConfig, timeout, timeout, null, password, database);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String user, String password, int database) {
        this(masterName, sentinels, poolConfig, timeout, timeout, user, password, database);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, timeout, timeout, null, password, database, clientName, 2000, 2000, null, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int timeout, String user, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, timeout, timeout, user, password, database, clientName, 2000, 2000, null, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, null, password, database, null, 2000, 2000, null, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String user, String password, int database) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, user, password, database, null, 2000, 2000, null, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password, int database, String clientName) {
        this(masterName, sentinels, poolConfig, connectionTimeout, soTimeout, null, password, database, clientName, 2000, 2000, null, null);
    }

    public JedisSentinelPool(String masterName, Set<String> sentinels, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String user, String password, int database, String clientName, int sentinelConnectionTimeout, int sentinelSoTimeout, String sentinelPassword, String sentinelClientName) {
        this.poolConfig = poolConfig;
        this.connectionTimeout = connectionTimeout;
        this.soTimeout = soTimeout;
        this.user = user;
        this.password = password;
        this.database = database;
        this.clientName = clientName;
        this.sentinelConnectionTimeout = sentinelConnectionTimeout;
        this.sentinelSoTimeout = sentinelSoTimeout;
        this.sentinelPassword = sentinelPassword;
        this.sentinelClientName = sentinelClientName;
        HostAndPort master = this.initSentinels(sentinels, masterName);
        this.initPool(master);
    }

    @Override
    public void destroy() {
        for (MasterListener m : this.masterListeners) {
            m.shutdown();
        }
        super.destroy();
    }

    public HostAndPort getCurrentHostMaster() {
        return this.currentHostMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initPool(HostAndPort master) {
        Object object = this.initPoolLock;
        synchronized (object) {
            if (!master.equals(this.currentHostMaster)) {
                this.currentHostMaster = master;
                if (this.factory == null) {
                    this.factory = new JedisFactory(master.getHost(), master.getPort(), this.connectionTimeout, this.soTimeout, this.password, this.database, this.clientName);
                    this.initPool(this.poolConfig, this.factory);
                } else {
                    this.factory.setHostAndPort(this.currentHostMaster);
                    this.internalPool.clear();
                }
                this.log.info("Created JedisPool to master at {}", (Object)master);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostAndPort initSentinels(Set<String> sentinels, String masterName) {
        HostAndPort hap;
        HostAndPort master = null;
        boolean sentinelAvailable = false;
        this.log.info("Trying to find master from available Sentinels...");
        for (String sentinel : sentinels) {
            hap = HostAndPort.parseString(sentinel);
            this.log.debug("Connecting to Sentinel {}", (Object)hap);
            Jedis jedis = null;
            try {
                jedis = new Jedis(hap.getHost(), hap.getPort(), this.sentinelConnectionTimeout, this.sentinelSoTimeout);
                if (this.sentinelPassword != null) {
                    jedis.auth(this.sentinelPassword);
                }
                if (this.sentinelClientName != null) {
                    jedis.clientSetname(this.sentinelClientName);
                }
                List<String> masterAddr = jedis.sentinelGetMasterAddrByName(masterName);
                sentinelAvailable = true;
                if (masterAddr == null || masterAddr.size() != 2) {
                    this.log.warn("Can not get master addr, master name: {}. Sentinel: {}", (Object)masterName, (Object)hap);
                    continue;
                }
                master = this.toHostAndPort(masterAddr);
                this.log.debug("Found Redis master at {}", (Object)master);
                break;
            }
            catch (JedisException e) {
                this.log.warn("Cannot get master address from sentinel running @ {}. Reason: {}. Trying next one.", (Object)hap, (Object)e);
            }
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        if (master == null) {
            if (sentinelAvailable) {
                throw new JedisException("Can connect to sentinel, but " + masterName + " seems to be not monitored...");
            }
            throw new JedisConnectionException("All sentinels down, cannot determine where is " + masterName + " master is running...");
        }
        this.log.info("Redis master running at {}, starting Sentinel listeners...", master);
        for (String sentinel : sentinels) {
            hap = HostAndPort.parseString(sentinel);
            MasterListener masterListener = new MasterListener(masterName, hap.getHost(), hap.getPort());
            masterListener.setDaemon(true);
            this.masterListeners.add(masterListener);
            masterListener.start();
        }
        return master;
    }

    private HostAndPort toHostAndPort(List<String> getMasterAddrByNameResult) {
        String host = getMasterAddrByNameResult.get(0);
        int port = Integer.parseInt(getMasterAddrByNameResult.get(1));
        return new HostAndPort(host, port);
    }

    @Override
    public Jedis getResource() {
        while (true) {
            Jedis jedis = (Jedis)super.getResource();
            jedis.setDataSource(this);
            HostAndPort master = this.currentHostMaster;
            HostAndPort connection = new HostAndPort(jedis.getClient().getHost(), jedis.getClient().getPort());
            if (master.equals(connection)) {
                return jedis;
            }
            this.returnBrokenResource(jedis);
        }
    }

    @Override
    protected void returnBrokenResource(Jedis resource) {
        if (resource != null) {
            this.returnBrokenResourceObject(resource);
        }
    }

    @Override
    protected void returnResource(Jedis resource) {
        if (resource != null) {
            try {
                resource.resetState();
                this.returnResourceObject(resource);
            }
            catch (Exception e) {
                this.returnBrokenResource(resource);
                throw new JedisException("Resource is returned to the pool as broken", e);
            }
        }
    }

    protected class MasterListener
    extends Thread {
        protected String masterName;
        protected String host;
        protected int port;
        protected long subscribeRetryWaitTimeMillis;
        protected volatile Jedis j;
        protected AtomicBoolean running;

        protected MasterListener() {
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
        }

        public MasterListener(String masterName, String host, int port) {
            super(String.format("MasterListener-%s-[%s:%d]", masterName, host, port));
            this.subscribeRetryWaitTimeMillis = 5000L;
            this.running = new AtomicBoolean(false);
            this.masterName = masterName;
            this.host = host;
            this.port = port;
        }

        public MasterListener(String masterName, String host, int port, long subscribeRetryWaitTimeMillis) {
            this(masterName, host, port);
            this.subscribeRetryWaitTimeMillis = subscribeRetryWaitTimeMillis;
        }

        @Override
        public void run() {
            this.running.set(true);
            while (this.running.get()) {
                this.j = new Jedis(this.host, this.port);
                try {
                    if (!this.running.get()) break;
                    List<String> masterAddr = this.j.sentinelGetMasterAddrByName(this.masterName);
                    if (masterAddr == null || masterAddr.size() != 2) {
                        JedisSentinelPool.this.log.warn("Can not get master addr, master name: {}. Sentinel: {}:{}.", new Object[]{this.masterName, this.host, this.port});
                    } else {
                        JedisSentinelPool.this.initPool(JedisSentinelPool.this.toHostAndPort(masterAddr));
                    }
                    this.j.subscribe(new JedisPubSub(){

                        @Override
                        public void onMessage(String channel, String message) {
                            JedisSentinelPool.this.log.debug("Sentinel {}:{} published: {}.", new Object[]{MasterListener.this.host, MasterListener.this.port, message});
                            String[] switchMasterMsg = message.split(" ");
                            if (switchMasterMsg.length > 3) {
                                if (MasterListener.this.masterName.equals(switchMasterMsg[0])) {
                                    JedisSentinelPool.this.initPool(JedisSentinelPool.this.toHostAndPort(Arrays.asList(switchMasterMsg[3], switchMasterMsg[4])));
                                } else {
                                    JedisSentinelPool.this.log.debug("Ignoring message on +switch-master for master name {}, our master name is {}", (Object)switchMasterMsg[0], (Object)MasterListener.this.masterName);
                                }
                            } else {
                                JedisSentinelPool.this.log.error("Invalid message received on Sentinel {}:{} on channel +switch-master: {}", new Object[]{MasterListener.this.host, MasterListener.this.port, message});
                            }
                        }
                    }, "+switch-master");
                }
                catch (JedisException e) {
                    if (this.running.get()) {
                        JedisSentinelPool.this.log.error("Lost connection to Sentinel at {}:{}. Sleeping 5000ms and retrying.", new Object[]{this.host, this.port, e});
                        try {
                            Thread.sleep(this.subscribeRetryWaitTimeMillis);
                        }
                        catch (InterruptedException e1) {
                            JedisSentinelPool.this.log.error("Sleep interrupted: ", (Throwable)e1);
                        }
                        continue;
                    }
                    JedisSentinelPool.this.log.debug("Unsubscribing from Sentinel at {}:{}", (Object)this.host, (Object)this.port);
                }
                finally {
                    this.j.close();
                }
            }
        }

        public void shutdown() {
            try {
                JedisSentinelPool.this.log.debug("Shutting down listener on {}:{}", (Object)this.host, (Object)this.port);
                this.running.set(false);
                if (this.j != null) {
                    this.j.disconnect();
                }
            }
            catch (Exception e) {
                JedisSentinelPool.this.log.error("Caught exception while shutting down: ", (Throwable)e);
            }
        }
    }
}

