/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;

public class Utils {
    public static final String REGEX_ALL_NEWLINES = "(\\r\\n|\\n|\\r)";

    public static String stringify(Object paramSet, int paramIdx) {
        String result = "[" + paramIdx + "] ";
        return result + Utils.stringify(paramSet);
    }

    public static String stringify(Object paramSet) {
        String result = paramSet == null ? "null" : (paramSet instanceof String ? paramSet.toString() : Utils.asCsvString(Utils.safelyCastParamsToArray(paramSet)));
        return Utils.trimSpecialChars(result);
    }

    public static String getParameterStringByIndexOrEmpty(Object paramSet, int parameterIndex) {
        Object[] params = Utils.safelyCastParamsToArray(paramSet);
        if (paramSet instanceof String) {
            params = Utils.splitAtCommaOrPipe((String)paramSet);
        }
        if (parameterIndex >= 0 && parameterIndex < params.length) {
            return Utils.addParamToResult("", params[parameterIndex]);
        }
        return "";
    }

    public static String[] splitAtCommaOrPipe(String input) {
        ArrayList<String> result = new ArrayList<String>();
        char character = '\u0000';
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char previousCharacter = character;
            character = input.charAt(i);
            if (character == ',' || character == '|') {
                if (previousCharacter == '\\') {
                    value.setCharAt(value.length() - 1, character);
                    continue;
                }
                result.add(value.toString().trim());
                value = new StringBuilder();
                continue;
            }
            value.append(character);
        }
        result.add(value.toString().trim());
        return result.toArray(new String[0]);
    }

    private static String trimSpecialChars(String result) {
        return result.replace('(', '[').replace(')', ']').replaceAll(REGEX_ALL_NEWLINES, " ");
    }

    static Object[] safelyCastParamsToArray(Object paramSet) {
        Object[] params = paramSet instanceof Object[] ? (Object[])paramSet : new Object[]{paramSet};
        return params;
    }

    private static String asCsvString(Object[] params) {
        if (params == null) {
            return "null";
        }
        if (params.length == 0) {
            return "";
        }
        String result = "";
        for (int i = 0; i < params.length - 1; ++i) {
            Object param = params[i];
            result = Utils.addParamToResult(result, param) + ", ";
        }
        result = Utils.addParamToResult(result, params[params.length - 1]);
        return result;
    }

    private static String addParamToResult(String result, Object param) {
        if (param == null) {
            result = result + "null";
        } else {
            try {
                Utils.tryFindingOverridenToString(param);
                result = result + param.toString();
            }
            catch (Exception e) {
                result = result + param.getClass().getSimpleName();
            }
        }
        return result;
    }

    private static void tryFindingOverridenToString(Object param) throws NoSuchMethodException {
        Method toString = param.getClass().getMethod("toString", new Class[0]);
        if (toString.getDeclaringClass().equals(Object.class)) {
            throw new NoSuchMethodException();
        }
    }

    static String uniqueMethodId(int index, Object paramSet, String methodName) {
        return Utils.stringify(paramSet, index) + " (" + methodName + ")";
    }
}

