/*
 * Decompiled with CFR 0.152.
 */
package junitparams.internal;

import java.util.ArrayList;
import java.util.List;
import junitparams.JUnitParamsRunner;
import org.junit.runner.manipulation.Filter;
import org.junit.runners.model.FrameworkMethod;

public class ParametrizedTestMethodsFilter {
    private final JUnitParamsRunner jUnitParamsRunner;
    private final Filter filter;

    public ParametrizedTestMethodsFilter(JUnitParamsRunner jUnitParamsRunner, Filter filter) {
        this.jUnitParamsRunner = jUnitParamsRunner;
        this.filter = filter;
    }

    public ParametrizedTestMethodsFilter(JUnitParamsRunner jUnitParamsRunner) {
        this.jUnitParamsRunner = jUnitParamsRunner;
        this.filter = Filter.ALL;
    }

    public List<FrameworkMethod> filteredMethods(List<FrameworkMethod> frameworkMethods) {
        ArrayList<FrameworkMethod> filteredMethods = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod frameworkMethod : frameworkMethods) {
            if (!this.filter.shouldRun(this.jUnitParamsRunner.describeMethod(frameworkMethod))) continue;
            filteredMethods.add(frameworkMethod);
        }
        return filteredMethods;
    }
}

