/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.providers;

import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorMapping;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InterceptorBuilder {
    private static final Log LOG = LogFactory.getLog((Class)InterceptorBuilder.class);

    public static List constructInterceptorReference(PackageConfig packageConfig, String refName, Map refParams) throws ConfigurationException {
        Object referencedConfig = packageConfig.getAllInterceptorConfigs().get(refName);
        List<InterceptorMapping> result = new ArrayList<InterceptorMapping>();
        if (referencedConfig == null) {
            LOG.error((Object)("Unable to find interceptor class referenced by ref-name " + refName));
        } else if (referencedConfig instanceof InterceptorConfig) {
            result.add(new InterceptorMapping(refName, ObjectFactory.getObjectFactory().buildInterceptor((InterceptorConfig)referencedConfig, refParams)));
        } else if (referencedConfig instanceof InterceptorStackConfig) {
            InterceptorStackConfig stackConfig = (InterceptorStackConfig)referencedConfig;
            if (refParams != null && refParams.size() > 0) {
                result = InterceptorBuilder.constructParameterizedInterceptorReferences(packageConfig, stackConfig, refParams);
            } else {
                result.addAll(stackConfig.getInterceptors());
            }
        } else {
            LOG.error((Object)("Got unexpected type for interceptor " + refName + ". Got " + referencedConfig));
        }
        return result;
    }

    private static List constructParameterizedInterceptorReferences(PackageConfig packageConfig, InterceptorStackConfig stackConfig, Map refParams) {
        String key;
        LinkedHashMap params = new LinkedHashMap();
        Iterator iter = refParams.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            String value = (String)refParams.get(key);
            try {
                String name = key.substring(0, key.indexOf(46));
                key = key.substring(key.indexOf(46) + 1);
                Map map = params.containsKey(name) ? (Map)params.get(name) : new LinkedHashMap();
                map.put(key, value);
                params.put(name, map);
            }
            catch (Exception e) {
                LOG.warn((Object)("No interceptor found for name = " + key));
            }
        }
        ArrayList<InterceptorMapping> result = new ArrayList<InterceptorMapping>(stackConfig.getInterceptors());
        iter = params.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            Map map = (Map)params.get(key);
            Object interceptorCfgObj = packageConfig.getAllInterceptorConfigs().get(key);
            if (interceptorCfgObj instanceof InterceptorConfig) {
                InterceptorConfig cfg = (InterceptorConfig)interceptorCfgObj;
                Interceptor interceptor = ObjectFactory.getObjectFactory().buildInterceptor(cfg, map);
                InterceptorMapping mapping = new InterceptorMapping(key, interceptor);
                if (result != null && result.contains(mapping)) {
                    int index = result.indexOf(mapping);
                    result.set(index, mapping);
                    continue;
                }
                result.add(mapping);
                continue;
            }
            if (!(interceptorCfgObj instanceof InterceptorStackConfig)) continue;
            InterceptorStackConfig stackCfg = (InterceptorStackConfig)interceptorCfgObj;
            List tmpResult = InterceptorBuilder.constructParameterizedInterceptorReferences(packageConfig, stackCfg, map);
            Iterator i = tmpResult.iterator();
            while (i.hasNext()) {
                InterceptorMapping tmpInterceptorMapping = (InterceptorMapping)i.next();
                if (result.contains(tmpInterceptorMapping)) {
                    int index = result.indexOf(tmpInterceptorMapping);
                    result.set(index, tmpInterceptorMapping);
                    continue;
                }
                result.add(tmpInterceptorMapping);
            }
        }
        return result;
    }
}

