/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.locking;

import java.util.Collection;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockEntry;

public class SerializableStrategy
extends AbstractLockStrategy {
    public boolean readLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        Collection readers = this.getReaders(obj);
        if (writer == null) {
            if (readers.size() == 0) {
                if (this.addReader(tx, obj)) {
                    readers = this.getReaders(obj);
                    if (readers.size() == 1) {
                        return true;
                    }
                    this.removeReader(tx, obj);
                    return this.readLock(tx, obj);
                }
                return this.readLock(tx, obj);
            }
            if (readers.size() == 1 && ((LockEntry)readers.iterator().next()).isOwnedBy(tx)) {
                return true;
            }
        } else if (writer.isOwnedBy(tx)) {
            return true;
        }
        return false;
    }

    public boolean writeLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        Collection readers = this.getReaders(obj);
        if (writer == null) {
            if (readers.size() == 0) {
                if (this.setWriter(tx, obj)) {
                    return true;
                }
                return this.writeLock(tx, obj);
            }
            if (readers.size() == 1 && ((LockEntry)readers.iterator().next()).isOwnedBy(tx)) {
                return this.upgradeLock(tx, obj);
            }
        } else if (writer.isOwnedBy(tx)) {
            return true;
        }
        return false;
    }

    public boolean upgradeLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer == null) {
            Collection readers = this.getReaders(obj);
            if (readers.size() == 1) {
                LockEntry reader = (LockEntry)readers.iterator().next();
                if (reader.isOwnedBy(tx)) {
                    if (this.upgradeLock(reader)) {
                        return true;
                    }
                    return this.upgradeLock(tx, obj);
                }
            } else if (readers.size() == 0) {
                if (this.setWriter(tx, obj)) {
                    return true;
                }
                return this.upgradeLock(tx, obj);
            }
        } else if (writer.isOwnedBy(tx)) {
            return true;
        }
        return false;
    }

    public boolean releaseLock(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        if (writer != null && writer.isOwnedBy(tx)) {
            this.removeWriter(writer);
            return true;
        }
        if (this.hasReadLock(tx, obj)) {
            this.removeReader(tx, obj);
            return true;
        }
        return false;
    }

    public boolean checkRead(TransactionImpl tx, Object obj) {
        if (this.hasReadLock(tx, obj)) {
            return true;
        }
        LockEntry writer = this.getWriter(obj);
        return writer != null && writer.isOwnedBy(tx);
    }

    public boolean checkWrite(TransactionImpl tx, Object obj) {
        LockEntry writer = this.getWriter(obj);
        return writer != null && writer.isOwnedBy(tx);
    }
}

