/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.metadata.SequenceDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManager;

public class SequenceManagerFactory {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerFactory == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerFactory = SequenceManagerFactory.class$("org.apache.ojb.broker.util.sequence.SequenceManagerFactory")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerFactory);
    private static SequenceManagerFactory singleton;
    private Class defaultSeqManagerClass;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerFactory;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$PersistenceBroker;

    public SequenceManagerFactory() {
        Class clazz = this.defaultSeqManagerClass = class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl = SequenceManagerFactory.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHighLowImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl;
        if (log.isDebugEnabled()) {
            log.debug("Default sequence manager class was " + this.defaultSeqManagerClass.getName());
        }
    }

    public static synchronized SequenceManager getSequenceManager(PersistenceBroker broker) {
        if (singleton == null) {
            singleton = new SequenceManagerFactory();
        }
        return singleton.createNewSequenceManager(broker);
    }

    private SequenceManager createNewSequenceManager(PersistenceBroker broker) {
        SequenceManagerFactory sequenceManagerFactory = singleton;
        synchronized (sequenceManagerFactory) {
            if (log.isDebugEnabled()) {
                log.debug("create new sequence manager for broker " + broker);
            }
            try {
                Class seqManClass = this.defaultSeqManagerClass;
                SequenceDescriptor sd = broker.serviceConnectionManager().getConnectionDescriptor().getSequenceDescriptor();
                if (sd != null && sd.getSequenceManagerClass() != null) {
                    seqManClass = sd.getSequenceManagerClass();
                    if (log.isDebugEnabled()) {
                        log.debug("Jdbc-Connection-Descriptor '" + broker.serviceConnectionManager().getConnectionDescriptor().getJcdAlias() + "' use sequence manager: " + seqManClass);
                    }
                }
                return (SequenceManager)ClassHelper.newInstance(seqManClass, class$org$apache$ojb$broker$PersistenceBroker == null ? (class$org$apache$ojb$broker$PersistenceBroker = SequenceManagerFactory.class$("org.apache.ojb.broker.PersistenceBroker")) : class$org$apache$ojb$broker$PersistenceBroker, (Object)broker);
            }
            catch (Exception ex) {
                log.error("Could not create sequence manager for broker " + broker, ex);
                throw new PersistenceBrokerException(ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

