/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class UserAlias
implements Serializable {
    private static final long serialVersionUID = 3257282552220627249L;
    private Map m_mapping = new HashMap();
    private String m_name = null;
    private String m_attributePath = null;
    private boolean m_allPathsAliased = false;
    private Logger m_logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$query$UserAlias == null ? (class$org$apache$ojb$broker$query$UserAlias = UserAlias.class$("org.apache.ojb.broker.query.UserAlias")) : class$org$apache$ojb$broker$query$UserAlias);
    static /* synthetic */ Class class$org$apache$ojb$broker$query$UserAlias;

    public UserAlias(String name) {
        this.m_name = name;
    }

    public UserAlias(String name, String attributePath, String aliasPath) {
        this.m_name = name;
        this.m_attributePath = attributePath;
        if (attributePath.lastIndexOf(aliasPath) == -1) {
            this.m_logger.warn("aliasPath should be a substring of attributePath");
        }
        this.initMapping(attributePath, aliasPath);
    }

    public UserAlias(String name, String attributePath, boolean allPathsAliased) {
        this.m_name = name;
        this.m_attributePath = attributePath;
        this.m_allPathsAliased = allPathsAliased;
    }

    private void initMapping(String attributePath, String aliasPath) {
        int beginIndex;
        Iterator aliasSegmentItr = this.pathToSegments(aliasPath).iterator();
        String currPath = "";
        String separator = "";
        while (aliasSegmentItr.hasNext() && (beginIndex = attributePath.indexOf(currPath = currPath + separator + (String)aliasSegmentItr.next())) != -1) {
            int endIndex = beginIndex + currPath.length();
            this.m_mapping.put(attributePath.substring(0, endIndex), this.m_name);
            separator = ".";
        }
    }

    private ArrayList pathToSegments(String path) {
        ArrayList<String> segments = new ArrayList<String>();
        int sp = path.indexOf(46);
        while (sp != -1) {
            segments.add(path.substring(0, sp));
            path = path.substring(sp + 1);
            sp = path.indexOf(46);
        }
        segments.add(path);
        return segments;
    }

    public String getName() {
        return this.m_name;
    }

    public String getAlias(String path) {
        if (this.m_allPathsAliased && this.m_attributePath.lastIndexOf(path) != -1) {
            return this.m_name;
        }
        Object retObj = this.m_mapping.get(path);
        if (retObj != null) {
            return (String)retObj;
        }
        return null;
    }

    public void add(String path) {
        this.m_mapping.put(path, this.m_name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

