/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.broker.util.ClassHelper;

public class BlobWrapper {
    protected Object m_blob;
    protected static Field durationSession;
    protected static Field durationCall;
    protected static Field modeReadOnly;
    protected static Field modeReadWrite;
    protected static Method createTemporary;
    protected static Method freeTemporary;
    protected static Method open;
    protected static Method isOpen;
    protected static Method getBinaryStream;
    protected static Method getBinaryOutputStream;
    protected static Method getBufferSize;
    protected static Method close;
    protected static Method trim;
    static /* synthetic */ Class class$java$sql$Connection;

    public Object getBlob() {
        return this.m_blob;
    }

    public void setBlob(Object blob) {
        this.m_blob = blob;
    }

    protected static int staticIntFieldValue(Field field) {
        int value = 0;
        try {
            value = field.getInt(null);
        }
        catch (Exception ignore) {
            value = -1;
        }
        return value;
    }

    public static int getDurationSessionValue() {
        return BlobWrapper.staticIntFieldValue(durationSession);
    }

    public static int getDurationCallValue() {
        return BlobWrapper.staticIntFieldValue(durationCall);
    }

    public static int getModeReadOnlyValue() {
        return BlobWrapper.staticIntFieldValue(modeReadOnly);
    }

    public static int getModeReadWriteValue() {
        return BlobWrapper.staticIntFieldValue(modeReadWrite);
    }

    public static BlobWrapper createTemporary(Connection conn, boolean b, int i) throws Exception {
        BlobWrapper retval = new BlobWrapper();
        retval.setBlob(createTemporary.invoke(null, conn, BooleanUtils.toBooleanObject((boolean)b), new Integer(i)));
        return retval;
    }

    public void open(int i) throws SQLException {
        if (this.m_blob == null) {
            return;
        }
        try {
            open.invoke(this.m_blob, new Integer(i));
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    public boolean isOpen() throws SQLException {
        if (this.m_blob == null) {
            return false;
        }
        boolean blobOpen = false;
        try {
            Boolean retval = (Boolean)isOpen.invoke(this.m_blob, null);
            if (retval != null) {
                blobOpen = retval;
            }
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
        return blobOpen;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.m_blob == null) {
            return null;
        }
        InputStream retval = null;
        try {
            retval = (InputStream)getBinaryStream.invoke(this.m_blob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
        return retval;
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        if (this.m_blob == null) {
            return null;
        }
        OutputStream retval = null;
        try {
            retval = (OutputStream)getBinaryOutputStream.invoke(this.m_blob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
        return retval;
    }

    public int getBufferSize() throws SQLException {
        if (this.m_blob == null) {
            return 0;
        }
        Integer retval = null;
        try {
            retval = (Integer)getBufferSize.invoke(this.m_blob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
        return retval;
    }

    public void close() throws SQLException {
        if (this.m_blob == null) {
            return;
        }
        try {
            close.invoke(this.m_blob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void trim(long l) throws SQLException {
        if (this.m_blob == null) {
            return;
        }
        try {
            trim.invoke(this.m_blob, new Long(l));
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    public void freeTemporary() throws SQLException {
        if (this.m_blob == null) {
            return;
        }
        try {
            freeTemporary.invoke(this.m_blob, null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class blobClass = ClassHelper.getClass("oracle.sql.BLOB", false);
            createTemporary = blobClass.getMethod("createTemporary", class$java$sql$Connection == null ? (class$java$sql$Connection = BlobWrapper.class$("java.sql.Connection")) : class$java$sql$Connection, Boolean.TYPE, Integer.TYPE);
            freeTemporary = blobClass.getMethod("freeTemporary", null);
            open = blobClass.getMethod("open", Integer.TYPE);
            isOpen = blobClass.getMethod("isOpen", null);
            getBinaryStream = blobClass.getMethod("getBinaryStream", null);
            getBinaryOutputStream = blobClass.getMethod("getBinaryOutputStream", null);
            getBufferSize = blobClass.getMethod("getBufferSize", null);
            close = blobClass.getMethod("close", null);
            trim = blobClass.getMethod("trim", Long.TYPE);
            durationSession = ClassHelper.getField(blobClass, "DURATION_SESSION");
            durationCall = ClassHelper.getField(blobClass, "DURATION_CALL");
            modeReadOnly = ClassHelper.getField(blobClass, "MODE_READONLY");
            modeReadWrite = ClassHelper.getField(blobClass, "MODE_READWRITE");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

