/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.torque.TableDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class TorqueForeignKeyGenerator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DescriptorRepository repository;
    private HashMap mappingTables = new HashMap();
    private HashMap foreignKeyVectors = new HashMap();

    public TorqueForeignKeyGenerator(DescriptorRepository repository) {
        this.repository = repository;
    }

    public void buildConstraintsMap() {
        Iterator classDescriptorIterators = this.repository.iterator();
        while (classDescriptorIterators.hasNext()) {
            ClassDescriptor cd = (ClassDescriptor)classDescriptorIterators.next();
            if (cd.isAbstract() || cd.isInterface()) {
                this.logger.debug("Skip constraint build for abstract class/ interface " + cd.getClassNameOfObject());
                continue;
            }
            this.buildConstraints(cd);
            this.buildOneToOneConstraints(cd);
        }
    }

    public Vector getForeignKeysForTable(String tableName) {
        return (Vector)this.foreignKeyVectors.get(tableName);
    }

    public HashMap getMappingTables() {
        return this.mappingTables;
    }

    private void buildTableFieldDescriptors(FieldDescriptor[] fieldDescriptors, TableDescriptor tableDescriptor) {
        for (int i = 0; i < fieldDescriptors.length; ++i) {
            tableDescriptor.addColumn(fieldDescriptors[i]);
        }
    }

    private void buildConstraints(ClassDescriptor cd) {
        Vector collectionDescriptors = cd.getCollectionDescriptors();
        for (int i = 0; i < collectionDescriptors.size(); ++i) {
            CollectionDescriptor collectionDescriptor = (CollectionDescriptor)collectionDescriptors.get(i);
            if (collectionDescriptor.isMtoNRelation()) {
                this.buildManyToManyConstraints(cd, collectionDescriptor);
                continue;
            }
            this.buildOneToManyReferences(cd, collectionDescriptor);
        }
    }

    private void buildManyToManyConstraints(ClassDescriptor cd, CollectionDescriptor collectionDescriptor) {
        Vector columns = new Vector();
        ClassDescriptor itemDescriptor = this.repository.getDescriptorFor(collectionDescriptor.getItemClass());
        this.buildManyToManyReferences(cd, collectionDescriptor, collectionDescriptor.getFksToThisClass(), columns);
        this.buildManyToManyReferences(itemDescriptor, collectionDescriptor, collectionDescriptor.getFksToItemClass(), columns);
        if (this.isImplicitlyMapped(collectionDescriptor.getIndirectionTable())) {
            TableDescriptor mappingTable = new TableDescriptor();
            this.buildTableFieldDescriptors(columns.toArray(new FieldDescriptor[0]), mappingTable);
            mappingTable.setName(collectionDescriptor.getIndirectionTable());
            this.mappingTables.put(mappingTable.getName(), mappingTable);
        }
    }

    private void buildManyToManyReferences(ClassDescriptor cd, CollectionDescriptor collectionDescriptor, Object[] keys, Vector columns) {
        if (cd.isAbstract() || cd.isInterface()) {
            this.logger.debug("Skip foreign key build for MtoM, found abstract base class or interface " + cd.getClassNameOfObject());
            return;
        }
        StringBuffer buffer = new StringBuffer(256);
        this.buildForeignKeyHeader(cd.getFullTableName(), buffer);
        for (int i = 0; i < keys.length; ++i) {
            String columnName = (String)keys[i];
            FieldDescriptor foreignColumn = cd.getPkFields()[i];
            String foreignColumnName = foreignColumn.getPersistentField().getName();
            this.buildReferenceForColumn(buffer, columnName, foreignColumnName);
            FieldDescriptor fieldDescriptor = (FieldDescriptor)foreignColumn.clone();
            fieldDescriptor.setColumnName(columnName);
            columns.add(fieldDescriptor);
        }
        buffer.append("        </foreign-key>\n");
        this.addReferenceToTable(collectionDescriptor.getIndirectionTable(), buffer.toString());
    }

    private void buildOneToManyReferences(ClassDescriptor cd, CollectionDescriptor collectionDescriptor) {
        Vector foreignKeyIndices = collectionDescriptor.getForeignKeyFields();
        ClassDescriptor foreignKeyClassDescriptor = this.repository.getDescriptorFor(collectionDescriptor.getItemClass());
        this.buildForeignKey(cd, foreignKeyIndices, foreignKeyClassDescriptor);
    }

    private void buildOneToOneConstraints(ClassDescriptor classDescriptor) {
        Vector referenceDescriptors = classDescriptor.getObjectReferenceDescriptors();
        for (int i = 0; i < referenceDescriptors.size(); ++i) {
            ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)referenceDescriptors.get(i);
            Vector foreignKeyIndices = ord.getForeignKeyFields();
            ClassDescriptor foreignClassDescriptor = this.repository.getDescriptorFor(ord.getItemClass());
            this.buildForeignKey(foreignClassDescriptor, foreignKeyIndices, classDescriptor);
        }
    }

    private void buildForeignKey(ClassDescriptor foreignClassDescriptor, Vector foreignKeyIndices, ClassDescriptor classDescriptor) {
        if (classDescriptor.isAbstract() || classDescriptor.isInterface()) {
            this.logger.debug("Skip foreign key build, found abstract base class or interface " + classDescriptor.getClassNameOfObject());
            return;
        }
        StringBuffer buffer = new StringBuffer(256);
        this.buildForeignKeyHeader(foreignClassDescriptor.getFullTableName(), buffer);
        for (int i = 0; i < foreignKeyIndices.size(); ++i) {
            String columnName = null;
            Object obj = foreignKeyIndices.get(i);
            if (obj instanceof Integer) {
                int foreignKeyIndex = (Integer)obj;
                columnName = classDescriptor.getFieldDescriptorByIndex(foreignKeyIndex).getColumnName();
            } else {
                FieldDescriptor fld = classDescriptor.getFieldDescriptorByName((String)obj);
                if (fld == null) {
                    this.logger.debug("FieldDescriptor for foreign key parameter \n" + obj + " was not found in ClassDescriptor \n" + classDescriptor);
                } else {
                    columnName = fld.getColumnName();
                }
            }
            FieldDescriptor foreignColumn = foreignClassDescriptor.getPkFields()[i];
            String foreignColumnName = foreignColumn.getColumnName();
            this.buildReferenceForColumn(buffer, columnName, foreignColumnName);
        }
        buffer.append("        </foreign-key>\n");
        this.addReferenceToTable(classDescriptor.getFullTableName(), buffer.toString());
    }

    private void buildForeignKeyHeader(String foreignClassName, StringBuffer buffer) {
        buffer.append("        <foreign-key foreignTable=\"");
        buffer.append(foreignClassName);
        buffer.append("\">\n");
    }

    private void buildReferenceForColumn(StringBuffer buffer, String columnName, String foreignColumnName) {
        buffer.append("            <reference local=\"");
        buffer.append(columnName);
        buffer.append("\" foreign=\"");
        buffer.append(foreignColumnName);
        buffer.append("\"/>\n");
    }

    private boolean isImplicitlyMapped(String tableName) {
        Iterator classDescriptorIterator = this.repository.iterator();
        while (classDescriptorIterator.hasNext()) {
            ClassDescriptor cd = (ClassDescriptor)classDescriptorIterator.next();
            if (!tableName.equals(cd.getFullTableName())) continue;
            return false;
        }
        return true;
    }

    private void addReferenceToTable(String tableName, String reference) {
        Vector<String> tableReferences = (Vector<String>)this.foreignKeyVectors.get(tableName);
        if (tableReferences == null) {
            tableReferences = new Vector<String>();
            this.foreignKeyVectors.put(tableName, tableReferences);
        }
        if (!tableReferences.contains(reference)) {
            tableReferences.add(reference);
        }
    }
}

