/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.JdbcMetadataUtils;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.metadata.XmlCapable;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionRepository
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -5581126412817848887L;
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$ConnectionRepository == null ? (class$org$apache$ojb$broker$metadata$ConnectionRepository = ConnectionRepository.class$("org.apache.ojb.broker.metadata.ConnectionRepository")) : class$org$apache$ojb$broker$metadata$ConnectionRepository);
    private HashMap jcdMap = new HashMap();
    private Hashtable jcdAliasToPBKeyMap = new Hashtable();
    private JdbcMetadataUtils utils = new JdbcMetadataUtils();
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$ConnectionRepository;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor;

    public JdbcConnectionDescriptor getDescriptor(PBKey pbKey) {
        JdbcConnectionDescriptor result = (JdbcConnectionDescriptor)this.jcdMap.get(pbKey);
        if (result == null) {
            result = this.deepCopyOfFirstFound(pbKey.getAlias());
            if (result != null) {
                result.setUserName(pbKey.getUser());
                result.setPassWord(pbKey.getPassword());
                result.setDefaultConnection(false);
                log.info("Automatic create of new jdbc-connection-descriptor for PBKey " + pbKey);
                this.addDescriptor(result);
            } else {
                log.info("Could not find " + (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = ConnectionRepository.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor).getName() + " for PBKey " + pbKey);
            }
        }
        return result;
    }

    private JdbcConnectionDescriptor deepCopyOfFirstFound(String jcdAlias) {
        Iterator it = this.jcdMap.values().iterator();
        while (it.hasNext()) {
            JdbcConnectionDescriptor jcd = (JdbcConnectionDescriptor)it.next();
            if (!jcdAlias.equals(jcd.getJcdAlias())) continue;
            return (JdbcConnectionDescriptor)SerializationUtils.clone((Serializable)jcd);
        }
        return null;
    }

    public PBKey getStandardPBKeyForJcdAlias(String jcdAlias) {
        return (PBKey)this.jcdAliasToPBKeyMap.get(jcdAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDescriptor(JdbcConnectionDescriptor jcd) {
        HashMap hashMap = this.jcdMap;
        synchronized (hashMap) {
            if (this.jcdMap.containsKey(jcd.getPBKey())) {
                throw new MetadataException("Found duplicate connection descriptor using PBKey " + jcd.getPBKey() + ", remove the old descriptor first, before add the new one. " + jcd);
            }
            this.jcdMap.put(jcd.getPBKey(), jcd);
            if (!this.jcdAliasToPBKeyMap.containsKey(jcd.getJcdAlias())) {
                this.jcdAliasToPBKeyMap.put(jcd.getJcdAlias(), jcd.getPBKey());
            }
            if (log.isDebugEnabled()) {
                log.debug("New descriptor was added: " + jcd);
            }
        }
    }

    public JdbcConnectionDescriptor addDescriptor(String jcdAlias, String jdbcDriver, String jdbcConnectionUrl, String username, String password) {
        JdbcConnectionDescriptor jcd = new JdbcConnectionDescriptor();
        HashMap props = this.utils.parseConnectionUrl(jdbcConnectionUrl);
        jcd.setJcdAlias(jcdAlias);
        jcd.setProtocol((String)props.get("protocol"));
        jcd.setSubProtocol((String)props.get("subprotocol"));
        jcd.setDbAlias((String)props.get("dbAlias"));
        String platform = this.utils.findPlatformFor(jcd.getSubProtocol(), jdbcDriver);
        jcd.setDbms(platform);
        jcd.setJdbcLevel(2.0);
        jcd.setDriver(jdbcDriver);
        if (username != null) {
            jcd.setUserName(username);
            jcd.setPassWord(password);
        }
        if ("default".equals(jcdAlias)) {
            jcd.setDefaultConnection(true);
            MetadataManager.getInstance().setDefaultPBKey(new PBKey(jcd.getJcdAlias(), jcd.getUserName(), jcd.getPassWord()));
        }
        this.addDescriptor(jcd);
        return jcd;
    }

    public JdbcConnectionDescriptor addDescriptor(String jcdAlias, DataSource dataSource, String username, String password) {
        JdbcConnectionDescriptor jcd = new JdbcConnectionDescriptor();
        jcd.setJcdAlias(jcdAlias);
        jcd.setDataSource(dataSource);
        if (username != null) {
            jcd.setUserName(username);
            jcd.setPassWord(password);
        }
        this.utils.fillJCDFromDataSource(jcd, dataSource, username, password);
        if ("default".equals(jcdAlias)) {
            jcd.setDefaultConnection(true);
            MetadataManager.getInstance().setDefaultPBKey(new PBKey(jcd.getJcdAlias(), jcd.getUserName(), jcd.getPassWord()));
        }
        this.addDescriptor(jcd);
        return jcd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void removeDescriptor(Object validKey) {
        PBKey pbKey;
        if (validKey instanceof PBKey) {
            pbKey = (PBKey)validKey;
        } else if (validKey instanceof JdbcConnectionDescriptor) {
            pbKey = ((JdbcConnectionDescriptor)validKey).getPBKey();
        } else {
            throw new MetadataException("Could not remove descriptor, given object was no vaild key: " + validKey);
        }
        Object removed = null;
        HashMap hashMap = this.jcdMap;
        synchronized (hashMap) {
            void var2_2;
            removed = this.jcdMap.remove(var2_2);
            this.jcdAliasToPBKeyMap.remove(var2_2.getAlias());
        }
        log.info("Remove descriptor: " + removed);
    }

    public List getAllDescriptor() {
        return (List)SerializationUtils.clone(new ArrayList(this.jcdMap.values()));
    }

    public String toXML() {
        String eol = SystemUtils.LINE_SEPARATOR;
        HashMap map = (HashMap)this.jcdMap.clone();
        StringBuffer buf = new StringBuffer();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            JdbcConnectionDescriptor jcd = (JdbcConnectionDescriptor)it.next();
            buf.append(jcd.toXML());
            buf.append(eol);
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

