/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.ConnectionManagerIF;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.accesslayer.StatementManagerIF;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.query.BetweenCriteria;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.ExistsCriteria;
import org.apache.ojb.broker.query.FieldCriteria;
import org.apache.ojb.broker.query.InCriteria;
import org.apache.ojb.broker.query.NullCriteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.SelectionCriteria;
import org.apache.ojb.broker.query.SqlCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class StatementManager
implements StatementManagerIF {
    private Logger m_log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$StatementManager == null ? (class$org$apache$ojb$broker$accesslayer$StatementManager = StatementManager.class$("org.apache.ojb.broker.accesslayer.StatementManager")) : class$org$apache$ojb$broker$accesslayer$StatementManager);
    private final PersistenceBroker m_broker;
    private Platform m_platform;
    private boolean m_eagerRelease;
    private ConnectionManagerIF m_conMan;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$StatementManager;

    public StatementManager(PersistenceBroker pBroker) {
        this.m_broker = pBroker;
        this.m_conMan = this.m_broker.serviceConnectionManager();
        this.m_eagerRelease = this.m_conMan.getConnectionDescriptor().getEagerRelease();
        this.m_platform = PlatformFactory.getPlatformFor(this.m_conMan.getConnectionDescriptor());
    }

    public void closeResources(Statement stmt, ResultSet rs) {
        block6: {
            if (this.m_log.isDebugEnabled()) {
                this.m_log.debug("closeResources was called");
            }
            try {
                this.m_platform.beforeStatementClose(stmt, rs);
                if (stmt != null) {
                    stmt.close();
                    if (this.m_eagerRelease) {
                        this.m_conMan.releaseConnection();
                    }
                }
                this.m_platform.afterStatementClose(stmt, rs);
            }
            catch (PlatformException e) {
                this.m_log.error("Platform dependent operation failed", (Throwable)((Object)e));
            }
            catch (SQLException ignored) {
                if (!this.m_log.isDebugEnabled()) break block6;
                this.m_log.debug("Statement closing failed", ignored);
            }
        }
    }

    public void bindDelete(PreparedStatement stmt, Identity oid, ClassDescriptor cld) throws SQLException {
        int i;
        Object[] pkValues = oid.getPrimaryKeyValues();
        FieldDescriptor[] pkFields = cld.getPkFields();
        try {
            for (i = 0; i < pkValues.length; ++i) {
                this.setObjectForStatement(stmt, i + 1, pkValues[i], pkFields[i].getJdbcType().getType());
            }
        }
        catch (SQLException e) {
            this.m_log.error("bindDelete failed for: " + oid.toString() + ", while set value '" + pkValues[i] + "' for column " + pkFields[i].getColumnName());
            throw e;
        }
    }

    public void bindDelete(PreparedStatement stmt, ClassDescriptor cld, Object obj) throws SQLException {
        if (cld.getDeleteProcedure() != null) {
            this.bindProcedure(stmt, cld, obj, cld.getDeleteProcedure());
        } else {
            int i;
            int index = 1;
            ValueContainer[] currentLockingValues = cld.getCurrentLockingValues(obj);
            ValueContainer[] values = this.getKeyValues(this.m_broker, cld, obj);
            for (i = 0; i < values.length; ++i) {
                this.setObjectForStatement(stmt, index, values[i].getValue(), values[i].getJdbcType().getType());
                ++index;
            }
            values = currentLockingValues;
            for (i = 0; i < values.length; ++i) {
                this.setObjectForStatement(stmt, index, values[i].getValue(), values[i].getJdbcType().getType());
                ++index;
            }
        }
    }

    private int bindStatementValue(PreparedStatement stmt, int index, Object attributeOrQuery, Object value, ClassDescriptor cld) throws SQLException {
        FieldDescriptor fld = null;
        if (value instanceof Query) {
            Query subQuery = (Query)value;
            return this.bindStatement(stmt, subQuery, cld.getRepository().getDescriptorFor(subQuery.getSearchClass()), index);
        }
        if (attributeOrQuery instanceof Query) {
            Query subQuery = (Query)attributeOrQuery;
            this.bindStatement(stmt, subQuery, cld.getRepository().getDescriptorFor(subQuery.getSearchClass()), index);
        } else {
            fld = cld.getFieldDescriptorForPath((String)attributeOrQuery);
        }
        if (fld != null) {
            if (value != null) {
                this.m_platform.setObjectForStatement(stmt, index, fld.getFieldConversion().javaToSql(value), fld.getJdbcType().getType());
            } else {
                this.m_platform.setNullForStatement(stmt, index, fld.getJdbcType().getType());
            }
        } else if (value != null) {
            stmt.setObject(index, value);
        } else {
            stmt.setNull(index, 0);
        }
        return ++index;
    }

    private int bindStatement(PreparedStatement stmt, int index, SelectionCriteria crit, ClassDescriptor cld) throws SQLException {
        return this.bindStatementValue(stmt, index, crit.getAttribute(), crit.getValue(), cld);
    }

    private int bindStatement(PreparedStatement stmt, int index, NullCriteria crit) {
        return index;
    }

    private int bindStatement(PreparedStatement stmt, int index, FieldCriteria crit) {
        return index;
    }

    private int bindStatement(PreparedStatement stmt, int index, SqlCriteria crit) {
        return index;
    }

    private int bindStatement(PreparedStatement stmt, int index, BetweenCriteria crit, ClassDescriptor cld) throws SQLException {
        index = this.bindStatementValue(stmt, index, crit.getAttribute(), crit.getValue(), cld);
        return this.bindStatementValue(stmt, index, crit.getAttribute(), crit.getValue2(), cld);
    }

    private int bindStatement(PreparedStatement stmt, int index, InCriteria crit, ClassDescriptor cld) throws SQLException {
        if (crit.getValue() instanceof Collection) {
            Collection values = (Collection)crit.getValue();
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                index = this.bindStatementValue(stmt, index, crit.getAttribute(), iter.next(), cld);
            }
        } else {
            index = this.bindStatementValue(stmt, index, crit.getAttribute(), crit.getValue(), cld);
        }
        return index;
    }

    private int bindStatement(PreparedStatement stmt, int index, ExistsCriteria crit, ClassDescriptor cld) throws SQLException {
        Query subQuery = (Query)crit.getValue();
        if (subQuery.getCriteria() != null && !subQuery.getCriteria().isEmpty()) {
            return this.bindStatement(stmt, subQuery.getCriteria(), cld.getRepository().getDescriptorFor(subQuery.getSearchClass()), index);
        }
        return index;
    }

    public int bindStatement(PreparedStatement stmt, Query query, ClassDescriptor cld, int param) throws SQLException {
        int result = this.bindStatement(stmt, query.getCriteria(), cld, param);
        result = this.bindStatement(stmt, query.getHavingCriteria(), cld, result);
        return result;
    }

    protected int bindStatement(PreparedStatement stmt, Criteria crit, ClassDescriptor cld, int param) throws SQLException {
        if (crit != null) {
            Enumeration e = crit.getElements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o instanceof Criteria) {
                    Criteria pc = (Criteria)o;
                    param = this.bindStatement(stmt, pc, cld, param);
                    continue;
                }
                SelectionCriteria c = (SelectionCriteria)o;
                param = this.bindSelectionCriteria(stmt, param, c, cld);
                for (int i = 0; i < c.getNumberOfExtentsToBind(); ++i) {
                    param = this.bindSelectionCriteria(stmt, param, c, cld);
                }
            }
        }
        return param;
    }

    private int bindSelectionCriteria(PreparedStatement stmt, int index, SelectionCriteria crit, ClassDescriptor cld) throws SQLException {
        index = crit instanceof NullCriteria ? this.bindStatement(stmt, index, (NullCriteria)crit) : (crit instanceof BetweenCriteria ? this.bindStatement(stmt, index, (BetweenCriteria)crit, cld) : (crit instanceof InCriteria ? this.bindStatement(stmt, index, (InCriteria)crit, cld) : (crit instanceof SqlCriteria ? this.bindStatement(stmt, index, (SqlCriteria)crit) : (crit instanceof FieldCriteria ? this.bindStatement(stmt, index, (FieldCriteria)crit) : (crit instanceof ExistsCriteria ? this.bindStatement(stmt, index, (ExistsCriteria)crit, cld) : this.bindStatement(stmt, index, crit, cld))))));
        return index;
    }

    public void bindInsert(PreparedStatement stmt, ClassDescriptor cld, Object obj) throws SQLException {
        cld.updateLockingValues(obj);
        if (cld.getInsertProcedure() != null) {
            this.bindProcedure(stmt, cld, obj, cld.getInsertProcedure());
        } else {
            ValueContainer[] values = this.getAllValues(cld, obj);
            for (int i = 0; i < values.length; ++i) {
                this.setObjectForStatement(stmt, i + 1, values[i].getValue(), values[i].getJdbcType().getType());
            }
        }
    }

    public void bindSelect(PreparedStatement stmt, Identity oid, ClassDescriptor cld) throws SQLException {
        ValueContainer[] values = null;
        int i = 0;
        if (cld == null) {
            cld = this.m_broker.getClassDescriptor(oid.getObjectsRealClass());
        }
        try {
            values = this.getKeyValues(this.m_broker, cld, oid);
            for (i = 0; i < values.length; ++i) {
                this.setObjectForStatement(stmt, i + 1, values[i].getValue(), values[i].getJdbcType().getType());
            }
        }
        catch (SQLException e) {
            this.m_log.error("bindSelect failed for: " + oid.toString() + ", PK: " + i + ", value: " + values[i]);
            throw e;
        }
    }

    public void bindUpdate(PreparedStatement stmt, ClassDescriptor cld, Object obj) throws SQLException {
        if (cld.getUpdateProcedure() != null) {
            this.bindProcedure(stmt, cld, obj, cld.getUpdateProcedure());
        } else {
            int i;
            int index = 1;
            ValueContainer[] valuesSnapshot = cld.getCurrentLockingValues(obj);
            cld.updateLockingValues(obj);
            ValueContainer[] values = this.getNonKeyValues(this.m_broker, cld, obj);
            for (i = 0; i < values.length; ++i) {
                this.setObjectForStatement(stmt, index, values[i].getValue(), values[i].getJdbcType().getType());
                ++index;
            }
            values = this.getKeyValues(this.m_broker, cld, obj);
            for (i = 0; i < values.length; ++i) {
                this.setObjectForStatement(stmt, index, values[i].getValue(), values[i].getJdbcType().getType());
                ++index;
            }
            values = valuesSnapshot;
            for (i = 0; i < values.length; ++i) {
                this.setObjectForStatement(stmt, index, values[i].getValue(), values[i].getJdbcType().getType());
                ++index;
            }
        }
    }

    public int bindValues(PreparedStatement stmt, ValueContainer[] values, int index) throws SQLException {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.setObjectForStatement(stmt, index, values[i].getValue(), values[i].getJdbcType().getType());
                ++index;
            }
        }
        return index;
    }

    public PreparedStatement getDeleteStatement(ClassDescriptor cld) throws PersistenceBrokerSQLException, PersistenceBrokerException {
        try {
            return cld.getStatementsForClass(this.m_conMan).getDeleteStmt(this.m_conMan.getConnection());
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException("Could not build statement ask for", e);
        }
        catch (LookupException e) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)e));
        }
    }

    public Statement getGenericStatement(ClassDescriptor cds, boolean scrollable) throws PersistenceBrokerException {
        try {
            return cds.getStatementsForClass(this.m_conMan).getGenericStmt(this.m_conMan.getConnection(), scrollable);
        }
        catch (LookupException e) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)e));
        }
    }

    public PreparedStatement getInsertStatement(ClassDescriptor cds) throws PersistenceBrokerSQLException, PersistenceBrokerException {
        try {
            return cds.getStatementsForClass(this.m_conMan).getInsertStmt(this.m_conMan.getConnection());
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException("Could not build statement ask for", e);
        }
        catch (LookupException e) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)e));
        }
    }

    public PreparedStatement getPreparedStatement(ClassDescriptor cds, String sql, boolean scrollable) throws PersistenceBrokerException {
        try {
            return cds.getStatementsForClass(this.m_conMan).getPreparedStmt(this.m_conMan.getConnection(), sql, scrollable);
        }
        catch (LookupException e) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)e));
        }
    }

    public PreparedStatement getSelectByPKStatement(ClassDescriptor cds) throws PersistenceBrokerSQLException, PersistenceBrokerException {
        try {
            return cds.getStatementsForClass(this.m_conMan).getSelectByPKStmt(this.m_conMan.getConnection());
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException("Could not build statement ask for", e);
        }
        catch (LookupException e) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)e));
        }
    }

    public PreparedStatement getUpdateStatement(ClassDescriptor cds) throws PersistenceBrokerSQLException, PersistenceBrokerException {
        try {
            return cds.getStatementsForClass(this.m_conMan).getUpdateStmt(this.m_conMan.getConnection());
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException("Could not build statement ask for", e);
        }
        catch (LookupException e) {
            throw new PersistenceBrokerException("Used ConnectionManager instance could not obtain a connection", (Throwable)((Object)e));
        }
    }

    protected ValueContainer[] getAllValues(ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        return this.m_broker.serviceBrokerHelper().getAllRwValues(cld, obj);
    }

    protected ValueContainer[] getKeyValues(PersistenceBroker broker, ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        return broker.serviceBrokerHelper().getKeyValues(cld, obj);
    }

    protected ValueContainer[] getKeyValues(PersistenceBroker broker, ClassDescriptor cld, Identity oid) throws PersistenceBrokerException {
        return broker.serviceBrokerHelper().getKeyValues(cld, oid);
    }

    protected ValueContainer[] getNonKeyValues(PersistenceBroker broker, ClassDescriptor cld, Object obj) throws PersistenceBrokerException {
        return broker.serviceBrokerHelper().getNonKeyRwValues(cld, obj);
    }

    private void bindProcedure(PreparedStatement stmt, ClassDescriptor cld, Object obj, ProcedureDescriptor proc) throws SQLException {
        int valueSub = 0;
        CallableStatement callable = null;
        if (stmt instanceof CallableStatement) {
            callable = (CallableStatement)stmt;
        }
        if (proc.hasReturnValue() && callable != null) {
            int jdbcType = proc.getReturnValueFieldRef().getJdbcType().getType();
            this.m_platform.setNullForStatement(stmt, valueSub + 1, jdbcType);
            callable.registerOutParameter(valueSub + 1, jdbcType);
            ++valueSub;
        }
        Iterator iterator = proc.getArguments().iterator();
        while (iterator.hasNext()) {
            ArgumentDescriptor arg = (ArgumentDescriptor)iterator.next();
            Object val = arg.getValue(obj);
            int jdbcType = arg.getJdbcType();
            this.setObjectForStatement(stmt, valueSub + 1, val, jdbcType);
            if (arg.getIsReturnedByProcedure() && callable != null) {
                callable.registerOutParameter(valueSub + 1, jdbcType);
            }
            ++valueSub;
        }
    }

    private void setObjectForStatement(PreparedStatement stmt, int index, Object value, int sqlType) throws SQLException {
        if (value == null) {
            this.m_platform.setNullForStatement(stmt, index, sqlType);
        } else {
            this.m_platform.setObjectForStatement(stmt, index, value, sqlType);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

