/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.ClassHelper;

public class RowReaderDefaultImpl
implements RowReader {
    private static final String OJB_CONCRETE_CLASS_KEY = "ojbTemporaryNoneColumnKey";
    private static final Object[] NO_ARGS = new Object[0];
    private ClassDescriptor m_cld;

    public RowReaderDefaultImpl(ClassDescriptor cld) {
        this.m_cld = cld;
    }

    public Object readObjectFrom(Map row) throws PersistenceBrokerException {
        ClassDescriptor cld = this.selectClassDescriptor(row);
        return this.buildOrRefreshObject(row, cld, null);
    }

    public void refreshObject(Object instance, Map row) {
        ClassDescriptor targetClassDescriptor = this.selectClassDescriptor(row);
        this.buildOrRefreshObject(row, targetClassDescriptor, instance);
    }

    protected Object buildOrRefreshObject(Map row, ClassDescriptor targetClassDescriptor, Object targetObject) {
        Method initializationMethod;
        Object result = targetObject;
        FieldDescriptor fmd = null;
        if (targetObject == null) {
            result = ClassHelper.buildNewObjectInstance(targetClassDescriptor);
        }
        FieldDescriptor[] fields = targetClassDescriptor.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            fmd = fields[i];
            fmd.getPersistentField().set(result, row.get(fmd.getColumnName()));
        }
        if (targetObject == null && (initializationMethod = targetClassDescriptor.getInitializationMethod()) != null) {
            try {
                initializationMethod.invoke(result, NO_ARGS);
            }
            catch (Exception ex) {
                throw new PersistenceBrokerException("Unable to invoke initialization method:" + initializationMethod.getName() + " for class:" + this.m_cld.getClassOfObject(), ex);
            }
        }
        return result;
    }

    public void readObjectArrayFrom(ResultSet rs, Map row) {
        FieldDescriptor[] fields = null;
        if (this.m_cld.getSuperClass() != null) {
            fields = this.m_cld.getFieldDescriptorsInHeirarchy();
        } else {
            String ojbConcreteClass = this.extractOjbConcreteClass(this.m_cld, rs);
            if (ojbConcreteClass != null) {
                row.put(OJB_CONCRETE_CLASS_KEY, ojbConcreteClass);
                ClassDescriptor cld = this.m_cld.getRepository().getDescriptorFor(ojbConcreteClass);
                fields = cld.getFieldDescriptions();
            } else {
                fields = this.m_cld.getFieldDescriptions();
            }
        }
        this.readValuesFrom(rs, row, fields);
    }

    public void readPkValuesFrom(ResultSet rs, Map row) {
        FieldDescriptor[] pkFields = this.m_cld.getPkFields();
        this.readValuesFrom(rs, row, pkFields);
    }

    protected void readValuesFrom(ResultSet rs, Map row, FieldDescriptor[] fields) {
        int size = fields.length;
        Object val = null;
        FieldDescriptor fld = null;
        try {
            for (int j = 0; j < size; ++j) {
                fld = fields[j];
                if (row.containsKey(fld.getColumnName())) continue;
                val = fld.getJdbcType().getObjectFromColumn(rs, fld.getColumnName());
                row.put(fld.getColumnName(), fld.getFieldConversion().sqlToJava(val));
            }
        }
        catch (SQLException t) {
            throw new PersistenceBrokerException("Error reading class type: " + this.m_cld.getClassNameOfObject() + " from result set, current read field was " + (fld != null ? fld.getPersistentField().getName() : null), t);
        }
    }

    protected String extractOjbConcreteClass(ClassDescriptor cld, ResultSet rs) {
        FieldDescriptor fld = this.m_cld.getOjbConcreteClassField();
        if (fld == null) {
            return null;
        }
        try {
            String result = (String)fld.getJdbcType().getObjectFromColumn(rs, fld.getColumnName());
            if (result == null || result.trim().length() == 0) {
                throw new PersistenceBrokerException("ojbConcreteClass field for class " + cld.getClassNameOfObject() + " returned null or 0-length string");
            }
            return result.trim();
        }
        catch (SQLException e) {
            throw new PersistenceBrokerException("Unexpected error while try to read 'ojbConcretClass' field from result set using column name " + fld.getColumnName() + " main class" + " was " + this.m_cld.getClassNameOfObject(), e);
        }
    }

    protected ClassDescriptor selectClassDescriptor(Map row) throws PersistenceBrokerException {
        ClassDescriptor result = this.m_cld;
        String ojbConcreteClass = (String)row.get(OJB_CONCRETE_CLASS_KEY);
        if (ojbConcreteClass != null && (result = this.m_cld.getRepository().getDescriptorFor(ojbConcreteClass)) == null) {
            throw new PersistenceBrokerException("Can't find class-descriptor for ojbConcreteClass '" + ojbConcreteClass + "', the main class was " + this.m_cld.getClassNameOfObject());
        }
        return result;
    }

    public void setClassDescriptor(ClassDescriptor cld) {
        this.m_cld = cld;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cld;
    }
}

