/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.IdentityFactory;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherImpl;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.collections.RemovalAwareCollection;

public class CollectionPrefetcher
extends RelationshipPrefetcherImpl {
    public CollectionPrefetcher(PersistenceBrokerImpl aBroker, ObjectReferenceDescriptor anOrd) {
        super(aBroker, anOrd);
    }

    protected Query[] buildPrefetchQueries(Collection owners, Collection children) {
        ClassDescriptor cld = this.getOwnerClassDescriptor();
        Class topLevelClass = this.getBroker().getTopLevelClass(cld.getClassOfObject());
        BrokerHelper helper = this.getBroker().serviceBrokerHelper();
        ArrayList<Query> queries = new ArrayList<Query>(owners.size());
        HashSet<Identity> idsSubset = new HashSet<Identity>(owners.size());
        Iterator iter = owners.iterator();
        while (iter.hasNext()) {
            Object owner = iter.next();
            Object[] fkValues = helper.extractValueArray(helper.getKeyValues(cld, owner));
            Identity id = new Identity(null, topLevelClass, fkValues);
            idsSubset.add(id);
            if (idsSubset.size() != this.pkLimit) continue;
            queries.add(this.buildPrefetchQuery(idsSubset));
            idsSubset.clear();
        }
        if (idsSubset.size() > 0) {
            queries.add(this.buildPrefetchQuery(idsSubset));
        }
        return queries.toArray(new Query[queries.size()]);
    }

    protected Query buildPrefetchQuery(Collection ids) {
        CollectionDescriptor cds = this.getCollectionDescriptor();
        QueryByCriteria query = this.buildPrefetchQuery(ids, cds.getForeignKeyFieldDescriptors(this.getItemClassDescriptor()));
        if (!cds.getOrderBy().isEmpty()) {
            Iterator iter = cds.getOrderBy().iterator();
            while (iter.hasNext()) {
                query.addOrderBy((FieldHelper)iter.next());
            }
        }
        return query;
    }

    protected void associateBatched(Collection owners, Collection children) {
        CollectionDescriptor cds = this.getCollectionDescriptor();
        PersistentField field = cds.getPersistentField();
        PersistenceBrokerImpl pb = this.getBroker();
        Class ownerTopLevelClass = pb.getTopLevelClass(this.getOwnerClassDescriptor().getClassOfObject());
        Class collectionClass = cds.getCollectionClass();
        HashMap ownerIdsToLists = new HashMap(owners.size());
        IdentityFactory identityFactory = pb.serviceIdentity();
        Iterator it = owners.iterator();
        while (it.hasNext()) {
            Object owner = it.next();
            ownerIdsToLists.put(identityFactory.buildIdentity(this.getOwnerClassDescriptor(), owner), new ArrayList());
        }
        it = children.iterator();
        while (it.hasNext()) {
            ClassDescriptor cld;
            Object child = it.next();
            Object[] fkValues = cds.getForeignKeyValues(child, cld = this.getDescriptorRepository().getDescriptorFor(ProxyHelper.getRealClass(child)));
            Identity ownerId = identityFactory.buildIdentity(null, ownerTopLevelClass, fkValues);
            List list = (List)ownerIdsToLists.get(ownerId);
            if (list == null) continue;
            list.add(child);
        }
        it = owners.iterator();
        while (it.hasNext()) {
            Object value;
            Object result;
            Object owner = it.next();
            Identity ownerId = identityFactory.buildIdentity(owner);
            List list = (List)ownerIdsToLists.get(ownerId);
            if (collectionClass == null && field.getType().isArray()) {
                int length = list.size();
                Class<?> itemtype = field.getType().getComponentType();
                result = Array.newInstance(itemtype, length);
                for (int j = 0; j < length; ++j) {
                    Array.set(result, j, list.get(j));
                }
            } else {
                ManageableCollection col = this.createCollection(collectionClass);
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    col.ojbAdd(it2.next());
                }
                result = col;
            }
            if ((value = field.get(owner)) instanceof CollectionProxyDefaultImpl && result instanceof Collection) {
                ((CollectionProxyDefaultImpl)value).setData((Collection)result);
                continue;
            }
            field.set(owner, result);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ManageableCollection createCollection(Class collectionClass) {
        void var2_2;
        ManageableCollection col;
        if (collectionClass == null) {
            col = new RemovalAwareCollection();
        } else {
            try {
                col = (ManageableCollection)collectionClass.newInstance();
            }
            catch (Exception e) {
                throw new OJBRuntimeException("Can't create new Collection for owner", e);
            }
        }
        return var2_2;
    }

    protected CollectionDescriptor getCollectionDescriptor() {
        return (CollectionDescriptor)this.getObjectReferenceDescriptor();
    }
}

