/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard.internal.convert;

import android.content.ContentValues;
import android.database.Cursor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import nl.qbusict.cupboard.Cupboard;
import nl.qbusict.cupboard.convert.EntityConverter;
import nl.qbusict.cupboard.convert.FieldConverter;
import nl.qbusict.cupboard.convert.FieldConverterFactory;

public class EnumFieldConverterFactory
implements FieldConverterFactory {
    @Override
    public FieldConverter<?> create(Cupboard cupboard, Type type) {
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Enum.class) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        if (!(type instanceof Class)) {
            return null;
        }
        Class clz = (Class)type;
        if (clz.isEnum()) {
            return new EnumConverter(clz);
        }
        return null;
    }

    private static class EnumConverter<E extends Enum>
    implements FieldConverter<E> {
        private final Class<E> mEnumClass;

        public EnumConverter(Class<E> enumClass) {
            this.mEnumClass = enumClass;
        }

        @Override
        public E fromCursorValue(Cursor cursor, int columnIndex) {
            return Enum.valueOf(this.mEnumClass, cursor.getString(columnIndex));
        }

        @Override
        public void toContentValue(E value, String key, ContentValues values) {
            values.put(key, ((Enum)value).toString());
        }

        @Override
        public EntityConverter.ColumnType getColumnType() {
            return EntityConverter.ColumnType.TEXT;
        }
    }
}

