/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nl.qbusict.cupboard.annotation.CompositeIndex;
import nl.qbusict.cupboard.annotation.Index;

public class IndexStatement {
    public static final String INDEX_PREFIX = "_cb";
    public final boolean mIsUnique;
    public final String[] mColumnNames;
    public final boolean[] mAscendings;
    public final String mIndexName;

    public IndexStatement(boolean isUnique, String[] columnNames, boolean[] ascendings, String indexName) {
        this.mIsUnique = isUnique;
        this.mColumnNames = columnNames;
        this.mAscendings = ascendings;
        this.mIndexName = indexName;
    }

    public String getCreationSql(String table) {
        return this.getCreationSql(table, true);
    }

    public String getCreationSql(String table, boolean includeIfNotExists) {
        StringBuilder sb = new StringBuilder("create ");
        if (this.mIsUnique) {
            sb.append("unique ");
        }
        sb.append("index ");
        if (includeIfNotExists) {
            sb.append("if not exists ");
        }
        sb.append(INDEX_PREFIX).append(this.mIndexName).append(" on %s (");
        int size = this.mColumnNames.length;
        sb.append('\'').append(this.mColumnNames[0]).append("' ").append(this.mAscendings[0] ? "ASC" : "DESC");
        for (int i = 1; i < size; ++i) {
            sb.append(", '").append(this.mColumnNames[i]).append("' ").append(this.mAscendings[i] ? "ASC" : "DESC");
        }
        sb.append(')');
        return String.format(sb.toString(), table, includeIfNotExists);
    }

    public static class Builder {
        public static final String GENERATED_INDEX_NAME = "%s_%s";
        Map<String, Set<IndexColumnMetadata>> indexes = new HashMap<String, Set<IndexColumnMetadata>>();
        Map<String, Set<IndexColumnMetadata>> uniqueIndexes = new HashMap<String, Set<IndexColumnMetadata>>();

        public void addIndexedColumn(String table, String name, Index index) {
            boolean added = false;
            if (index.indexNames().length != 0) {
                this.addCompositeIndexes(name, this.indexes, index.indexNames());
                added = true;
            }
            if (index.uniqueNames().length != 0) {
                this.addCompositeIndexes(name, this.uniqueIndexes, index.uniqueNames());
                added = true;
            }
            if (!added) {
                boolean unique = index.unique();
                this.addCompositeIndex(name, unique ? this.uniqueIndexes : this.indexes, true, 0, String.format(GENERATED_INDEX_NAME, table, name));
            }
        }

        private void addCompositeIndexes(String name, Map<String, Set<IndexColumnMetadata>> collectionToAdd, CompositeIndex[] composites) {
            for (CompositeIndex ci : composites) {
                this.addCompositeIndex(name, collectionToAdd, ci.ascending(), ci.order(), ci.indexName());
            }
        }

        private void addCompositeIndex(String columnName, Map<String, Set<IndexColumnMetadata>> collectionToAdd, boolean ascending, int order, String indexName) {
            IndexColumnMetadata indexColumnMetadata;
            Set<IndexColumnMetadata> set = collectionToAdd.get(indexName);
            if (set == null) {
                set = new HashSet<IndexColumnMetadata>();
                collectionToAdd.put(indexName, set);
            }
            if (!set.add(indexColumnMetadata = new IndexColumnMetadata(columnName, ascending, order))) {
                throw new IllegalArgumentException(String.format("Column '%s' has two indexes with the same name %s", columnName, indexName));
            }
        }

        public List<IndexStatement> build() {
            String indexName;
            ArrayList<IndexStatement> indexStatements = new ArrayList<IndexStatement>();
            HashSet<String> indexNames = new HashSet<String>();
            for (Map.Entry<String, Set<IndexColumnMetadata>> indexEntry : this.indexes.entrySet()) {
                indexName = indexEntry.getKey();
                indexNames.add(indexName);
                this.addStatementToList(indexName, false, indexStatements, indexEntry.getValue());
            }
            for (Map.Entry<String, Set<IndexColumnMetadata>> indexEntry : this.uniqueIndexes.entrySet()) {
                indexName = indexEntry.getKey();
                if (!indexNames.add(indexName)) {
                    throw new IllegalArgumentException(String.format("There are both unique and non-unique indexes with the same name : %s", indexName));
                }
                this.addStatementToList(indexName, true, indexStatements, indexEntry.getValue());
            }
            return indexStatements;
        }

        public Map<String, IndexStatement> buildAsMap() {
            HashMap<String, IndexStatement> map = new HashMap<String, IndexStatement>();
            for (IndexStatement is : this.build()) {
                map.put(is.mIndexName, is);
            }
            return map;
        }

        public void addStatementToList(String indexName, boolean unique, List<IndexStatement> indexStatements, Set<IndexColumnMetadata> metadatas) {
            ArrayList<IndexColumnMetadata> columnMetadatas = new ArrayList<IndexColumnMetadata>(metadatas);
            Collections.sort(columnMetadatas);
            int size = columnMetadatas.size();
            String[] columnNames = new String[size];
            boolean[] ascendingColumns = new boolean[size];
            for (int i = 0; i < size; ++i) {
                IndexColumnMetadata indexColumnMetadata = (IndexColumnMetadata)columnMetadatas.get(i);
                columnNames[i] = indexColumnMetadata.mColumnName;
                ascendingColumns[i] = indexColumnMetadata.mAscending;
            }
            indexStatements.add(new IndexStatement(unique, columnNames, ascendingColumns, indexName));
        }

        class IndexColumnMetadata
        implements Comparable<IndexColumnMetadata> {
            String mColumnName;
            boolean mAscending;
            int mOrder;

            public IndexColumnMetadata(String columnName, boolean ascending, int order) {
                this.mColumnName = columnName;
                this.mAscending = ascending;
                this.mOrder = order;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.mColumnName == null ? 0 : this.mColumnName.hashCode());
                return result;
            }

            @Override
            public int compareTo(IndexColumnMetadata another) {
                if (this.mOrder < another.mOrder) {
                    return -1;
                }
                if (this.mOrder > another.mOrder) {
                    return 1;
                }
                throw new IllegalArgumentException(String.format("Columns '%s' and '%s' cannot have the same composite index order %d", this.mColumnName, another.mColumnName, this.mOrder));
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                IndexColumnMetadata other = (IndexColumnMetadata)obj;
                return !(this.mColumnName == null ? other.mColumnName != null : !this.mColumnName.equals(other.mColumnName));
            }
        }
    }
}

