/*
 * Decompiled with CFR 0.152.
 */
package nl.qbusict.cupboard;

import android.content.ContentProviderOperation;
import android.content.ContentUris;
import android.content.ContentValues;
import android.net.Uri;
import java.util.ArrayList;
import nl.qbusict.cupboard.BaseCompartment;
import nl.qbusict.cupboard.Cupboard;
import nl.qbusict.cupboard.convert.EntityConverter;

public class ProviderOperationsCompartment
extends BaseCompartment {
    private final ArrayList<ContentProviderOperation> mOperations;
    private boolean mYieldAllowed = false;
    private int mYieldAfter = -1;

    protected ProviderOperationsCompartment(Cupboard cupboard, ArrayList<ContentProviderOperation> operations) {
        super(cupboard);
        this.mOperations = operations;
    }

    public <T> ProviderOperationsCompartment put(Uri uri, T entity) {
        EntityConverter<?> converter = this.getConverter(entity.getClass());
        ContentValues values = new ContentValues(converter.getColumns().size());
        converter.toValues(entity, values);
        Long id = converter.getId(entity);
        if (id == null) {
            this.mOperations.add(ContentProviderOperation.newInsert((Uri)uri).withValues(values).withYieldAllowed(this.shouldYield()).build());
        } else {
            this.mOperations.add(ContentProviderOperation.newInsert((Uri)ContentUris.withAppendedId((Uri)uri, (long)id)).withYieldAllowed(this.shouldYield()).withValues(values).build());
        }
        this.mYieldAllowed = false;
        return this;
    }

    public ProviderOperationsCompartment yield() {
        this.mYieldAllowed = true;
        return this;
    }

    public ProviderOperationsCompartment yieldAfter(int operationCount) {
        this.mYieldAfter = operationCount;
        return this;
    }

    public <T> ProviderOperationsCompartment put(Uri uri, Class<T> entityClass, T ... entities) {
        int i;
        boolean mWasYieldAllowed = this.mYieldAllowed;
        this.mYieldAllowed = false;
        EntityConverter<T> converter = this.getConverter(entityClass);
        ContentValues[] values = new ContentValues[entities.length];
        int size = converter.getColumns().size();
        for (i = 0; i < entities.length; ++i) {
            values[i] = new ContentValues(size);
            converter.toValues(entities[i], values[i]);
        }
        for (i = 0; i < entities.length; ++i) {
            if (i == entities.length - 1) {
                this.mYieldAllowed = mWasYieldAllowed;
            }
            this.put(uri, entities[i]);
        }
        return this;
    }

    public <T> ProviderOperationsCompartment delete(Uri uri, T entity) {
        EntityConverter<?> converter = this.getConverter(entity.getClass());
        Long id = converter.getId(entity);
        if (id == null) {
            return this;
        }
        this.mOperations.add(ContentProviderOperation.newDelete((Uri)ContentUris.withAppendedId((Uri)uri, (long)id)).withYieldAllowed(this.mYieldAllowed).build());
        return this;
    }

    public ArrayList<ContentProviderOperation> getOperations() {
        return this.mOperations;
    }

    private boolean shouldYield() {
        return this.mYieldAllowed || this.mYieldAfter > 0 && this.mOperations.size() + 1 >= this.mYieldAfter && (this.mOperations.size() + 1) % this.mYieldAfter == 0;
    }
}

