/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.common.error.http.badRequest;

import java.util.HashMap;
import java.util.Map;

public enum BadRequestType {
    PARAM_KEY("Missing api key", "PARAM_KEY"),
    PARAM_SESSION_ID("Missing sessionId", "PARAM_SESSION_ID"),
    PARAM_IMAGE_BASE64("Unknown imgBase64 param value.", "PARAM_IMAGE_BASE64"),
    PARAM_URL("Unknown url param value.", "PARAM_URL"),
    PARAM_DESCRIPTION("Unknown description param value.", "PARAM_DESCRIPTION"),
    PARAM_DESCRIPTION_LENGTH(String.format("Description param value too long (max %d chars).", 255), "PARAM_DESCRIPTION_LENGTH"),
    PARAM_COMMENT("Unknown comment text param value.", "PARAM_COMMENT"),
    PARAM_COMMENT_LENGTH(String.format("Comment text param value too long (max %d chars).", 255), "PARAM_COMMENT_LENGTH"),
    PARAM_TITLE("Unknown title param value.", "PARAM_TITLE"),
    PARAM_TITLE_LENGTH(String.format("Title param value too long (max %d chars).", 50), "PARAM_TITLE_LENGTH"),
    PARAM_PAGE_NUMBER("Unknown page param value.", "PARAM_PAGE_NUMBER"),
    PARAM_PAGE_LIMIT("Unknown limit param value.", "PARAM_PAGE_LIMIT"),
    PARAM_RATE("Unknown rate param value (must be 1 or -1)", "PARAM_RATE"),
    PARAM_USER_EMAIL("Invalid email value", "PARAM_USER_EMAIL"),
    PARAM_USER_EMAIL_LENGTH(String.format("Email param value too long (max %d chars).", 100), "PARAM_USER_EMAIL_LENGTH"),
    PARAM_USER_NAME("Invalid userName value", "PARAM_USER_NAME"),
    PARAM_USER_NAME_LENGTH(String.format("UserName param value too long (max %d chars).", 25), "PARAM_USER_NAME_LENGTH"),
    PARAM_PHOTO_ID("Invalid photoId value", "PARAM_PHOTO_ID"),
    PARAM_IMAGE_MIME_TYPE("Given mime type is not supported", "IMAGE_MIME_TYPE"),
    PARAM_IMAGE_CONTENT("Something wrong with image", "IMAGE_CONTENT"),
    PARAM_IMAGE_CONTENT_SIZE("Image is too big", "IMAGE_CONTENT_SIZE");

    private final String message;
    private final String errorCode;
    private static Map<String, BadRequestType> map;

    private BadRequestType(String message, String errorCode) {
        this.message = message;
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public static BadRequestType get(String errorCode) {
        return map.get(errorCode);
    }

    static {
        map = new HashMap<String, BadRequestType>(BadRequestType.values().length);
        for (BadRequestType type : BadRequestType.values()) {
            map.put(type.errorCode, type);
        }
    }
}

