/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jett.model.Block;
import net.sf.jett.model.ExcelColor;
import net.sf.jett.model.PastEndAction;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.Tag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.FormulaUtil;
import net.sf.jett.util.RichTextStringUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetUtil {
    private static final boolean DEBUG = false;
    private static final BigDecimal BD_MAX_DOUBLE = new BigDecimal(Double.MAX_VALUE);
    private static final double MIN_NORMAL = Double.longBitsToDouble(0x10000000000000L);
    private static final BigDecimal BD_MIN_DOUBLE = new BigDecimal(MIN_NORMAL);
    private static final BigInteger BI_MAX_DOUBLE = BD_MAX_DOUBLE.toBigInteger();
    private static final Pattern POSSIBLE_VARIABLES = Pattern.compile("[A-Za-z0-9_]+");

    private static void copyColumnWidthsLeft(Sheet sheet, int colStart, int colEnd, int numCols) {
        for (int colNum = colStart; colNum <= colEnd; ++colNum) {
            int newColNum = colNum - numCols;
            sheet.setColumnWidth(newColNum, sheet.getColumnWidth(colNum));
        }
    }

    private static void copyColumnWidthsRight(Sheet sheet, int colStart, int colEnd, int numCols) {
        for (int colNum = colEnd; colNum >= colStart; --colNum) {
            int newColNum = colNum + numCols;
            sheet.setColumnWidth(newColNum, sheet.getColumnWidth(colNum));
        }
    }

    public static int getLastPopulatedColIndex(Sheet sheet) {
        int maxCol = -1;
        for (Row row : sheet) {
            int lastCol = row.getLastCellNum() - 1;
            if (lastCol <= maxCol) continue;
            maxCol = lastCol;
        }
        return maxCol;
    }

    private static void copyRowHeightsUp(Sheet sheet, int rowStart, int rowEnd, int numRows) {
        for (int rowNum = rowStart; rowNum <= rowEnd; ++rowNum) {
            int newRowNum = rowNum - numRows;
            Row row = sheet.getRow(rowNum);
            Row newRow = sheet.getRow(newRowNum);
            if (row == null && newRow != null) {
                newRow.setHeight(sheet.getDefaultRowHeight());
                continue;
            }
            if (row == null) continue;
            if (newRow == null) {
                newRow = sheet.createRow(newRowNum);
            }
            newRow.setHeight(row.getHeight());
        }
    }

    private static void copyRowHeightsDown(Sheet sheet, int rowStart, int rowEnd, int numRows) {
        for (int rowNum = rowEnd; rowNum >= rowStart; --rowNum) {
            int newRowNum = rowNum + numRows;
            Row row = sheet.getRow(rowNum);
            Row newRow = sheet.getRow(newRowNum);
            if (row == null && newRow != null) {
                newRow.setHeight(sheet.getDefaultRowHeight());
                continue;
            }
            if (row == null) continue;
            if (newRow == null) {
                newRow = sheet.createRow(newRowNum);
            }
            newRow.setHeight(row.getHeight());
        }
    }

    private static void shiftCellsLeft(Sheet sheet, TagContext context, WorkbookContext workbookContext, int colStart, int colEnd, int rowStart, int rowEnd, int numCols) {
        Map<String, String> tagLocationsMap = workbookContext.getTagLocationsMap();
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) continue;
            for (int colIndex = colStart; colIndex <= colEnd; ++colIndex) {
                Cell cell = row.getCell(colIndex);
                int newColIndex = colIndex - numCols;
                Cell newCell = row.getCell(newColIndex);
                if (cell == null && newCell != null) {
                    SheetUtil.removeCell(row, newCell);
                    continue;
                }
                if (cell == null) continue;
                if (newCell == null) {
                    newCell = row.createCell(newColIndex);
                }
                SheetUtil.copyCell(cell, newCell);
                String cellRef = SheetUtil.getCellKey(cell);
                String newCellRef = SheetUtil.getCellKey(newCell);
                String origCellRef = tagLocationsMap.get(cellRef);
                if (origCellRef != null) {
                    tagLocationsMap.remove(cellRef);
                    tagLocationsMap.put(newCellRef, origCellRef);
                }
                if (colIndex <= colEnd - numCols || colIndex > colEnd) continue;
                SheetUtil.removeCell(row, cell);
            }
        }
        SheetUtil.shiftMergedRegionsInRange(context, colStart, colEnd, rowStart, rowEnd, -numCols, 0, true, true);
    }

    private static void shiftCellsRight(Sheet sheet, TagContext context, WorkbookContext workbookContext, int colStart, int colEnd, int rowStart, int rowEnd, int numCols) {
        Map<String, String> tagLocationsMap = workbookContext.getTagLocationsMap();
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            Row row = sheet.getRow(rowIndex);
            if (row == null) continue;
            for (int colIndex = colEnd; colIndex >= colStart; --colIndex) {
                Cell cell = row.getCell(colIndex);
                int newColIndex = colIndex + numCols;
                Cell newCell = row.getCell(newColIndex);
                if (cell == null && newCell != null) {
                    SheetUtil.removeCell(row, newCell);
                    continue;
                }
                if (cell == null) continue;
                if (newCell == null) {
                    newCell = row.createCell(newColIndex);
                }
                SheetUtil.copyCell(cell, newCell);
                String cellRef = SheetUtil.getCellKey(cell);
                String newCellRef = SheetUtil.getCellKey(newCell);
                String origCellRef = tagLocationsMap.get(cellRef);
                if (origCellRef != null) {
                    tagLocationsMap.remove(cellRef);
                    tagLocationsMap.put(newCellRef, origCellRef);
                }
                if (colIndex >= colStart + numCols || colIndex > colEnd) continue;
                SheetUtil.removeCell(row, cell);
            }
        }
        SheetUtil.shiftMergedRegionsInRange(context, colStart, colEnd, rowStart, rowEnd, numCols, 0, true, true);
    }

    private static void shiftCellsUp(Sheet sheet, TagContext context, WorkbookContext workbookContext, int colStart, int colEnd, int rowStart, int rowEnd, int numRows) {
        Map<String, String> tagLocationsMap = workbookContext.getTagLocationsMap();
        for (int colIndex = colStart; colIndex <= colEnd; ++colIndex) {
            for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
                int newRowIndex = rowIndex - numRows;
                Row oldRow = sheet.getRow(rowIndex);
                Row newRow = sheet.getRow(newRowIndex);
                Cell cell = null;
                if (oldRow != null) {
                    cell = oldRow.getCell(colIndex);
                }
                Cell newCell = null;
                if (newRow != null) {
                    newCell = newRow.getCell(colIndex);
                }
                if (cell == null && newRow != null && newCell != null) {
                    SheetUtil.removeCell(newRow, newCell);
                    continue;
                }
                if (cell == null) continue;
                if (newRow == null) {
                    newRow = sheet.createRow(newRowIndex);
                }
                if (newCell == null) {
                    newCell = newRow.createCell(colIndex);
                }
                SheetUtil.copyCell(cell, newCell);
                String cellRef = SheetUtil.getCellKey(cell);
                String newCellRef = SheetUtil.getCellKey(newCell);
                String origCellRef = tagLocationsMap.get(cellRef);
                if (origCellRef != null) {
                    tagLocationsMap.remove(cellRef);
                    tagLocationsMap.put(newCellRef, origCellRef);
                }
                if (rowIndex <= rowEnd - numRows || rowIndex > rowEnd) continue;
                SheetUtil.removeCell(oldRow, cell);
            }
        }
        SheetUtil.shiftMergedRegionsInRange(context, colStart, colEnd, rowStart, rowEnd, 0, -numRows, true, true);
    }

    private static void shiftCellsDown(Sheet sheet, TagContext context, WorkbookContext workbookContext, int colStart, int colEnd, int rowStart, int rowEnd, int numRows) {
        Map<String, String> tagLocationsMap = workbookContext.getTagLocationsMap();
        for (int rowIndex = rowEnd; rowIndex >= rowStart; --rowIndex) {
            Row newRow;
            int newRowIndex = rowIndex + numRows;
            Row oldRow = sheet.getRow(rowIndex);
            if (oldRow == null) {
                oldRow = sheet.createRow(rowIndex);
            }
            if ((newRow = sheet.getRow(newRowIndex)) == null) {
                newRow = sheet.createRow(newRowIndex);
            }
            for (int colIndex = colStart; colIndex <= colEnd; ++colIndex) {
                Cell newCell;
                Cell cell = oldRow.getCell(colIndex);
                if (cell == null) {
                    cell = oldRow.createCell(colIndex);
                }
                if ((newCell = newRow.getCell(colIndex)) == null) {
                    newCell = newRow.createCell(colIndex);
                }
                SheetUtil.copyCell(cell, newCell);
                String cellRef = SheetUtil.getCellKey(cell);
                String newCellRef = SheetUtil.getCellKey(newCell);
                String origCellRef = tagLocationsMap.get(cellRef);
                if (origCellRef != null) {
                    tagLocationsMap.remove(cellRef);
                    tagLocationsMap.put(newCellRef, origCellRef);
                }
                if (rowIndex >= rowStart + numRows || rowIndex > rowEnd) continue;
                SheetUtil.removeCell(oldRow, cell);
            }
        }
        SheetUtil.shiftMergedRegionsInRange(context, colStart, colEnd, rowStart, rowEnd, 0, numRows, true, true);
    }

    private static void removeCell(Row row, Cell cell) {
        cell.removeCellComment();
        row.removeCell(cell);
    }

    private static void copyCell(Cell oldCell, Cell newCell) {
        newCell.setCellStyle(oldCell.getCellStyle());
        switch (oldCell.getCellType()) {
            case 1: {
                newCell.setCellValue(oldCell.getRichStringCellValue());
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 2: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
        }
    }

    public static Object setCellValue(Cell cell, Object value) {
        return SheetUtil.setCellValue(cell, value, null);
    }

    public static Object setCellValue(Cell cell, Object value, RichTextString origRichString) {
        CreationHelper helper = cell.getSheet().getWorkbook().getCreationHelper();
        Object newValue = value;
        boolean applyStyle = true;
        if (value == null) {
            newValue = helper.createRichTextString("");
            cell.setCellValue((RichTextString)newValue);
            cell.setCellType(3);
        } else if (value instanceof String) {
            newValue = helper.createRichTextString(value.toString());
            cell.setCellValue((RichTextString)newValue);
            applyStyle = false;
        } else if (value instanceof RichTextString) {
            cell.setCellValue((RichTextString)value);
            applyStyle = false;
        } else if (value instanceof Double) {
            cell.setCellValue(((Double)value).doubleValue());
        } else if (value instanceof Integer) {
            cell.setCellValue((double)((Integer)value).intValue());
        } else if (value instanceof Float) {
            cell.setCellValue((double)((Float)value).floatValue());
        } else if (value instanceof Long) {
            cell.setCellValue((double)((Long)value).longValue());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else if (value instanceof Calendar) {
            cell.setCellValue((Calendar)value);
        } else if (value instanceof Short) {
            cell.setCellValue((double)((Short)value).shortValue());
        } else if (value instanceof Byte) {
            cell.setCellValue((double)((Byte)value).byteValue());
        } else if (value instanceof Boolean) {
            cell.setCellValue(((Boolean)value).booleanValue());
        } else if (value instanceof BigInteger) {
            BigInteger bi = (BigInteger)value;
            BigInteger abs = bi.abs();
            if (abs.compareTo(BI_MAX_DOUBLE) <= 0) {
                cell.setCellValue(bi.doubleValue());
            } else {
                cell.setCellValue(bi.toString());
            }
        } else if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            BigDecimal abs = bd.abs();
            if (abs.compareTo(BigDecimal.ZERO) == 0 || abs.compareTo(BD_MIN_DOUBLE) >= 0 && abs.compareTo(BD_MAX_DOUBLE) <= 0) {
                cell.setCellValue(bd.doubleValue());
            } else {
                cell.setCellValue(bd.toString());
            }
        } else {
            newValue = helper.createRichTextString(value.toString());
            cell.setCellValue((RichTextString)newValue);
            applyStyle = false;
        }
        if (applyStyle) {
            RichTextStringUtil.applyFont(origRichString, cell);
        }
        return newValue;
    }

    public static boolean isCellBlank(Sheet sheet, int rowNum, int colNum) {
        Row r = sheet.getRow(rowNum);
        if (r == null) {
            return true;
        }
        Cell c = r.getCell(colNum);
        return c == null || c.getCellType() == 3 || c.getCellType() == 1 && "".equals(c.getStringCellValue());
    }

    public static boolean isCellBlank(Row r, int colNum) {
        Cell c = r.getCell(colNum);
        return c == null || c.getCellType() == 3 || c.getCellType() == 1 && "".equals(c.getStringCellValue());
    }

    public static String getCellKey(Cell cell) {
        StringBuilder buf = new StringBuilder();
        buf.append(cell.getSheet().getSheetName());
        buf.append("!");
        buf.append(CellReference.convertNumToColString((int)cell.getColumnIndex()));
        buf.append(cell.getRowIndex() + 1);
        return buf.toString();
    }

    private static void shiftMergedRegionsInRange(TagContext context, int left, int right, int top, int bottom, int numCols, int numRows, boolean remove, boolean add) {
        if (numCols == 0 && numRows == 0 && remove && add) {
            return;
        }
        List<CellRangeAddress> sheetMergedRegions = context.getMergedRegions();
        if (add) {
            int numMergedRegions = sheetMergedRegions.size();
            for (int i = 0; i < numMergedRegions; ++i) {
                CellRangeAddress region = sheetMergedRegions.get(i);
                if (!SheetUtil.isCellAddressWhollyContained(region, left, right, top, bottom)) continue;
                CellRangeAddress newRegion = new CellRangeAddress(region.getFirstRow() + numRows, region.getLastRow() + numRows, region.getFirstColumn() + numCols, region.getLastColumn() + numCols);
                if (remove) {
                    sheetMergedRegions.set(i, newRegion);
                    continue;
                }
                sheetMergedRegions.add(newRegion);
            }
        } else if (remove) {
            int numMergedRegions = sheetMergedRegions.size();
            ArrayList<CellRangeAddress> regionsToRemove = new ArrayList<CellRangeAddress>();
            for (int i = 0; i < numMergedRegions; ++i) {
                CellRangeAddress region = sheetMergedRegions.get(i);
                if (!SheetUtil.isCellAddressWhollyContained(region, left, right, top, bottom)) continue;
                regionsToRemove.add(region);
            }
            if (!regionsToRemove.isEmpty()) {
                sheetMergedRegions.removeAll(regionsToRemove);
            }
        }
    }

    private static boolean isCellAddressWhollyContained(CellRangeAddress mergedRegion, int left, int right, int top, int bottom) {
        return mergedRegion.getFirstRow() >= top && mergedRegion.getLastRow() <= bottom && mergedRegion.getFirstColumn() >= left && mergedRegion.getLastColumn() <= right;
    }

    public static void deleteBlock(Sheet sheet, TagContext tagContext, Block block, WorkbookContext context) {
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        Map<String, String> tagLocationsMap = context.getTagLocationsMap();
        for (int rowNum = top; rowNum <= bottom; ++rowNum) {
            Row r = sheet.getRow(rowNum);
            if (r == null) continue;
            for (int cellNum = left; cellNum <= right; ++cellNum) {
                Cell c = r.getCell(cellNum);
                if (c == null) continue;
                String cellRef = SheetUtil.getCellKey(c);
                SheetUtil.removeCell(r, c);
                tagLocationsMap.remove(cellRef);
            }
        }
        SheetUtil.shiftMergedRegionsInRange(tagContext, left, right, top, bottom, 0, 0, true, false);
        FormulaUtil.shiftCellReferencesInRange(sheet.getSheetName(), context, left, right, top, bottom, 0, 0, true, false);
    }

    public static void clearBlock(Sheet sheet, Block block, WorkbookContext context) {
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        Map<String, String> tagLocationsMap = context.getTagLocationsMap();
        for (int rowNum = top; rowNum <= bottom; ++rowNum) {
            Row r = sheet.getRow(rowNum);
            if (r == null) continue;
            for (int cellNum = left; cellNum <= right; ++cellNum) {
                Cell c = r.getCell(cellNum);
                if (c == null) continue;
                String cellRef = SheetUtil.getCellKey(c);
                c.setCellType(3);
                tagLocationsMap.remove(cellRef);
            }
        }
        FormulaUtil.shiftCellReferencesInRange(sheet.getSheetName(), context, left, right, top, bottom, 0, 0, true, false);
    }

    public static void takePastEndAction(Sheet sheet, Block block, List<String> pastEndRefs, PastEndAction pastEndAction, String replacementValue) {
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        if (pastEndRefs == null || pastEndRefs.size() == 0) {
            return;
        }
        for (int rowNum = top; rowNum <= bottom; ++rowNum) {
            Row r = sheet.getRow(rowNum);
            if (r == null) continue;
            for (int cellNum = left; cellNum <= right; ++cellNum) {
                Cell c = r.getCell(cellNum);
                if (c == null) continue;
                SheetUtil.takePastEndActionOnCell(c, pastEndRefs, pastEndAction, replacementValue);
            }
        }
    }

    private static void takePastEndActionOnCell(Cell cell, List<String> pastEndRefs, PastEndAction pastEndAction, String replacementValue) {
        boolean takeAction = false;
        if (cell.getCellType() == 1) {
            for (String pastEndRef : pastEndRefs) {
                String strValue = cell.getStringCellValue();
                if (strValue == null || strValue.indexOf(pastEndRef) < 0) continue;
                takeAction = true;
                break;
            }
        }
        if (takeAction) {
            switch (pastEndAction) {
                case CLEAR_CELL: {
                    cell.setCellType(3);
                    break;
                }
                case REMOVE_CELL: {
                    SheetUtil.removeCell(cell.getRow(), cell);
                    break;
                }
                case REPLACE_EXPR: {
                    if (cell.getCellType() != 1) break;
                    CreationHelper helper = cell.getSheet().getWorkbook().getCreationHelper();
                    RichTextString rts = cell.getRichStringCellValue();
                    String cellText = rts.getString();
                    int exprBegin = cellText.indexOf("${");
                    int exprEnd = cellText.indexOf("}");
                    while (exprBegin != -1 && exprEnd != -1 && exprEnd > exprBegin) {
                        String expression = cellText.substring(exprBegin + "${".length(), exprEnd - 1 + "}".length());
                        boolean nullExpr = false;
                        Matcher m = POSSIBLE_VARIABLES.matcher(expression);
                        while (m.find()) {
                            String possibleVariable = m.group();
                            if (Character.isDigit(possibleVariable.charAt(0)) || !pastEndRefs.contains(possibleVariable)) continue;
                            nullExpr = true;
                            break;
                        }
                        if (nullExpr) {
                            String remove = cellText.substring(exprBegin, exprEnd + "}".length());
                            rts = RichTextStringUtil.replaceAll(rts, helper, remove, replacementValue);
                            cell.setCellValue(rts);
                            cellText = rts.getString();
                            exprBegin = cellText.indexOf("${", exprBegin);
                        } else {
                            exprBegin = cellText.indexOf("${", exprEnd + 1);
                        }
                        exprEnd = cellText.indexOf("}", exprBegin);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown PastEndAction: " + (Object)((Object)pastEndAction));
                }
            }
        }
    }

    public static void removeBlock(Sheet sheet, TagContext tagContext, Block block, WorkbookContext context) {
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        int numToShiftUp = bottom - top + 1;
        int numToShiftLeft = right - left + 1;
        switch (block.getDirection()) {
            case VERTICAL: {
                Block ancestor = SheetUtil.getShiftEndingAncestor(block, -numToShiftUp, 0);
                int startRowNum = bottom + 1;
                int endRowNum = ancestor.getBottomRowNum();
                SheetUtil.deleteBlock(sheet, tagContext, block, context);
                if (ancestor.getParent() == null && left == ancestor.getLeftColNum() && right == ancestor.getRightColNum()) {
                    ancestor.expand(0, -numToShiftUp);
                    SheetUtil.copyRowHeightsUp(sheet, startRowNum, endRowNum, numToShiftUp);
                }
                SheetUtil.shiftCellsUp(sheet, tagContext, context, left, right, startRowNum, endRowNum, numToShiftUp);
                FormulaUtil.shiftCellReferencesInRange(sheet.getSheetName(), context, left, right, startRowNum, endRowNum, 0, -numToShiftUp, true, true);
                break;
            }
            case HORIZONTAL: {
                Block ancestor = SheetUtil.getShiftEndingAncestor(block, 0, -numToShiftLeft);
                int startCellNum = right + 1;
                int endCellNum = ancestor.getRightColNum();
                SheetUtil.deleteBlock(sheet, tagContext, block, context);
                if (ancestor.getParent() == null && top == ancestor.getTopRowNum() && bottom == ancestor.getBottomRowNum()) {
                    ancestor.expand(-numToShiftLeft, 0);
                    SheetUtil.copyColumnWidthsLeft(sheet, startCellNum, endCellNum, numToShiftLeft);
                }
                SheetUtil.shiftCellsLeft(sheet, tagContext, context, startCellNum, endCellNum, top, bottom, numToShiftLeft);
                FormulaUtil.shiftCellReferencesInRange(sheet.getSheetName(), context, startCellNum, endCellNum, top, bottom, -numToShiftLeft, 0, true, true);
                break;
            }
            case NONE: {
                SheetUtil.deleteBlock(sheet, tagContext, block, context);
            }
        }
    }

    public static Block getShiftEndingAncestor(Block block) {
        return SheetUtil.getShiftEndingAncestor(block, 0, 0);
    }

    public static Block getShiftEndingAncestor(Block block, int numVertCells, int numHorizCells) {
        Block ancestor;
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        Block.Direction dir = block.getDirection();
        switch (dir) {
            case VERTICAL: {
                for (ancestor = block.getParent(); ancestor != null && ancestor.getDirection() == dir && left == ancestor.getLeftColNum() && right == ancestor.getRightColNum(); ancestor = ancestor.getParent()) {
                    if (numVertCells != 0) {
                        ancestor.expand(0, numVertCells);
                    }
                    if (numHorizCells == 0) continue;
                    ancestor.expand(numHorizCells, 0);
                }
                break;
            }
            case HORIZONTAL: {
                while (ancestor != null && ancestor.getDirection() == dir && top == ancestor.getTopRowNum() && bottom == ancestor.getBottomRowNum()) {
                    if (numVertCells != 0) {
                        ancestor.expand(0, numVertCells);
                    }
                    if (numHorizCells != 0) {
                        ancestor.expand(numHorizCells, 0);
                    }
                    ancestor = ancestor.getParent();
                }
                break;
            }
        }
        return ancestor;
    }

    public static void shiftForBlock(Sheet sheet, TagContext tagContext, Block block, WorkbookContext context, int numBlocksAway) {
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        int height = bottom - top + 1;
        int translateDown = (numBlocksAway - 1) * height;
        int width = right - left + 1;
        int translateRight = (numBlocksAway - 1) * width;
        Stack<Block> blocksToShift = new Stack<Block>();
        Stack<Integer> shiftAmounts = new Stack<Integer>();
        switch (block.getDirection()) {
            case VERTICAL: {
                Block prevAncestor = block;
                Block ancestor = SheetUtil.getShiftEndingAncestor(block, translateDown, 0);
                while (translateDown > 0) {
                    int startRowNum = prevAncestor.getBottomRowNum() + 1;
                    int startCellNum = prevAncestor.getLeftColNum();
                    int endCellNum = prevAncestor.getRightColNum();
                    int endRowNum = ancestor.getBottomRowNum();
                    if (prevAncestor.getDirection() == Block.Direction.HORIZONTAL) {
                        startCellNum = ancestor.getLeftColNum();
                        endCellNum = ancestor.getRightColNum();
                    }
                    if (!shiftAmounts.isEmpty()) {
                        startRowNum -= ((Integer)shiftAmounts.peek()).intValue();
                    }
                    int emptyRowsAtBottom = 0;
                    if (prevAncestor == block && (emptyRowsAtBottom = SheetUtil.getEmptyRowsAtBottom(sheet, startCellNum, endCellNum, startRowNum, endRowNum)) > 0) {
                        endRowNum -= emptyRowsAtBottom;
                    }
                    if (translateDown > 0) {
                        Block toShift = new Block(null, startCellNum, endCellNum, startRowNum, endRowNum);
                        blocksToShift.push(toShift);
                        shiftAmounts.push(translateDown);
                        if (emptyRowsAtBottom > 0) {
                            translateDown -= emptyRowsAtBottom;
                        }
                        if (translateDown > 0) {
                            ancestor.expand(0, translateDown);
                        }
                    }
                    prevAncestor = ancestor;
                    if (ancestor.getParent() == null) break;
                    ancestor = SheetUtil.getShiftEndingAncestor(ancestor, translateDown, 0);
                }
                while (!blocksToShift.isEmpty()) {
                    Block toShift = (Block)blocksToShift.pop();
                    translateDown = (Integer)shiftAmounts.pop();
                    SheetUtil.copyRowHeightsDown(sheet, toShift.getTopRowNum(), toShift.getBottomRowNum(), translateDown);
                    SheetUtil.shiftCellsDown(sheet, tagContext, context, toShift.getLeftColNum(), toShift.getRightColNum(), toShift.getTopRowNum(), toShift.getBottomRowNum(), translateDown);
                    FormulaUtil.shiftCellReferencesInRange(sheet.getSheetName(), context, toShift.getLeftColNum(), toShift.getRightColNum(), toShift.getTopRowNum(), toShift.getBottomRowNum(), 0, translateDown, true, true);
                }
                break;
            }
            case HORIZONTAL: {
                Block prevAncestor = block;
                Block ancestor = SheetUtil.getShiftEndingAncestor(block, 0, translateRight);
                while (translateRight > 0) {
                    int startCellNum = prevAncestor.getRightColNum() + 1;
                    int startRowNum = prevAncestor.getTopRowNum();
                    int endRowNum = prevAncestor.getBottomRowNum();
                    int endCellNum = ancestor.getRightColNum();
                    if (!shiftAmounts.isEmpty()) {
                        startCellNum -= ((Integer)shiftAmounts.peek()).intValue();
                    }
                    int emptyColsAtRight = 0;
                    if (prevAncestor == block && (emptyColsAtRight = SheetUtil.getEmptyColumnsAtRight(sheet, startCellNum, endCellNum, startRowNum, endRowNum)) > 0) {
                        endCellNum -= emptyColsAtRight;
                    }
                    if (translateRight > 0) {
                        Block toShift = new Block(null, startCellNum, endCellNum, startRowNum, endRowNum);
                        blocksToShift.push(toShift);
                        shiftAmounts.push(translateRight);
                        if (emptyColsAtRight > 0) {
                            translateRight -= emptyColsAtRight;
                        }
                        if (translateRight > 0) {
                            ancestor.expand(translateRight, 0);
                        }
                    }
                    prevAncestor = ancestor;
                    if (ancestor.getParent() == null) break;
                    ancestor = SheetUtil.getShiftEndingAncestor(ancestor, 0, translateRight);
                }
                while (!blocksToShift.isEmpty()) {
                    Block toShift = (Block)blocksToShift.pop();
                    translateRight = (Integer)shiftAmounts.pop();
                    SheetUtil.copyColumnWidthsRight(sheet, toShift.getLeftColNum(), toShift.getRightColNum(), translateRight);
                    SheetUtil.shiftCellsRight(sheet, tagContext, context, toShift.getLeftColNum(), toShift.getRightColNum(), toShift.getTopRowNum(), toShift.getBottomRowNum(), translateRight);
                    FormulaUtil.shiftCellReferencesInRange(sheet.getSheetName(), context, toShift.getLeftColNum(), toShift.getRightColNum(), toShift.getTopRowNum(), toShift.getBottomRowNum(), translateRight, 0, true, true);
                }
                break;
            }
        }
    }

    private static int getEmptyRowsAtBottom(Sheet sheet, int left, int right, int top, int bottom) {
        int emptyRows = 0;
        for (int r = bottom; r >= top; --r) {
            boolean rowEmpty = true;
            for (int c = left; c <= right; ++c) {
                if (SheetUtil.isCellBlank(sheet, r, c)) continue;
                rowEmpty = false;
                break;
            }
            if (!rowEmpty) break;
            ++emptyRows;
        }
        return emptyRows;
    }

    private static int getEmptyColumnsAtRight(Sheet sheet, int left, int right, int top, int bottom) {
        int emptyColumns = 0;
        for (int c = right; c >= left; --c) {
            boolean colEmpty = true;
            for (int r = top; r <= bottom; ++r) {
                Row row = sheet.getRow(r);
                if (row == null || SheetUtil.isCellBlank(sheet, r, c)) continue;
                colEmpty = false;
                break;
            }
            if (!colEmpty) break;
            ++emptyColumns;
        }
        return emptyColumns;
    }

    public static Block copyBlock(Sheet sheet, TagContext tagContext, Block block, WorkbookContext context, int numBlocksAway) {
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        Block parent = block.getParent();
        Block newBlock = null;
        String sheetName = sheet.getSheetName();
        int seqNbr = context.getSequenceNbr();
        String currSuffix = null;
        String newSuffix = "[" + seqNbr + "," + numBlocksAway + "]";
        Map<String, String> tagLocationsMap = context.getTagLocationsMap();
        int height = block.getBottomRowNum() - block.getTopRowNum() + 1;
        int translateDown = numBlocksAway * height;
        int newTop = top + translateDown;
        int newBottom = bottom + translateDown;
        int width = block.getRightColNum() - block.getLeftColNum() + 1;
        int translateRight = numBlocksAway * width;
        int newLeft = left + translateRight;
        int newRight = right + translateRight;
        switch (block.getDirection()) {
            case VERTICAL: {
                for (int r = top; r <= bottom; ++r) {
                    Row newRow;
                    Row oldRow = sheet.getRow(r);
                    if (oldRow == null) {
                        oldRow = sheet.createRow(r);
                    }
                    if ((newRow = sheet.getRow(r + translateDown)) == null) {
                        newRow = sheet.createRow(r + translateDown);
                    }
                    for (int c = left; c <= right; ++c) {
                        int idx;
                        Cell newCell;
                        Cell oldCell = oldRow.getCell(c);
                        if (oldCell == null) {
                            oldCell = oldRow.createCell(c);
                        }
                        if ((newCell = newRow.getCell(c)) == null) {
                            newCell = newRow.createCell(c);
                        }
                        if (numBlocksAway > 0) {
                            SheetUtil.copyCell(oldCell, newCell);
                        }
                        String oldCellRef = SheetUtil.getCellKey(oldCell);
                        String newCellRef = SheetUtil.getCellKey(newCell);
                        String origCellRef = tagLocationsMap.get(oldCellRef);
                        if (origCellRef != null) {
                            tagLocationsMap.put(newCellRef, origCellRef);
                        }
                        if (newCell.getCellType() != 1) continue;
                        String cellText = newCell.getStringCellValue();
                        int startIdx = cellText.indexOf("$[");
                        int endIdx = cellText.lastIndexOf("]");
                        if (startIdx == -1 || endIdx == -1 || startIdx >= endIdx) continue;
                        if (numBlocksAway > 0 && (idx = cellText.lastIndexOf("[")) > -1) {
                            cellText = cellText.substring(0, idx);
                        }
                        if (currSuffix == null) {
                            idx = cellText.indexOf("[", "$[".length());
                            currSuffix = idx > -1 ? cellText.substring(idx) : "";
                        }
                        String newFormula = cellText + newSuffix;
                        SheetUtil.setCellValue(newCell, newFormula);
                    }
                }
                if (numBlocksAway > 0) {
                    SheetUtil.shiftMergedRegionsInRange(tagContext, left, right, top, bottom, 0, translateDown, false, true);
                    SheetUtil.copyRowHeightsDown(sheet, top, bottom, translateDown);
                    newBlock = new Block(parent, left, right, newTop, newBottom);
                    newBlock.setDirection(block.getDirection());
                } else {
                    newBlock = block;
                }
                if (currSuffix == null) {
                    currSuffix = "";
                }
                FormulaUtil.copyCellReferencesInRange(sheetName, context, left, right, top, bottom, 0, translateDown, currSuffix, newSuffix);
                break;
            }
            case HORIZONTAL: {
                for (int r = top; r <= bottom; ++r) {
                    Row row = sheet.getRow(r);
                    if (row == null) {
                        row = sheet.createRow(r);
                    }
                    for (int col = left; col <= right; ++col) {
                        int idx;
                        Cell newCell;
                        Cell oldCell = row.getCell(col);
                        if (oldCell == null) {
                            oldCell = row.createCell(col);
                        }
                        if ((newCell = row.getCell(col + translateRight)) == null) {
                            newCell = row.createCell(col + translateRight);
                        }
                        if (numBlocksAway > 0) {
                            SheetUtil.copyCell(oldCell, newCell);
                        }
                        String oldCellRef = SheetUtil.getCellKey(oldCell);
                        String newCellRef = SheetUtil.getCellKey(newCell);
                        String origCellRef = tagLocationsMap.get(oldCellRef);
                        if (origCellRef != null) {
                            tagLocationsMap.put(newCellRef, origCellRef);
                        }
                        if (newCell.getCellType() != 1) continue;
                        String cellText = newCell.getStringCellValue();
                        int startIdx = cellText.indexOf("$[");
                        int endIdx = cellText.lastIndexOf("]");
                        if (startIdx == -1 || endIdx == -1 || startIdx >= endIdx) continue;
                        if (numBlocksAway > 0 && (idx = cellText.lastIndexOf("[")) > -1) {
                            cellText = cellText.substring(0, idx);
                        }
                        if (currSuffix == null) {
                            idx = cellText.indexOf("[", "$[".length());
                            currSuffix = idx > -1 ? cellText.substring(idx) : "";
                        }
                        String newFormula = cellText + newSuffix;
                        SheetUtil.setCellValue(newCell, newFormula);
                    }
                }
                if (numBlocksAway > 0) {
                    SheetUtil.shiftMergedRegionsInRange(tagContext, left, right, top, bottom, translateRight, 0, false, true);
                    SheetUtil.copyColumnWidthsRight(sheet, left, right, translateRight);
                    newBlock = new Block(parent, newLeft, newRight, top, bottom);
                    newBlock.setDirection(block.getDirection());
                } else {
                    newBlock = block;
                }
                if (currSuffix == null) {
                    currSuffix = "";
                }
                FormulaUtil.copyCellReferencesInRange(sheetName, context, left, right, top, bottom, translateRight, 0, currSuffix, newSuffix);
            }
        }
        return newBlock;
    }

    public static void setUpBlockForImplicitCollectionAccess(Sheet sheet, Block block, String collExpr, String itemName) {
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        CreationHelper helper = sheet.getWorkbook().getCreationHelper();
        for (int rowNum = top; rowNum <= bottom; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            for (int cellNum = left; cellNum <= right; ++cellNum) {
                Cell cell = row.getCell(cellNum);
                if (cell == null || cell.getCellType() != 1) continue;
                RichTextString value = cell.getRichStringCellValue();
                cell.setCellValue(RichTextStringUtil.replaceAll(value, helper, collExpr, itemName, false, 0, true));
            }
        }
    }

    public static void groupRows(Sheet sheet, int begin, int end, boolean collapse) {
        sheet.groupRow(begin, end);
        if (collapse) {
            if (sheet instanceof XSSFSheet) {
                for (int r = begin; r <= end; ++r) {
                    Row row = sheet.getRow(r);
                    if (row == null) {
                        row = sheet.createRow(r);
                    }
                    row.setZeroHeight(true);
                }
            } else {
                sheet.setRowGroupCollapsed(begin, true);
            }
        }
    }

    public static void groupColumns(Sheet sheet, int begin, int end, boolean collapse) {
        int w;
        int c;
        HashMap<Integer, Integer> colWidths = new HashMap<Integer, Integer>();
        if (sheet instanceof XSSFSheet) {
            for (c = begin; c <= end; ++c) {
                w = sheet.getColumnWidth(c);
                colWidths.put(c, w);
            }
        }
        if (sheet instanceof XSSFSheet) {
            for (c = begin; c <= end; ++c) {
                sheet.groupColumn(c, c);
                w = (Integer)colWidths.get(c);
                sheet.setColumnWidth(c, w);
            }
        } else {
            sheet.groupColumn(begin, end);
        }
        if (collapse) {
            if (sheet instanceof XSSFSheet) {
                for (c = begin; c <= end; ++c) {
                    sheet.setColumnHidden(c, true);
                }
            } else {
                sheet.setColumnGroupCollapsed(begin, true);
            }
        }
    }

    public static String getColorHexString(Color color) {
        if (color instanceof HSSFColor) {
            HSSFColor hssfColor = (HSSFColor)color;
            return SheetUtil.getHSSFColorHexString(hssfColor);
        }
        if (color instanceof XSSFColor) {
            XSSFColor xssfColor = (XSSFColor)color;
            return SheetUtil.getXSSFColorHexString(xssfColor);
        }
        if (color == null) {
            return "null";
        }
        throw new IllegalArgumentException("Unexpected type of Color: " + color.getClass().getName());
    }

    private static String getHSSFColorHexString(HSSFColor hssfColor) {
        short[] shorts = hssfColor.getTriplet();
        StringBuilder hexString = new StringBuilder();
        for (short s : shorts) {
            String twoHex = Integer.toHexString(0xFF & s);
            if (twoHex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(twoHex);
        }
        return hexString.toString();
    }

    private static String getXSSFColorHexString(XSSFColor xssfColor) {
        if (xssfColor == null) {
            return "000000";
        }
        byte[] bytes = xssfColor.getCTColor().isSetTheme() ? xssfColor.getRgb() : xssfColor.getCTColor().getRgb();
        if (bytes == null) {
            HSSFColor hColor = ExcelColor.getHssfColorByIndex(xssfColor.getIndexed());
            if (hColor != null) {
                return SheetUtil.getHSSFColorHexString(ExcelColor.getHssfColorByIndex(xssfColor.getIndexed()));
            }
            return "000000";
        }
        if (bytes.length == 4) {
            bytes = new byte[]{bytes[1], bytes[2], bytes[3]};
        }
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String twoHex = Integer.toHexString(0xFF & b);
            if (twoHex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(twoHex);
        }
        return hexString.toString();
    }

    public static CellStyle createCellStyle(Workbook workbook, short alignment, short borderBottom, short borderLeft, short borderRight, short borderTop, String dataFormat, boolean wrapText, Color fillBackgroundColor, Color fillForegroundColor, short fillPattern, short verticalAlignment, short indention, short rotationDegrees, Color bottomBorderColor, Color leftBorderColor, Color rightBorderColor, Color topBorderColor, boolean locked, boolean hidden) {
        CellStyle cs = workbook.createCellStyle();
        cs.setAlignment(alignment);
        cs.setBorderBottom(borderBottom);
        cs.setBorderLeft(borderLeft);
        cs.setBorderRight(borderRight);
        cs.setBorderTop(borderTop);
        cs.setDataFormat(workbook.getCreationHelper().createDataFormat().getFormat(dataFormat));
        cs.setHidden(hidden);
        cs.setIndention(indention);
        cs.setLocked(locked);
        cs.setRotation(rotationDegrees);
        cs.setVerticalAlignment(verticalAlignment);
        cs.setWrapText(wrapText);
        if (workbook instanceof HSSFWorkbook) {
            if (bottomBorderColor != null) {
                cs.setBottomBorderColor(((HSSFColor)bottomBorderColor).getIndex());
            }
            if (leftBorderColor != null) {
                cs.setLeftBorderColor(((HSSFColor)leftBorderColor).getIndex());
            }
            if (rightBorderColor != null) {
                cs.setRightBorderColor(((HSSFColor)rightBorderColor).getIndex());
            }
            if (topBorderColor != null) {
                cs.setTopBorderColor(((HSSFColor)topBorderColor).getIndex());
            }
            cs.setFillForegroundColor(((HSSFColor)fillForegroundColor).getIndex());
            cs.setFillBackgroundColor(((HSSFColor)fillBackgroundColor).getIndex());
        } else {
            XSSFCellStyle xcs = (XSSFCellStyle)cs;
            if (bottomBorderColor != null) {
                xcs.setBottomBorderColor((XSSFColor)bottomBorderColor);
            }
            if (leftBorderColor != null) {
                xcs.setLeftBorderColor((XSSFColor)leftBorderColor);
            }
            if (rightBorderColor != null) {
                xcs.setRightBorderColor((XSSFColor)rightBorderColor);
            }
            if (topBorderColor != null) {
                xcs.setTopBorderColor((XSSFColor)topBorderColor);
            }
            if (fillForegroundColor != null) {
                xcs.setFillForegroundColor((XSSFColor)fillForegroundColor);
            }
            if (fillBackgroundColor != null) {
                xcs.setFillBackgroundColor((XSSFColor)fillBackgroundColor);
            }
        }
        cs.setFillPattern(fillPattern);
        return cs;
    }

    public static Font createFont(Workbook workbook, short fontBoldweight, boolean fontItalic, Color fontColor, String fontName, short fontHeightInPoints, byte fontUnderline, boolean fontStrikeout, int fontCharset, short fontTypeOffset) {
        Font f = workbook.createFont();
        f.setBoldweight(fontBoldweight);
        f.setItalic(fontItalic);
        f.setFontName(fontName);
        f.setFontHeightInPoints(fontHeightInPoints);
        f.setUnderline(fontUnderline);
        f.setStrikeout(fontStrikeout);
        f.setCharSet(fontCharset);
        f.setTypeOffset(fontTypeOffset);
        if (fontColor instanceof HSSFColor) {
            f.setColor(((HSSFColor)fontColor).getIndex());
        } else {
            XSSFFont xf = (XSSFFont)f;
            XSSFColor xssfFontColor = (XSSFColor)fontColor;
            if (xssfFontColor != null) {
                if (xssfFontColor.getCTColor().isSetTheme()) {
                    xf.setColor(xssfFontColor);
                } else {
                    xf.setColor(new XSSFColor(xssfFontColor.getRgb()));
                }
            }
        }
        return f;
    }

    public static Color getColor(Workbook workbook, String value) {
        HSSFColor color = null;
        if (workbook instanceof HSSFWorkbook) {
            if (value.startsWith("#")) {
                ExcelColor best = ExcelColor.AUTOMATIC;
                int minDist = 765;
                String strRed = value.substring(1, 3);
                String strGreen = value.substring(3, 5);
                String strBlue = value.substring(5, 7);
                int red = Integer.parseInt(strRed, 16);
                int green = Integer.parseInt(strGreen, 16);
                int blue = Integer.parseInt(strBlue, 16);
                for (ExcelColor excelColor : ExcelColor.values()) {
                    int dist = excelColor.distance(red, green, blue);
                    if (dist >= minDist) continue;
                    best = excelColor;
                    minDist = dist;
                }
                color = best.getHssfColor();
            } else {
                try {
                    ExcelColor excelColor = ExcelColor.valueOf(value);
                    if (excelColor != null) {
                        color = excelColor.getHssfColor();
                    }
                }
                catch (IllegalArgumentException e) {}
            }
        } else if (value.startsWith("#") && value.length() == 7) {
            color = new XSSFColor(new byte[]{Integer.valueOf(value.substring(1, 3), 16).byteValue(), Integer.valueOf(value.substring(3, 5), 16).byteValue(), Integer.valueOf(value.substring(5, 7), 16).byteValue()});
        } else {
            try {
                ExcelColor excelColor = ExcelColor.valueOf(value);
                if (excelColor != null) {
                    color = new XSSFColor(new byte[]{(byte)excelColor.getRed(), (byte)excelColor.getGreen(), (byte)excelColor.getBlue()});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return color;
    }

    public static String getCellLocation(Cell cell) {
        if (cell == null) {
            return "";
        }
        return " at " + SheetUtil.getCellKey(cell);
    }

    public static String getTagLocationWithHierarchy(Tag tag) {
        if (tag == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        WorkbookContext workbookContext = tag.getWorkbookContext();
        Map<String, String> tagLocationsMap = workbookContext.getTagLocationsMap();
        do {
            TagContext tagContext = tag.getContext();
            Sheet sheet = tagContext.getSheet();
            Block block = tagContext.getBlock();
            int row = block.getTopRowNum();
            int col = block.getLeftColNum();
            String cellRef = new CellReference(sheet == null ? "DNE" : sheet.getSheetName(), row, col, false, false).formatAsString();
            String origCellRef = tagLocationsMap.get(cellRef);
            buf.append(System.getProperty("line.separator"));
            buf.append("  inside tag \"");
            buf.append(tag.getName());
            buf.append("\" (");
            buf.append(tag.getClass().getName());
            buf.append("), at ");
            buf.append(cellRef);
            if (origCellRef == null) continue;
            buf.append(" (originally at ");
            buf.append(origCellRef);
            buf.append(")");
        } while ((tag = tag.getParentTag()) != null);
        return buf.toString();
    }
}

