/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jett.util.FormattingRun;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichTextStringUtil {
    private static final boolean DEBUG = false;

    public static RichTextString replaceAll(RichTextString richTextString, CreationHelper helper, String target, String replacement) {
        return RichTextStringUtil.replaceAll(richTextString, helper, target, replacement, false);
    }

    public static RichTextString replaceAll(RichTextString richTextString, CreationHelper helper, String target, String replacement, boolean firstOnly) {
        return RichTextStringUtil.replaceAll(richTextString, helper, target, replacement, firstOnly, 0);
    }

    public static RichTextString replaceAll(RichTextString richTextString, CreationHelper helper, String target, String replacement, boolean firstOnly, int startIdx) {
        return RichTextStringUtil.replaceAll(richTextString, helper, target, replacement, firstOnly, startIdx, false);
    }

    public static RichTextString replaceAll(RichTextString richTextString, CreationHelper helper, String target, String replacement, boolean firstOnly, int startIdx, boolean identifierMode) {
        if (target == null || target.length() == 0) {
            return richTextString;
        }
        int numFormattingRuns = richTextString.numFormattingRuns();
        String value = richTextString.getString();
        List<FormattingRun> formattingRuns = RichTextStringUtil.determineFormattingRunStats(richTextString);
        int change = replacement.length() - target.length();
        int beginIdx = value.indexOf(target, startIdx);
        while (beginIdx != -1) {
            if (identifierMode && (beginIdx > 0 && Character.isJavaIdentifierPart(value.charAt(beginIdx - 1)) || beginIdx + target.length() < value.length() && Character.isJavaIdentifierPart(value.charAt(beginIdx + target.length())))) {
                beginIdx = value.indexOf(target, beginIdx + target.length());
                continue;
            }
            value = value.substring(0, beginIdx) + replacement + value.substring(beginIdx + target.length());
            RichTextStringUtil.updateFormattingRuns(formattingRuns, beginIdx, change);
            if (firstOnly) break;
            beginIdx = value.indexOf(target, beginIdx + replacement.length());
        }
        return RichTextStringUtil.createFormattedString(numFormattingRuns, helper, value, formattingRuns);
    }

    public static RichTextString replaceValues(RichTextString richTextString, CreationHelper helper, List<String> targets, List<String> replacements, boolean replaceAll) {
        if (targets == null || targets.size() == 0) {
            return richTextString;
        }
        int numFormattingRuns = richTextString.numFormattingRuns();
        String value = richTextString.getString();
        List<FormattingRun> formattingRuns = RichTextStringUtil.determineFormattingRunStats(richTextString);
        for (int i = 0; i < targets.size(); ++i) {
            int beginIdx = value.indexOf(targets.get(i));
            if (beginIdx == -1) continue;
            String replaceMe = targets.get(i);
            String replaceWith = replacements.get(i);
            int change = replaceWith.length() - replaceMe.length();
            value = replaceAll ? value.replaceAll("(?<![\\\\])" + Pattern.quote(replaceMe), Matcher.quoteReplacement(replaceWith)) : value.replaceFirst("(?<![\\\\])" + Pattern.quote(replaceMe), Matcher.quoteReplacement(replaceWith));
            RichTextStringUtil.updateFormattingRuns(formattingRuns, beginIdx, change);
        }
        int beginIdx = value.indexOf("\\${");
        while (beginIdx != -1) {
            value = value.replace("\\${", "${");
            RichTextStringUtil.updateFormattingRuns(formattingRuns, beginIdx, -1);
            beginIdx = value.indexOf("\\${");
        }
        return RichTextStringUtil.createFormattedString(numFormattingRuns, helper, value, formattingRuns);
    }

    private static void updateFormattingRuns(List<FormattingRun> formattingRuns, int beginIdx, int change) {
        FormattingRun run;
        int j;
        int numFormattingRuns = formattingRuns.size();
        int fmtIndex = -1;
        for (j = 0; j < numFormattingRuns; ++j) {
            run = formattingRuns.get(j);
            int currBeginIdx = run.getBegin();
            int currLength = run.getLength();
            if (beginIdx < currBeginIdx || beginIdx >= currBeginIdx + currLength) continue;
            fmtIndex = j;
            break;
        }
        if (fmtIndex != -1) {
            FormattingRun run2 = formattingRuns.get(fmtIndex);
            run2.setLength(run2.getLength() + change);
            for (int j2 = fmtIndex + 1; j2 < numFormattingRuns; ++j2) {
                run2 = formattingRuns.get(j2);
                run2.setBegin(run2.getBegin() + change);
            }
        } else {
            for (j = 0; j < numFormattingRuns; ++j) {
                run = formattingRuns.get(j);
                run.setBegin(run.getBegin() + change);
            }
        }
    }

    public static RichTextString substring(RichTextString richTextString, CreationHelper helper, int beginIndex, int endIndex) {
        int numFormattingRuns = richTextString.numFormattingRuns();
        String value = richTextString.getString();
        List<FormattingRun> formattingRuns = RichTextStringUtil.determineFormattingRunStats(richTextString);
        ArrayList<FormattingRun> substrFormattingRuns = new ArrayList<FormattingRun>();
        for (int i = 0; i < numFormattingRuns; ++i) {
            FormattingRun run = formattingRuns.get(i);
            int begin = run.getBegin();
            int end = begin + run.getLength();
            if (begin < beginIndex && end < beginIndex || begin >= endIndex && end >= endIndex) continue;
            if (begin < beginIndex && end >= beginIndex) {
                begin = beginIndex;
            }
            if (begin < endIndex && end >= endIndex) {
                end = endIndex;
            }
            substrFormattingRuns.add(new FormattingRun(begin - beginIndex, end - begin, run.getFont()));
        }
        return RichTextStringUtil.createFormattedString(substrFormattingRuns.size(), helper, value.substring(beginIndex, endIndex), substrFormattingRuns);
    }

    public static List<FormattingRun> determineFormattingRunStats(RichTextString richTextString) {
        ArrayList<FormattingRun> formattingRuns;
        block5: {
            int numFormattingRuns;
            block4: {
                numFormattingRuns = richTextString.numFormattingRuns();
                formattingRuns = new ArrayList<FormattingRun>(numFormattingRuns);
                if (!(richTextString instanceof HSSFRichTextString)) break block4;
                HSSFRichTextString hssfRichTextString = (HSSFRichTextString)richTextString;
                for (int fmtIdx = 0; fmtIdx < numFormattingRuns; ++fmtIdx) {
                    short currFontIndex;
                    int begin = richTextString.getIndexOfFormattingRun(fmtIdx);
                    short fontIndex = (Short)RichTextStringUtil.getFontOfFormattingRun((RichTextString)hssfRichTextString, fmtIdx);
                    int length = 0;
                    for (int j = begin; j < richTextString.length() && (currFontIndex = ((Short)RichTextStringUtil.getFontAtIndex((RichTextString)hssfRichTextString, j)).shortValue()) == fontIndex; ++j) {
                        ++length;
                    }
                    formattingRuns.add(new FormattingRun(begin, length, fontIndex));
                }
                break block5;
            }
            if (!(richTextString instanceof XSSFRichTextString)) break block5;
            XSSFRichTextString xssfRichTextString = (XSSFRichTextString)richTextString;
            for (int fmtIdx = 0; fmtIdx < numFormattingRuns; ++fmtIdx) {
                XSSFFont currFontIndex;
                int begin = richTextString.getIndexOfFormattingRun(fmtIdx);
                XSSFFont fontIndex = (XSSFFont)RichTextStringUtil.getFontOfFormattingRun((RichTextString)xssfRichTextString, fmtIdx);
                int length = 0;
                for (int j = begin; j < richTextString.length() && ((currFontIndex = (XSSFFont)RichTextStringUtil.getFontAtIndex((RichTextString)xssfRichTextString, j)) == null && fontIndex == null || currFontIndex != null && currFontIndex.equals((Object)fontIndex)); ++j) {
                    ++length;
                }
                formattingRuns.add(new FormattingRun(begin, length, fontIndex));
            }
        }
        return formattingRuns;
    }

    public static RichTextString createFormattedString(int numFormattingRuns, CreationHelper helper, String value, List<FormattingRun> formattingRuns) {
        RichTextString newString = helper.createRichTextString(value);
        RichTextStringUtil.formatString(newString, numFormattingRuns, formattingRuns);
        return newString;
    }

    public static void formatString(RichTextString string, int numFormattingRuns, List<FormattingRun> formattingRuns) {
        for (int i = 0; i < numFormattingRuns; ++i) {
            FormattingRun run = formattingRuns.get(i);
            int begin = run.getBegin();
            int end = begin + run.getLength();
            Object font = run.getFont();
            if (string instanceof HSSFRichTextString) {
                string.applyFont(begin, end, ((Short)font).shortValue());
                continue;
            }
            if (string instanceof XSSFRichTextString) {
                if (font == null) continue;
                string.applyFont(begin, end, (Font)((XSSFFont)font));
                continue;
            }
            throw new IllegalArgumentException("Unexpected RichTextString type: " + string.getClass().getName() + ": " + string.getString());
        }
    }

    private static Object getFontOfFormattingRun(RichTextString richTextString, int fmtIndex) {
        if (richTextString instanceof HSSFRichTextString) {
            return ((HSSFRichTextString)richTextString).getFontOfFormattingRun(fmtIndex);
        }
        if (richTextString instanceof XSSFRichTextString) {
            try {
                return ((XSSFRichTextString)richTextString).getFontOfFormattingRun(fmtIndex);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected RichTextString type: " + richTextString.getClass().getName() + ": " + richTextString.getString());
    }

    public static Object getFontAtIndex(RichTextString richTextString, int fmtIndex) {
        if (richTextString instanceof HSSFRichTextString) {
            return ((HSSFRichTextString)richTextString).getFontAtIndex(fmtIndex);
        }
        if (richTextString instanceof XSSFRichTextString) {
            try {
                return ((XSSFRichTextString)richTextString).getFontAtIndex(fmtIndex);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Unexpected RichTextString type: " + richTextString.getClass().getName() + ": " + richTextString.getString());
    }

    public static void applyFont(RichTextString richTextString, Cell cell) {
        XSSFFont font;
        if (richTextString == null) {
            return;
        }
        if (richTextString instanceof HSSFRichTextString) {
            short fontIdx = ((HSSFRichTextString)richTextString).getFontAtIndex(0);
            font = cell.getSheet().getWorkbook().getFontAt(fontIdx);
        } else if (richTextString instanceof XSSFRichTextString) {
            try {
                font = ((XSSFRichTextString)richTextString).getFontAtIndex(0);
            }
            catch (NullPointerException e) {
                font = null;
            }
        } else {
            throw new IllegalArgumentException("Unexpected RichTextString type: " + richTextString.getClass().getName() + ": " + richTextString.getString());
        }
        if (font != null) {
            CellStyle cellStyle = cell.getCellStyle();
            Workbook workbook = cell.getSheet().getWorkbook();
            CellStyle newCellStyle = RichTextStringUtil.findCellStyle(workbook, cellStyle, (Font)font);
            if (newCellStyle == null) {
                newCellStyle = workbook.createCellStyle();
                newCellStyle.cloneStyleFrom(cellStyle);
                Font foundFont = RichTextStringUtil.findFont(workbook, (Font)font);
                newCellStyle.setFont(foundFont);
            }
            cell.setCellStyle(newCellStyle);
        }
    }

    private static CellStyle findCellStyle(Workbook workbook, CellStyle cellStyle, Font font) {
        short numCellStyles = workbook.getNumCellStyles();
        for (short i = 0; i < numCellStyles; i = (short)(i + 1)) {
            CellStyle cs = workbook.getCellStyleAt(i);
            Font f = workbook.getFontAt(cs.getFontIndex());
            if (cs.getFillForegroundColor() != cellStyle.getFillForegroundColor() || cs.getFillBackgroundColor() != cellStyle.getFillBackgroundColor() || cs.getDataFormat() != cellStyle.getDataFormat() || cs.getAlignment() != cellStyle.getAlignment() || cs.getBorderBottom() != cellStyle.getBorderBottom() || cs.getBorderLeft() != cellStyle.getBorderLeft() || cs.getBorderRight() != cellStyle.getBorderRight() || cs.getBorderTop() != cellStyle.getBorderTop() || cs.getFillPattern() != cellStyle.getFillPattern() || cs.getWrapText() != cellStyle.getWrapText() || cs.getRotation() != cellStyle.getRotation() || cs.getBottomBorderColor() != cellStyle.getBottomBorderColor() || cs.getTopBorderColor() != cellStyle.getTopBorderColor() || cs.getLeftBorderColor() != cellStyle.getLeftBorderColor() || cs.getRightBorderColor() != cellStyle.getRightBorderColor() || cs.getVerticalAlignment() != cellStyle.getVerticalAlignment() || cs.getIndention() != cellStyle.getIndention() || cs.getLocked() != cellStyle.getLocked() || cs.getHidden() != cellStyle.getHidden() || f.getBoldweight() != font.getBoldweight() || f.getItalic() != font.getItalic() || f.getColor() != font.getColor() || f.getFontHeight() != font.getFontHeight() || f.getUnderline() != font.getUnderline() || !f.getFontName().equals(font.getFontName()) || f.getTypeOffset() != font.getTypeOffset() || font instanceof XSSFFont && f instanceof XSSFFont && !((XSSFFont)font).getXSSFColor().getARGBHex().equals(((XSSFFont)f).getXSSFColor().getARGBHex())) continue;
            return cs;
        }
        return null;
    }

    private static Font findFont(Workbook workbook, Font font) {
        short numFonts = workbook.getNumberOfFonts();
        for (short i = 0; i < numFonts; i = (short)(i + 1)) {
            Font f = workbook.getFontAt(i);
            if (f.getBoldweight() != font.getBoldweight() || f.getItalic() != font.getItalic() || f.getColor() != font.getColor() || f.getFontHeight() != font.getFontHeight() || f.getUnderline() != font.getUnderline() || !f.getFontName().equals(font.getFontName()) || f.getTypeOffset() != font.getTypeOffset() || font instanceof XSSFFont && f instanceof XSSFFont && !((XSSFFont)font).getXSSFColor().getARGBHex().equals(((XSSFFont)f).getXSSFColor().getARGBHex())) continue;
            return f;
        }
        return null;
    }

    public static RichTextString performEscaping(RichTextString richTextString, CreationHelper helper) {
        int numFormattingRuns = richTextString.numFormattingRuns();
        String value = richTextString.getString();
        List<FormattingRun> formattingRuns = RichTextStringUtil.determineFormattingRunStats(richTextString);
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char curr = value.charAt(i);
            if (curr == '\\' && i + 1 < value.length() && "\\\"'bfnrt".indexOf(value.charAt(i + 1)) != -1) {
                switch (value.charAt(i + 1)) {
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case '\"': {
                        buf.append('\"');
                        break;
                    }
                    case '\'': {
                        buf.append('\'');
                        break;
                    }
                    case 'b': {
                        buf.append('\b');
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Accidentally recognized invalid escape sequence: \"\\" + value.charAt(i + 1) + "\"!");
                    }
                }
                RichTextStringUtil.updateFormattingRuns(formattingRuns, i, -1);
                ++i;
                continue;
            }
            buf.append(curr);
        }
        return RichTextStringUtil.createFormattedString(numFormattingRuns, helper, buf.toString(), formattingRuns);
    }
}

