/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jett.formula.CellRef;
import net.sf.jett.formula.CellRefRange;
import net.sf.jett.formula.Formula;
import net.sf.jett.model.WorkbookContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaUtil {
    private static final boolean DEBUG = false;
    private static final String NEGATIVE_LOOKBEHIND_ALPHA = "(?<![A-Za-z])";
    private static final String NEGATIVE_LOOKAHEAD_ALPHAN = "(?![A-Za-z0-9])";

    public static Map<String, List<CellRef>> createCellRefMap(Map<String, Formula> formulaMap) {
        HashMap<String, List<CellRef>> cellRefMap = new HashMap<String, List<CellRef>>();
        for (String key : formulaMap.keySet()) {
            Formula formula = formulaMap.get(key);
            String keySheetName = key.substring(0, key.indexOf("!"));
            for (CellRef cellRef : formula.getCellRefs()) {
                String sheetName = cellRef.getSheetName();
                String cellKey = FormulaUtil.getCellKey(cellRef, keySheetName);
                if (cellRefMap.containsKey(cellKey)) continue;
                ArrayList<CellRef> cellRefs = new ArrayList<CellRef>();
                CellRef mappedCellRef = sheetName == null || "".equals(sheetName) ? new CellRef(cellRef.getRow(), cellRef.getCol(), cellRef.isRowAbsolute(), cellRef.isColAbsolute()) : new CellRef(sheetName, cellRef.getRow(), cellRef.getCol(), cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                cellRefs.add(mappedCellRef);
                cellRefMap.put(cellKey, cellRefs);
            }
        }
        return cellRefMap;
    }

    public static String getCellKey(CellRef cellRef, String sheetName) {
        String cellRefSheetName = cellRef.getSheetName();
        String cellKey = cellRefSheetName == null || "".equals(cellRefSheetName) ? sheetName + "!" + cellRef.formatAsString() : cellRef.formatAsString().replace("'", "");
        return cellKey;
    }

    public static String createExcelFormulaString(String formulaText, Formula formula, String sheetName, WorkbookContext context) {
        String suffix;
        String excelFormula;
        Map<String, List<CellRef>> cellRefMap = context.getCellRefMap();
        List<CellRef> origCellRefs = formula.getCellRefs();
        StringBuffer buf = new StringBuffer();
        int idx = formulaText.indexOf("[", "$[".length());
        if (idx > -1) {
            excelFormula = formulaText.substring(0, idx);
            suffix = formulaText.substring(idx);
        } else {
            excelFormula = formulaText;
            suffix = "";
        }
        if (excelFormula.startsWith("$[") && excelFormula.endsWith("]")) {
            excelFormula = excelFormula.substring("$[".length(), excelFormula.length() - "]".length());
        }
        for (CellRef origCellRef : origCellRefs) {
            String cellRefs;
            List<CellRef> transCellRefs;
            String cellKey = FormulaUtil.getCellKey(origCellRef, sheetName);
            cellKey = cellKey + suffix;
            do {
                if ((transCellRefs = cellRefMap.get(cellKey)) != null) continue;
                int lastSuffixIdx = cellKey.lastIndexOf("[");
                if (lastSuffixIdx != -1) {
                    cellKey = cellKey.substring(0, lastSuffixIdx);
                    continue;
                }
                throw new IllegalStateException("Unable to find cell references for cell key \"" + cellKey + "\"!");
            } while (transCellRefs == null);
            buf.delete(0, buf.length());
            int numCellRefs = transCellRefs.size();
            if (numCellRefs > 0) {
                for (int i = 0; i < numCellRefs; ++i) {
                    if (i > 0) {
                        buf.append(",");
                    }
                    String cellRef = transCellRefs.get(i).formatAsString();
                    buf.append(cellRef);
                }
                cellRefs = buf.toString();
            } else {
                cellRefs = origCellRef.getDefaultValue();
                if (cellRefs == null) {
                    cellRefs = "0";
                }
            }
            excelFormula = excelFormula.replaceAll(NEGATIVE_LOOKBEHIND_ALPHA + Pattern.quote(origCellRef.formatAsStringWithDef()) + NEGATIVE_LOOKAHEAD_ALPHAN, Matcher.quoteReplacement(cellRefs));
        }
        return excelFormula;
    }

    public static void findAndReplaceCellRanges(Map<String, List<CellRef>> cellRefMap) {
        for (String key : cellRefMap.keySet()) {
            List<CellRef> cellRefs = cellRefMap.get(key);
            Collections.sort(cellRefs);
            boolean vertical = false;
            boolean horizontal = false;
            CellRef first = null;
            CellRef prev = null;
            int firstIdx = -1;
            int size = cellRefs.size();
            for (int i = 0; i < size; ++i) {
                int shrink;
                CellRef curr = cellRefs.get(i);
                if (first == null) {
                    vertical = false;
                    horizontal = false;
                    first = curr;
                    firstIdx = i;
                } else if (vertical) {
                    if (!FormulaUtil.isBelow(prev, curr)) {
                        FormulaUtil.replaceRange(cellRefs, firstIdx, i - 1);
                        shrink = size - cellRefs.size();
                        size -= shrink;
                        vertical = false;
                        first = curr;
                        firstIdx = i -= shrink;
                    }
                } else if (horizontal) {
                    if (!FormulaUtil.isRightOf(prev, curr)) {
                        FormulaUtil.replaceRange(cellRefs, firstIdx, i - 1);
                        shrink = size - cellRefs.size();
                        size -= shrink;
                        horizontal = false;
                        first = curr;
                        firstIdx = i -= shrink;
                    }
                } else if (FormulaUtil.isRightOf(prev, curr)) {
                    horizontal = true;
                } else if (FormulaUtil.isBelow(prev, curr)) {
                    vertical = true;
                } else {
                    first = curr;
                    firstIdx = i;
                }
                prev = curr;
            }
            if (!horizontal && !vertical) continue;
            FormulaUtil.replaceRange(cellRefs, firstIdx, size - 1);
        }
    }

    public static void updateSheetNameRefsAfterClone(WorkbookContext context) {
        Map<String, List<CellRef>> cellRefMap = context.getCellRefMap();
        List<String> templateSheetNamesList = context.getTemplateSheetNames();
        List<String> newSheetNamesList = context.getSheetNames();
        for (String key : cellRefMap.keySet()) {
            String templateSheetName = key.substring(0, key.indexOf("!"));
            int index = templateSheetNamesList.indexOf(templateSheetName);
            if (index == -1) continue;
            List<CellRef> cellRefs = cellRefMap.get(key);
            ArrayList<CellRef> addedCellRefs = new ArrayList<CellRef>();
            CellRef cellRef = cellRefs.get(0);
            String templateRefSheetName = cellRef.getSheetName();
            if (templateRefSheetName != null) {
                boolean updatedFirstAlready = false;
                for (int j = 0; j < templateSheetNamesList.size(); ++j) {
                    String sheetName = templateSheetNamesList.get(j);
                    if (!sheetName.equals(templateSheetName)) continue;
                    String newSheetName = newSheetNamesList.get(j);
                    CellRef newCellRef = new CellRef(newSheetName, cellRef.getRow(), cellRef.getCol(), cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                    if (updatedFirstAlready) {
                        addedCellRefs.add(newCellRef);
                        continue;
                    }
                    cellRefs.set(0, newCellRef);
                    updatedFirstAlready = true;
                }
            }
            cellRefs.addAll(addedCellRefs);
        }
    }

    public static void replaceSheetNameRefs(WorkbookContext context, String oldSheetName, String newSheetName) {
        List<String> newSheetNames = context.getSheetNames();
        int index = newSheetNames.indexOf(oldSheetName);
        if (index != -1) {
            newSheetNames.set(index, newSheetName);
        }
        Map<String, Formula> formulaMap = context.getFormulaMap();
        ArrayList<String> removeFromFormulaMap = new ArrayList<String>();
        HashMap<String, Formula> addToFormulaMap = new HashMap<String, Formula>();
        for (String key : formulaMap.keySet()) {
            if (!key.startsWith(oldSheetName)) continue;
            Formula formula = formulaMap.get(key);
            removeFromFormulaMap.add(key);
            index = key.indexOf("!");
            String newKey = newSheetName + "!" + key.substring(index + 1);
            addToFormulaMap.put(newKey, formula);
        }
        for (String key : removeFromFormulaMap) {
            formulaMap.remove(key);
        }
        formulaMap.putAll(addToFormulaMap);
        Map<String, List<CellRef>> cellRefMap = context.getCellRefMap();
        ArrayList<String> removeFromCellRefMap = new ArrayList<String>();
        HashMap<String, List<CellRef>> addToCellRefMap = new HashMap<String, List<CellRef>>();
        for (String key : cellRefMap.keySet()) {
            List<CellRef> cellRefs = cellRefMap.get(key);
            if (key.startsWith(oldSheetName)) {
                removeFromCellRefMap.add(key);
                index = key.indexOf("!");
                String newKey = newSheetName + "!" + key.substring(index + 1);
                addToCellRefMap.put(newKey, cellRefs);
            }
            for (int i = 0; i < cellRefs.size(); ++i) {
                CellRef cellRef = cellRefs.get(i);
                String cellRefSheetName = cellRef.getSheetName();
                if (cellRefSheetName == null || !cellRefSheetName.equals(oldSheetName)) continue;
                CellRef newCellRef = new CellRef(newSheetName, cellRef.getRow(), cellRef.getCol(), cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                cellRefs.set(i, newCellRef);
            }
        }
        for (String key : removeFromCellRefMap) {
            cellRefMap.remove(key);
        }
        cellRefMap.putAll(addToCellRefMap);
    }

    private static boolean isRightOf(CellRef prev, CellRef curr) {
        return curr.getRow() == prev.getRow() && curr.getCol() == prev.getCol() + 1 && (curr.getSheetName() == null && prev.getSheetName() == null || curr.getSheetName() != null && curr.getSheetName().equals(prev.getSheetName()));
    }

    private static boolean isBelow(CellRef prev, CellRef curr) {
        return curr.getCol() == prev.getCol() && curr.getRow() == prev.getRow() + 1 && (curr.getSheetName() == null && prev.getSheetName() == null || curr.getSheetName() != null && curr.getSheetName().equals(prev.getSheetName()));
    }

    private static void replaceRange(List<CellRef> cellRefs, int startIdx, int endIdx) {
        CellRef first = cellRefs.get(startIdx);
        CellRef prev = cellRefs.get(endIdx);
        CellRefRange range = new CellRefRange(first.getSheetName(), first.getRow(), first.getCol(), first.isRowAbsolute(), first.isColAbsolute());
        range.setRangeEndCellRef(prev);
        cellRefs.set(startIdx, range);
        cellRefs.subList(startIdx + 1, endIdx + 1).clear();
    }

    public static void shiftCellReferencesInRange(String sheetName, WorkbookContext context, int left, int right, int top, int bottom, int numCols, int numRows, boolean remove, boolean add) {
        Map<String, List<CellRef>> cellRefMap = context.getCellRefMap();
        List<String> templateSheetNames = context.getTemplateSheetNames();
        List<String> newSheetNames = context.getSheetNames();
        if (numCols == 0 && numRows == 0 && remove && add) {
            return;
        }
        for (String cellKey : cellRefMap.keySet()) {
            String keySheetName = cellKey.substring(0, cellKey.indexOf("!"));
            if (!keySheetName.equals(sheetName)) {
                int index = newSheetNames.indexOf(sheetName);
                if (index == -1 || !keySheetName.equals(templateSheetNames.get(index))) continue;
                keySheetName = sheetName;
            }
            List<CellRef> cellRefs = cellRefMap.get(cellKey);
            ArrayList<CellRef> delete = new ArrayList<CellRef>();
            ArrayList<CellRef> insert = new ArrayList<CellRef>();
            for (CellRef cellRef : cellRefs) {
                String cellRefSheetName = cellRef.getSheetName();
                int row = cellRef.getRow();
                short col = cellRef.getCol();
                if (cellRefSheetName != null && !keySheetName.equals(cellRefSheetName) || row < top || row > bottom || col < left || col > right) continue;
                if (remove) {
                    delete.add(cellRef);
                }
                if (!add) continue;
                CellRef adjCellRef = new CellRef(cellRefSheetName, row + numRows, col + numCols, cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                insert.add(adjCellRef);
            }
            if (remove) {
                cellRefs.removeAll(delete);
            }
            if (!add) continue;
            cellRefs.addAll(insert);
        }
    }

    public static void copyCellReferencesInRange(String sheetName, WorkbookContext context, int left, int right, int top, int bottom, int numCols, int numRows, String currSuffix, String newSuffix) {
        Map<String, List<CellRef>> cellRefMap = context.getCellRefMap();
        HashMap newCellRefEntries = new HashMap();
        List<String> templateSheetNames = context.getTemplateSheetNames();
        List<String> newSheetNames = context.getSheetNames();
        for (String cellKey : cellRefMap.keySet()) {
            String keySheetName = cellKey.substring(0, cellKey.indexOf("!"));
            if (!keySheetName.equals(sheetName)) {
                int index = newSheetNames.indexOf(sheetName);
                if (index == -1 || !keySheetName.equals(templateSheetNames.get(index))) continue;
                keySheetName = sheetName;
            }
            String keySuffix = "";
            int idx = cellKey.indexOf("[");
            if (idx > -1) {
                keySuffix = cellKey.substring(idx);
            }
            if (!currSuffix.startsWith(keySuffix)) continue;
            List<CellRef> cellRefs = cellRefMap.get(cellKey);
            ArrayList<CellRef> insert = new ArrayList<CellRef>();
            for (CellRef cellRef : cellRefs) {
                String cellRefSheetName = cellRef.getSheetName();
                int row = cellRef.getRow();
                short col = cellRef.getCol();
                if (cellRefSheetName != null && !keySheetName.equals(cellRefSheetName) || row < top || row > bottom || col < left || col > right) continue;
                CellRef adjCellRef = new CellRef(cellRefSheetName, row + numRows, col + numCols, cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                if (numRows != 0 || numCols != 0) {
                    insert.add(adjCellRef);
                }
                if (idx != -1) continue;
                String newCellKey = cellKey + currSuffix + newSuffix;
                ArrayList<CellRef> newCellRefs = new ArrayList<CellRef>();
                newCellRefs.add(adjCellRef);
                newCellRefEntries.put(newCellKey, newCellRefs);
            }
            cellRefs.addAll(insert);
        }
        cellRefMap.putAll(newCellRefEntries);
    }
}

