/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.AttributeExpressionException;
import net.sf.jett.expression.Expression;
import net.sf.jett.tag.Tag;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeUtil {
    public static final String SPEC_SEP = ";";
    public static final String SPEC_SEP_2 = ",";

    private AttributeUtil() {
    }

    private static AttributeExpressionException nullValueOrExpectedVariableMissing(Tag tag, String expression) {
        return AttributeUtil.attributeValidationFailure(tag, expression, "Null value or expected variable missing in expression");
    }

    private static AttributeExpressionException attributeValidationFailure(Tag tag, String expression, String message) {
        return new AttributeExpressionException(message + " \"" + expression + "\"." + SheetUtil.getTagLocationWithHierarchy(tag));
    }

    private static AttributeExpressionException attributeValidationFailure(Tag tag, String expression, String message, Exception cause) {
        return new AttributeExpressionException(message + " \"" + expression + "\"." + SheetUtil.getTagLocationWithHierarchy(tag), cause);
    }

    public static boolean evaluateBoolean(Tag tag, RichTextString text, Map<String, Object> beans, boolean def) {
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), tag.getWorkbookContext().getExpressionFactory(), beans);
        if (obj == null) {
            throw AttributeUtil.nullValueOrExpectedVariableMissing(tag, text.toString());
        }
        boolean result = obj instanceof Boolean ? (Boolean)obj : Boolean.parseBoolean(obj.toString());
        return result;
    }

    public static int evaluateInt(Tag tag, RichTextString text, Map<String, Object> beans, String attrName, int def) {
        int result;
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), tag.getWorkbookContext().getExpressionFactory(), beans);
        if (obj == null) {
            throw AttributeUtil.nullValueOrExpectedVariableMissing(tag, text.toString());
        }
        if (obj instanceof Number) {
            result = ((Number)obj).intValue();
        } else {
            try {
                result = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "The \"" + attrName + "\" attribute must be an integer");
            }
        }
        return result;
    }

    public static int evaluateNonNegativeInt(Tag tag, RichTextString text, Map<String, Object> beans, String attrName, int def) {
        int result = AttributeUtil.evaluateInt(tag, text, beans, attrName, def);
        if (result < 0) {
            throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "The \"" + attrName + "\" attribute must be non-negative");
        }
        return result;
    }

    public static int evaluatePositiveInt(Tag tag, RichTextString text, Map<String, Object> beans, String attrName, int def) {
        int result = AttributeUtil.evaluateInt(tag, text, beans, attrName, def);
        if (result <= 0) {
            throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "The \"" + attrName + "\" attribute must be positive");
        }
        return result;
    }

    public static int evaluateNonZeroInt(Tag tag, RichTextString text, Map<String, Object> beans, String attrName, int def) {
        int result = AttributeUtil.evaluateInt(tag, text, beans, attrName, def);
        if (result == 0) {
            throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "The \"" + attrName + "\" attribute must not be zero");
        }
        return result;
    }

    public static double evaluateDouble(Tag tag, RichTextString text, Map<String, Object> beans, String attrName, double def) {
        double result;
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), tag.getWorkbookContext().getExpressionFactory(), beans);
        if (obj == null) {
            throw AttributeUtil.nullValueOrExpectedVariableMissing(tag, text.toString());
        }
        if (obj instanceof Number) {
            result = ((Number)obj).doubleValue();
        } else {
            try {
                result = Double.parseDouble(obj.toString());
            }
            catch (NumberFormatException e) {
                throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "The \"" + attrName + "\" attribute must be a number");
            }
        }
        return result;
    }

    public static Object evaluateRichTextStringNotNull(Tag tag, RichTextString text, CreationHelper helper, Map<String, Object> beans, String attrName, String def) {
        if (text == null) {
            return def;
        }
        Object result = Expression.evaluateString(text, helper, tag.getWorkbookContext().getExpressionFactory(), beans);
        if (result == null || result.toString().length() == 0) {
            throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "Value for \"" + attrName + "\" must not be null or empty");
        }
        return result;
    }

    public static String evaluateString(Tag tag, RichTextString text, Map<String, Object> beans, String def) {
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), tag.getWorkbookContext().getExpressionFactory(), beans);
        return obj == null ? null : obj.toString();
    }

    public static String evaluateStringNotNull(Tag tag, RichTextString text, Map<String, Object> beans, String attrName, String def) {
        String result = AttributeUtil.evaluateString(tag, text, beans, def);
        if (result == null || result.length() == 0) {
            throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "Value for \"" + attrName + "\" must not be null or empty");
        }
        return result;
    }

    public static String evaluateStringSpecificValues(Tag tag, RichTextString text, Map<String, Object> beans, String attrName, List<String> legalValues, String def) {
        String result = AttributeUtil.evaluateString(tag, text, beans, def);
        for (String legalValue : legalValues) {
            if (!legalValue.equalsIgnoreCase(result)) continue;
            return result;
        }
        throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "Unknown value for \"" + attrName + "\": " + result + " (expected one of " + legalValues.toString() + ").");
    }

    public static <T> T evaluateObject(Tag tag, RichTextString text, Map<String, Object> beans, String attrName, Class<T> expectedClass, T def) {
        if (text == null) {
            return def;
        }
        return AttributeUtil.evaluateObject(tag, text.toString(), beans, attrName, expectedClass, def);
    }

    public static <T> T evaluateObject(Tag tag, String text, Map<String, Object> beans, String attrName, Class<T> expectedClass, T def) {
        Object result;
        block11: {
            if (text == null) {
                return def;
            }
            Object obj = Expression.evaluateString(text, tag.getWorkbookContext().getExpressionFactory(), beans);
            if (obj == null) {
                throw AttributeUtil.nullValueOrExpectedVariableMissing(tag, text);
            }
            Class<?> objClass = obj.getClass();
            if (expectedClass.isAssignableFrom(objClass)) {
                result = expectedClass.cast(obj);
            } else {
                if (obj instanceof String) {
                    String className = (String)obj;
                    try {
                        Class<?> actualClass = Class.forName(className);
                        result = actualClass.newInstance();
                        if (!expectedClass.isInstance(result)) {
                            throw AttributeUtil.attributeValidationFailure(tag, text, "Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", but instantiated a \"" + className + "\".");
                        }
                        break block11;
                    }
                    catch (ClassNotFoundException e) {
                        throw AttributeUtil.attributeValidationFailure(tag, text, "Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", could not find class \"" + className + "\"", e);
                    }
                    catch (InstantiationException e) {
                        throw AttributeUtil.attributeValidationFailure(tag, text, "Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", could not instantiate class \"" + className + "\": ", e);
                    }
                    catch (IllegalAccessException e) {
                        throw AttributeUtil.attributeValidationFailure(tag, text, "Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", could not instantiate class \"" + className + "\": ", e);
                    }
                    catch (ClassCastException e) {
                        throw AttributeUtil.attributeValidationFailure(tag, text, "Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", could not instantiate class \"" + className + "\": ", e);
                    }
                }
                throw AttributeUtil.attributeValidationFailure(tag, text, "Expected a \"" + expectedClass.getName() + "\" for \"" + attrName + "\", got a \"" + obj.getClass().getName() + "\": ");
            }
        }
        return result;
    }

    public static List<String> evaluateList(Tag tag, RichTextString text, Map<String, Object> beans, List<String> def) {
        List<String> result;
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), tag.getWorkbookContext().getExpressionFactory(), beans);
        if (obj == null) {
            throw AttributeUtil.nullValueOrExpectedVariableMissing(tag, text.toString());
        }
        if (obj instanceof List) {
            List list = (List)obj;
            result = new ArrayList<String>(list.size());
            for (Object item : list) {
                result.add(item.toString());
            }
        } else {
            String[] items = obj.toString().split(SPEC_SEP);
            result = Arrays.asList(items);
        }
        return result;
    }

    public static List<Integer> evaluateIntegerArray(Tag tag, RichTextString text, Map<String, Object> beans, List<Integer> def) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), tag.getWorkbookContext().getExpressionFactory(), beans);
        if (obj == null) {
            throw AttributeUtil.nullValueOrExpectedVariableMissing(tag, text.toString());
        }
        if (obj instanceof int[]) {
            int[] intArray;
            for (int i : intArray = (int[])obj) {
                result.add(i);
            }
        } else if (obj instanceof Integer[]) {
            Integer[] intArray = (Integer[])obj;
            result.addAll(Arrays.asList(intArray));
        } else if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            for (Object o : c) {
                if (o instanceof Number) {
                    result.add(((Number)o).intValue());
                    continue;
                }
                try {
                    result.add(Integer.parseInt(o.toString()));
                }
                catch (NumberFormatException e) {
                    throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "Expected an integer, got " + o.toString(), e);
                }
            }
        } else {
            String[] items;
            for (String item : items = obj.toString().split(SPEC_SEP)) {
                try {
                    result.add(Integer.parseInt(item));
                }
                catch (NumberFormatException e) {
                    throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "Expected an integer, got " + item, e);
                }
            }
        }
        return result;
    }

    public static List<List<Integer>> evaluateIntegerArrayArray(Tag tag, RichTextString text, Map<String, Object> beans, List<List<Integer>> def) {
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>();
        if (text == null) {
            return def;
        }
        Object obj = Expression.evaluateString(text.toString(), tag.getWorkbookContext().getExpressionFactory(), beans);
        if (obj == null) {
            throw AttributeUtil.nullValueOrExpectedVariableMissing(tag, text.toString());
        }
        if (obj instanceof int[][]) {
            int[][] intArray;
            for (int[] array : intArray = (int[][])obj) {
                ArrayList<Integer> innerList = new ArrayList<Integer>();
                for (int i : array) {
                    innerList.add(i);
                }
                result.add(innerList);
            }
        } else if (obj instanceof Integer[][]) {
            Integer[][] intArray;
            for (Integer[] array : intArray = (Integer[][])obj) {
                ArrayList<Integer> innerList = new ArrayList<Integer>();
                innerList.addAll(Arrays.asList(array));
                result.add(innerList);
            }
        } else if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            for (Object o : c) {
                ArrayList<Integer> innerList = new ArrayList<Integer>();
                if (o instanceof Collection) {
                    Collection inner = (Collection)o;
                    for (Object innerObj : inner) {
                        if (innerObj instanceof Number) {
                            innerList.add(((Number)innerObj).intValue());
                            continue;
                        }
                        try {
                            innerList.add(Integer.parseInt(innerObj.toString()));
                        }
                        catch (NumberFormatException e) {
                            throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "Expected an integer, got " + o.toString(), e);
                        }
                    }
                }
                result.add(innerList);
            }
        } else {
            String[] items;
            for (String item : items = obj.toString().split(SPEC_SEP)) {
                String[] innerItems;
                ArrayList<Integer> innerList = new ArrayList<Integer>();
                for (String innerItem : innerItems = item.split(SPEC_SEP_2)) {
                    try {
                        innerList.add(Integer.parseInt(innerItem));
                    }
                    catch (NumberFormatException e) {
                        throw AttributeUtil.attributeValidationFailure(tag, text.toString(), "Expected an integer, got " + item, e);
                    }
                }
                result.add(innerList);
            }
        }
        return result;
    }

    public static void ensureExactlyOneExists(Tag tag, List<RichTextString> attrValues, List<String> attrNames) {
        int exists = 0;
        for (RichTextString text : attrValues) {
            if (text == null || ++exists <= 1) continue;
            throw AttributeUtil.attributeValidationFailure(tag, attrNames.toString(), "Exactly one attribute must be specified");
        }
        if (exists != 1) {
            throw AttributeUtil.attributeValidationFailure(tag, attrNames.toString(), "Exactly one attribute must be specified");
        }
    }

    public static void ensureAtMostOneExists(Tag tag, List<RichTextString> attrValues, List<String> attrNames) {
        int exists = 0;
        for (RichTextString text : attrValues) {
            if (text == null || ++exists <= 1) continue;
            throw AttributeUtil.attributeValidationFailure(tag, attrNames.toString(), "At most one attribute must be specified");
        }
        if (exists != 1 && exists != 0) {
            throw AttributeUtil.attributeValidationFailure(tag, attrNames.toString(), "At most one attribute must be specified");
        }
    }

    public static void ensureAtLeastOneExists(Tag tag, List<RichTextString> attrValues, List<String> attrNames) {
        for (RichTextString text : attrValues) {
            if (text == null) continue;
            return;
        }
        throw AttributeUtil.attributeValidationFailure(tag, attrNames.toString(), "At least one attribute must be specified");
    }
}

