/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jett.event.SheetEvent;
import net.sf.jett.event.SheetListener;
import net.sf.jett.expression.Expression;
import net.sf.jett.expression.ExpressionFactory;
import net.sf.jett.formula.Formula;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.FormulaParser;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.FormulaUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetTransformer {
    private static final boolean DEBUG = false;

    public void transform(Sheet sheet, WorkbookContext context, Map<String, Object> beans) {
        this.transform(sheet, context, beans, null);
    }

    public void transform(Sheet sheet, WorkbookContext context, Map<String, Object> beans, AfterOffSheetProperties callback) {
        this.exposeSheet(beans, sheet);
        boolean shouldProceed = this.fireBeforeSheetProcessedEvent(context, sheet, beans);
        if (shouldProceed) {
            this.transformOffSheetProperties(sheet, beans, context);
        }
        if (callback != null) {
            callback.applySettings(sheet);
        }
        if (!shouldProceed) {
            return;
        }
        Block block = new Block(null, 0, SheetUtil.getLastPopulatedColIndex(sheet), 0, sheet.getLastRowNum());
        block.setDirection(Block.Direction.NONE);
        TagContext tagContext = new TagContext();
        tagContext.setSheet(sheet);
        tagContext.setBlock(block);
        tagContext.setBeans(beans);
        tagContext.setProcessedCellsMap(new HashMap<String, Cell>());
        ArrayList<CellRangeAddress> mergedRegions = new ArrayList<CellRangeAddress>();
        tagContext.setMergedRegions(mergedRegions);
        this.readMergedRegions(sheet, mergedRegions);
        ArrayList<List<CellRangeAddress>> conditionalFormattingRegions = new ArrayList<List<CellRangeAddress>>();
        tagContext.setConditionalFormattingRegions(conditionalFormattingRegions);
        this.readConditionalFormattingRegions(sheet, conditionalFormattingRegions);
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(tagContext, context);
        this.writeMergedRegions(sheet, mergedRegions);
        this.fireSheetProcessedEvent(context, sheet, beans);
    }

    private void transformOffSheetProperties(Sheet sheet, Map<String, Object> beans, WorkbookContext context) {
        ExpressionFactory factory = context.getExpressionFactory();
        Header header = sheet.getHeader();
        String text = header.getLeft();
        Object result = Expression.evaluateString(text, factory, beans);
        header.setLeft(result.toString());
        text = header.getCenter();
        result = Expression.evaluateString(text, factory, beans);
        header.setCenter(result.toString());
        text = header.getRight();
        result = Expression.evaluateString(text, factory, beans);
        header.setRight(result.toString());
        Footer footer = sheet.getFooter();
        text = footer.getLeft();
        result = Expression.evaluateString(text, factory, beans);
        footer.setLeft(result.toString());
        text = footer.getCenter();
        result = Expression.evaluateString(text, factory, beans);
        footer.setCenter(result.toString());
        text = footer.getRight();
        result = Expression.evaluateString(text, factory, beans);
        footer.setRight(result.toString());
        text = sheet.getSheetName();
        result = Expression.evaluateString(text, factory, beans);
        Workbook workbook = sheet.getWorkbook();
        if (result != null) {
            String newSheetName = result.toString();
            if (!sheet.getSheetName().equals(newSheetName)) {
                String oldSheetName = sheet.getSheetName();
                workbook.setSheetName(workbook.getSheetIndex(sheet), newSheetName);
                FormulaUtil.replaceSheetNameRefs(context, oldSheetName, newSheetName);
            }
        }
    }

    public void gatherFormulasAndTagLocations(Sheet sheet, Map<String, Formula> formulaMap, Map<String, String> tagLocationsMap) {
        int top = sheet.getFirstRowNum();
        int bottom = sheet.getLastRowNum();
        String sheetName = sheet.getSheetName();
        FormulaParser parser = new FormulaParser();
        for (int rowNum = top; rowNum <= bottom; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            int left = row.getFirstCellNum();
            int right = row.getLastCellNum() - 1;
            for (int cellNum = left; cellNum <= right; ++cellNum) {
                char next;
                int tagStartIdx;
                int formulaEndIdx;
                String cellText;
                Cell cell = row.getCell(cellNum);
                if (cell == null || cell.getCellType() != 1 || (cellText = cell.getStringCellValue()) == null) continue;
                int formulaStartIdx = cellText.indexOf("$[");
                if (formulaStartIdx != -1 && (formulaEndIdx = cellText.indexOf("]", formulaStartIdx)) != -1) {
                    cellText = cellText.substring(formulaStartIdx, formulaEndIdx + "]".length());
                    String formulaText = cellText.substring("$[".length(), formulaEndIdx - formulaStartIdx);
                    parser.setFormulaText(formulaText);
                    parser.setCell(cell);
                    parser.parse();
                    Formula formula = new Formula(cellText, parser.getCellReferences());
                    String key = sheetName + "!" + cellText;
                    formulaMap.put(key, formula);
                }
                if ((tagStartIdx = cellText.indexOf("<")) == -1 || tagStartIdx >= cellText.length() - 1 || Character.isWhitespace(next = cellText.charAt(tagStartIdx + 1)) || "=<>\"/".indexOf(next) != -1) continue;
                String cellRef = new CellReference(sheet.getSheetName(), cell.getRowIndex(), cell.getColumnIndex(), false, false).formatAsString();
                tagLocationsMap.put(cellRef, cellRef);
            }
        }
    }

    public void replaceFormulas(Sheet sheet, WorkbookContext context) {
        int top = sheet.getFirstRowNum();
        int bottom = sheet.getLastRowNum();
        String sheetName = sheet.getSheetName();
        Map<String, Formula> formulaMap = context.getFormulaMap();
        for (int rowNum = top; rowNum <= bottom; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            int left = row.getFirstCellNum();
            int right = row.getLastCellNum() - 1;
            for (int cellNum = left; cellNum <= right; ++cellNum) {
                String cellText;
                Cell cell = row.getCell(cellNum);
                if (cell == null || cell.getCellType() != 1 || (cellText = cell.getStringCellValue()) == null || !cellText.startsWith("$[") || !cellText.endsWith("]")) continue;
                int idx = cellText.indexOf("]");
                String cellTextNoSfx = cellText.substring(0, idx + 1);
                String key = sheetName + "!" + cellTextNoSfx;
                Formula formula = formulaMap.get(key);
                if (formula == null) continue;
                String excelFormula = FormulaUtil.createExcelFormulaString(cellText, formula, sheetName, context);
                cell.setCellFormula(excelFormula);
            }
        }
    }

    private void exposeSheet(Map<String, Object> beans, Sheet sheet) {
        beans.put("sheet", sheet);
    }

    private boolean fireBeforeSheetProcessedEvent(WorkbookContext context, Sheet sheet, Map<String, Object> beans) {
        boolean shouldProceed = true;
        List<SheetListener> listeners = context.getSheetListeners();
        SheetEvent event = new SheetEvent(sheet, beans);
        for (SheetListener listener : listeners) {
            shouldProceed &= listener.beforeSheetProcessed(event);
        }
        return shouldProceed;
    }

    private void fireSheetProcessedEvent(WorkbookContext context, Sheet sheet, Map<String, Object> beans) {
        List<SheetListener> listeners = context.getSheetListeners();
        SheetEvent event = new SheetEvent(sheet, beans);
        for (SheetListener listener : listeners) {
            listener.sheetProcessed(event);
        }
    }

    private void readMergedRegions(Sheet sheet, List<CellRangeAddress> mergedRegions) {
        int numMergedRegions = sheet.getNumMergedRegions();
        for (int i = 0; i < numMergedRegions; ++i) {
            mergedRegions.add(sheet.getMergedRegion(i));
        }
    }

    private void writeMergedRegions(Sheet sheet, List<CellRangeAddress> mergedRegions) {
        for (int i = sheet.getNumMergedRegions() - 1; i >= 0; --i) {
            sheet.removeMergedRegion(i);
        }
        for (CellRangeAddress mergedRegion : mergedRegions) {
            sheet.addMergedRegion(mergedRegion);
        }
    }

    private void readConditionalFormattingRegions(Sheet sheet, List<List<CellRangeAddress>> regions) {
        SheetConditionalFormatting scf = sheet.getSheetConditionalFormatting();
        int numConditionalFormattings = scf.getNumConditionalFormattings();
        for (int i = 0; i < numConditionalFormattings; ++i) {
            ConditionalFormatting cf = scf.getConditionalFormattingAt(i);
            CellRangeAddress[] ranges = cf.getFormattingRanges();
            ArrayList<CellRangeAddress> copies = new ArrayList<CellRangeAddress>(ranges.length);
            for (CellRangeAddress range : ranges) {
                copies.add(range.copy());
            }
            regions.add(copies);
        }
    }

    public static interface AfterOffSheetProperties {
        public void applySettings(Sheet var1);
    }
}

