/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.expression.Expression;
import net.sf.jett.expression.ExpressionFactory;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.MetadataParser;
import net.sf.jett.tag.MultiForEachTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.RichTextStringUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionsTransformer {
    private static boolean DEBUG = false;
    private static final String IMPL_ITEM_NAME_SUFFIX = "__JettItem__";

    public void transform(Cell cell, WorkbookContext workbookContext, TagContext cellContext) {
        int i;
        int top;
        Block parentBlock = cellContext.getBlock();
        Map<String, Object> beans = cellContext.getBeans();
        Map<String, Cell> processedCells = cellContext.getProcessedCellsMap();
        Sheet sheet = cellContext.getSheet();
        CreationHelper helper = sheet.getWorkbook().getCreationHelper();
        ExpressionFactory factory = workbookContext.getExpressionFactory();
        MetadataParser parser = null;
        RichTextString richString = cell.getRichStringCellValue();
        String value = richString.getString();
        int metadataIndIdx = value.indexOf("?@");
        if (metadataIndIdx != -1) {
            String metadata = value.substring(metadataIndIdx + "?@".length());
            if (DEBUG) {
                System.err.println("  CT: Metadata found: " + metadata + " on sheet " + sheet.getSheetName() + " at row " + cell.getRowIndex() + ", cell " + cell.getColumnIndex());
            }
            parser = new MetadataParser(metadata);
            parser.setCell(cell);
            parser.parse();
            RichTextString metadataRemoved = RichTextStringUtil.replaceAll(richString, helper, "?@" + metadata, "");
            SheetUtil.setCellValue(cell, metadataRemoved);
        }
        int left = parentBlock.getLeftColNum();
        int right = parentBlock.getRightColNum();
        int bottom = top = cell.getRowIndex();
        String copyRight = null;
        String fixed = null;
        String pastEndAction = null;
        String replacementValue = "";
        String groupDir = null;
        String collapse = null;
        String tagLoopListener = null;
        String tagListener = null;
        String indexVarName = null;
        String limit = null;
        if (parser != null) {
            String lexeme = parser.getExtraRows();
            if (lexeme != null) {
                bottom += this.evaluateInt(lexeme, factory, beans, "extraRows", cell);
            }
            copyRight = parser.getCopyingRight();
            fixed = parser.getFixed();
            pastEndAction = parser.getPastEndAction();
            replacementValue = parser.getReplacementValue();
            groupDir = parser.getGroupDir();
            collapse = parser.getCollapsingGroup();
            tagLoopListener = parser.getTagLoopListener();
            tagListener = parser.getTagListener();
            indexVarName = parser.getIndexVarName();
            limit = parser.getLimit();
            if (parser.isDefiningCols()) {
                lexeme = parser.getColsLeft();
                left = lexeme != null ? cell.getColumnIndex() - this.evaluateInt(lexeme, factory, beans, "left", cell) : cell.getColumnIndex();
                lexeme = parser.getColsRight();
                right = lexeme != null ? cell.getColumnIndex() + this.evaluateInt(lexeme, factory, beans, "right", cell) : cell.getColumnIndex();
                if (left < parentBlock.getLeftColNum()) {
                    left = parentBlock.getLeftColNum();
                }
                if (right > parentBlock.getRightColNum()) {
                    right = parentBlock.getRightColNum();
                }
            }
        }
        Block containingBlock = new Block(parentBlock, left, right, top, bottom);
        if (DEBUG) {
            System.err.println("CT: Impl MultiForEach Block: " + containingBlock);
        }
        List<String> collectionNames = this.findCollectionsInBlock(cell, containingBlock, workbookContext, beans);
        ArrayList<String> vars = new ArrayList<String>(collectionNames.size());
        List<String> fixedSizeCollNames = workbookContext.getFixedSizedCollectionNames();
        ArrayList<String> fixedSizeCollNamesCopy = new ArrayList<String>(fixedSizeCollNames);
        for (String collectionName : collectionNames) {
            if (DEBUG) {
                System.err.println("  CollT: collection name found: " + collectionName);
            }
            String varName = collectionName.replaceAll("\\.", "_");
            varName = varName + IMPL_ITEM_NAME_SUFFIX;
            vars.add(varName);
            SheetUtil.setUpBlockForImplicitCollectionAccess(sheet, containingBlock, collectionName, varName);
            ArrayList<String> additions = new ArrayList<String>();
            for (String fixedCollName : fixedSizeCollNamesCopy) {
                String addition;
                if (!fixedCollName.startsWith(collectionName) || fixedSizeCollNamesCopy.contains(addition = varName + fixedCollName.substring(collectionName.length()))) continue;
                additions.add(addition);
            }
            fixedSizeCollNames.addAll(additions);
        }
        Iterator itr = fixedSizeCollNamesCopy.iterator();
        while (itr.hasNext()) {
            String fixedSizeCollName = (String)itr.next();
            if (DEBUG) {
                System.err.println("  CollT: fixed size collection name: " + fixedSizeCollName);
            }
            if (collectionNames.contains(fixedSizeCollName)) continue;
            itr.remove();
        }
        if (!fixedSizeCollNamesCopy.isEmpty()) {
            fixed = "true";
        }
        if (DEBUG) {
            if (!fixedSizeCollNamesCopy.isEmpty()) {
                System.err.println("CollT: Setting implicit tag to fixed: " + fixed + " based on fixed size collection name: " + (String)fixedSizeCollNamesCopy.get(0));
            } else {
                System.err.println("CollT: Setting implicit tag to fixed: " + fixed + " based on no fixed size collection names found.");
            }
        }
        TagContext context = new TagContext();
        context.setBeans(beans);
        context.setBlock(containingBlock);
        context.setSheet(sheet);
        context.setProcessedCellsMap(processedCells);
        context.setDrawing(cellContext.getDrawing());
        context.setMergedRegions(cellContext.getMergedRegions());
        MultiForEachTag tag = new MultiForEachTag();
        tag.setContext(context);
        tag.setWorkbookContext(workbookContext);
        tag.setParentTag(cellContext.getCurrentTag());
        context.setCurrentTag(tag);
        HashMap<String, RichTextString> attributes = new HashMap<String, RichTextString>();
        StringBuilder buf = new StringBuilder();
        for (i = 0; i < collectionNames.size(); ++i) {
            if (i > 0) {
                buf.append(";");
            }
            buf.append("${");
            buf.append(collectionNames.get(i));
            buf.append("}");
        }
        attributes.put("collections", helper.createRichTextString(buf.toString()));
        buf.setLength(0);
        for (i = 0; i < vars.size(); ++i) {
            if (i > 0) {
                buf.append(";");
            }
            buf.append((String)vars.get(i));
        }
        attributes.put("vars", helper.createRichTextString(buf.toString()));
        if (copyRight != null) {
            attributes.put("copyRight", helper.createRichTextString(copyRight));
        }
        if (fixed != null) {
            attributes.put("fixed", helper.createRichTextString(fixed));
        }
        if (pastEndAction != null) {
            attributes.put("pastEndAction", helper.createRichTextString(pastEndAction));
        }
        if (replacementValue != null) {
            attributes.put("replaceValue", helper.createRichTextString(replacementValue));
        }
        if (groupDir != null) {
            attributes.put("groupDir", helper.createRichTextString(groupDir));
        }
        if (collapse != null) {
            attributes.put("collapse", helper.createRichTextString(collapse));
        }
        if (tagLoopListener != null) {
            attributes.put("onLoopProcessed", helper.createRichTextString(tagLoopListener));
        }
        if (tagListener != null) {
            attributes.put("onProcessed", helper.createRichTextString(tagListener));
        }
        if (indexVarName != null) {
            attributes.put("indexVar", helper.createRichTextString(indexVarName));
        }
        if (limit != null) {
            attributes.put("limit", helper.createRichTextString(limit));
        }
        if (DEBUG) {
            for (String attribute : attributes.keySet()) {
                System.err.println("CoT: attr: " + attribute + " => " + attributes.get(attribute));
            }
        }
        tag.setAttributes(attributes);
        tag.setBodiless(false);
        tag.processTag();
    }

    private int evaluateInt(String lexeme, ExpressionFactory factory, Map<String, Object> beans, String keyName, Cell cell) {
        int change;
        Object obj = Expression.evaluateString(lexeme, factory, beans);
        if (obj instanceof Number) {
            change = ((Number)obj).intValue();
        } else {
            try {
                change = Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException e) {
                throw new TagParseException("Metadata key \"" + keyName + "\" needs to be a non-negative integer: " + lexeme + SheetUtil.getCellLocation(cell));
            }
            if (change < 0) {
                throw new TagParseException("Metadata key \"" + keyName + "\" needs to be a non-negative integer: " + lexeme + SheetUtil.getCellLocation(cell));
            }
        }
        return change;
    }

    private List<String> findCollectionsInBlock(Cell startTag, Block block, WorkbookContext context, Map<String, Object> beans) {
        ExpressionFactory factory = context.getExpressionFactory();
        int startColumnIndex = startTag.getColumnIndex();
        int startRowIndex = startTag.getRowIndex();
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int bottom = block.getBottomRowNum();
        if (DEBUG) {
            System.err.println("fCIB: Finding Collections in Block: " + block + ", starting tag found at row " + startRowIndex + ", cell " + startColumnIndex);
        }
        ArrayList<String> collectionNames = new ArrayList<String>();
        boolean lenient = factory.isLenient();
        boolean silent = factory.isSilent();
        factory.setLenient(true);
        factory.setSilent(true);
        Row startRow = startTag.getRow();
        int startCellNum = startColumnIndex;
        int endCellNum = right;
        for (int cellNum = startCellNum; cellNum <= endCellNum; ++cellNum) {
            RichTextString richString;
            List<String> collExprs;
            Cell cell;
            if (DEBUG) {
                System.err.println("  Trying same row: row " + startRowIndex + ", col " + cellNum);
            }
            if ((cell = startRow.getCell(cellNum)) == null || cell.getCellType() != 1 || (collExprs = Expression.getImplicitCollectionExpr((richString = cell.getRichStringCellValue()).toString(), beans, context)).isEmpty()) continue;
            for (String collExpr : collExprs) {
                if (collectionNames.contains(collExpr)) continue;
                collectionNames.add(collExpr);
            }
        }
        Sheet sheet = startTag.getSheet();
        for (int rowNum = startRowIndex + 1; rowNum <= bottom; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            startCellNum = left;
            endCellNum = right;
            for (int cellNum = startCellNum; cellNum <= endCellNum; ++cellNum) {
                RichTextString richString;
                List<String> collExprs;
                Cell cell = row.getCell(cellNum);
                if (cell == null || cell.getCellType() != 1 || (collExprs = Expression.getImplicitCollectionExpr((richString = cell.getRichStringCellValue()).toString(), beans, context)).isEmpty()) continue;
                for (String collExpr : collExprs) {
                    if (collectionNames.contains(collExpr)) continue;
                    collectionNames.add(collExpr);
                }
            }
        }
        factory.setLenient(lenient);
        factory.setSilent(silent);
        return collectionNames;
    }
}

