/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.transform;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.sf.jett.event.CellEvent;
import net.sf.jett.event.CellListener;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.expression.Expression;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.TagParser;
import net.sf.jett.tag.Tag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.tag.TagLibraryRegistry;
import net.sf.jett.transform.CollectionsTransformer;
import net.sf.jett.util.RichTextStringUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellTransformer {
    private static final boolean DEBUG_TAG = false;
    private static final boolean DEBUG_GENERAL = false;

    public boolean transform(Cell cell, WorkbookContext workbookContext, TagContext cellContext) {
        String key;
        Map<String, Object> beans = cellContext.getBeans();
        Map<String, Cell> processedCells = cellContext.getProcessedCellsMap();
        if (processedCells.containsKey(key = SheetUtil.getCellKey(cell))) {
            return true;
        }
        this.exposeCell(beans, cell);
        Object oldValue = null;
        switch (cell.getCellType()) {
            case 1: {
                oldValue = cell.getStringCellValue();
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    oldValue = cell.getDateCellValue();
                    break;
                }
                oldValue = cell.getNumericCellValue();
                break;
            }
            case 3: {
                oldValue = null;
                break;
            }
            case 2: {
                oldValue = cell.getCellFormula();
                break;
            }
            case 4: {
                oldValue = cell.getBooleanCellValue();
                break;
            }
            case 5: {
                oldValue = cell.getErrorCellValue();
            }
        }
        if (!this.fireBeforeCellProcessedEvent(workbookContext, cell, beans, oldValue)) {
            processedCells.put(key, cell);
            return true;
        }
        Sheet sheet = cell.getSheet();
        boolean cellProcessed = true;
        Object newValue = null;
        switch (cell.getCellType()) {
            case 1: {
                TagParser parser = new TagParser(cell);
                parser.parse();
                if (parser.isTag() && !parser.isEndTag()) {
                    cellProcessed = this.transformCellTag(cell, workbookContext, cellContext, parser);
                    break;
                }
                RichTextString richString = cell.getRichStringCellValue();
                List<String> collExprs = Expression.getImplicitCollectionExpr(richString.toString(), beans, workbookContext);
                if (!collExprs.isEmpty()) {
                    CollectionsTransformer collTransformer = new CollectionsTransformer();
                    collTransformer.transform(cell, workbookContext, cellContext);
                    cellProcessed = false;
                    break;
                }
                CreationHelper helper = sheet.getWorkbook().getCreationHelper();
                Object result = Expression.evaluateString(richString, helper, workbookContext.getExpressionFactory(), beans);
                newValue = SheetUtil.setCellValue(cell, result, richString);
                break;
            }
            case 0: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    newValue = cell.getDateCellValue();
                    break;
                }
                newValue = cell.getNumericCellValue();
                break;
            }
            case 3: {
                newValue = null;
                break;
            }
            case 2: {
                newValue = cell.getCellFormula();
                break;
            }
            case 4: {
                newValue = cell.getBooleanCellValue();
                break;
            }
            case 5: {
                newValue = cell.getErrorCellValue();
            }
        }
        if (cellProcessed) {
            this.fireCellProcessedEvent(workbookContext, cell, beans, oldValue, newValue);
            processedCells.put(key, cell);
        }
        return cellProcessed;
    }

    private boolean fireBeforeCellProcessedEvent(WorkbookContext context, Cell cell, Map<String, Object> beans, Object oldValue) {
        boolean shouldProceed = true;
        List<CellListener> cellListeners = context.getCellListeners();
        CellEvent event = new CellEvent(cell, beans, oldValue, null);
        for (CellListener listener : cellListeners) {
            shouldProceed &= listener.beforeCellProcessed(event);
        }
        return shouldProceed;
    }

    private void fireCellProcessedEvent(WorkbookContext context, Cell cell, Map<String, Object> beans, Object oldValue, Object newValue) {
        List<CellListener> cellListeners = context.getCellListeners();
        CellEvent event = new CellEvent(cell, beans, oldValue, newValue);
        for (CellListener listener : cellListeners) {
            listener.cellProcessed(event);
        }
    }

    private boolean transformCellTag(Cell cell, WorkbookContext workbookContext, TagContext cellContext, TagParser parser) {
        Block newBlock;
        Block parentBlock = cellContext.getBlock();
        TagLibraryRegistry registry = workbookContext.getRegistry();
        Map<String, Object> beans = cellContext.getBeans();
        Sheet sheet = cellContext.getSheet();
        Map<String, Cell> processedCells = cellContext.getProcessedCellsMap();
        String value = cell.getStringCellValue();
        RichTextString richTextString = cell.getRichStringCellValue();
        if (parser.isBodiless()) {
            newBlock = new Block(parentBlock, cell);
        } else {
            SheetUtil.setCellValue(cell, RichTextStringUtil.replaceAll(richTextString, sheet.getWorkbook().getCreationHelper(), parser.getTagText(), "", true));
            Cell match = this.findMatchingEndTag(cell, parentBlock, parser.getNamespaceAndTagName());
            if (match == null) {
                throw new TagParseException("Matching tag not found for tag: " + parser.getTagText() + ", located" + SheetUtil.getCellLocation(cell) + ", within block " + parentBlock);
            }
            newBlock = new Block(parentBlock, cell, match);
        }
        TagContext context = new TagContext();
        context.setBeans(beans);
        context.setBlock(newBlock);
        context.setSheet(sheet);
        context.setProcessedCellsMap(processedCells);
        context.setDrawing(cellContext.getDrawing());
        context.setMergedRegions(cellContext.getMergedRegions());
        Tag tag = registry.createTag(parser, context, workbookContext);
        if (tag == null) {
            Map<String, String> tagLocationsMap = workbookContext.getTagLocationsMap();
            String cellRef = SheetUtil.getCellKey(cell);
            String location = " at " + cellRef;
            String origCellRef = tagLocationsMap.get(cellRef);
            if (origCellRef != null) {
                location = location + " (originally located at " + origCellRef + ")";
            }
            throw new TagParseException("Invalid tag: " + value + location + SheetUtil.getTagLocationWithHierarchy(cellContext.getCurrentTag()));
        }
        context.setCurrentTag(tag);
        tag.setParentTag(cellContext.getCurrentTag());
        return tag.processTag();
    }

    private Cell findMatchingEndTag(Cell startTag, Block parentBlock, String namespaceAndTagName) {
        int startColumnIndex = startTag.getColumnIndex();
        int startRowIndex = startTag.getRowIndex();
        int right = parentBlock.getRightColNum();
        int bottom = parentBlock.getBottomRowNum();
        ArrayList<TagParser> innerTags = new ArrayList<TagParser>();
        Sheet sheet = startTag.getSheet();
        for (int rowNum = startRowIndex; rowNum <= bottom; ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            for (int cellNum = startColumnIndex; cellNum <= right; ++cellNum) {
                Cell candidate = row.getCell(cellNum);
                if (candidate == null || !this.isMatchingEndTag(candidate, namespaceAndTagName, innerTags)) continue;
                return candidate;
            }
        }
        return null;
    }

    private boolean isMatchingEndTag(Cell candidate, String namespaceAndTagName, List<TagParser> innerTags) {
        if (candidate.getCellType() != 1) {
            return false;
        }
        TagParser candidateParser = new TagParser(candidate);
        candidateParser.parse();
        int rightMostCol = candidate.getColumnIndex();
        int afterTagIdx = 0;
        while (candidateParser.isTag()) {
            if (candidateParser.isEndTag()) {
                if (namespaceAndTagName.equals(candidateParser.getNamespaceAndTagName()) && this.doAllInnerTagsMatch(innerTags, rightMostCol)) {
                    SheetUtil.setCellValue(candidate, RichTextStringUtil.replaceAll(candidate.getRichStringCellValue(), candidate.getSheet().getWorkbook().getCreationHelper(), candidateParser.getTagText(), "", true, afterTagIdx));
                    return true;
                }
                if (innerTags.isEmpty()) {
                    throw new TagParseException("End tag found \"" + candidateParser.getNamespaceAndTagName() + "\" does not match start tag \"" + namespaceAndTagName + "\"" + SheetUtil.getCellLocation(candidate) + ".");
                }
                innerTags.add(candidateParser);
            } else if (!candidateParser.isEndTag() && !candidateParser.isBodiless()) {
                innerTags.add(candidateParser);
            }
            candidateParser = new TagParser(candidate, afterTagIdx += candidateParser.getAfterTagIdx());
            candidateParser.parse();
        }
        return false;
    }

    private boolean doAllInnerTagsMatch(List<TagParser> innerTags, int rightMostCol) {
        Stack<TagParser> tagsToMatch = new Stack<TagParser>();
        for (TagParser parser : innerTags) {
            Cell candidateCell = parser.getCell();
            if (candidateCell.getColumnIndex() > rightMostCol) continue;
            if (parser.isEndTag()) {
                TagParser startParser;
                if (tagsToMatch.isEmpty()) {
                    return false;
                }
                String namespaceAndTagName = parser.getNamespaceAndTagName();
                if (!namespaceAndTagName.equals((startParser = (TagParser)tagsToMatch.peek()).getNamespaceAndTagName())) continue;
                tagsToMatch.pop();
                continue;
            }
            if (parser.isBodiless()) continue;
            tagsToMatch.push(parser);
        }
        return tagsToMatch.isEmpty();
    }

    private void exposeCell(Map<String, Object> beans, Cell cell) {
        beans.put("cell", cell);
    }
}

