/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.model.CellStyleCache;
import net.sf.jett.model.ExcelColor;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanTag
extends BaseTag {
    private static final boolean DEBUG = false;
    public static final String ATTR_FACTOR = "factor";
    public static final String ATTR_ADJUST = "adjust";
    public static final String ATTR_EXPAND_RIGHT = "expandRight";
    public static final String ATTR_VALUE = "value";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("value"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("expandRight", "factor", "adjust"));
    private int myFactor = 1;
    private int myAdjust = 0;
    private RichTextString myValue;

    @Override
    public String getName() {
        return "span";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() {
        super.validateAttributes();
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        Block block = context.getBlock();
        if (!this.isBodiless()) {
            throw new TagParseException("SpanTag: Must be bodiless.  SpanTag with body found" + this.getLocation());
        }
        this.myValue = attributes.get(ATTR_VALUE);
        List<RichTextString> atLeastOne = Arrays.asList(attributes.get(ATTR_FACTOR), attributes.get(ATTR_ADJUST));
        AttributeUtil.ensureAtLeastOneExists(this, atLeastOne, Arrays.asList(ATTR_FACTOR, ATTR_ADJUST));
        this.myFactor = AttributeUtil.evaluateNonNegativeInt(this, attributes.get(ATTR_FACTOR), beans, ATTR_FACTOR, 1);
        this.myAdjust = AttributeUtil.evaluateInt(this, attributes.get(ATTR_ADJUST), beans, ATTR_ADJUST, 0);
        boolean explicitlyExpandingRight = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_EXPAND_RIGHT), beans, false);
        if (explicitlyExpandingRight) {
            block.setDirection(Block.Direction.HORIZONTAL);
        } else {
            block.setDirection(Block.Direction.VERTICAL);
        }
    }

    @Override
    public boolean process() {
        int change;
        Cell cRight;
        Row rBottom;
        Cell cLeft;
        int top;
        int left;
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        int right = left = block.getLeftColNum();
        int bottom = top = block.getTopRowNum();
        int height = 1;
        int width = 1;
        List<CellRangeAddress> sheetMergedRegions = context.getMergedRegions();
        int index = this.findMergedRegionAtCell(sheetMergedRegions, left, top);
        if (index != -1) {
            CellRangeAddress remove = sheetMergedRegions.get(index);
            right = remove.getLastColumn();
            bottom = remove.getLastRow();
            height = remove.getLastRow() - remove.getFirstRow() + 1;
            width = remove.getLastColumn() - remove.getFirstColumn() + 1;
            sheetMergedRegions.remove(index);
        }
        short borderBottomType = 0;
        short borderLeftType = 0;
        short borderRightType = 0;
        short borderTopType = 0;
        HSSFColor borderBottomColor = null;
        HSSFColor borderLeftColor = null;
        HSSFColor borderRightColor = null;
        HSSFColor borderTopColor = null;
        Row rTop = sheet.getRow(top);
        if (rTop != null && (cLeft = rTop.getCell(left)) != null) {
            CellStyle cs = cLeft.getCellStyle();
            borderLeftType = cs.getBorderLeft();
            borderTopType = cs.getBorderTop();
            if (cs instanceof HSSFCellStyle) {
                borderLeftColor = ExcelColor.getHssfColorByIndex(cs.getLeftBorderColor());
                borderTopColor = ExcelColor.getHssfColorByIndex(cs.getTopBorderColor());
            } else {
                XSSFCellStyle xcs = (XSSFCellStyle)cs;
                borderLeftColor = xcs.getLeftBorderXSSFColor();
                borderTopColor = xcs.getTopBorderXSSFColor();
            }
        }
        if ((rBottom = sheet.getRow(bottom)) != null && (cRight = rBottom.getCell(right)) != null) {
            CellStyle cs = cRight.getCellStyle();
            borderRightType = cs.getBorderRight();
            borderBottomType = cs.getBorderBottom();
            if (cs instanceof HSSFCellStyle) {
                borderRightColor = ExcelColor.getHssfColorByIndex(cs.getRightBorderColor());
                borderBottomColor = ExcelColor.getHssfColorByIndex(cs.getBottomBorderColor());
            } else {
                XSSFCellStyle xcs = (XSSFCellStyle)cs;
                borderRightColor = xcs.getRightBorderXSSFColor();
                borderBottomColor = xcs.getBottomBorderXSSFColor();
            }
        }
        if (borderTopType != 0 || borderBottomType != 0 || borderRightType != 0 || borderLeftType != 0) {
            this.removeBorders(sheet, left, right, top, bottom);
        }
        Block mergedBlock = new Block(block.getParent(), left, right, top, bottom);
        mergedBlock.setDirection(block.getDirection());
        if (block.getDirection() == Block.Direction.VERTICAL) {
            change = height * (this.myFactor - 1) + this.myAdjust;
            height = (bottom += change) - top + 1;
        } else {
            change = width * (this.myFactor - 1) + this.myAdjust;
            width = (right += change) - left + 1;
        }
        if (height <= 0 || width <= 0) {
            SheetUtil.removeBlock(sheet, context, mergedBlock, this.getWorkbookContext());
            return false;
        }
        if (change < 0) {
            Block remove = block.getDirection() == Block.Direction.VERTICAL ? new Block(block.getParent(), left, right, bottom + 1, bottom - change) : new Block(block.getParent(), right + 1, right - change, top, bottom);
            remove.setDirection(block.getDirection());
            SheetUtil.removeBlock(sheet, context, remove, this.getWorkbookContext());
        }
        if (change > 0) {
            Block expand = block.getDirection() == Block.Direction.VERTICAL ? new Block(block.getParent(), left, right, bottom - change, bottom - change) : new Block(block.getParent(), right - change, right - change, top, bottom);
            expand.setDirection(block.getDirection());
            SheetUtil.shiftForBlock(sheet, context, expand, this.getWorkbookContext(), change + 1);
        }
        if (borderTopType != 0 || borderBottomType != 0 || borderRightType != 0 || borderLeftType != 0) {
            this.putBackBorders(sheet, left, right, top, bottom, borderLeftType, borderRightType, borderTopType, borderBottomType, (Color)borderLeftColor, (Color)borderRightColor, (Color)borderTopColor, (Color)borderBottomColor);
        }
        Row row = sheet.getRow(top);
        Cell cell = row.getCell(left);
        SheetUtil.setCellValue(cell, this.myValue);
        if (height > 1 || width > 1) {
            CellRangeAddress create = new CellRangeAddress(top, bottom, left, right);
            sheetMergedRegions.add(create);
        }
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(context, this.getWorkbookContext());
        return true;
    }

    private int findMergedRegionAtCell(List<CellRangeAddress> sheetMergedRegions, int col, int row) {
        int numMergedRegions = sheetMergedRegions.size();
        for (int i = 0; i < numMergedRegions; ++i) {
            CellRangeAddress candidate = sheetMergedRegions.get(i);
            if (candidate.getFirstRow() != row || candidate.getFirstColumn() != col) continue;
            return i;
        }
        return -1;
    }

    private void removeBorders(Sheet sheet, int left, int right, int top, int bottom) {
        CellStyleCache csCache = this.getWorkbookContext().getCellStyleCache();
        for (int r = top; r <= bottom; ++r) {
            Row row = sheet.getRow(r);
            for (int c = left; c <= right; ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) continue;
                CellStyle cs = cell.getCellStyle();
                Font f = sheet.getWorkbook().getFontAt(cs.getFontIndex());
                Object fontColor = cs instanceof HSSFCellStyle ? ExcelColor.getHssfColorByIndex(f.getColor()) : ((XSSFFont)f).getXSSFColor();
                CellStyle foundStyle = csCache.retrieveCellStyle(f.getBoldweight(), f.getItalic(), (Color)fontColor, f.getFontName(), f.getFontHeightInPoints(), cs.getAlignment(), (short)0, (short)0, (short)0, (short)0, cs.getDataFormatString(), f.getUnderline(), f.getStrikeout(), cs.getWrapText(), cs.getFillBackgroundColorColor(), cs.getFillForegroundColorColor(), cs.getFillPattern(), cs.getVerticalAlignment(), cs.getIndention(), cs.getRotation(), null, null, null, null, f.getCharSet(), f.getTypeOffset(), cs.getLocked(), cs.getHidden());
                if (foundStyle == null) {
                    foundStyle = SheetUtil.createCellStyle(sheet.getWorkbook(), cs.getAlignment(), (short)0, (short)0, (short)0, (short)0, cs.getDataFormatString(), cs.getWrapText(), cs.getFillBackgroundColorColor(), cs.getFillForegroundColorColor(), cs.getFillPattern(), cs.getVerticalAlignment(), cs.getIndention(), cs.getRotation(), null, null, null, null, cs.getLocked(), cs.getHidden());
                    foundStyle.setFont(f);
                }
                cell.setCellStyle(foundStyle);
            }
        }
    }

    private void putBackBorders(Sheet sheet, int left, int right, int top, int bottom, short borderLeft, short borderRight, short borderTop, short borderBottom, Color borderLeftColor, Color borderRightColor, Color borderTopColor, Color borderBottomColor) {
        CellStyleCache csCache = this.getWorkbookContext().getCellStyleCache();
        for (int r = top; r <= bottom; ++r) {
            Row row = sheet.getRow(r);
            if (row == null) {
                row = sheet.createRow(r);
            }
            for (int c = left; c <= right; ++c) {
                Cell cell = row.getCell(c);
                if (cell == null) {
                    cell = row.createCell(c);
                }
                CellStyle cs = cell.getCellStyle();
                Font f = sheet.getWorkbook().getFontAt(cs.getFontIndex());
                Object fontColor = cs instanceof HSSFCellStyle ? ExcelColor.getHssfColorByIndex(f.getColor()) : ((XSSFFont)f).getXSSFColor();
                short newBorderBottom = r == bottom ? borderBottom : (short)0;
                short newBorderLeft = c == left ? borderLeft : (short)0;
                short newBorderRight = c == right ? borderRight : (short)0;
                short newBorderTop = r == top ? borderTop : (short)0;
                Color newBorderBottomColor = r == bottom ? borderBottomColor : null;
                Color newBorderLeftColor = c == left ? borderLeftColor : null;
                Color newBorderRightColor = c == right ? borderRightColor : null;
                Color newBorderTopColor = r == top ? borderTopColor : null;
                CellStyle foundStyle = csCache.retrieveCellStyle(f.getBoldweight(), f.getItalic(), (Color)fontColor, f.getFontName(), f.getFontHeightInPoints(), cs.getAlignment(), newBorderBottom, newBorderLeft, newBorderRight, newBorderTop, cs.getDataFormatString(), f.getUnderline(), f.getStrikeout(), cs.getWrapText(), cs.getFillBackgroundColorColor(), cs.getFillForegroundColorColor(), cs.getFillPattern(), cs.getVerticalAlignment(), cs.getIndention(), cs.getRotation(), newBorderBottomColor, newBorderLeftColor, newBorderRightColor, newBorderTopColor, f.getCharSet(), f.getTypeOffset(), cs.getLocked(), cs.getHidden());
                if (foundStyle == null) {
                    foundStyle = SheetUtil.createCellStyle(sheet.getWorkbook(), cs.getAlignment(), newBorderBottom, newBorderLeft, newBorderRight, newBorderTop, cs.getDataFormatString(), cs.getWrapText(), cs.getFillBackgroundColorColor(), cs.getFillForegroundColorColor(), cs.getFillPattern(), cs.getVerticalAlignment(), cs.getIndention(), cs.getRotation(), newBorderBottomColor, newBorderLeftColor, newBorderRightColor, newBorderTopColor, cs.getLocked(), cs.getHidden());
                    foundStyle.setFont(f);
                }
                cell.setCellStyle(foundStyle);
            }
        }
    }
}

