/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.AttributeExpressionException;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.formula.CellRef;
import net.sf.jett.formula.Formula;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.FormulaUtil;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameTag
extends BaseTag {
    public static final List<String> EXCEL_BUILT_IN_NAMES = Arrays.asList("Consolidate_Area", "Auto_Open", "Auto_Close", "Database", "Criteria", "Print_Area", "Print_Titles", "Recorder", "Data_Form", "Auto_Activate", "Auto_Deactivate", "Sheet_Title", "_FilterDatabase", "_xlnm.Consolidate_Area", "_xlnm.Criteria:", "_xlnm.Database", "_xlnm.Extract:", "_xlnm._FilterDatabase", "_xlnm.Print_Area", "_xlnm.Print_Titles", "_xlnm.Sheet_Title");
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PREFER_WORKBOOK_SCOPE = "preferWorkbookScope";
    public static final String ATTR_FORMULA = "formula";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("name", "formula"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("preferWorkbookScope"));
    private Name myNamedRange;
    private String myJettFormula;

    @Override
    public String getName() {
        return ATTR_NAME;
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (!this.isBodiless()) {
            throw new TagParseException("Name tags must not have a body.  Name tag with body found" + this.getLocation());
        }
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Workbook workbook = sheet.getWorkbook();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        String name = AttributeUtil.evaluateStringNotNull(this, attributes.get(ATTR_NAME), beans, ATTR_NAME, "");
        boolean preferWorkbookScopeFirst = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_PREFER_WORKBOOK_SCOPE), beans, false);
        int numNamedRanges = workbook.getNumberOfNames();
        String sheetName = sheet.getSheetName();
        this.myNamedRange = null;
        for (int i = 0; i < numNamedRanges; ++i) {
            Name namedRange = workbook.getNameAt(i);
            if (preferWorkbookScopeFirst) {
                if (namedRange.getSheetIndex() == -1 && namedRange.getNameName().equals(name)) {
                    this.myNamedRange = namedRange;
                    break;
                }
                if (!sheetName.equals(namedRange.getSheetName()) || !namedRange.getNameName().equals(name)) continue;
                this.myNamedRange = namedRange;
                break;
            }
            if (sheetName.equals(namedRange.getSheetName()) && namedRange.getNameName().equals(name)) {
                this.myNamedRange = namedRange;
                break;
            }
            if (namedRange.getSheetIndex() != -1 || !namedRange.getNameName().equals(name)) continue;
            this.myNamedRange = namedRange;
            break;
        }
        if (this.myNamedRange == null) {
            throw new AttributeExpressionException("NameTag: Unable to find named range with name \"" + name + "\" in the workbook.  Reference found" + this.getLocation());
        }
        this.myJettFormula = AttributeUtil.evaluateStringNotNull(this, attributes.get(ATTR_FORMULA), beans, ATTR_FORMULA, "");
        if (!this.myJettFormula.startsWith("$[") || !this.myJettFormula.endsWith("]")) {
            throw new AttributeExpressionException("NameTag: Expected JETT formula of the form \"$[formula]\", got \"" + this.myJettFormula + "\"" + this.getLocation());
        }
    }

    @Override
    public boolean process() {
        WorkbookContext workbookContext = this.getWorkbookContext();
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        String sheetName = sheet.getSheetName();
        String formulaMapKey = sheetName + "!" + this.myJettFormula;
        String newKey = sheetName + "!" + this.myNamedRange.getNameName() + "?" + this.myNamedRange.getSheetName();
        Map<String, Formula> formulaMap = workbookContext.getFormulaMap();
        Formula existingFormula = formulaMap.get(formulaMapKey);
        List<CellRef> existingFormulaCellRefs = existingFormula.getCellRefs();
        formulaMap.put(newKey, existingFormula);
        Map<String, List<CellRef>> cellRefMap = workbookContext.getCellRefMap();
        for (CellRef formulaCellRef : existingFormulaCellRefs) {
            String cellKey = FormulaUtil.getCellKey(formulaCellRef, sheetName);
            List<CellRef> cellRefs = cellRefMap.get(cellKey);
            for (int i = 0; i < cellRefs.size(); ++i) {
                CellRef cellRef = cellRefs.get(i);
                String cellRefSheetName = cellRef.getSheetName();
                if (cellRefSheetName != null && !"".equals(cellRefSheetName)) continue;
                CellRef newCellRef = new CellRef(sheetName, cellRef.getRow(), cellRef.getCol(), cellRef.isRowAbsolute(), cellRef.isColAbsolute());
                cellRefs.set(i, newCellRef);
            }
        }
        this.clearBlock();
        return true;
    }
}

