/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.expression.Expression;
import net.sf.jett.expression.ExpressionFactory;
import net.sf.jett.model.Block;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.AttributeUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaTag
extends BaseTag {
    private static final boolean DEBUG = false;
    public static final String ATTR_BEAN = "bean";
    public static final String ATTR_TEXT = "text";
    public static final String ATTR_IF_ERROR = "ifError";
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("ifError", "text", "bean"));
    private String myFormulaExpression;
    private String myIfErrorExpression;

    @Override
    public String getName() {
        return "formula";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        return super.getRequiredAttributes();
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (!this.isBodiless()) {
            throw new TagParseException("Formula tags must not have a body.  Formula tag with body found" + this.getLocation());
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        RichTextString formulaBean = attributes.get(ATTR_BEAN);
        RichTextString formulaText = attributes.get(ATTR_TEXT);
        AttributeUtil.ensureExactlyOneExists(this, Arrays.asList(formulaBean, formulaText), Arrays.asList(ATTR_BEAN, ATTR_TEXT));
        if (formulaBean != null) {
            this.myFormulaExpression = Expression.evaluateString("${" + formulaBean.toString() + "}", this.getWorkbookContext().getExpressionFactory(), beans).toString();
        } else if (formulaText != null) {
            this.myFormulaExpression = attributes.get(ATTR_TEXT).getString();
        }
        RichTextString rtsIfError = attributes.get(ATTR_IF_ERROR);
        this.myIfErrorExpression = rtsIfError != null ? rtsIfError.getString() : null;
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        ExpressionFactory factory = this.getWorkbookContext().getExpressionFactory();
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        Map<String, Object> beans = context.getBeans();
        int left = block.getLeftColNum();
        int top = block.getTopRowNum();
        Row row = sheet.getRow(top);
        Cell cell = row.getCell(left);
        String formulaText = Expression.evaluateString(this.myFormulaExpression, factory, beans).toString();
        if (this.myIfErrorExpression != null) {
            Object errorResult = Expression.evaluateString(this.myIfErrorExpression, factory, beans);
            String newFormulaText = "IF(ISERROR(" + formulaText + "), ";
            if (!(errorResult instanceof Number)) {
                newFormulaText = newFormulaText + "\"";
            }
            newFormulaText = newFormulaText + errorResult.toString();
            if (!(errorResult instanceof Number)) {
                newFormulaText = newFormulaText + "\"";
            }
            formulaText = newFormulaText = newFormulaText + ", " + formulaText + ")";
        }
        cell.setCellFormula(formulaText);
        return true;
    }
}

