/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jett.event.TagLoopEvent;
import net.sf.jett.event.TagLoopListener;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.model.PastEndAction;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.Tag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseLoopTag
extends BaseTag {
    private static final boolean DEBUG = false;
    public static final String ATTR_COPY_RIGHT = "copyRight";
    public static final String ATTR_FIXED = "fixed";
    public static final String ATTR_PAST_END_ACTION = "pastEndAction";
    public static final String ATTR_GROUP_DIR = "groupDir";
    public static final String ATTR_COLLAPSE = "collapse";
    public static final String ATTR_ON_LOOP_PROCESSED = "onLoopProcessed";
    public static final String ATTR_REPLACE_VALUE = "replaceValue";
    public static final String PAST_END_ACTION_CLEAR = "clear";
    public static final String PAST_END_ACTION_REMOVE = "remove";
    public static final String PAST_END_ACTION_REPLACE_EXPR = "replaceExpr";
    public static final String GROUP_DIR_COLS = "cols";
    public static final String GROUP_DIR_ROWS = "rows";
    public static final String GROUP_DIR_NONE = "none";
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("copyRight", "fixed", "pastEndAction", "replaceValue", "groupDir", "collapse", "onLoopProcessed"));
    private boolean amIExplicitlyCopyingRight = false;
    private boolean amIFixed = false;
    private PastEndAction myPastEndAction = PastEndAction.CLEAR_CELL;
    private String myReplaceExprValue = "";
    private Block.Direction myGroupDir;
    private boolean amICollapsed;
    private TagLoopListener myTagLoopListener;

    public void setCopyRight(boolean copyRight) {
        this.amIExplicitlyCopyingRight = copyRight;
    }

    public void setFixed(boolean fixed) {
        this.amIFixed = fixed;
    }

    public void setPastEndAction(PastEndAction pae) {
        this.myPastEndAction = pae;
    }

    public void setReplaceExprValue(String value) {
        this.myReplaceExprValue = value;
    }

    public void setGroupDirection(Block.Direction direction) {
        this.myGroupDir = direction;
    }

    public void setCollapsed(boolean collapsed) {
        this.amICollapsed = collapsed;
    }

    public void setOnLoopProcessed(TagLoopListener listener) {
        this.myTagLoopListener = listener;
    }

    @Override
    protected List<String> getRequiredAttributes() {
        return super.getRequiredAttributes();
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    protected void validateAttributes() throws TagParseException {
        super.validateAttributes();
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        Block block = context.getBlock();
        this.amIExplicitlyCopyingRight = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_COPY_RIGHT), beans, false);
        if (this.amIExplicitlyCopyingRight) {
            block.setDirection(Block.Direction.HORIZONTAL);
        }
        this.amIFixed = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_FIXED), beans, false);
        String strPastEndAction = AttributeUtil.evaluateStringSpecificValues(this, attributes.get(ATTR_PAST_END_ACTION), beans, ATTR_PAST_END_ACTION, Arrays.asList(PAST_END_ACTION_CLEAR, PAST_END_ACTION_REMOVE, PAST_END_ACTION_REPLACE_EXPR), PAST_END_ACTION_CLEAR);
        if (PAST_END_ACTION_CLEAR.equalsIgnoreCase(strPastEndAction)) {
            this.myPastEndAction = PastEndAction.CLEAR_CELL;
        } else if (PAST_END_ACTION_REMOVE.equalsIgnoreCase(strPastEndAction)) {
            this.myPastEndAction = PastEndAction.REMOVE_CELL;
        } else if (PAST_END_ACTION_REPLACE_EXPR.equalsIgnoreCase(strPastEndAction)) {
            this.myPastEndAction = PastEndAction.REPLACE_EXPR;
        }
        this.myReplaceExprValue = AttributeUtil.evaluateString(this, attributes.get(ATTR_REPLACE_VALUE), beans, "");
        String strGroupDir = AttributeUtil.evaluateStringSpecificValues(this, attributes.get(ATTR_GROUP_DIR), beans, ATTR_GROUP_DIR, Arrays.asList(GROUP_DIR_ROWS, GROUP_DIR_COLS, GROUP_DIR_NONE), GROUP_DIR_NONE);
        if (GROUP_DIR_ROWS.equals(strGroupDir)) {
            this.myGroupDir = Block.Direction.VERTICAL;
        } else if (GROUP_DIR_COLS.equals(strGroupDir)) {
            this.myGroupDir = Block.Direction.HORIZONTAL;
        } else if (GROUP_DIR_NONE.equals(strGroupDir)) {
            this.myGroupDir = Block.Direction.NONE;
        }
        this.amICollapsed = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_COLLAPSE), beans, false);
        this.myTagLoopListener = AttributeUtil.evaluateObject((Tag)this, attributes.get(ATTR_ON_LOOP_PROCESSED), beans, ATTR_ON_LOOP_PROCESSED, TagLoopListener.class, null);
    }

    protected PastEndAction getPastEndAction() {
        return this.myPastEndAction;
    }

    protected String getReplacementExprValue() {
        return this.myReplaceExprValue;
    }

    @Override
    public boolean process() {
        List<String> varNames;
        int numIterations;
        boolean fixed;
        Map<String, Object> beans;
        Sheet sheet;
        WorkbookContext workbookContext;
        Block block;
        TagContext context;
        block23: {
            block25: {
                block24: {
                    context = this.getContext();
                    block = context.getBlock();
                    workbookContext = this.getWorkbookContext();
                    workbookContext.incrSequenceNbr();
                    sheet = context.getSheet();
                    beans = context.getBeans();
                    fixed = this.amIFixed;
                    if (!fixed) {
                        ArrayList<String> fixedSizeCollNames = new ArrayList<String>(workbookContext.getFixedSizedCollectionNames());
                        List<String> collNames = this.getCollectionNames();
                        if (collNames != null) {
                            Iterator itr = fixedSizeCollNames.iterator();
                            while (itr.hasNext()) {
                                String fixedSizeCollName = (String)itr.next();
                                if (collNames.contains(fixedSizeCollName)) continue;
                                itr.remove();
                            }
                        } else {
                            fixedSizeCollNames.clear();
                        }
                        fixed = !fixedSizeCollNames.isEmpty();
                    }
                    numIterations = this.getNumIterations();
                    varNames = this.getVarNames();
                    if (numIterations != 0) break block23;
                    if (!fixed) break block24;
                    switch (this.myPastEndAction) {
                        case CLEAR_CELL: {
                            this.clearBlock();
                            break block25;
                        }
                        case REMOVE_CELL: {
                            this.deleteBlock();
                            break block25;
                        }
                        case REPLACE_EXPR: {
                            SheetUtil.takePastEndAction(sheet, block, varNames, this.myPastEndAction, this.myReplaceExprValue);
                            block.collapse();
                            break block25;
                        }
                        default: {
                            throw new IllegalStateException("BaseLoopTag: Unknown PastEndAction: " + (Object)((Object)this.myPastEndAction));
                        }
                    }
                }
                this.removeBlock();
            }
            return false;
        }
        BlockTransformer transformer = new BlockTransformer();
        ArrayList<Block> blocksToProcess = new ArrayList<Block>(numIterations);
        if (!fixed) {
            this.shiftForBlock();
        }
        for (int i = 0; i < numIterations; ++i) {
            Block copy = this.copyBlock(i);
            blocksToProcess.add(copy);
        }
        int index = 0;
        Iterator<?> iterator = this.getLoopIterator();
        int maxRight = 0;
        int maxBottom = 0;
        while (iterator.hasNext()) {
            Object item = iterator.next();
            Block currBlock = (Block)blocksToProcess.get(index);
            if (index >= this.getCollectionSize()) {
                switch (this.myPastEndAction) {
                    case CLEAR_CELL: {
                        SheetUtil.clearBlock(sheet, currBlock, this.getWorkbookContext());
                        break;
                    }
                    case REMOVE_CELL: {
                        SheetUtil.deleteBlock(sheet, context, currBlock, this.getWorkbookContext());
                        break;
                    }
                    case REPLACE_EXPR: {
                        SheetUtil.takePastEndAction(sheet, currBlock, varNames, this.myPastEndAction, this.myReplaceExprValue);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("BaseLoopTag: Unknown PastEndAction: " + (Object)((Object)this.myPastEndAction));
                    }
                }
            }
            this.beforeBlockProcessed(context, currBlock, item, index);
            if (this.fireBeforeTagLoopProcessedEvent(currBlock, index)) {
                TagContext blockContext = new TagContext();
                blockContext.setSheet(sheet);
                blockContext.setBeans(beans);
                blockContext.setBlock(currBlock);
                blockContext.setProcessedCellsMap(context.getProcessedCellsMap());
                blockContext.setDrawing(context.getDrawing());
                blockContext.setMergedRegions(context.getMergedRegions());
                blockContext.setCurrentTag(this);
                int right = currBlock.getRightColNum();
                int bottom = currBlock.getBottomRowNum();
                transformer.transform(blockContext, workbookContext);
                int colGrowth = currBlock.getRightColNum() - right;
                int rowGrowth = currBlock.getBottomRowNum() - bottom;
                if (colGrowth != 0 || rowGrowth != 0) {
                    for (int j = index + 1; j < numIterations; ++j) {
                        Block pendingBlock = (Block)blocksToProcess.get(j);
                        pendingBlock.reactToGrowth(currBlock, colGrowth, rowGrowth);
                    }
                }
                if (currBlock.getRightColNum() > maxRight) {
                    maxRight = currBlock.getRightColNum();
                }
                if (currBlock.getBottomRowNum() > maxBottom) {
                    maxBottom = currBlock.getBottomRowNum();
                }
                this.fireTagLoopProcessedEvent(currBlock, index);
            }
            this.afterBlockProcessed(context, currBlock, item, index);
            ++index;
        }
        block.expand(maxRight - block.getRightColNum(), maxBottom - block.getBottomRowNum());
        this.groupRowsOrCols(sheet, context.getBlock(), (Block)blocksToProcess.get(blocksToProcess.size() - 1));
        return true;
    }

    private boolean fireBeforeTagLoopProcessedEvent(Block block, int index) {
        if (this.myTagLoopListener != null) {
            TagContext context = this.getContext();
            TagLoopEvent tagLoopEvent = new TagLoopEvent(context.getSheet(), block, context.getBeans(), index);
            return this.myTagLoopListener.beforeTagLoopProcessed(tagLoopEvent);
        }
        return true;
    }

    private void fireTagLoopProcessedEvent(Block block, int index) {
        if (this.myTagLoopListener != null) {
            TagContext context = this.getContext();
            TagLoopEvent tagLoopEvent = new TagLoopEvent(context.getSheet(), block, context.getBeans(), index);
            this.myTagLoopListener.onTagLoopProcessed(tagLoopEvent);
        }
    }

    private void groupRowsOrCols(Sheet sheet, Block first, Block last) {
        switch (this.myGroupDir) {
            case VERTICAL: {
                int begin = first.getTopRowNum();
                int end = last.getBottomRowNum();
                SheetUtil.groupRows(sheet, begin, end, this.amICollapsed);
                break;
            }
            case HORIZONTAL: {
                int begin = first.getLeftColNum();
                int end = last.getRightColNum();
                SheetUtil.groupColumns(sheet, begin, end, this.amICollapsed);
            }
        }
    }

    private void shiftForBlock() {
        TagContext context = this.getContext();
        Block block = context.getBlock();
        Sheet sheet = context.getSheet();
        int numIterations = this.getNumIterations();
        SheetUtil.shiftForBlock(sheet, context, block, this.getWorkbookContext(), numIterations);
    }

    private Block copyBlock(int numBlocksAway) {
        TagContext context = this.getContext();
        Block block = context.getBlock();
        Sheet sheet = context.getSheet();
        return SheetUtil.copyBlock(sheet, context, block, this.getWorkbookContext(), numBlocksAway);
    }

    protected abstract List<String> getCollectionNames();

    protected abstract List<String> getVarNames();

    protected abstract int getNumIterations();

    protected abstract int getCollectionSize();

    protected abstract Iterator<?> getLoopIterator();

    protected abstract void beforeBlockProcessed(TagContext var1, Block var2, Object var3, int var4);

    protected abstract void afterBlockProcessed(TagContext var1, Block var2, Object var3, int var4);
}

